/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl.validation.internal;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.modeler.modelgenerator.wsdl.ModelGeneratorWsdlPlugin;
import com.metamatrix.modeler.modelgenerator.wsdl.validation.WSDLValidationException;
import com.metamatrix.modeler.modelgenerator.wsdl.validation.WSDLValidator;
import com.metamatrix.modeler.modelgenerator.wsdl.validation.internal.NamespaceResolver;
import com.metamatrix.modeler.modelgenerator.wsdl.validation.internal.WSDLValidationMessage;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.resolver.IExtensibleURIResolver;

public class WSDLValidatorImpl
implements WSDLValidator {
    PluginUtil util = ModelGeneratorWsdlPlugin.Util;

    public MultiStatus validateWSDL(String fileUri) {
        return this.validateWSDL(fileUri, null);
    }

    public MultiStatus validateWSDL(String fileUri, IProgressMonitor monitor) {
        MultiStatus status;
        boolean success;
        if (monitor != null) {
            monitor.beginTask("Validating WSDL", -1);
        }
        org.eclipse.wst.wsdl.validation.internal.WSDLValidator validator = new org.eclipse.wst.wsdl.validation.internal.WSDLValidator();
        try {
            validator.addURIResolver((IExtensibleURIResolver)new NamespaceResolver());
        }
        catch (Exception e) {
            MultiStatus status2 = new MultiStatus("com.metamatrix.modeler.modelgenerator.wsdl", 500, new IStatus[0], this.util.getString("WSDLValidationImpl.validation.error"), (Throwable)e);
            return status2;
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        IValidationReport report = validator.validate(fileUri);
        if (monitor != null) {
            monitor.worked(1);
        }
        boolean bl = success = !report.hasErrors() && report.isWSDLValid();
        if (success) {
            int code = 100;
            status = new MultiStatus("com.metamatrix.modeler.modelgenerator.wsdl", 100, new IStatus[0], this.util.getString("WSDLValidationImpl.validation.passed"), null);
        } else {
            boolean warningsOnly = report.isWSDLValid();
            int code = 500;
            IValidationMessage[] vmessages = report.getValidationMessages();
            IStatus[] messages = new WSDLValidationMessage[vmessages.length];
            for (int i = 0; i < vmessages.length; ++i) {
                String message = this.buildValidationMessageString(vmessages[i]);
                int severity = vmessages[i].getSeverity();
                if (severity == 0) {
                    warningsOnly = false;
                }
                int newSeverity = severity == 0 ? 4 : 2;
                messages[i] = new WSDLValidationMessage(message, newSeverity);
            }
            if (warningsOnly) {
                status = new MultiStatus("com.metamatrix.modeler.modelgenerator.wsdl", 500, messages, this.util.getString("WSDLValidationImpl.validation.warning"), null);
            } else {
                try {
                    URL url = new URL(fileUri);
                    URLConnection connection = url.openConnection();
                    String contentType = connection.getContentType();
                    if (messages.length == 0) {
                        if (!(null == contentType || contentType.contains("text/xml") && contentType.contains("application/xml"))) {
                            String messageSuffix = MessageFormat.format(this.util.getString("WSDLValidationImpl.validation.content.type.error"), fileUri, contentType);
                            String fullMessage = this.util.getString("WSDLValidationImpl.wsdl.invalid") + messageSuffix;
                            messages = new WSDLValidationMessage[]{new WSDLValidationMessage(fullMessage, 4)};
                            status = new MultiStatus("com.metamatrix.modeler.modelgenerator.wsdl", 500, messages, fullMessage, (Throwable)new WSDLValidationException());
                        } else {
                            messages = new WSDLValidationMessage[]{new WSDLValidationMessage(this.util.getString("WSDLValidationImpl.wsdl.invalid"), 4)};
                            status = new MultiStatus("com.metamatrix.modeler.modelgenerator.wsdl", 500, messages, this.util.getString("WSDLValidationImpl.wsdl.invalid"), (Throwable)new WSDLValidationException());
                        }
                    } else if (!url.getProtocol().equals("file") && !contentType.contains("text/xml") || !contentType.equals("application/xml")) {
                        String messageSuffix = MessageFormat.format(this.util.getString("WSDLValidationImpl.validation.content.type.error"), fileUri, contentType);
                        status = new MultiStatus("com.metamatrix.modeler.modelgenerator.wsdl", 500, messages, this.util.getString("WSDLValidationImpl.validation.error") + messageSuffix, (Throwable)new WSDLValidationException());
                    } else {
                        status = new MultiStatus("com.metamatrix.modeler.modelgenerator.wsdl", 500, messages, this.util.getString("WSDLValidationImpl.validation.error"), (Throwable)new WSDLValidationException());
                    }
                }
                catch (Exception e) {
                    if (messages.length == 0) {
                        messages = new WSDLValidationMessage[]{new WSDLValidationMessage(this.util.getString("WSDLValidationImpl.open.connection.error"), 4)};
                    }
                    status = new MultiStatus("com.metamatrix.modeler.modelgenerator.wsdl", 500, messages, this.util.getString("WSDLValidationImpl.open.connection.error"), (Throwable)new WSDLValidationException());
                }
            }
        }
        if (monitor != null) {
            monitor.worked(1);
            monitor.done();
        }
        return status;
    }

    private String buildValidationMessageString(IValidationMessage vmessage) {
        StringBuffer buff = new StringBuffer();
        buff.append(vmessage.getLine());
        buff.append(":");
        buff.append(vmessage.getColumn());
        buff.append(" - ");
        buff.append(vmessage.getMessage());
        return buff.toString();
    }
}

