/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl.util;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;

public class WSDLSchemaExtractor {
    private ResourceSet resourceSet = new ResourceSetImpl();
    private HashSet schemas;

    public WSDLSchemaExtractor() throws IOException {
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        this.schemas = new HashSet();
    }

    public void findSchema(String wsdlUriString) throws IOException {
        URI uri;
        URI wsdlURI = URI.createURI((String)wsdlUriString);
        if (wsdlURI.isFile()) {
            File testWsdl = new File(wsdlURI.devicePath());
            uri = URI.createFileURI((String)testWsdl.getCanonicalPath().toString());
        } else {
            uri = URI.createURI((String)wsdlUriString);
        }
        WSDLResourceFactoryImpl fac = (WSDLResourceFactoryImpl)this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().get("wsdl");
        Resource res = fac.createResource(uri);
        if (res instanceof WSDLResourceImpl) {
            Definition def;
            Types types;
            WSDLResourceImpl wsdlResource = (WSDLResourceImpl)res;
            wsdlResource.basicSetResourceSet(this.resourceSet, null);
            if (!wsdlResource.isLoaded()) {
                wsdlResource.load(null);
            }
            if (null != (types = (def = wsdlResource.getDefinition()).getETypes())) {
                this.schemas.addAll(types.getSchemas());
            }
        }
    }

    public XSDSchema[] getSchemas() {
        for (Resource res : this.resourceSet.getResources()) {
            if (!(res instanceof XSDResourceImpl)) continue;
            XSDResourceImpl schema = (XSDResourceImpl)res;
            this.schemas.add(schema.getSchema());
        }
        XSDSchema[] retVal = new XSDSchema[this.schemas.size()];
        this.schemas.toArray(retVal);
        return retVal;
    }
}

