/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl.model.internal;

import com.ibm.wsdl.ImportImpl;
import com.ibm.wsdl.factory.WSDLFactoryImpl;
import com.metamatrix.core.log.Logger;
import com.metamatrix.modeler.modelgenerator.wsdl.ModelGeneratorWsdlPlugin;
import com.metamatrix.modeler.modelgenerator.wsdl.SoapBindingInfo;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Binding;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Fault;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Message;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Model;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Operation;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Part;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Port;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Service;
import com.metamatrix.modeler.modelgenerator.wsdl.model.internal.BindingImpl;
import com.metamatrix.modeler.modelgenerator.wsdl.model.internal.FaultImpl;
import com.metamatrix.modeler.modelgenerator.wsdl.model.internal.MessageImpl;
import com.metamatrix.modeler.modelgenerator.wsdl.model.internal.ModelImpl;
import com.metamatrix.modeler.modelgenerator.wsdl.model.internal.OperationImpl;
import com.metamatrix.modeler.modelgenerator.wsdl.model.internal.PartImpl;
import com.metamatrix.modeler.modelgenerator.wsdl.model.internal.PortImpl;
import com.metamatrix.modeler.modelgenerator.wsdl.model.internal.ServiceImpl;
import com.metamatrix.modeler.modelgenerator.wsdl.util.WSDLSchemaExtractor;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaModel;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SimpleRelationship;
import com.metamatrix.modeler.schema.tools.processing.internal.SchemaProcessorImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDSchema;

public class ModelBuilder {
    private String m_wsdlURI;
    private Definition m_wsdlDef;
    private Exception m_wsdlException;
    private XSDSchema[] m_schemas;
    private SchemaModel m_schemaModel;
    private WSDLSchemaExtractor extractor;

    public void setWSDL(String wsdlUri) {
        this.m_wsdlURI = wsdlUri;
        try {
            this.m_wsdlDef = this.getDefinition();
        }
        catch (WSDLException wx) {
            this.m_wsdlDef = null;
            this.m_wsdlException = wx;
        }
        try {
            this.extractor = new WSDLSchemaExtractor();
        }
        catch (IOException e) {
            this.m_wsdlDef = null;
            this.m_wsdlException = e;
        }
    }

    private WSDLReader getWSDLReader() {
        WSDLFactoryImpl impl = new WSDLFactoryImpl();
        return impl.newWSDLReader();
    }

    private Definition getDefinition() throws WSDLException {
        WSDLReader reader = this.getWSDLReader();
        Definition def = reader.readWSDL(this.m_wsdlURI);
        return def;
    }

    public boolean isWSDLParsed() {
        return this.m_wsdlDef != null;
    }

    public Exception getWSDLException() {
        return this.m_wsdlException;
    }

    public Model getModel(Logger logger) throws Exception {
        if (this.m_wsdlDef == null) {
            return null;
        }
        Model theModel = this.createModel(logger);
        return theModel;
    }

    private Model createModel(Logger logger) throws Exception {
        ModelImpl theModel = new ModelImpl();
        Map namespaceMap = this.m_wsdlDef.getNamespaces();
        theModel.setNamespaces(namespaceMap);
        this.extractor.findSchema(this.m_wsdlURI);
        Map imports = this.m_wsdlDef.getImports();
        if (!imports.isEmpty()) {
            Set keys = imports.keySet();
            for (String namespace : keys) {
                List importImpls = (List)imports.get(namespace);
                for (ImportImpl impImpl : importImpls) {
                    Definition def = impImpl.getDefinition();
                    URI baseURI = new URI(def.getDocumentBaseURI());
                    URL baseURL = baseURI.toURL();
                    this.extractor.findSchema(baseURL.toString());
                }
            }
        }
        this.m_schemas = this.extractor.getSchemas();
        this.setSchemaModel(logger);
        theModel.setSchemas(this.m_schemas);
        Service[] svcs = this.createServices(this.getServices(), theModel);
        theModel.setServices(svcs);
        return theModel;
    }

    private Map getServices() {
        Map services = this.m_wsdlDef.getServices();
        Map imports = this.m_wsdlDef.getImports();
        if (!imports.isEmpty()) {
            Set keys = imports.keySet();
            for (String namespace : keys) {
                List importImpls = (List)imports.get(namespace);
                for (ImportImpl impImpl : importImpls) {
                    Map importedServices = impImpl.getDefinition().getServices();
                    services.putAll(importedServices);
                }
            }
        }
        return services;
    }

    private Service[] createServices(Map services, Model theModel) {
        Service[] retVal = new Service[services.size()];
        int arrayCtr = 0;
        for (QName key : services.keySet()) {
            ServiceImpl impl = new ServiceImpl();
            impl.setModel(theModel);
            javax.wsdl.Service svc = (javax.wsdl.Service)services.get(key);
            impl.setId(key.toString());
            impl.setName(key.getLocalPart());
            impl.setPorts(this.getPortsForService(impl, svc.getPorts()));
            retVal[arrayCtr++] = impl;
        }
        return retVal;
    }

    private Port[] getPortsForService(Service service, Map ports) {
        Port[] retVal = new Port[ports.size()];
        int arrayCtr = 0;
        for (String name : ports.keySet()) {
            PortImpl port = new PortImpl(service);
            javax.wsdl.Port pt = (javax.wsdl.Port)ports.get(name);
            port.setId(name);
            port.setName(name);
            List port_extens_elements = pt.getExtensibilityElements();
            for (Object pe_next : port_extens_elements) {
                if (!(pe_next instanceof SOAPAddress)) continue;
                SOAPAddress address = (SOAPAddress)pe_next;
                port.setLocationURI(address.getLocationURI());
            }
            BindingImpl binding = new BindingImpl(port);
            javax.wsdl.Binding bind = pt.getBinding();
            binding.setId(bind.getQName().toString());
            binding.setName(bind.getQName().getLocalPart());
            List extens = bind.getExtensibilityElements();
            for (Object next : extens) {
                if (!(next instanceof SOAPBinding)) continue;
                SOAPBinding soap = (SOAPBinding)next;
                binding.setTransportURI(soap.getTransportURI());
                binding.setStyle(soap.getStyle());
            }
            binding.setOperations(this.getOperationsForBinding(binding, bind.getBindingOperations()));
            port.setBinding(binding);
            retVal[arrayCtr++] = port;
        }
        return retVal;
    }

    private Operation[] getOperationsForBinding(Binding binding, List operations) {
        Operation[] retVal = new Operation[operations.size()];
        int arrayPtr = 0;
        for (BindingOperation boper : operations) {
            javax.wsdl.Operation oper = boper.getOperation();
            OperationImpl operation = new OperationImpl(binding);
            operation.setId(binding.getId() + "." + oper.getName());
            operation.setName(oper.getName());
            OperationType style = oper.getStyle();
            if (style != null) {
                operation.setStyle(style.toString());
            }
            operation.setInputMessage(this.getInputMessageForOperation(operation, oper.getInput(), boper.getBindingInput()));
            if (oper.getOutput() != null) {
                operation.setOutputMessage(this.getOutputMessageForOperation(operation, oper.getOutput(), boper.getBindingOutput()));
            }
            List elems = boper.getExtensibilityElements();
            for (Object next : elems) {
                String soapStyle;
                if (!(next instanceof SOAPOperation)) continue;
                SOAPOperation soapO = (SOAPOperation)next;
                operation.setSOAPAction(soapO.getSoapActionURI());
                if (binding.getStyle() != null || (soapStyle = soapO.getStyle()) == null) continue;
                binding.setStyle(soapStyle);
            }
            if (operation.getBinding().getStyle() == null) {
                operation.setCanModel(false);
                String message = ModelGeneratorWsdlPlugin.Util.getString("ModelBuilder.cannot.resolve.style");
                operation.addProblemMessage(message);
            } else {
                Map faults = oper.getFaults();
                Map bFaults = boper.getBindingFaults();
                operation.setFaults(this.getFaultsForOperation(operation, faults, bFaults));
                this.createBindingInfo(operation);
            }
            retVal[arrayPtr++] = operation;
        }
        return retVal;
    }

    private Fault[] getFaultsForOperation(Operation operation, Map faults, Map bindingFaults) {
        Fault[] faultArr = new Fault[faults.size()];
        Iterator faultIter = faults.keySet().iterator();
        Iterator faultBIter = bindingFaults.keySet().iterator();
        int ctr = 0;
        while (faultIter.hasNext()) {
            Object key = faultIter.next();
            Object bKey = faultBIter.next();
            javax.wsdl.Fault fault = (javax.wsdl.Fault)faults.get(key);
            BindingFault bFault = (BindingFault)bindingFaults.get(bKey);
            FaultImpl newFault = new FaultImpl(operation);
            newFault.setName(fault.getName());
            newFault.setId(fault.getName());
            MessageImpl message = new MessageImpl(newFault);
            javax.wsdl.Message msg = fault.getMessage();
            message.setName(newFault.getName());
            message.setId(msg.getQName().toString());
            message.setType(4);
            List elems = bFault.getExtensibilityElements();
            for (Object next : elems) {
                if (!(next instanceof SOAPBody)) continue;
                SOAPBody body = (SOAPBody)next;
                if (body.getEncodingStyles() != null) {
                    StringBuffer buff = new StringBuffer();
                    Iterator encIter = body.getEncodingStyles().iterator();
                    while (encIter.hasNext()) {
                        buff.append(encIter.next().toString());
                        buff.append(" ");
                    }
                    message.setEncodingStyle(buff.toString().trim());
                }
                message.setUse(body.getUse());
                message.setNamespaceURI(body.getNamespaceURI());
                if (body.getNamespaceURI() == null || body.getNamespaceURI().equals("")) continue;
                Model theModel = operation.getBinding().getPort().getService().getModel();
                theModel.addNamespaceToMap(body.getNamespaceURI());
            }
            Part[] parts = this.getPartsForMessage(message, msg.getParts());
            message.setParts(parts);
            newFault.setMessage(message);
            faultArr[ctr++] = newFault;
        }
        return faultArr;
    }

    private Message getInputMessageForOperation(Operation operation, Input input, BindingInput bIn) {
        MessageImpl inputMessage = new MessageImpl(operation);
        javax.wsdl.Message message = input.getMessage();
        inputMessage.setName(message.getQName().getLocalPart());
        inputMessage.setId(message.getQName().toString());
        inputMessage.setType(0);
        List elems = bIn.getExtensibilityElements();
        for (Object next : elems) {
            if (!(next instanceof SOAPBody)) continue;
            SOAPBody body = (SOAPBody)next;
            if (body.getEncodingStyles() != null) {
                StringBuffer buff = new StringBuffer();
                Iterator encIter = body.getEncodingStyles().iterator();
                while (encIter.hasNext()) {
                    buff.append(encIter.next().toString());
                    buff.append(" ");
                }
                inputMessage.setEncodingStyle(buff.toString().trim());
            }
            inputMessage.setUse(body.getUse());
            inputMessage.setNamespaceURI(body.getNamespaceURI());
            if (body.getNamespaceURI() == null || body.getNamespaceURI().equals("")) continue;
            Model theModel = operation.getBinding().getPort().getService().getModel();
            theModel.addNamespaceToMap(body.getNamespaceURI());
        }
        Part[] parts = this.getPartsForMessage(inputMessage, message.getParts());
        inputMessage.setParts(parts);
        return inputMessage;
    }

    private Message getOutputMessageForOperation(Operation operation, Output output, BindingOutput bOut) {
        MessageImpl outputMessage = new MessageImpl(operation);
        javax.wsdl.Message message = output.getMessage();
        outputMessage.setName(message.getQName().getLocalPart());
        outputMessage.setId(message.getQName().toString());
        outputMessage.setType(2);
        List elems = bOut.getExtensibilityElements();
        for (Object next : elems) {
            if (!(next instanceof SOAPBody)) continue;
            SOAPBody body = (SOAPBody)next;
            if (body.getEncodingStyles() != null) {
                StringBuffer buff = new StringBuffer();
                Iterator encIter = body.getEncodingStyles().iterator();
                while (encIter.hasNext()) {
                    buff.append(encIter.next().toString());
                    buff.append(" ");
                }
                outputMessage.setEncodingStyle(buff.toString().trim());
            }
            outputMessage.setUse(body.getUse());
            outputMessage.setNamespaceURI(body.getNamespaceURI());
            if (body.getNamespaceURI() == null || body.getNamespaceURI().equals("")) continue;
            Model theModel = operation.getBinding().getPort().getService().getModel();
            theModel.addNamespaceToMap(body.getNamespaceURI());
        }
        Part[] parts = this.getPartsForMessage(outputMessage, message.getParts());
        outputMessage.setParts(parts);
        return outputMessage;
    }

    private Part[] getPartsForMessage(Message msg, Map parts) {
        Part[] partArr = new Part[parts.size()];
        int ctr = 0;
        for (Object key : parts.keySet()) {
            javax.wsdl.Part part = (javax.wsdl.Part)parts.get(key);
            PartImpl newPart = new PartImpl(msg);
            newPart.setName(part.getName());
            newPart.setId(part.getName());
            if (part.getElementName() != null) {
                newPart.setElementName(part.getElementName().getLocalPart());
                newPart.setElementNamespace(part.getElementName().getNamespaceURI());
            }
            if (part.getTypeName() != null) {
                newPart.setTypeName(part.getTypeName().getLocalPart());
                newPart.setTypeNamespace(part.getTypeName().getNamespaceURI());
            }
            Operation oper = newPart.getMessage().getFault() == null ? newPart.getMessage().getOperation() : newPart.getMessage().getFault().getOperation();
            if (!this.resolvePart(newPart)) {
                oper.setCanModel(false);
                String message = ModelGeneratorWsdlPlugin.Util.getString("ModelBuilder.cannot.resolve.element");
                String fMsg = MessageFormat.format(message, newPart.getName(), newPart.getMessage().getName());
                oper.addProblemMessage(fMsg);
            }
            partArr[ctr++] = newPart;
        }
        return partArr;
    }

    private void setSchemaModel(Logger logger) throws Exception {
        SchemaProcessorImpl processor = new SchemaProcessorImpl(logger, null);
        processor.representTypes(true);
        processor.processSchemas(this.m_schemas);
        this.m_schemaModel = processor.getSchemaModel();
    }

    private boolean modelPart(Part newPart) {
        if ("http://www.w3.org/2001/XMLSchema".equalsIgnoreCase(newPart.getElementNamespace()) || "http://www.w3.org/2001/XMLSchema".equalsIgnoreCase(newPart.getTypeNamespace())) {
            return true;
        }
        boolean retVal = false;
        List roots = this.m_schemaModel.getElements();
        SchemaObject element = null;
        for (SchemaObject elem : roots) {
            String simpleName = elem.getSimpleName();
            if (!simpleName.equals(newPart.getElementName()) && !simpleName.equals(newPart.getTypeName())) continue;
            element = elem;
            break;
        }
        if (element != null) {
            List children = element.getChildren();
            retVal = children.size() == 0 ? true : this.walkElementsForMaxOccursThreshold(children, 1);
        }
        return retVal;
    }

    private boolean walkElementsForMaxOccursThreshold(List elems, int level) {
        int MAX = 4;
        boolean ok = true;
        for (SimpleRelationship rel : elems) {
            SchemaObject elem = rel.getChild();
            if (elem.getMaxOccurs() * level > 4) {
                ok = false;
                break;
            }
            List children = elem.getChildren();
            if (this.walkElementsForMaxOccursThreshold(children, elem.getMaxOccurs() * level)) continue;
            ok = false;
            break;
        }
        return ok;
    }

    private boolean resolvePart(Part newPart) {
        String elementNS = newPart.getElementNamespace();
        String typeNS = newPart.getTypeNamespace();
        if ("http://www.w3.org/2001/XMLSchema".equalsIgnoreCase(elementNS) || "http://www.w3.org/2001/XMLSchema".equalsIgnoreCase(typeNS)) {
            return true;
        }
        boolean resolved = false;
        for (int i = 0; i < this.m_schemas.length; ++i) {
            String tns = this.m_schemas[i].getTargetNamespace();
            if (null == tns) continue;
            if (tns.equals(typeNS)) {
                resolved = true;
            }
            if (!tns.equals(elementNS)) continue;
            resolved = true;
        }
        return resolved;
    }

    private void createBindingInfo(Operation oper) {
        Binding bind = oper.getBinding();
        Port targetport = bind.getPort();
        SoapBindingInfo info = new SoapBindingInfo();
        info.setDestinationURL(targetport.getLocationURI());
        String docType = bind.getStyle();
        String encType = oper.getInputMessage().getEncodingStyle();
        if (docType.equalsIgnoreCase("RPC")) {
            if (encType != null) {
                info.setStyle(0);
            } else {
                info.setStyle(1);
            }
        } else if (encType != null) {
            info.setStyle(2);
        } else {
            info.setStyle(3);
        }
        info.setOperationName(oper.getBinding().getPort().getService().getName());
        oper.setSoapBindingInfo(info);
    }
}

