/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.common.vdb.api.VDBModelDefn;
import com.metamatrix.modeler.dqp.DqpPlugin;
import com.metamatrix.modeler.dqp.config.ConfigurationManager;
import com.metamatrix.modeler.dqp.internal.config.VdbDefnHelper;
import com.metamatrix.modeler.dqp.util.ModelerDqpUtils;
import com.metamatrix.vdb.internal.edit.InternalVdbEditingContext;
import java.lang.reflect.Method;
import java.util.Collection;

public class SoapBindingInfo {
    public static final int STYLE_RPC_ENCODED = 0;
    public static final int STYLE_RPC_LITERAL = 1;
    public static final int STYLE_DOCUMENT_ENCODED = 2;
    public static final int STYLE_DOCUMENT_LITERAL = 3;
    private static final String CONNECTOR_NAME = "XML-Relational SOAP Connector";
    private static final String RPC_ENCODED = "RPC - Encoded";
    private static final String RPC_LITERAL = "RPC - Literal";
    private static final String DOCUMENT_ENCODED = "Document - Encoded";
    private static final String DOCUMENT_LITERAL = "Document - Literal";
    private static final String STYLE = "EncodingStyle";
    private static final String DESTINATION = "Uri";
    private String m_destinationURL;
    private String m_operName;
    private int m_style;

    public void setDestinationURL(String destinationURL) {
        this.m_destinationURL = destinationURL;
    }

    public String getDestinationURL() {
        return this.m_destinationURL;
    }

    public void setStyle(int style) {
        this.m_style = style;
    }

    public int getStyle() {
        return this.m_style;
    }

    public void setOperationName(String name) {
        this.m_operName = name;
    }

    public String getStyleString() {
        String strStyle;
        switch (this.m_style) {
            case 0: {
                strStyle = RPC_ENCODED;
                break;
            }
            case 1: {
                strStyle = RPC_LITERAL;
                break;
            }
            case 2: {
                strStyle = DOCUMENT_ENCODED;
                break;
            }
            case 3: {
                strStyle = DOCUMENT_LITERAL;
                break;
            }
            default: {
                strStyle = null;
            }
        }
        return strStyle;
    }

    public void createConnectorBinding(String modelName, String name, Object vce) throws Exception {
        String suffix = ".xmi";
        if (modelName.endsWith(".xmi")) {
            modelName = modelName.substring(0, modelName.length() - ".xmi".length());
        }
        VdbDefnHelper helper = null;
        if (vce instanceof InternalVdbEditingContext) {
            helper = DqpPlugin.getInstance().getVdbDefnHelper((InternalVdbEditingContext)vce);
        } else {
            Method getVdbDefnHelper = DqpPlugin.class.getMethod("getVdbDefnHelper", Class.forName("com.metamatrix.vdb.edit.VdbContextEditor"));
            helper = (VdbDefnHelper)getVdbDefnHelper.invoke((Object)DqpPlugin.getInstance(), vce);
        }
        VDBDefn def = helper.getVdbDefn();
        boolean add = true;
        ConfigurationManager impl = DqpPlugin.getInstance().getConfigurationManager();
        Collection types = DqpPlugin.getInstance().getConfigurationManager().getConnectorTypes();
        ComponentType type = null;
        for (ComponentType tp : types) {
            if (!tp.getName().equals(CONNECTOR_NAME)) continue;
            type = tp;
            break;
        }
        if (type == null) {
            return;
        }
        ConnectorBinding bind = impl.createConnectorBinding(type, name, add);
        boolean destWorked = ModelerDqpUtils.setPropertyValue((ConnectorBinding)bind, (Object)DESTINATION, (Object)this.getDestinationURL());
        boolean styleWorked = ModelerDqpUtils.setPropertyValue((ConnectorBinding)bind, (Object)STYLE, (Object)this.getStyleString());
        VDBModelDefn mDef = null;
        for (ModelInfo info : def.getModels()) {
            String path = info.getName();
            if (!path.equals(modelName)) continue;
            mDef = (VDBModelDefn)info;
            break;
        }
        helper.setConnectorBinding(mDef, bind, type);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SoapBindingInfo)) {
            return false;
        }
        SoapBindingInfo test = (SoapBindingInfo)other;
        return this.getDestinationURL().equalsIgnoreCase(test.getDestinationURL()) && this.getStyle() == test.getStyle();
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (this.m_destinationURL == null ? 0 : this.m_destinationURL.hashCode());
        hash = hash * 31 + this.m_style;
        return hash;
    }

    public String generateUniqueName() {
        String candidate = this.m_operName;
        int num = 1;
        while (!ModelerDqpUtils.isUniqueBindingName((String)candidate)) {
            candidate = this.m_operName + "_" + num++;
        }
        return candidate;
    }
}

