/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.model.schema.impl;

import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.BaseRelationship;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SchemaModelCopyTraversalContext;

public class SimpleRelationship
extends BaseRelationship {
    private SchemaObject parent;
    private SchemaObject child;
    private int minOccurs;
    private int maxOccurs;

    public SimpleRelationship(SchemaObject parent, SchemaObject child, int minOccurs, int maxOccurs) {
        this.parent = parent;
        this.child = child;
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
    }

    public String getParentRelativeXpath() {
        return "..";
    }

    public String getChildRelativeXpath() {
        String xpath = this.child.getRelativeXpath();
        return xpath;
    }

    public SchemaObject getParent() {
        return this.parent;
    }

    public SchemaObject getChild() {
        return this.child;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public String toString() {
        String childName = this.getChild().getSimpleName();
        String parentName = this.getParent().getSimpleName();
        return parentName + "_" + childName;
    }

    public Object copy(SchemaModelCopyTraversalContext ctx) {
        SchemaObject parentCopy = ctx.getElement(this.parent);
        SchemaObject childCopy = ctx.getElement(this.child);
        return new SimpleRelationship(parentCopy, childCopy, this.minOccurs, this.maxOccurs);
    }

    public void printDebug() {
        StringBuffer buff = new StringBuffer();
        buff.append("\t \t SimpleRelationship:");
        buff.append("ParentSimpleName = " + this.parent.getSimpleName());
        buff.append(" ");
        buff.append("ChildSimpleName = " + this.child.getSimpleName());
        buff.append(" ");
        buff.append("MinOccurs = " + this.minOccurs);
        buff.append(" ");
        buff.append("MaxOccurs = " + this.maxOccurs);
        buff.append(" ");
        buff.append("Type = " + this.getType());
        System.out.println(buff.toString());
    }

    public void setType(int relationshipType) {
        super.setType(relationshipType);
    }

    public int getType() {
        return super.getType();
    }
}

