/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.model.schema.impl;

import com.metamatrix.modeler.schema.tools.model.schema.Column;
import com.metamatrix.modeler.schema.tools.model.schema.Relationship;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObjectKey;
import com.metamatrix.modeler.schema.tools.model.schema.impl.MergedColumn;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SchemaModelCopyTraversalContext;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SimpleRelationship;
import com.metamatrix.modeler.schema.tools.processing.RelationshipProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public abstract class BaseSchemaObject
implements SchemaObject {
    protected boolean doesNotHaveUniqueName;
    protected String fileName = new String();
    protected boolean availableRoot = false;
    boolean recursivityDetector = false;
    protected boolean withinSelectedHierarchy = false;
    private String prefix;
    protected List parents = new ArrayList();
    protected List attributes = new ArrayList();
    protected List children = new ArrayList();
    protected boolean representAsTable = false;
    boolean useAsRoot = false;
    protected XSDTypeDefinition type;
    protected XSDSchema schema;
    private static XSDSimpleTypeDefinition stringType = null;

    BaseSchemaObject(String namespacePrefix, XSDTypeDefinition type, XSDSchema schema) {
        this.prefix = namespacePrefix;
        this.type = type;
        this.schema = schema;
    }

    public void setMustBeQualified() {
        this.doesNotHaveUniqueName = true;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isWithinSelectedHierarchy() {
        return this.withinSelectedHierarchy;
    }

    public void setWithinSelectedHierarchy(boolean under) {
        this.withinSelectedHierarchy = under;
    }

    public boolean isCanBeRoot() {
        return this.availableRoot && this.children.size() != 0 && this.parents.size() <= 0;
    }

    protected ArrayList copyRelationshipArray(List relationships, SchemaModelCopyTraversalContext ctx) {
        ArrayList<Object> relationshipsCopy = new ArrayList<Object>(relationships.size());
        for (SimpleRelationship rel : relationships) {
            relationshipsCopy.add(rel.copy(ctx));
        }
        return relationshipsCopy;
    }

    protected ArrayList copyAttributesArray(List list, SchemaObject copiedElement) {
        ArrayList<Column> attributesCopy = new ArrayList<Column>(list.size());
        for (Column column : list) {
            Column copy = column.copy();
            copy.setTable(copiedElement);
            attributesCopy.add(copy);
        }
        return attributesCopy;
    }

    public void addParent(SchemaObject parent, int minOccurs, int maxOccurs) {
        if (parent == null) {
            this.availableRoot = true;
            return;
        }
        boolean alreadyThere = false;
        for (Object o : this.parents) {
            SimpleRelationship existingTableRelationship = (SimpleRelationship)o;
            SchemaObject existingTable = existingTableRelationship.getParent();
            if (existingTable != parent) continue;
            alreadyThere = true;
            existingTableRelationship.setMinOccurs(existingTableRelationship.getMinOccurs() + minOccurs);
            if (existingTableRelationship.getMaxOccurs() != -1 && maxOccurs != -1) {
                existingTableRelationship.setMaxOccurs(existingTableRelationship.getMaxOccurs() + maxOccurs);
                continue;
            }
            existingTableRelationship.setMaxOccurs(-1);
        }
        if (!alreadyThere) {
            SimpleRelationship relationship = new SimpleRelationship(parent, this, minOccurs, maxOccurs);
            relationship.addNewRelationship();
        }
    }

    public void addAttribute(Column col) {
        col.setTable(this);
        this.attributes.add(col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String recursiveGetXpath() {
        if (this.recursivityDetector) {
            return null;
        }
        this.recursivityDetector = true;
        try {
            String parentXpath;
            Object o;
            HashSet<String> paths = new HashSet<String>();
            ArrayList<String> xpaths = new ArrayList<String>();
            for (Object o2 : this.parents) {
                String leafXpath;
                Relationship tableRelationship = (Relationship)o2;
                SchemaObject element = tableRelationship.getParent();
                String parentXpath2 = element.recursiveGetXpath();
                if (parentXpath2 == null) {
                    String string = null;
                    return string;
                }
                String childRelXpath = tableRelationship.getChildRelativeXpath();
                if (!childRelXpath.endsWith(leafXpath = this.getRelativeXpath())) {
                    throw new IllegalStateException("Incorrect leaf node for relative xpath");
                }
                String xpathPlusLeaf = parentXpath2.endsWith("/") ? parentXpath2 + childRelXpath : parentXpath2 + "/" + childRelXpath;
                String xpathWithoutLeaf = xpathPlusLeaf.substring(0, xpathPlusLeaf.length() - leafXpath.length() - 1);
                if (paths.contains(xpathWithoutLeaf)) continue;
                paths.add(xpathWithoutLeaf);
                xpaths.add(xpathWithoutLeaf);
            }
            String qname = this.getRelativeXpath();
            StringBuffer xpath = new StringBuffer();
            boolean alsoRoot = this.isUseAsRoot();
            if (xpaths.size() == 0) {
                xpath.append("/");
                xpath.append(qname);
            } else if (xpaths.size() == 1 && alsoRoot) {
                xpath.append("((");
                xpath.append(xpaths.get(0));
                xpath.append('/');
                xpath.append(qname);
                xpath.append(") | (/");
                xpath.append(qname);
                xpath.append("))");
            } else if (xpaths.size() == 1 && !alsoRoot) {
                xpath.append(xpaths.get(0));
                xpath.append('/');
                xpath.append(qname);
            } else if (alsoRoot) {
                xpath.append("(((");
                for (int i = 0; i < xpaths.size(); ++i) {
                    o = xpaths.get(i);
                    parentXpath = (String)o;
                    if (i > 0) {
                        xpath.append(" | ");
                    }
                    xpath.append("(");
                    xpath.append(parentXpath);
                    xpath.append(")");
                }
                xpath.append(")/");
                xpath.append(qname);
                xpath.append(") | (/");
                xpath.append(qname);
                xpath.append("))");
            } else {
                xpath.append("(");
                for (int i = 0; i < xpaths.size(); ++i) {
                    o = xpaths.get(i);
                    parentXpath = (String)o;
                    if (i > 0) {
                        xpath.append(" | ");
                    }
                    xpath.append("(");
                    xpath.append(parentXpath);
                    xpath.append(")");
                }
                xpath.append(")/");
                xpath.append(qname);
            }
            String string = xpath.toString();
            return string;
        }
        finally {
            this.recursivityDetector = false;
        }
    }

    public void cascadeRootSelection(boolean b) {
        HashSet<SchemaObjectKey> visitedElements = new HashSet<SchemaObjectKey>();
        this.setUseAsRoot(b);
        this.setWithinSelectedHierarchy(b);
        visitedElements.add(this.getKey());
        this.cascadeRootSelectionImpl(this.getChildren(), b, visitedElements);
    }

    private void cascadeRootSelectionImpl(List children, boolean b, Set visitedElements) {
        for (Relationship childRelationship : children) {
            SchemaObject child = childRelationship.getChild();
            if (visitedElements.contains(child.getKey())) continue;
            visitedElements.add(child.getKey());
            child.setWithinSelectedHierarchy(b);
            this.cascadeRootSelectionImpl(child.getChildren(), b, visitedElements);
        }
    }

    public String getInputXPath() {
        return this.GetXPath();
    }

    public String getOutputXPath() {
        return this.GetXPath();
    }

    private String GetXPath() {
        String xpath = this.recursiveGetXpath();
        if (xpath == null) {
            String name = this.getName();
            xpath = this.prefix != null && !this.prefix.equals("") ? "//" + this.prefix + ':' + name : "//" + name;
        }
        return xpath;
    }

    public String getRelativeXpath() {
        String name = this.getName();
        String qname = this.prefix != null && !this.prefix.equals("") ? this.prefix + ':' + name : name;
        return qname;
    }

    public List getParents() {
        return this.parents;
    }

    public List getChildren() {
        return this.children;
    }

    public List getAttributes() {
        return this.attributes;
    }

    void mergeChild(Relationship tableRelationship) {
        SchemaObject child = tableRelationship.getChild();
        for (Object oCol : child.getAttributes()) {
            Column col = (Column)oCol;
            int maxOccurs = tableRelationship.getMaxOccurs();
            for (int iOccurrence = 1; iOccurrence <= maxOccurs; ++iOccurrence) {
                int iOccurenceParam = maxOccurs > 1 ? iOccurrence : -1;
                MergedColumn mergedColumn = new MergedColumn(col, tableRelationship, iOccurenceParam);
                this.addAttribute(mergedColumn);
            }
        }
    }

    public void setAllParentRepresentations(int representation, RelationshipProcessor processor) {
        List parents = this.getParents();
        for (Object o : parents) {
            Relationship tableRelationship = (Relationship)o;
            tableRelationship.setType(representation);
            SchemaObject child = tableRelationship.getChild();
            String key = child.getSimpleName() + ':' + child.getNamespace();
            processor.addRelationship(key, new Integer(representation));
        }
    }

    public boolean isUseAsRoot() {
        return this.useAsRoot;
    }

    public void setUseAsRoot(boolean useAsRoot) {
        this.useAsRoot = useAsRoot;
    }

    public boolean isSimpleElement(RelationshipProcessor processor) {
        boolean isSimpleRequest = true;
        return isSimpleRequest;
    }

    public boolean representAsTable() {
        return this.representAsTable;
    }

    public void setRepresentAsTable(boolean table) {
        this.representAsTable = table;
    }

    public List getAllModelColumns() {
        ArrayList<com.metamatrix.modeler.schema.tools.model.jdbc.Column> columns = new ArrayList<com.metamatrix.modeler.schema.tools.model.jdbc.Column>();
        for (Column column : this.attributes) {
            columns.add(column.getColumnImplementation());
        }
        return columns;
    }

    public List getAttributeList() {
        EList result = this.type instanceof XSDComplexTypeDefinition ? ((XSDComplexTypeDefinition)this.type).getAttributeUses() : new ArrayList();
        return result;
    }

    protected String getNamespacePrefix() {
        return this.prefix;
    }

    protected void copy(BaseSchemaObject copy, SchemaModelCopyTraversalContext ctx) {
        ArrayList attributesCopy = this.copyAttributesArray(this.attributes, copy);
        copy.attributes = attributesCopy;
        ArrayList parentsCopy = this.copyRelationshipArray(this.parents, ctx);
        copy.parents = parentsCopy;
        ArrayList childrenCopy = this.copyRelationshipArray(this.children, ctx);
        copy.children = childrenCopy;
        copy.availableRoot = this.availableRoot;
        copy.doesNotHaveUniqueName = this.doesNotHaveUniqueName;
        copy.fileName = this.fileName;
        copy.useAsRoot = this.useAsRoot;
        copy.withinSelectedHierarchy = this.withinSelectedHierarchy;
    }

    public XSDSchema getSchema() {
        return this.schema;
    }

    public boolean hasComplexTypeDefinition() {
        return this.type instanceof XSDComplexTypeDefinition;
    }

    public boolean hasSimpleTypeDefinition() {
        return this.type instanceof XSDSimpleTypeDefinition;
    }

    public XSDComplexTypeContent getContent() {
        XSDComplexTypeContent result = null;
        if (this.type instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.type;
            result = complexType.getContent();
        }
        return result;
    }

    public XSDSimpleTypeDefinition getTextType() {
        XSDSimpleTypeDefinition textType = null;
        if (this.hasSimpleTypeDefinition()) {
            textType = (XSDSimpleTypeDefinition)this.getType();
        } else if (this.hasComplexTypeDefinition()) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.getType();
            XSDComplexTypeContent content = complexType.getContent();
            if (content instanceof XSDSimpleTypeDefinition) {
                textType = (XSDSimpleTypeDefinition)content;
            } else if (complexType.isMixed()) {
                textType = BaseSchemaObject.getStringType(this.getSchema());
            }
        }
        return textType;
    }

    private static XSDSimpleTypeDefinition getStringType(XSDSchema schema) {
        if (stringType == null) {
            XSDSchema schemaForSchema = schema.getSchemaForSchema();
            Map typeIdMap = schemaForSchema.getSimpleTypeIdMap();
            Object o = typeIdMap.get("string");
            stringType = (XSDSimpleTypeDefinition)o;
        }
        return stringType;
    }
}

