/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.soap;

import com.metamatrix.connector.xml.SOAPConnectorState;
import com.metamatrix.connector.xml.XMLConnectorState;
import com.metamatrix.connector.xml.XMLExecution;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.RequestGenerator;
import com.metamatrix.connector.xml.base.Response;
import com.metamatrix.connector.xml.http.HTTPExecutor;
import com.metamatrix.connector.xml.soap.SOAPDocBuilder;
import com.metamatrix.data.exception.ConnectorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class SOAPExecutor
extends HTTPExecutor {
    public SOAPExecutor(XMLConnectorState state, XMLExecution execution) throws ConnectorException {
        super(state, execution);
    }

    protected void modifyRequest(HttpClient client, HttpMethod method) {
        String soapActionHeader = "SOAPAction";
        String schemaAction = this.getExecution().getInfo().getOtherProperties().getProperty("SOAPAction");
        Header soapAction = null;
        if (schemaAction != null && schemaAction.trim().length() > 0) {
            soapAction = new Header("SOAPAction", schemaAction);
        }
        method.addRequestHeader(soapAction);
    }

    public Response getXMLResponse(int invocationNumber) throws ConnectorException {
        SOAPConnectorState state = (SOAPConnectorState)((Object)this.getState());
        super.setAllowHttp500(true);
        Response response = super.getXMLResponse(invocationNumber);
        SOAPDocBuilder.removeEnvelope(state, response);
        return response;
    }

    protected void setRequests(List params, String uriString) throws ConnectorException {
        SOAPConnectorState state = (SOAPConnectorState)((Object)this.getState());
        ArrayList requestPerms = RequestGenerator.getRequestPerms(params);
        CriteriaDesc[] queryParameters = (CriteriaDesc[])requestPerms.get(0);
        PostMethod method = (PostMethod)this.m_requestor.generateMethod(uriString);
        List<CriteriaDesc> newList = Arrays.asList(queryParameters);
        ArrayList<CriteriaDesc> queryList = new ArrayList<CriteriaDesc>(newList);
        SOAPDocBuilder docBuilder = new SOAPDocBuilder();
        String namespacePrefixes = this.getExecutionInfo().getOtherProperties().getProperty("NamespacePrefixes");
        String inputParmsXPath = this.getExecutionInfo().getOtherProperties().getProperty("XPathRootForInput");
        String xmlDoc = docBuilder.createSOAPRequest(state, queryList, namespacePrefixes, inputParmsXPath);
        method.setRequestEntity((RequestEntity)new StringRequestEntity(xmlDoc));
        method.getParams().setVersion(new HttpVersion(1, 0));
        this.request = method;
        this.attemptConditionalLog("XML Connector Framework: request body set to: " + xmlDoc);
        this.getLogger().logDetail("XML Connector Framework: request created");
    }
}

