/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.AbstractCachingConnector;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;

public class XMLConnector
extends AbstractCachingConnector {
    public void initialize(ConnectorEnvironment env) throws ConnectorException {
        try {
            super.initialize(env);
            this.getLogger().logInfo("XML Connector Framework: connector has been initialized");
            this.getLogger().logTrace("XML Connector Framework: connector init properties: " + this.getEnvironment().getProperties());
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void start() throws ConnectorException {
        try {
            this.getLogger().logInfo("XML Connector Framework: connector has been started");
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void stop() {
        super.stop();
        ConnectorLogger logger = this.getLogger();
        if (logger != null) {
            this.getLogger().logInfo("XML Connector Framework: connector has been stopped");
        }
    }

    public Connection getConnection(SecurityContext context) throws ConnectorException {
        try {
            if (this.m_state == null) {
                throw new ConnectorException(Messages.getString("XMLConnector.state.not.set"));
            }
            return this.m_state.getConnection(this, context, this.getEnvironment());
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }
}

