/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.io.Serializable;

public class SessionToken
implements Serializable,
Comparable,
Cloneable {
    public static final long serialVersionUID = -2853708320435636107L;
    private MetaMatrixSessionID sessionID;
    private Serializable trustedToken = null;

    public SessionToken(long id, long pingInterval, int resourceAlgorithm, String clusterName, String userName, String[] productInfo) {
        this.sessionID = new MetaMatrixSessionID(new Long(id), pingInterval, resourceAlgorithm, clusterName, userName, productInfo);
    }

    public SessionToken(MetaMatrixSessionID id) {
        if (id == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0063"));
        }
        this.sessionID = id;
    }

    public SessionToken(MetaMatrixSessionID id, Serializable trustedToken) {
        if (id == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0063"));
        }
        this.sessionID = id;
        this.trustedToken = trustedToken;
    }

    SessionToken(SessionToken token, Serializable trustedToken) {
        this.sessionID = token.sessionID;
        this.trustedToken = trustedToken;
    }

    public String getProductInfo(int index) {
        return this.sessionID.getProductInfo(index);
    }

    public MetaMatrixSessionID getSessionID() {
        return this.sessionID;
    }

    public long getSessionIDValue() {
        return this.sessionID.getValue();
    }

    public String getUsername() {
        return this.sessionID.getUserName();
    }

    public String getClusterName() {
        return this.sessionID.getClusterName();
    }

    public int compareTo(Object o) {
        SessionToken that = (SessionToken)o;
        if (that == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0065"));
        }
        if (that == this) {
            return 0;
        }
        int result = this.sessionID.compareTo(that.sessionID);
        if (result != 0) {
            return result;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            SessionToken that = (SessionToken)obj;
            return this.sessionID.equals(that.sessionID);
        }
        return false;
    }

    public int hashCode() {
        return this.sessionID.hashCode();
    }

    public String toString() {
        return "SessionToken[" + this.getUsername() + "," + this.getSessionIDValue() + "," + this.getClusterName() + "]";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Serializable getTrustedToken() {
        return this.trustedToken;
    }
}

