/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.client.impl;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.lob.LobChunkInputStream;
import com.metamatrix.common.lob.LobChunkReader;
import com.metamatrix.common.types.BlobType;
import com.metamatrix.common.types.ClobType;
import com.metamatrix.common.types.Streamable;
import com.metamatrix.common.types.XMLType;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.client.Results;
import com.metamatrix.dqp.client.impl.FacadeLobChunkProducer;
import com.metamatrix.dqp.client.impl.ServerFacadeImpl;
import com.metamatrix.dqp.message.ParameterInfo;
import com.metamatrix.dqp.message.ResultsMessage;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ResultBatch
implements Results {
    private long requestID;
    private ServerFacadeImpl.ConnectionHolder holder;
    private boolean isLast;
    private int beginRow;
    private int endRow;
    private int rowCount;
    private int columnCount;
    private List[] results;
    private ParameterInfo[] parameterInfo;
    private Map outputParameterMap = new HashMap();
    private boolean update;
    private Exception exception;
    private List warnings;

    ResultBatch(ResultsMessage results, boolean isUpdate, long requestID, ServerFacadeImpl.ConnectionHolder holder) {
        this.requestID = requestID;
        this.holder = holder;
        this.beginRow = results.getFirstRow();
        this.endRow = results.getLastRow();
        this.results = results.getResults();
        this.rowCount = this.results == null ? 0 : this.results.length;
        this.isLast = results.getFinalRow() == this.endRow;
        this.columnCount = results.getColumnNames() == null ? 0 : results.getColumnNames().length;
        this.exception = results.getException();
        this.warnings = results.getWarnings() == null ? Collections.EMPTY_LIST : results.getWarnings();
        this.update = isUpdate;
        this.setParameters(results.getParameters());
    }

    public boolean isLast() {
        return this.isLast;
    }

    public int getBeginRow() {
        return this.beginRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Object getValue(int row, int column) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        if (this.rowCount == 0) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.no_rows"));
        }
        if (row < this.beginRow || row > this.endRow) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.invalid_row", row));
        }
        if (column < 1 || column > this.columnCount) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.invalid_column", column));
        }
        Object val = this.getData(row, column);
        try {
            if (val != null && (val instanceof XMLType || val instanceof ClobType)) {
                LobChunkReader reader = new LobChunkReader(new FacadeLobChunkProducer((Streamable)val, this.requestID, this.holder));
                return new String(reader.getCharacterContents());
            }
            if (val != null && val instanceof BlobType) {
                LobChunkInputStream stream = new LobChunkInputStream(new FacadeLobChunkProducer((Streamable)val, this.requestID, this.holder));
                return stream.getByteContents();
            }
            return val;
        }
        catch (SQLException e) {
            throw new MetaMatrixComponentException(e);
        }
        catch (IOException e) {
            throw new MetaMatrixComponentException(e);
        }
    }

    private Object getData(int row, int column) {
        return this.results[row - this.beginRow].get(column - 1);
    }

    public int getParameterCount() {
        return this.parameterInfo.length;
    }

    public int getParameterType(int index) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        this.validateParameterIndex(index);
        int type = this.parameterInfo[index - 1].getType();
        switch (type) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ResultBatch.invalid_paramtype", type));
    }

    public Object getOutputParameter(int index) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        if (!this.isLast) {
            return new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.not_last_batch"));
        }
        this.validateParameterIndex(index);
        Integer actualIndex = (Integer)this.outputParameterMap.get(new Integer(index));
        if (actualIndex == null) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.not_out_param", index));
        }
        int endOfRows = 0;
        int endOfColumns = 0;
        if (this.rowCount > 0) {
            endOfRows = this.endRow;
            endOfColumns = this.columnCount;
        }
        return this.getData(endOfRows + actualIndex, endOfColumns + actualIndex);
    }

    private void validateParameterIndex(int index) throws MetaMatrixProcessingException {
        if (this.parameterInfo.length == 0) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.no_params"));
        }
        if (index < 1 || index > this.parameterInfo.length) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.invalid_paramindex", index));
        }
    }

    public boolean isUpdate() {
        return this.update;
    }

    public int getUpdateCount() throws MetaMatrixComponentException {
        if (!this.update) {
            throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ResultBatch.not_update"));
        }
        if (this.exception != null) {
            throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ResultBatch.exception_exists"));
        }
        if (this.results == null || this.results.length != 1) {
            throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ResultBatch.update_count_unavailable"));
        }
        Integer val = (Integer)this.getData(1, 1);
        if (val == null) {
            return 0;
        }
        return val;
    }

    public Exception getException() {
        return this.exception;
    }

    public Exception[] getWarnings() {
        return this.warnings.toArray(new Exception[this.warnings.size()]);
    }

    private void setParameters(List parameters) {
        if (parameters == null || parameters.isEmpty()) {
            this.parameterInfo = new ParameterInfo[0];
        } else {
            int outputParameterCount = 0;
            int nonResultSetParameterCount = 0;
            ArrayList<ParameterInfo> paramInfos = new ArrayList<ParameterInfo>(parameters.size());
            for (int i = 0; i < parameters.size(); ++i) {
                ParameterInfo info = (ParameterInfo)parameters.get(i);
                int parameterType = info.getType();
                if (parameterType != 5) {
                    paramInfos.add(info);
                    ++nonResultSetParameterCount;
                }
                if (parameterType != 4 && parameterType != 2 && parameterType != 3) continue;
                this.outputParameterMap.put(new Integer(nonResultSetParameterCount), new Integer(++outputParameterCount));
            }
            this.parameterInfo = paramInfos.toArray(new ParameterInfo[paramInfos.size()]);
        }
        int numOutputParameters = this.outputParameterMap.size();
        if (numOutputParameters > 0) {
            this.endRow -= numOutputParameters;
            this.rowCount -= numOutputParameters;
            this.columnCount -= numOutputParameters;
        }
    }
}

