/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.EquivalenceUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class ExternalizeUtil {
    private ExternalizeUtil() {
    }

    public static void writeArray(ObjectOutput out, Object[] array) throws IOException {
        if (array == null) {
            out.writeInt(0);
        } else {
            int length = array.length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                out.writeObject(array[i]);
            }
        }
    }

    public static void writeCollection(ObjectOutput out, Collection coll) throws IOException {
        if (coll == null) {
            out.writeInt(0);
        } else {
            int size = coll.size();
            if (size > 0) {
                out.writeInt(coll.size());
                Iterator i = coll.iterator();
                while (i.hasNext()) {
                    out.writeObject(i.next());
                }
            }
        }
    }

    public static void writeList(ObjectOutput out, List list) throws IOException {
        if (list == null) {
            out.writeInt(0);
        } else {
            int size = list.size();
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                out.writeObject(list.get(i));
            }
        }
    }

    public static void writeMap(ObjectOutput out, Map map) throws IOException {
        if (map == null) {
            out.writeInt(0);
        } else {
            out.writeInt(map.size());
            Map.Entry entry = null;
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                entry = i.next();
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
    }

    public static String[] readStringArray(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = (String)in.readObject();
        }
        return strings;
    }

    public static List readList(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        Object[] array = new Object[size];
        for (int i = 0; i < size; ++i) {
            array[i] = in.readObject();
        }
        return Arrays.asList(array);
    }

    public static Map readMap(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        HashMap<Object, Object> map = new HashMap<Object, Object>(size + 1, 1.0f);
        for (int i = 0; i < size; ++i) {
            map.put(in.readObject(), in.readObject());
        }
        return map;
    }

    public static void writeThrowable(ObjectOutput out, Throwable t) throws IOException {
        if (t == null || !(t instanceof CoreException) || t instanceof MetaMatrixCoreException) {
            out.writeBoolean(false);
            out.writeObject(t);
        } else {
            out.writeBoolean(true);
            ExternalizeUtil.writeCoreException(out, (CoreException)t);
        }
    }

    public static void writeCoreException(ObjectOutput out, CoreException e) throws IOException {
        ExternalizeUtil.writeIStatus(out, e.getStatus());
        out.writeObject(e.getStackTrace());
    }

    public static void writeIStatus(ObjectOutput out, IStatus status) throws IOException {
        StatusImpl serializableStatus = new StatusImpl(status);
        out.writeObject(serializableStatus);
    }

    public static Throwable readThrowable(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean isCoreException = in.readBoolean();
        if (isCoreException) {
            return ExternalizeUtil.readCoreException(in);
        }
        return (Throwable)in.readObject();
    }

    public static CoreException readCoreException(ObjectInput in) throws IOException, ClassNotFoundException {
        IStatus status = ExternalizeUtil.readIStatus(in);
        CoreException exception = new CoreException(status);
        StackTraceElement[] stackTrace = (StackTraceElement[])in.readObject();
        exception.setStackTrace(stackTrace);
        return exception;
    }

    public static IStatus readIStatus(ObjectInput in) throws IOException, ClassNotFoundException {
        IStatus status = (IStatus)in.readObject();
        return status;
    }

    public static class StatusImpl
    implements IStatus,
    Externalizable {
        public static final long serialVersionUID = 0L;
        private StatusImpl[] children = null;
        private int code = 0;
        private Throwable exception = null;
        private String message = null;
        private String plugin = null;
        private int severity = 0;
        private boolean multiStatus = false;
        private boolean ok = false;

        public StatusImpl() {
        }

        public StatusImpl(int severity, String pluginId, int code, String message, Throwable exception) {
            this.severity = severity;
            this.plugin = pluginId;
            this.code = code;
            this.message = message;
            this.exception = exception;
        }

        public StatusImpl(IStatus original) {
            if (original.getChildren() != null) {
                int length = original.getChildren().length;
                this.children = new StatusImpl[length];
                for (int i = 0; i < length; ++i) {
                    if (original.getChildren()[i] == null) continue;
                    this.children[i] = new StatusImpl(original.getChildren()[i]);
                }
            }
            this.code = original.getCode();
            this.exception = original.getException();
            this.message = original.getMessage();
            this.plugin = original.getPlugin();
            this.severity = original.getSeverity();
            this.multiStatus = original.isMultiStatus();
            this.ok = original.isOK();
        }

        public StatusImpl(IStatus[] children, int code, Throwable exception, String message, String plugin, int severity, boolean multiStatus, boolean ok) {
            if (children != null) {
                int length = children.length;
                this.children = new StatusImpl[length];
                for (int i = 0; i < length; ++i) {
                    if (children[i] == null) continue;
                    this.children[i] = new StatusImpl(children[i]);
                }
            }
            this.code = code;
            this.exception = exception;
            this.message = message;
            this.plugin = plugin;
            this.severity = severity;
            this.multiStatus = multiStatus;
            this.ok = ok;
        }

        public IStatus[] getChildren() {
            return this.children;
        }

        public int getCode() {
            return this.code;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getMessage() {
            return this.message;
        }

        public String getPlugin() {
            return this.plugin;
        }

        public int getSeverity() {
            return this.severity;
        }

        public boolean isMultiStatus() {
            return this.multiStatus;
        }

        public boolean isOK() {
            return this.ok;
        }

        public boolean matches(int severityMask) {
            return (this.severity & severityMask) != 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IStatus)) {
                return false;
            }
            IStatus other = (IStatus)obj;
            return EquivalenceUtil.areEquivalent(this.children, other.getChildren()) && this.code == other.getCode() && EquivalenceUtil.areEqual(this.message, other.getMessage()) && EquivalenceUtil.areEqual(this.plugin, other.getPlugin()) && this.severity == other.getSeverity() && this.multiStatus == other.isMultiStatus() && this.ok == other.isOK();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int length = in.readInt();
            this.children = new StatusImpl[length];
            for (int i = 0; i < length; ++i) {
                this.children[i] = (StatusImpl)in.readObject();
            }
            this.code = in.readInt();
            this.exception = ExternalizeUtil.readThrowable(in);
            this.message = (String)in.readObject();
            this.plugin = (String)in.readObject();
            this.severity = in.readInt();
            this.multiStatus = in.readBoolean();
            this.ok = in.readBoolean();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            ExternalizeUtil.writeArray(out, this.children);
            out.writeInt(this.code);
            ExternalizeUtil.writeThrowable(out, this.exception);
            out.writeObject(this.message);
            out.writeObject(this.plugin);
            out.writeInt(this.severity);
            out.writeBoolean(this.multiStatus);
            out.writeBoolean(this.ok);
        }
    }
}

