/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.lob;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.lob.LobChunkProducer;
import com.metamatrix.common.log.LogManager;
import java.io.IOException;

public class BufferManagerLobChunkStream
implements LobChunkProducer {
    TupleSourceID sourceId;
    BufferManager bufferMgr;
    int position = 0;

    public BufferManagerLobChunkStream(String persitentId, BufferManager bufferMgr) {
        this.sourceId = new TupleSourceID(persitentId);
        this.bufferMgr = bufferMgr;
    }

    public LobChunk getNextChunk() throws IOException {
        try {
            ++this.position;
            return this.bufferMgr.getStreamablePart(this.sourceId, this.position);
        }
        catch (TupleSourceNotFoundException e) {
            String msg = CommonPlugin.Util.getString("BufferManagerLobChunkStream.no_tuple_source", new Object[]{this.sourceId});
            LogManager.logWarning("BUFFER_MGR", (Throwable)e, msg);
            throw new IOException(msg);
        }
        catch (MetaMatrixComponentException e) {
            String msg = CommonPlugin.Util.getString("BufferManagerLobChunkStream.error_processing", new Object[]{this.sourceId});
            LogManager.logWarning("BUFFER_MGR", (Throwable)e, msg);
            throw new IOException(msg);
        }
    }

    public void close() throws IOException {
    }
}

