/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BatchedUpdateCommand;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.ProcedureContainer;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.DeclareStatement;
import com.metamatrix.query.sql.proc.LoopStatement;
import com.metamatrix.query.sql.symbol.ScalarSubquery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CommandCollectorVisitor
extends LanguageVisitor {
    private List commands = new ArrayList();
    private boolean embeddedOnly;
    private boolean nonEmbeddedOnly;

    public CommandCollectorVisitor(boolean embeddedOnly, boolean nonEmbeddedOnly) {
        this.embeddedOnly = embeddedOnly;
        this.nonEmbeddedOnly = nonEmbeddedOnly;
    }

    public List getCommands() {
        return this.commands;
    }

    public void visit(ExistsCriteria obj) {
        if (!this.nonEmbeddedOnly) {
            this.commands.add(obj.getCommand());
        }
    }

    public void visit(ScalarSubquery obj) {
        if (!this.nonEmbeddedOnly) {
            this.commands.add(obj.getCommand());
        }
    }

    public void visit(SubqueryCompareCriteria obj) {
        if (!this.nonEmbeddedOnly) {
            this.commands.add(obj.getCommand());
        }
    }

    public void visit(SubqueryFromClause obj) {
        if (!this.nonEmbeddedOnly) {
            this.commands.add(obj.getCommand());
        }
    }

    public void visit(SubquerySetCriteria obj) {
        if (!this.nonEmbeddedOnly) {
            this.commands.add(obj.getCommand());
        }
    }

    public void visit(CommandStatement obj) {
        if (!this.nonEmbeddedOnly) {
            this.commands.add(obj.getCommand());
        }
    }

    public void visit(AssignmentStatement obj) {
        if (!this.nonEmbeddedOnly && obj.hasCommand()) {
            this.commands.add(obj.getCommand());
        }
    }

    public void visit(LoopStatement obj) {
        if (!this.nonEmbeddedOnly) {
            this.commands.add(obj.getCommand());
        }
    }

    public void visit(UnaryFromClause obj) {
        if (!this.embeddedOnly && obj.getExpandedCommand() != null) {
            this.commands.add(obj.getExpandedCommand());
        }
    }

    public void visit(SetQuery obj) {
        if (!this.nonEmbeddedOnly) {
            Iterator i = obj.getQueries().iterator();
            while (i.hasNext()) {
                QueryCommand command = (QueryCommand)i.next();
                if (command instanceof SetQuery) {
                    this.visit((SetQuery)command);
                    continue;
                }
                this.commands.addAll(command.getSubCommands());
            }
        }
    }

    public void visit(BatchedUpdateCommand obj) {
        if (!this.embeddedOnly) {
            this.commands.addAll(obj.getUpdateCommands());
        }
    }

    public void visit(ProcedureContainer obj) {
        if (!this.embeddedOnly && obj.getSubCommand() != null) {
            this.commands.add(obj.getSubCommand());
        }
    }

    public static final List getCommands(LanguageObject obj) {
        return CommandCollectorVisitor.getCommands(obj, false, false);
    }

    public static final List getCommands(LanguageObject obj, boolean embeddedOnly) {
        return CommandCollectorVisitor.getCommands(obj, embeddedOnly, false);
    }

    private static final List getCommands(LanguageObject obj, boolean embeddedOnly, boolean nonEmbeddedOnly) {
        CommandCollectorVisitor visitor = new CommandCollectorVisitor(embeddedOnly, nonEmbeddedOnly);
        PreOrderNavigator navigator = new PreOrderNavigator(visitor){

            public void visit(LoopStatement obj) {
                this.preVisitVisitor((LanguageObject)obj);
                this.visitNode((LanguageObject)obj.getBlock());
            }

            public void visit(CommandStatement obj) {
                this.preVisitVisitor((LanguageObject)obj);
            }

            public void visit(AssignmentStatement obj) {
                this.preVisitVisitor((LanguageObject)obj);
                if (obj.hasExpression()) {
                    this.visitNode((LanguageObject)obj.getExpression());
                }
            }

            public void visit(DeclareStatement obj) {
                this.preVisitVisitor((LanguageObject)obj);
                if (obj.hasExpression()) {
                    this.visitNode((LanguageObject)obj.getExpression());
                }
            }

            public void visit(SetQuery obj) {
                this.preVisitVisitor((LanguageObject)obj);
                this.visitNode((LanguageObject)obj.getOrderBy());
                this.visitNode((LanguageObject)obj.getLimit());
                this.visitNode((LanguageObject)obj.getOption());
            }
        };
        obj.acceptVisitor((LanguageVisitor)navigator);
        return visitor.getCommands();
    }

    public static final List getNonEmbeddedCommands(LanguageObject obj) {
        return CommandCollectorVisitor.getCommands(obj, false, true);
    }
}

