/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.webservice;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.wsdl.Definitions;
import com.metamatrix.metamodels.wsdl.Import;
import com.metamatrix.metamodels.wsdl.Types;
import com.metamatrix.modeler.compare.ModelGenerator;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.MetamodelDescriptor;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.webservice.AbstractWebServiceResource;
import com.metamatrix.modeler.internal.webservice.FileSystemWebServiceResource;
import com.metamatrix.modeler.internal.webservice.IInternalWebServiceXsdResource;
import com.metamatrix.modeler.internal.webservice.NonResolvableXSDSchema;
import com.metamatrix.modeler.internal.webservice.UnresolvedWebServiceResource;
import com.metamatrix.modeler.internal.webservice.WebServiceResources;
import com.metamatrix.modeler.internal.webservice.WebServiceXsdResource;
import com.metamatrix.modeler.internal.webservice.WorkspaceFileWebServiceResource;
import com.metamatrix.modeler.webservice.IWebServiceModelBuilder;
import com.metamatrix.modeler.webservice.IWebServiceResource;
import com.metamatrix.modeler.webservice.IWebServiceXsdResource;
import com.metamatrix.modeler.webservice.WebServicePlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDFactoryImpl;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BasicWebServiceModelBuilder
implements IWebServiceModelBuilder {
    private IResource parentResource;
    private MetamodelDescriptor modelDescriptor;
    private IPath modelPath;
    private IPath xmlModel;
    private final List resources;
    private Collection selectedWsdlOperations;
    private final Map emfResourceUriByWebServiceResource;
    private final WebServiceResources resourceSet;
    private List xsdWorkspaceResources;
    private final Object xsdWorkspaceResourcesLock = new Object();
    private boolean saveAllBeforeFinish = false;
    private Map urlMap = new HashMap();

    public BasicWebServiceModelBuilder() {
        this.resources = new ArrayList();
        this.resourceSet = new WebServiceResources();
        this.emfResourceUriByWebServiceResource = new HashMap();
        this.selectedWsdlOperations = new HashSet();
    }

    public IPath getXmlModel() {
        return this.xmlModel;
    }

    public IResource getParentResource() {
        return this.parentResource;
    }

    public IPath getModelPath() {
        return this.modelPath;
    }

    public Map getUrlMap() {
        return this.urlMap;
    }

    public void setMetamodelDescriptor(MetamodelDescriptor theDescriptor) {
        this.modelDescriptor = theDescriptor;
    }

    public void setParentResource(IResource theResource) {
        this.parentResource = theResource;
    }

    public void setModelPath(IPath thePath) {
        this.modelPath = thePath;
    }

    public void setXmlModel(IPath theXmlModel) {
        this.xmlModel = theXmlModel;
    }

    protected IWebServiceResource addOrFind(IWebServiceResource resource) {
        Iterator iter = this.resources.iterator();
        while (iter.hasNext()) {
            IWebServiceResource r = (IWebServiceResource)iter.next();
            if (!r.equals(resource)) continue;
            return r;
        }
        this.resources.add(resource);
        return resource;
    }

    public IWebServiceResource addResource(File theFile) throws CoreException {
        ArgCheck.isNotNull((Object)theFile);
        if (!theFile.exists()) {
            Object[] params = new Object[]{theFile};
            String msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.FileDoesNotExist", params);
            throw new IllegalArgumentException(msg);
        }
        URI uri = URI.createFileURI((String)theFile.getAbsolutePath());
        Resource resource = null;
        try {
            resource = this.resourceSet.add(uri);
        }
        catch (Exception theException) {
            this.resourceSet.remove(uri);
            String msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.ProblemLoadingWsdl", (Object)theFile);
            Status status = new Status(4, "com.metamatrix.modeler.webservice", 0, msg, (Throwable)theException);
            throw new CoreException((IStatus)status);
        }
        String targetNamespace = this.resourceSet.getTargetNamespace(resource);
        FileSystemWebServiceResource wsResource = new FileSystemWebServiceResource(targetNamespace, theFile);
        this.emfResourceUriByWebServiceResource.put(wsResource.getFullPath(), uri);
        wsResource = (AbstractWebServiceResource)this.addOrFind((IWebServiceResource)wsResource);
        return wsResource;
    }

    public IWebServiceResource addResource(IFile theFile) throws CoreException {
        ArgCheck.isNotNull((Object)theFile);
        if (!theFile.exists()) {
            Object[] params = new Object[]{theFile};
            String msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.FileDoesNotExist", params);
            throw new IllegalArgumentException(msg);
        }
        URI uri = URI.createFileURI((String)theFile.getFullPath().toString());
        Resource resource = null;
        try {
            resource = this.resourceSet.add(uri);
        }
        catch (Exception theException) {
            this.resourceSet.remove(uri);
            String msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.ProblemLoadingWsdl", (Object)theFile);
            Status status = new Status(4, "com.metamatrix.modeler.webservice", 0, msg, (Throwable)theException);
            throw new CoreException((IStatus)status);
        }
        String targetNamespace = this.resourceSet.getTargetNamespace(resource);
        WorkspaceFileWebServiceResource wsResource = new WorkspaceFileWebServiceResource(targetNamespace, theFile);
        this.emfResourceUriByWebServiceResource.put(wsResource.getFullPath(), uri);
        wsResource = (AbstractWebServiceResource)this.addOrFind((IWebServiceResource)wsResource);
        return wsResource;
    }

    public void resolve(IWebServiceResource resource, File theFile) {
        Collection resolvesResources;
        ArgCheck.isNotNull((Object)resource);
        ArgCheck.isNotNull((Object)theFile);
        FileSystemWebServiceResource resolved = new FileSystemWebServiceResource(resource.getNamespace(), theFile);
        IWebServiceResource origResolvedResource = resolved.getResolvedResource();
        if (resource instanceof AbstractWebServiceResource) {
            ((AbstractWebServiceResource)resource).setResolvedResource((IWebServiceResource)resolved);
        }
        if (origResolvedResource != null && (resolvesResources = origResolvedResource.getResourcesResolved()).size() == 0) {
            this.remove(origResolvedResource);
        }
    }

    public void unresolve(IWebServiceResource resource) {
        URI uri;
        ArgCheck.isNotNull((Object)resource);
        if (resource.isResolved()) {
            resource.setResolvedResource(null);
        }
        if ((uri = (URI)this.emfResourceUriByWebServiceResource.remove(resource.getFullPath())) != null) {
            this.resourceSet.remove(uri);
        }
    }

    public void resolve(IWebServiceResource resource, IFile theFile) {
        Collection resolvesResources;
        ArgCheck.isNotNull((Object)resource);
        ArgCheck.isNotNull((Object)theFile);
        WorkspaceFileWebServiceResource resolved = new WorkspaceFileWebServiceResource(resource.getNamespace(), theFile);
        IWebServiceResource origResolvedResource = resolved.getResolvedResource();
        if (resource instanceof AbstractWebServiceResource) {
            ((AbstractWebServiceResource)resource).setResolvedResource((IWebServiceResource)resolved);
        }
        if (origResolvedResource != null && (resolvesResources = origResolvedResource.getResourcesResolved()).size() == 0) {
            this.remove(origResolvedResource);
        }
    }

    public void remove(IWebServiceResource theResource) {
        ArgCheck.isNotNull((Object)theResource);
        if (!this.resources.remove(theResource)) {
            return;
        }
        URI uri = (URI)this.emfResourceUriByWebServiceResource.remove(theResource.getFullPath());
        if (uri != null) {
            this.resourceSet.remove(uri);
        }
        if (theResource instanceof AbstractWebServiceResource) {
            AbstractWebServiceResource wsResource = (AbstractWebServiceResource)theResource;
            wsResource.removeFromAllReferencers();
            Iterator iter = wsResource.getReferencedResources().iterator();
            while (iter.hasNext()) {
                AbstractWebServiceResource referenced = (AbstractWebServiceResource)iter.next();
                wsResource.removeReferencedResource((IWebServiceResource)referenced);
                if (referenced.getReferencingResources().size() != 0) continue;
                this.remove((IWebServiceResource)referenced);
            }
        }
    }

    public Collection getResources() {
        return this.resources;
    }

    public Resource getEmfResource(IWebServiceResource theResource) {
        URI uri = (URI)this.emfResourceUriByWebServiceResource.get(theResource.getFullPath());
        if (uri != null) {
            return this.resourceSet.get(uri);
        }
        return null;
    }

    public Collection getWSDLResources() {
        ArrayList<IWebServiceResource> resourcesCollection = new ArrayList<IWebServiceResource>();
        LinkedList<IWebServiceResource> resourcesToProcessForDependencies = new LinkedList<IWebServiceResource>(this.resources);
        while (!resourcesToProcessForDependencies.isEmpty()) {
            URI uri;
            Resource resourceToProcess;
            IWebServiceResource wsResourceToProcess = (IWebServiceResource)resourcesToProcessForDependencies.removeFirst();
            resourcesCollection.add(wsResourceToProcess);
            if (wsResourceToProcess == null || wsResourceToProcess instanceof UnresolvedWebServiceResource || !this.resourceSet.isWsdl(resourceToProcess = this.resourceSet.add(uri = URI.createFileURI((String)wsResourceToProcess.getFullPath())))) continue;
            EList roots = resourceToProcess.getContents();
            Iterator iter = roots.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!(object instanceof Definitions)) continue;
                Definitions defns = (Definitions)object;
                EList imports = defns.getImports();
                Iterator iter2 = imports.iterator();
                while (iter2.hasNext()) {
                    File f;
                    IWebServiceResource wsr = null;
                    Import theImport = (Import)iter2.next();
                    URI locationUri = URI.createURI((String)theImport.getLocation());
                    URI resolvedLocationUri = locationUri.resolve(uri);
                    if (resolvedLocationUri != null && resolvedLocationUri.isFile() && (f = new File(resolvedLocationUri.toFileString())).exists()) {
                        wsr = new FileSystemWebServiceResource(theImport.getNamespace(), f);
                    }
                    if (wsr == null) {
                        wsr = new UnresolvedWebServiceResource(theImport.getNamespace());
                    }
                    if ((wsr = this.addOrFind(wsr)) instanceof AbstractWebServiceResource) {
                        ((AbstractWebServiceResource)wsResourceToProcess).addReferencedResource(wsr);
                    }
                    if (this.emfResourceUriByWebServiceResource.get(wsr.getFullPath()) != null) continue;
                    this.emfResourceUriByWebServiceResource.put(wsr.getFullPath(), resolvedLocationUri);
                    resourcesToProcessForDependencies.add(wsr);
                }
            }
        }
        return resourcesCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getXsdDestinations() {
        List xsdResources = this.xsdWorkspaceResources;
        if (xsdResources == null) {
            Object object = this.xsdWorkspaceResourcesLock;
            synchronized (object) {
                if (this.xsdWorkspaceResources == null) {
                    this.xsdWorkspaceResources = new ArrayList();
                    List xsdWsrTuples = this.doDiscoverReferencedXsds();
                    ArrayList usedNames = new ArrayList();
                    Iterator iter = xsdWsrTuples.iterator();
                    while (iter.hasNext()) {
                        IWebServiceXsdResource wsXsdResource;
                        XSDWebServiceResourceTuple tuple = (XSDWebServiceResourceTuple)iter.next();
                        XSDSchema schema = tuple.getSchema();
                        IWebServiceResource wsr = tuple.getResource();
                        boolean inWorkspaceAlready = wsr instanceof WorkspaceFileWebServiceResource;
                        if (!wsr.isWsdl() && (!wsr.isXsd() || inWorkspaceAlready) || (wsXsdResource = this.doCreateWebServiceXsdResource(schema, wsr, usedNames)) == null) continue;
                        this.xsdWorkspaceResources.add(wsXsdResource);
                    }
                }
                xsdResources = this.xsdWorkspaceResources;
            }
        }
        return xsdResources;
    }

    public void setDestinationPath(IWebServiceXsdResource xsdResource, IPath workspacePathForXsd) {
        if (xsdResource instanceof IInternalWebServiceXsdResource) {
            IPath existing = xsdResource.getDestinationPath();
            boolean match = false;
            if (existing == null) {
                if (workspacePathForXsd == null) {
                    match = true;
                }
            } else {
                match = workspacePathForXsd == null ? existing.segmentCount() == 0 : existing.makeAbsolute().equals(workspacePathForXsd.makeAbsolute());
            }
            if (!match) {
                ((IInternalWebServiceXsdResource)xsdResource).setDestinationPath(workspacePathForXsd.makeAbsolute());
            }
        }
    }

    public IWebServiceXsdResource doCreateWebServiceXsdResource(XSDSchema schema, IWebServiceResource origResource, List usedNames) {
        WebServiceXsdResource result = new WebServiceXsdResource(schema, schema.getTargetNamespace(), schema.eResource().getURI().toFileString());
        try {
            URI schemaUri = schema.eResource().getURI();
            schemaUri = schemaUri.isFile() ? URI.createFileURI((String)schemaUri.toFileString()) : schema.eResource().getURI();
            URI wsdlUri = URI.createFileURI((String)origResource.getFullPath());
            IPath webServiceContainerPath = this.modelPath.removeLastSegments(1);
            if (wsdlUri.equals((Object)schemaUri)) {
                URI wsdlUriWOFileExtension = wsdlUri.trimFileExtension();
                String name = wsdlUriWOFileExtension.lastSegment();
                String uniqueName = this.getUniqueName(name, usedNames);
                IPath uniqueSchemaNamePath = webServiceContainerPath.append(uniqueName + ".xsd");
                result.setDestinationPath(uniqueSchemaNamePath);
            } else {
                URI relativeUri = schemaUri.deresolve(wsdlUri);
                if (!relativeUri.isFile()) {
                    relativeUri = URI.createURI((String)relativeUri.path());
                }
                String workspacePath = null;
                workspacePath = relativeUri.isRelative() ? relativeUri.toString() : schemaUri.lastSegment();
                IPath newPath = webServiceContainerPath.append(workspacePath);
                result.setDestinationPath(newPath);
            }
        }
        catch (RuntimeException err) {
            WebServicePlugin.Util.log((Throwable)err);
        }
        return result;
    }

    private String getUniqueName(String name, Collection collection) {
        if (collection == null) {
            collection = Collections.EMPTY_SET;
        }
        String result = name;
        int incr = 1;
        while (collection.contains(result)) {
            result = name + incr;
            ++incr;
        }
        collection.add(result);
        return result;
    }

    protected List doDiscoverReferencedXsds() {
        LinkedList<XSDWebServiceResourceTuple> wsResourceTuples = new LinkedList<XSDWebServiceResourceTuple>();
        ArrayList<String> schemaPathsAlreadyAdded = new ArrayList<String>();
        Iterator iter = this.getResources().iterator();
        while (iter.hasNext()) {
            Resource emfResource;
            IWebServiceResource wsr = (IWebServiceResource)iter.next();
            IWebServiceResource resolved = wsr.getLastResolvedResource();
            if (resolved == null) continue;
            boolean findXsdSchema = false;
            if (resolved.isWsdl()) {
                findXsdSchema = true;
            } else if (resolved.isXsd() && !(resolved instanceof WorkspaceFileWebServiceResource)) {
                findXsdSchema = true;
            }
            if (!findXsdSchema || (emfResource = this.getEmfResource(wsr)) == null) continue;
            EList roots = emfResource.getContents();
            Iterator rootIter = roots.iterator();
            while (rootIter.hasNext()) {
                EObject root = (EObject)rootIter.next();
                ArrayList schemas = new ArrayList();
                if (root instanceof Definitions) {
                    schemas.addAll(this.doDiscoverReferencedXsdsForWSDLResource((Definitions)root, emfResource));
                } else if (root instanceof XSDSchema) {
                    schemas.addAll(this.processSchemas((XSDSchema)root, schemas, emfResource, new ArrayList()));
                }
                Iterator schemaIter = schemas.iterator();
                while (schemaIter.hasNext()) {
                    XSDSchema schema = (XSDSchema)schemaIter.next();
                    if (schema == null) continue;
                    XSDWebServiceResourceTuple tuple = new XSDWebServiceResourceTuple(wsr, schema);
                    String schemaPath = schema.eResource().getURI().toString();
                    if (root instanceof Definitions) {
                        wsResourceTuples.add(tuple);
                        continue;
                    }
                    if (schemaPathsAlreadyAdded.contains(schemaPath)) continue;
                    schemaPathsAlreadyAdded.add(schemaPath);
                    wsResourceTuples.add(tuple);
                }
            }
        }
        return wsResourceTuples;
    }

    protected List doDiscoverReferencedXsdsForWSDLResource(Definitions wsdlDefinition, Resource emfResource) {
        EList schemasFromTypes;
        ArrayList schemas = new ArrayList();
        Types types = wsdlDefinition.getTypes();
        if (types != null && (schemasFromTypes = types.getSchemas()) != null) {
            Iterator itSchemas = schemasFromTypes.iterator();
            while (itSchemas.hasNext()) {
                XSDSchemaImpl schemaTemp = (XSDSchemaImpl)itSchemas.next();
                this.processSchemas((XSDSchema)schemaTemp, schemas, emfResource, new ArrayList());
            }
        }
        return schemas;
    }

    protected List getSchemaImportsAndIncludes(XSDSchema schema) {
        LinkedList referencingDirectives = new LinkedList();
        Iterator iter = schema.eContents().iterator();
        while (iter.hasNext()) {
            Object contentObject = iter.next();
            if (contentObject instanceof XSDSchemaDirective) {
                referencingDirectives.add(contentObject);
                continue;
            }
            if (contentObject instanceof XSDAnnotation) continue;
            break;
        }
        return referencingDirectives;
    }

    protected List processSchemas(XSDSchema schema, List schemas, Resource referrringResource, List schemaLocationsAlreadyAdded) {
        Iterator contents = schema.getContents().iterator();
        while (contents.hasNext()) {
            XSDSchemaContent xsdSchemaContent = (XSDSchemaContent)contents.next();
            if (xsdSchemaContent instanceof XSDSchemaDirective) {
                Object o;
                Resource resSchemaResource;
                URI uriSchemaLocation;
                block11: {
                    NonResolvableXSDSchema xsdImpl;
                    XSDSchemaDirective xsdImportImpl = (XSDSchemaDirective)xsdSchemaContent;
                    String sSchemaLocation = xsdImportImpl.getSchemaLocation();
                    if (sSchemaLocation == null) {
                        Node schemaLocationNode = xsdImportImpl.getElement().getAttributes().getNamedItem("schemaLocation");
                        if (schemaLocationNode == null) continue;
                        sSchemaLocation = schemaLocationNode.toString();
                        sSchemaLocation = this.trimNamedItem(sSchemaLocation, "schemaLocation");
                    }
                    if ((uriSchemaLocation = URI.createURI((String)sSchemaLocation)).isRelative()) {
                        URI referringResourceUri = referrringResource.getURI();
                        uriSchemaLocation = uriSchemaLocation.resolve(referringResourceUri);
                    }
                    if (schemaLocationsAlreadyAdded.contains(uriSchemaLocation)) continue;
                    resSchemaResource = null;
                    try {
                        resSchemaResource = ModelerCore.getModelContainer().getResource(uriSchemaLocation, true);
                        if (resSchemaResource == null) {
                            NonResolvableXSDSchema xsdImpl2 = new NonResolvableXSDSchema(uriSchemaLocation);
                            if (!schemas.contains(xsdImpl2)) {
                                schemas.add(xsdImpl2);
                            }
                            String sMessage = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.ProblemLoadingXsdFromImport", (Object)URI.decode((String)uriSchemaLocation.toString()));
                            this.addDiagnosticToSchema((XSDSchemaImpl)xsdImpl2, sMessage);
                        }
                    }
                    catch (CoreException theException) {
                        xsdImpl = new NonResolvableXSDSchema(uriSchemaLocation);
                        this.addDiagnosticToSchema((XSDSchemaImpl)xsdImpl, theException.getLocalizedMessage());
                        if (!schemas.contains(xsdImpl)) {
                            schemas.add(xsdImpl);
                        }
                    }
                    catch (Exception theException) {
                        xsdImpl = new NonResolvableXSDSchema(uriSchemaLocation);
                        this.addDiagnosticToSchema((XSDSchemaImpl)xsdImpl, theException.getLocalizedMessage());
                        if (schemas.contains(xsdImpl)) break block11;
                        schemas.add(xsdImpl);
                    }
                }
                if (resSchemaResource == null || resSchemaResource.getContents() == null || resSchemaResource.getContents().size() <= 0 || !((o = resSchemaResource.getContents().get(0)) instanceof XSDSchema)) continue;
                XSDSchema tempSchema = (XSDSchema)o;
                schemaLocationsAlreadyAdded.add(uriSchemaLocation);
                if (!schemas.contains(o)) {
                    schemas.add(o);
                }
                this.processSchemas(tempSchema, schemas, resSchemaResource, schemaLocationsAlreadyAdded);
                continue;
            }
            if (xsdSchemaContent instanceof XSDAnnotation) continue;
            if (schemas.contains(schema)) break;
            schemas.add(schema);
            break;
        }
        return schemas;
    }

    private void addDiagnosticToSchema(XSDSchemaImpl schema, String sMessage) {
        XSDDiagnostic xsdDiagnostic = new XSDFactoryImpl().createXSDDiagnostic();
        XSDDiagnosticSeverity severity = XSDDiagnosticSeverity.get((int)1);
        xsdDiagnostic.setSeverity(severity);
        xsdDiagnostic.setMessage(sMessage);
        xsdDiagnostic.setPrimaryComponent((XSDConcreteComponent)schema);
        xsdDiagnostic.setNode((Node)schema.getElement());
        Element theElement = schema.getElement();
        xsdDiagnostic.setNode((Node)theElement);
        schema.getDiagnostics().add((Object)xsdDiagnostic);
    }

    private String trimNamedItem(String sNamedItem, String sId) {
        String sResult = sNamedItem;
        String sMatchString = sId + "=" + "\"";
        if (sResult.startsWith(sMatchString)) {
            sResult = sResult.substring(sMatchString.length() - 1);
        }
        sResult = sResult.replace('\"', ' ');
        sResult = sResult.trim();
        return sResult;
    }

    public String getNamespaceFromImport(XSDSchema schema) {
        String sResultNamespace = null;
        for (int i = 0; i < schema.eContents().size(); ++i) {
            NamedNodeMap nodeMap;
            XSDImportImpl xsdImport;
            Element element;
            Object o = schema.eContents().get(i);
            if (!(o instanceof XSDImportImpl) || (element = (xsdImport = (XSDImportImpl)o).getElement()) == null || (nodeMap = element.getAttributes()) == null) continue;
            sResultNamespace = nodeMap.getNamedItem("namespace").toString();
            break;
        }
        return sResultNamespace;
    }

    public IStatus validateWSDLNamespaces() {
        String msg;
        LinkedList<Object> problems = new LinkedList<Object>();
        boolean foundErrors = false;
        if (this.parentResource == null) {
            msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.MissingWebServiceModelLocation");
            problems.add(new Status(4, "com.metamatrix.modeler.webservice", 18107, msg, null));
            foundErrors = true;
        } else if (!this.parentResource.exists()) {
            msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.NonExistantWebServiceModelLocation");
            problems.add(new Status(4, "com.metamatrix.modeler.webservice", 18106, msg, null));
            foundErrors = true;
        }
        if (this.modelPath == null) {
            msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.MissingWebServiceModelPath");
            problems.add(new Status(4, "com.metamatrix.modeler.webservice", 18105, msg, null));
            foundErrors = true;
        }
        if (this.modelDescriptor == null) {
            msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.MissingWebServiceModelDescriptor");
            problems.add(new Status(4, "com.metamatrix.modeler.webservice", 18104, msg, null));
            foundErrors = true;
        }
        ArrayList<Status> unresolved = new ArrayList<Status>();
        Iterator itr = this.getResources().iterator();
        while (itr.hasNext()) {
            IWebServiceResource resource = (IWebServiceResource)itr.next();
            if (resource.isResolved()) continue;
            Object[] params = new Object[]{resource.getNamespace()};
            String msg2 = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.UnresolvedNamespace", params);
            unresolved.add(new Status(4, "com.metamatrix.modeler.webservice", 18102, msg2, null));
            foundErrors = true;
        }
        if (!unresolved.isEmpty()) {
            int size = unresolved.size();
            if (size == 1) {
                problems.add(unresolved.get(0));
            } else if (size > 1) {
                IStatus[] errors = new IStatus[size];
                for (int i = 0; i < size; ++i) {
                    errors[i] = (IStatus)unresolved.get(i);
                }
                Object[] params = new Object[]{new Integer(size)};
                String msg3 = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.MultipleUnresolvedNamespaces", params);
                problems.add(new MultiStatus("com.metamatrix.modeler.webservice", 18102, errors, msg3, null));
            }
        }
        return this.constructStatuses(problems, foundErrors);
    }

    public IStatus validateXSDNamespaces() {
        LinkedList<IStatus> problems = new LinkedList<IStatus>();
        boolean foundErrors = false;
        Iterator destIter = this.getXsdDestinations().iterator();
        while (destIter.hasNext()) {
            IWebServiceXsdResource dest = (IWebServiceXsdResource)destIter.next();
            IStatus status = dest.isValid();
            if (status.getSeverity() != 2 && status.getSeverity() != 4) continue;
            problems.add(status);
            foundErrors = true;
        }
        return this.constructStatuses(problems, foundErrors);
    }

    public IStatus constructStatuses(List problems, boolean foundErrors) {
        IStatus result = null;
        if (problems.size() == 0) {
            String msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.ReadyToGenerate");
            result = new Status(0, "com.metamatrix.modeler.webservice", 0, msg, null);
        } else if (problems.size() == 1) {
            result = (IStatus)problems.get(0);
        } else {
            String msg = foundErrors ? WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.UnableToGenerate") : WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.ReadyToGenerate");
            MultiStatus multi = new MultiStatus("com.metamatrix.modeler.webservice", 18101, msg, null);
            Iterator iter = problems.iterator();
            while (iter.hasNext()) {
                IStatus problem = (IStatus)iter.next();
                multi.add(problem);
            }
            result = multi;
        }
        return result;
    }

    public ModelGenerator getModelGenerator(boolean isNewModel) throws CoreException {
        return this.doCreateModelGenerator(isNewModel);
    }

    protected ModelGenerator doCreateModelGenerator(boolean isNewModel) throws CoreException {
        ModelGenerator generator = WebServicePlugin.createModelGenerator((IWebServiceModelBuilder)this);
        String desc = null;
        generator.setDescription(desc);
        generator.setNewModelCase(isNewModel);
        generator.setSaveAllBeforeFinish(this.saveAllBeforeFinish);
        return generator;
    }

    public void setSaveAllBeforeFinish(boolean theDoSave) {
        this.saveAllBeforeFinish = theDoSave;
    }

    public List getAllNewResources() {
        ModelWorkspaceItem wsItem;
        IResource resource;
        ArrayList<IResource> resources = new ArrayList<IResource>(10);
        if (!this.xsdWorkspaceResources.isEmpty()) {
            Iterator iter = this.xsdWorkspaceResources.iterator();
            while (iter.hasNext()) {
                IWebServiceXsdResource xsdRes = (IWebServiceXsdResource)iter.next();
                IPath xsdPath = xsdRes.getDestinationPath();
                IResource resource2 = null;
                try {
                    ModelWorkspaceItem wsItem2 = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(xsdPath, 1);
                    if (wsItem2 != null) {
                        resource2 = wsItem2.getResource();
                    }
                }
                catch (ModelWorkspaceException theException) {
                    // empty catch block
                }
                if (resource2 == null) continue;
                resources.add(resource2);
            }
        }
        if (this.xmlModel != null) {
            resource = null;
            try {
                wsItem = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(this.xmlModel, 1);
                if (wsItem != null) {
                    resource = wsItem.getResource();
                }
            }
            catch (ModelWorkspaceException theException) {
                // empty catch block
            }
            if (resource != null) {
                resources.add(resource);
            }
        }
        if (this.modelPath != null) {
            resource = null;
            try {
                wsItem = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(this.modelPath, 1);
                if (wsItem != null) {
                    resource = wsItem.getResource();
                }
            }
            catch (ModelWorkspaceException modelWorkspaceException) {
                // empty catch block
            }
            if (resource != null) {
                resources.add(resource);
            }
        }
        return resources;
    }

    public void setSelectedOperations(Collection operations) {
        this.selectedWsdlOperations = operations;
    }

    public Collection getSelectedOperations() {
        return this.selectedWsdlOperations;
    }

    public class XSDWebServiceResourceTuple {
        private IWebServiceResource resource;
        private XSDSchema schema;

        public XSDWebServiceResourceTuple(IWebServiceResource resource, XSDSchema schema) {
            this.schema = schema;
            this.resource = resource;
        }

        public IWebServiceResource getResource() {
            return this.resource;
        }

        public void setResource(IWebServiceResource resource) {
            this.resource = resource;
        }

        public XSDSchema getSchema() {
            return this.schema;
        }

        public void setSchema(XSDSchema schema) {
            this.schema = schema;
        }
    }
}

