/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BlockedOnMemoryException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.query.processor.relational.DependentProcedureExecutionNode;
import com.metamatrix.query.processor.relational.RelationalNode;
import java.util.Collections;
import java.util.Map;

public class UnionAllNode
extends RelationalNode {
    private boolean[] sourceDone;
    private int outputRow = 1;

    public UnionAllNode(int nodeID) {
        super(nodeID);
    }

    public void reset() {
        super.reset();
        this.sourceDone = null;
        this.outputRow = 1;
    }

    public void open() throws MetaMatrixComponentException {
        this.sourceDone = new boolean[this.getChildren().length];
        super.open();
    }

    public TupleBatch nextBatchDirect() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        RelationalNode[] children = this.getChildren();
        int activeSources = 0;
        TupleBatch batch = null;
        for (int i = 0; i < children.length; ++i) {
            if (children[i] == null || this.sourceDone[i]) continue;
            ++activeSources;
            if (batch != null) break;
            try {
                batch = children[i].nextBatch();
                if (!batch.getTerminationFlag()) continue;
                this.sourceDone[i] = true;
                --activeSources;
                continue;
            }
            catch (BlockedOnMemoryException e) {
                throw e;
            }
            catch (BlockedException e) {
                if (i >= children.length - 1 || !this.hasDependentProcedureExecutionNode(children[0])) continue;
                throw e;
            }
        }
        TupleBatch outputBatch = null;
        if (batch != null) {
            outputBatch = new TupleBatch(this.outputRow, batch.getAllTuples());
            outputBatch.setTerminationFlag(batch.getTerminationFlag() && activeSources == 0);
            this.outputRow += outputBatch.getRowCount();
        } else {
            if (activeSources > 0) {
                throw BlockedException.INSTANCE;
            }
            outputBatch = new TupleBatch(this.outputRow, Collections.EMPTY_LIST);
            outputBatch.setTerminationFlag(true);
        }
        return outputBatch;
    }

    private boolean hasDependentProcedureExecutionNode(RelationalNode node) {
        if (node == null) {
            return false;
        }
        if (node instanceof DependentProcedureExecutionNode) {
            return true;
        }
        if (node.getChildren() != null) {
            for (int i = 0; i < node.getChildren().length; ++i) {
                if (!this.hasDependentProcedureExecutionNode(node.getChildren()[i])) continue;
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        UnionAllNode clonedNode = new UnionAllNode(super.getID());
        super.copy(this, clonedNode);
        return clonedNode;
    }

    public Map getDescriptionProperties() {
        Map props = super.getDescriptionProperties();
        props.put("type", "Union All");
        return props;
    }
}

