/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.proc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.IndexedTupleSource;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.processor.BaseProcessorPlan;
import com.metamatrix.query.processor.DescribableUtil;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.processor.TempTableDataManager;
import com.metamatrix.query.processor.proc.ProcedureEnvironment;
import com.metamatrix.query.processor.proc.RepeatedInstruction;
import com.metamatrix.query.processor.program.Program;
import com.metamatrix.query.processor.program.ProgramEnvironment;
import com.metamatrix.query.processor.program.ProgramInstruction;
import com.metamatrix.query.processor.program.ProgramUtil;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.util.VariableContext;
import com.metamatrix.query.tempdata.TempTableStore;
import com.metamatrix.query.tempdata.TempTableStoreImpl;
import com.metamatrix.query.util.CommandContext;
import com.metamatrix.query.util.TypeRetrievalUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ProcedurePlan
extends BaseProcessorPlan {
    private ProcedureEnvironment env;
    private Program originalProgram;
    private TempTableDataManager dataMgr;
    private BufferManager bufferMgr;
    private int batchSize;
    private boolean done = false;
    private QueryProcessor internalProcessor;
    private TupleSourceID internalResultID;
    private TupleSource finalTupleSource;
    private int beginBatch = 1;
    private List batchRows;
    private boolean lastBatch = false;
    private Map params;
    private QueryMetadataInterface metadata;

    public ProcedurePlan(ProcedureEnvironment env) {
        this.env = env;
        this.env.initialize((ProcessorPlan)((Object)this));
        this.originalProgram = (Program)this.env.getProgramStack().peek();
    }

    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.bufferMgr = bufferMgr;
        this.batchSize = bufferMgr.getProcessorBatchSize();
        TempTableStoreImpl tempTableStore = new TempTableStoreImpl(bufferMgr, context.getConnectionID(), (TempTableStoreImpl)context.getTempTableStore());
        this.dataMgr = new TempTableDataManager(dataMgr, tempTableStore);
        this.env.setTempTableStore((TempTableStore)tempTableStore);
        this.setContext(context);
    }

    public void reset() {
        super.reset();
        this.done = false;
        this.internalProcessor = null;
        this.internalResultID = null;
        this.finalTupleSource = null;
        this.beginBatch = 1;
        this.batchRows = null;
        this.lastBatch = false;
        this.originalProgram.resetProgramCounter();
        if (this.env.getProgramStack().empty()) {
            this.env.getProgramStack().push(this.originalProgram);
        }
        this.env.reset();
        try {
            if (this.dataMgr != null) {
                this.dataMgr.getTempTableStore().removeTempTables();
            }
        }
        catch (MetaMatrixComponentException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        LogManager.logTrace((String)"QUERY_PLANNER", (String)"ProcedurePlan reset");
    }

    public ProcessorDataManager getDataManager() {
        return this.dataMgr;
    }

    TupleSourceID registerRequest(Object command) throws MetaMatrixComponentException {
        Assertion.assertTrue((boolean)(command instanceof ProcessorPlan), (String)QueryExecPlugin.Util.getString("ERR.015.006.0050", command.getClass()));
        if (this.internalProcessor != null) {
            return this.internalResultID;
        }
        ProcessorPlan subPlan = (ProcessorPlan)command;
        subPlan.reset();
        List schema = subPlan.getOutputElements();
        CommandContext subContext = (CommandContext)this.getContext().clone();
        subContext.setTempTableStore(this.env.getTempTableStore());
        this.internalResultID = this.bufferMgr.createTupleSource(schema, TypeRetrievalUtil.getTypeNames((List)schema), subContext.getConnectionID(), 1);
        subContext.setTupleSourceID(this.internalResultID);
        this.internalProcessor = new QueryProcessor(subPlan, subContext, this.bufferMgr, this.dataMgr);
        return this.internalResultID;
    }

    void removeTupleSource(TupleSourceID tupleSourceID) throws MetaMatrixComponentException {
        try {
            this.bufferMgr.removeTupleSource(tupleSourceID);
        }
        catch (TupleSourceNotFoundException e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.015.006.0021", QueryExecPlugin.Util.getString("ERR.015.006.0021", (Object)null));
        }
        catch (MetaMatrixComponentException e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.015.006.0022", QueryExecPlugin.Util.getString("ERR.015.006.0022", (Object)null));
        }
        LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"removed tuple source", tupleSourceID, "for result set"});
    }

    public boolean connectTupleSource(TupleSource source, int dataRequestID) {
        return this.internalProcessor.connectTupleSource(source, dataRequestID);
    }

    public List getOutputElements() {
        return this.env.getOutputElements();
    }

    public void open() throws MetaMatrixComponentException {
        try {
            this.evaluateParams();
        }
        catch (MetaMatrixProcessingException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
    }

    public TupleBatch nextBatch() throws MetaMatrixComponentException, MetaMatrixProcessingException, BlockedException {
        if (this.done) {
            TupleBatch emptyTerminationBatch = new TupleBatch(this.beginBatch, new List[0]);
            emptyTerminationBatch.setTerminationFlag(true);
            return emptyTerminationBatch;
        }
        if (this.finalTupleSource == null) {
            this.finalTupleSource = this.processProcedure();
        }
        while (!this.isBatchFull()) {
            List tuple = this.finalTupleSource.nextTuple();
            if (tuple == null) {
                this.terminateBatches();
                this.done = true;
                break;
            }
            this.addBatchRow(tuple);
        }
        return this.pullBatch();
    }

    private TupleSource processProcedure() throws MetaMatrixComponentException, MetaMatrixProcessingException, BlockedException {
        ProgramInstruction inst = null;
        while (!this.env.getProgramStack().empty()) {
            Program program = this.env.peek();
            inst = program.getCurrentInstruction();
            if (inst == null) {
                this.env.pop();
                continue;
            }
            if (inst instanceof RepeatedInstruction) {
                RepeatedInstruction loop = (RepeatedInstruction)inst;
                if (loop.testCondition(this.env)) {
                    inst.process((ProgramEnvironment)this.env);
                    this.env.push(loop.getNestedProgram());
                    continue;
                }
                loop.postInstruction(this.env);
            } else {
                inst.process((ProgramEnvironment)this.env);
            }
            program.incrementProgramCounter();
        }
        return this.env.getFinalTupleSource();
    }

    public TupleSource getResults(TupleSourceID tupleID) throws MetaMatrixComponentException, BlockedException {
        IndexedTupleSource results;
        try {
            this.internalProcessor.processNoTimeSlice();
            results = this.bufferMgr.getTupleSource(this.internalResultID);
        }
        catch (MetaMatrixComponentException e) {
            throw e;
        }
        catch (MetaMatrixException e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.015.006.0023", QueryExecPlugin.Util.getString("ERR.015.006.0023", (Object)e.getMessage()));
        }
        this.internalProcessor = null;
        return results;
    }

    public void close() throws MetaMatrixComponentException {
        if (this.internalResultID != null) {
            try {
                this.bufferMgr.removeTupleSource(this.internalResultID);
                this.internalResultID = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.env.getTempTableStore() != null) {
            this.env.getTempTableStore().removeTempTables();
        }
    }

    public String toString() {
        try {
            return "ProcedurePlan:\n" + ProgramUtil.programToString((Program)this.originalProgram);
        }
        catch (Exception e) {
            LogManager.logWarning((String)"QUERY_PLANNER", (String)QueryExecPlugin.Util.getString("ERR.015.006.0003"));
            return "ProcedurePlan";
        }
    }

    public Object clone() {
        ProcedureEnvironment clonedEnv = new ProcedureEnvironment();
        clonedEnv.getProgramStack().push(this.originalProgram.clone());
        clonedEnv.setUpdateProcedure(this.env.isUpdateProcedure());
        clonedEnv.setOutputElements(this.env.getOutputElements());
        ProcedurePlan plan = new ProcedurePlan(clonedEnv);
        plan.setParams(this.params);
        plan.setMetadata(this.metadata);
        return plan;
    }

    public boolean canHandleData(int dataRequestID) {
        Iterator planIterator = this.getChildPlans().iterator();
        while (planIterator.hasNext()) {
            ProcessorPlan plan = (ProcessorPlan)planIterator.next();
            if (plan == null || !plan.canHandleData(dataRequestID)) continue;
            return true;
        }
        return false;
    }

    protected void addBatchRow(List row) {
        if (this.batchRows == null) {
            this.batchRows = new ArrayList(this.batchSize);
        }
        this.batchRows.add(row);
    }

    protected void terminateBatches() {
        this.lastBatch = true;
    }

    protected boolean isBatchFull() {
        return this.batchRows != null && this.batchRows.size() == this.batchSize;
    }

    protected TupleBatch pullBatch() {
        TupleBatch batch = null;
        if (this.batchRows != null) {
            batch = new TupleBatch(this.beginBatch, this.batchRows);
            this.beginBatch += this.batchRows.size();
        } else {
            batch = new TupleBatch(this.beginBatch, Collections.EMPTY_LIST);
        }
        batch.setTerminationFlag(this.lastBatch);
        this.batchRows = null;
        this.lastBatch = false;
        return batch;
    }

    public Map getDescriptionProperties() {
        Map props = this.originalProgram.getDescriptionProperties();
        props.put("type", "Procedure Plan");
        props.put("outputCols", DescribableUtil.getOutputColumnProperties((List)this.getOutputElements()));
        return props;
    }

    public Collection getChildPlans() {
        return this.originalProgram.getChildPlans();
    }

    public void setMetadata(QueryMetadataInterface metadata) {
        this.metadata = metadata;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public void evaluateParams() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        if (this.params == null) {
            return;
        }
        Iterator iter = this.params.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ElementSymbol param = (ElementSymbol)entry.getKey();
            Expression expr = (Expression)entry.getValue();
            VariableContext context = this.env.getCurrentVariableContext();
            Object value = ExpressionEvaluator.evaluate(expr, null, null);
            if (value == null && !this.metadata.elementSupports(param.getMetadataID(), 4)) {
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("ProcedurePlan.nonNullableParam", (Object)expr));
            }
            context.setValue(param, value);
        }
    }
}

