/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.cache;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.cache.ObjectCache;
import com.metamatrix.common.cache.ObjectCacheException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.dqp.internal.cache.CacheID;
import com.metamatrix.dqp.internal.cache.CacheResults;
import com.metamatrix.dqp.internal.cache.ResultSetCacheUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ResultSetCache {
    public static final String RS_CACHE_MAX_SIZE = "maxSize";
    public static final String RS_CACHE_MAX_AGE = "maxAge";
    public static final String RS_CACHE_SCOPE = "scope";
    public static final String RS_CACHE_SCOPE_VDB = "vdb";
    public static final String RS_CACHE_SCOPE_CONN = "connection";
    private ObjectCache cache;
    private Properties cacheProps = new Properties();
    private String scope;
    private Map tempBatchResults = new HashMap();
    private long maxSize;

    public ResultSetCache(Properties props) throws MetaMatrixComponentException {
        this.maxSize = Integer.parseInt(props.getProperty(RS_CACHE_MAX_SIZE)) * 1024 * 1024;
        this.cacheProps.setProperty("com.metamatrix.common.cache.ObjectCache.PolicyFactory", "com.metamatrix.common.cache.mru.MRUObjectCachePolicyFactory");
        this.cacheProps.setProperty("com.metamatrix.common.cache.ObjectCache.MaximumCost", "" + (long)((double)this.maxSize * 0.9));
        this.cacheProps.setProperty("com.metamatrix.common.cache.ObjectCache.MaximumAge", props.getProperty(RS_CACHE_MAX_AGE));
        this.cacheProps.setProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureMode", "SeparateThread");
        this.cacheProps.setProperty("com.metamatrix.common.cache.ObjectCache.CacheHelper", "com.metamatrix.common.cache.mru.AgeAndCostMRUCacheHelper");
        this.cacheProps.setProperty("com.metamatrix.common.cache.ObjectCache.CostCalculatorClass", "com.metamatrix.dqp.internal.cache.ResultSetSizeCalculator");
        this.scope = props.getProperty(RS_CACHE_SCOPE);
        try {
            this.cache = new ObjectCache(this.cacheProps);
        }
        catch (ObjectCacheException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public final CacheResults getResults(CacheID cacheID, int[] interval) {
        CacheResults cacheResults = null;
        cacheResults = (CacheResults)this.cache.find(cacheID);
        if (cacheResults == null) {
            return null;
        }
        int firstRow = interval[0] - 1;
        int resultSize = cacheResults.getResults().length;
        int finalRow = resultSize - 1;
        int lastRow = Math.min(finalRow, interval[1] - 1);
        if (resultSize == 0 || firstRow == 0 && lastRow == finalRow) {
            return cacheResults;
        }
        int batchSize = lastRow - firstRow + 1;
        List[] resultsPart = new List[batchSize];
        System.arraycopy(cacheResults.getResults(), firstRow, resultsPart, 0, batchSize);
        boolean isFinal = lastRow == finalRow;
        CacheResults newCacheResults = new CacheResults(resultsPart, cacheResults.getElements(), firstRow + 1, lastRow == finalRow);
        newCacheResults.setCommand(cacheResults.getCommand());
        newCacheResults.setAnalysisRecord(cacheResults.getAnalysisRecord());
        newCacheResults.setParamValues(cacheResults.getParamValues());
        if (isFinal) {
            newCacheResults.setFinalRow(resultSize);
        }
        return newCacheResults;
    }

    public boolean hasResults(CacheID cacheID) {
        boolean hasResults = this.cache.find(cacheID) != null;
        return hasResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResults(CacheID cacheID, CacheResults cacheResults, Object requestID) {
        Object[] results = cacheResults.getResults();
        if (cacheResults.getSize() == -1L) {
            cacheResults.setSize(ResultSetCacheUtil.getResultsSize((Object[])results, (boolean)true));
        }
        if (this.isOverCacheLimit(cacheResults.getSize())) {
            LogManager.logTrace((String)"DQP", (Object[])new Object[]{"Batch will not be cached as it exceeds cache size limit - ", "command = ", cacheID.getCommand(), "hash = ", new Integer(cacheID.hashCode())});
            this.removeTempResults(cacheID);
            return;
        }
        Map map = this.tempBatchResults;
        synchronized (map) {
            CacheResults savedResults = (CacheResults)this.tempBatchResults.get(cacheID);
            if (savedResults == null) {
                savedResults = new CacheResults(null, cacheResults.getElements(), 1, false);
                this.tempBatchResults.put(cacheID, savedResults);
            }
            if (!savedResults.addResults(cacheResults, requestID)) {
                LogManager.logTrace((String)"DQP", (Object[])new Object[]{"Batch could not be cached because addResults() was unsuccessful - ", "command = ", cacheID.getCommand(), "hash = ", new Integer(cacheID.hashCode())});
                this.removeTempResults(cacheID);
                return;
            }
            if (this.isOverCacheLimit(savedResults.getCurrentSize())) {
                LogManager.logTrace((String)"DQP", (Object[])new Object[]{"Batch will not be cached as it exceeds cache size limit - ", "command = ", cacheID.getCommand(), "hash = ", new Integer(cacheID.hashCode())});
                this.removeTempResults(cacheID);
                return;
            }
            if (savedResults.hasAllResults()) {
                this.tempBatchResults.remove(cacheID);
                this.cache.mark(cacheID, savedResults);
            }
        }
        LogManager.logTrace((String)"DQP", (Object[])new Object[]{"Batch has been cached - ", "command = ", cacheID.getCommand(), "hash = ", new Integer(cacheID.hashCode()), ", ", "batchSize = ", new Integer(cacheResults.getResults() != null ? cacheResults.getResults().length : 0)});
    }

    private boolean isOverCacheLimit(long size) {
        if (this.maxSize == 0L || size == 0L) {
            return false;
        }
        long recentCacheSize = this.cache.getStatistics().getCost();
        return size + recentCacheSize > this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTempResults(CacheID cacheID) {
        Map map = this.tempBatchResults;
        synchronized (map) {
            this.tempBatchResults.remove(cacheID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.cache.clear();
        Map map = this.tempBatchResults;
        synchronized (map) {
            this.tempBatchResults.clear();
        }
    }

    public Object getCacheStatistics() {
        return this.cache.getStatistics();
    }

    public void shutDown() {
        this.cache.shutdown();
    }

    public String getCacheScope() {
        return this.scope;
    }
}

