/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuleCopyCriteria
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, MetaMatrixComponentException {
        PlanNode critNode;
        List critNodes = NodeEditor.findAllNodes((PlanNode)plan, (int)13);
        Iterator i = critNodes.iterator();
        boolean shouldRun = false;
        while (i.hasNext()) {
            critNode = (PlanNode)i.next();
            if (critNode.hasBooleanProperty((Object)NodeConstants.Info.IS_COPIED)) continue;
            shouldRun = true;
            break;
        }
        if (!shouldRun) {
            return plan;
        }
        if (this.tryToCopy(plan, new Set[2])) {
            rules.push(RuleConstants.COPY_CRITERIA);
            rules.push(RuleConstants.PUSH_NON_JOIN_CRITERIA);
        }
        i = critNodes.iterator();
        while (i.hasNext()) {
            critNode = (PlanNode)i.next();
            critNode.setProperty((Object)NodeConstants.Info.IS_COPIED, (Object)Boolean.TRUE);
        }
        return plan;
    }

    private boolean copyCriteria(Criteria crit, Map tgtMap, List joinCriteria, Set combinedCriteria, boolean checkForGroupReduction) {
        int startGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit).size();
        Criteria tgtCrit = (Criteria)crit.clone();
        try {
            tgtCrit = FrameUtil.convertCriteria(tgtCrit, tgtMap);
        }
        catch (QueryPlannerException err) {
            LogManager.logWarning((String)"QUERY_PLANNER", (Throwable)err, (Object[])new Object[]{"Could not remap target criteria in RuleCopyCriteria"});
            return false;
        }
        int endGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)tgtCrit).size();
        if (checkForGroupReduction ? endGroups >= startGroups : endGroups > startGroups) {
            return false;
        }
        if (combinedCriteria.add(tgtCrit)) {
            joinCriteria.add(tgtCrit);
            return true;
        }
        return checkForGroupReduction;
    }

    private boolean tryToCopy(PlanNode node, Set[] criteriaInfo) {
        boolean changedTree = false;
        if (node == null) {
            return false;
        }
        if (node.getType() == 7) {
            JoinType jt = (JoinType)node.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
            if (jt == JoinType.JOIN_FULL_OUTER) {
                return this.visitChildern(node, criteriaInfo, changedTree);
            }
            Set[] leftChildCriteria = new Set[2];
            Set[] rightChildCriteria = new Set[2];
            changedTree |= this.tryToCopy(node.getFirstChild(), leftChildCriteria);
            changedTree |= this.tryToCopy(node.getLastChild(), rightChildCriteria);
            List joinCrits = (List)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
            HashSet combinedCriteria = null;
            if (joinCrits != null) {
                combinedCriteria = new HashSet(joinCrits);
                combinedCriteria.addAll(leftChildCriteria[1]);
                combinedCriteria.addAll(rightChildCriteria[1]);
            }
            leftChildCriteria[0].addAll(rightChildCriteria[0]);
            leftChildCriteria[1].addAll(rightChildCriteria[1]);
            criteriaInfo[0] = leftChildCriteria[0];
            criteriaInfo[1] = leftChildCriteria[1];
            if (jt == JoinType.JOIN_CROSS) {
                return changedTree;
            }
            Set toCopy = criteriaInfo[0];
            Set allCriteria = criteriaInfo[1];
            if (!toCopy.isEmpty()) {
                Map srcToTgt = this.buildElementMap(joinCrits);
                LinkedList newJoinCrits = new LinkedList();
                changedTree = this.createCriteriaFromSelectCriteria(changedTree, combinedCriteria, toCopy, srcToTgt, newJoinCrits);
                srcToTgt = this.buildElementMap(allCriteria);
                changedTree = this.createCriteriaFromJoinCriteria(changedTree, joinCrits, combinedCriteria, srcToTgt, newJoinCrits);
                joinCrits.addAll(newJoinCrits);
            }
            if (jt == JoinType.JOIN_RIGHT_OUTER) {
                criteriaInfo[0].removeAll(leftChildCriteria[0]);
                criteriaInfo[1].removeAll(leftChildCriteria[1]);
            } else if (jt == JoinType.JOIN_LEFT_OUTER) {
                criteriaInfo[0].removeAll(rightChildCriteria[0]);
                criteriaInfo[1].removeAll(rightChildCriteria[1]);
            }
            return changedTree;
        }
        changedTree = this.visitChildern(node, criteriaInfo, changedTree);
        switch (node.getType()) {
            case 13: {
                if (criteriaInfo[0] == null) break;
                this.visitSelectNode(node, criteriaInfo[0], criteriaInfo[1]);
                break;
            }
            case 11: 
            case 19: 
            case 23: 
            case 29: 
            case 31: {
                if (criteriaInfo[0] == null) {
                    criteriaInfo[0] = new HashSet();
                    criteriaInfo[1] = new HashSet();
                    break;
                }
                criteriaInfo[0].clear();
                criteriaInfo[1].clear();
            }
        }
        return changedTree;
    }

    private boolean createCriteriaFromJoinCriteria(boolean changedTree, List joinCrits, Set combinedCriteria, Map srcToTgt, List newJoinCrits) {
        if (srcToTgt.size() == 0) {
            return changedTree;
        }
        Iterator i = joinCrits.iterator();
        while (i.hasNext()) {
            Criteria crit = (Criteria)i.next();
            if (!this.copyCriteria(crit, srcToTgt, newJoinCrits, combinedCriteria, true)) continue;
            i.remove();
            changedTree = true;
        }
        return changedTree;
    }

    private boolean createCriteriaFromSelectCriteria(boolean changedTree, Set combinedCriteria, Set toCopy, Map srcToTgt, List newJoinCrits) {
        if (srcToTgt.size() == 0) {
            return changedTree;
        }
        Iterator i = toCopy.iterator();
        while (i.hasNext()) {
            Criteria crit = (Criteria)i.next();
            changedTree |= this.copyCriteria(crit, srcToTgt, newJoinCrits, combinedCriteria, false);
        }
        return changedTree;
    }

    private void visitSelectNode(PlanNode node, Set toCopy, Set allCriteria) {
        Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        if (node.getGroups().size() == 1 && crit != null && !node.hasBooleanProperty((Object)NodeConstants.Info.IS_HAVING) && !FrameUtil.hasSubquery(node)) {
            if (!node.hasBooleanProperty((Object)NodeConstants.Info.IS_COPIED)) {
                toCopy.add(crit);
            }
            allCriteria.add(crit);
        }
    }

    private boolean visitChildern(PlanNode node, Set[] criteriaInfo, boolean changedTree) {
        if (node.getChildCount() > 0) {
            List children = node.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                PlanNode childNode = (PlanNode)children.get(i);
                changedTree |= this.tryToCopy(childNode, i == 0 ? criteriaInfo : new Set[2]);
            }
        }
        return changedTree;
    }

    Map buildElementMap(Collection crits) {
        HashMap<Expression, Expression> srcToTgt = null;
        Iterator critIter = crits.iterator();
        while (critIter.hasNext()) {
            CompareCriteria crit;
            Criteria theCrit = (Criteria)critIter.next();
            if (!(theCrit instanceof CompareCriteria) || (crit = (CompareCriteria)theCrit).getOperator() != 1) continue;
            if (srcToTgt == null) {
                srcToTgt = new HashMap<Expression, Expression>();
            }
            srcToTgt.put(crit.getLeftExpression(), crit.getRightExpression());
            srcToTgt.put(crit.getRightExpression(), crit.getLeftExpression());
        }
        if (srcToTgt == null) {
            return Collections.EMPTY_MAP;
        }
        return srcToTgt;
    }

    public String toString() {
        return "CopyCriteria";
    }
}

