/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyBlob;
import com.metamatrix.jdbcspy.SpyClob;
import com.metamatrix.jdbcspy.SpyConfig;
import com.metamatrix.jdbcspy.SpyConfigInterface;
import com.metamatrix.jdbcspy.SpyInputStream;
import com.metamatrix.jdbcspy.SpyReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Date;
import java.util.Properties;

public abstract class SpyLogger {
    private static String footprint = "$Revision:   1.4.2.0  $";
    public boolean logIS;
    public boolean logSingleRead;
    public boolean logLobs;
    protected int linelimit;
    protected boolean logTName;
    protected boolean logTimestamp;
    boolean enabled = true;
    private final char[] Digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    abstract void enter();

    abstract void leave();

    protected abstract PrintWriter getLog();

    public final void println(String string) {
        String string2;
        if (!this.enabled) {
            return;
        }
        PrintWriter printWriter = this.getLog();
        if (printWriter == null) {
            return;
        }
        String string3 = "";
        if (this.logTName) {
            string3 = "(" + Thread.currentThread().getName() + ")";
        }
        StringBuffer stringBuffer = new StringBuffer(25);
        if (this.logTimestamp) {
            Date date = new Date();
            stringBuffer.append('(');
            stringBuffer.append(date.getYear() + 1900);
            stringBuffer.append('/');
            int n = date.getMonth() + 1;
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
            stringBuffer.append('/');
            n = date.getDate();
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
            stringBuffer.append(' ');
            n = date.getHours();
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
            stringBuffer.append(':');
            n = date.getMinutes();
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
            stringBuffer.append(':');
            n = date.getSeconds();
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
            stringBuffer.append('.');
            long l = date.getTime();
            n = (int)(l & 0xFFFFFFL) % 1000;
            if (n < 100) {
                stringBuffer.append('0');
            }
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
            stringBuffer.append(')');
        }
        if (string.startsWith("\n")) {
            string = string.substring(1);
            string2 = "\nspy" + string3 + stringBuffer + ">> ";
        } else {
            string2 = "spy" + string3 + stringBuffer + ">> ";
        }
        string = string2 + string;
        if (this.linelimit > 0 && string.length() > this.linelimit) {
            string = string.substring(0, this.linelimit - 1);
            string = string + "..";
        }
        printWriter.println(string);
        printWriter.flush();
    }

    public final SQLException sqlException(Throwable throwable) {
        if (throwable instanceof SQLException) {
            this.printSqlException((SQLException)throwable);
            this.printStackTraceOfException(throwable);
            return (SQLException)throwable.fillInStackTrace();
        }
        if (throwable instanceof RuntimeException) {
            this.println("***" + throwable.toString() + "***");
            this.printStackTraceOfException(throwable);
            throw (RuntimeException)throwable.fillInStackTrace();
        }
        if (throwable instanceof Error) {
            this.println("***" + throwable.toString() + "***");
            this.printStackTraceOfException(throwable);
            throw (Error)throwable.fillInStackTrace();
        }
        SQLException sQLException = new SQLException(throwable.toString());
        this.printSqlException(sQLException);
        this.printStackTraceOfException(throwable);
        return sQLException;
    }

    final void printSqlException(SQLException sQLException) {
        while (sQLException != null) {
            if (sQLException instanceof BatchUpdateException) {
                this.println(sQLException + " getUpdateCounts()=" + this.intArrayToString(((BatchUpdateException)sQLException).getUpdateCounts()) + " ErrorCode=" + sQLException.getErrorCode() + " SQLState=" + sQLException.getSQLState());
            } else {
                this.println(sQLException + " ErrorCode=" + sQLException.getErrorCode() + " SQLState=" + sQLException.getSQLState());
            }
            sQLException = sQLException.getNextException();
        }
    }

    final void printStackTraceOfException(Throwable throwable) {
        if (!this.enabled) {
            return;
        }
        PrintWriter printWriter = this.getLog();
        if (printWriter != null) {
            throwable.printStackTrace(printWriter);
            printWriter.flush();
        }
    }

    final void printSqlWarning(SQLWarning sQLWarning) {
        while (sQLWarning != null) {
            this.println(sQLWarning.toString());
            sQLWarning = sQLWarning.getNextWarning();
        }
    }

    public void setOptions(Properties properties) {
        String string = properties.getProperty("configclass");
        try {
            SpyConfigInterface spyConfigInterface = string != null ? (SpyConfigInterface)Class.forName(string).newInstance() : new SpyConfig();
            spyConfigInterface.setProperties(properties);
            this.readConfig(spyConfigInterface);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    final Object loggedInputObject(Object object) {
        if (object instanceof InputStream) {
            if (this.logIS && !(object instanceof SpyInputStream)) {
                object = new SpyInputStream((InputStream)object, this);
            }
        } else if (object instanceof Reader) {
            if (this.logIS && !(object instanceof SpyInputStream)) {
                object = new SpyReader((Reader)object, this);
            }
        } else if (object instanceof Blob) {
            if (this.logLobs && !(object instanceof SpyInputStream)) {
                object = new SpyBlob((Blob)object, this);
            }
        } else if (object instanceof Clob && this.logLobs && !(object instanceof SpyInputStream)) {
            object = new SpyClob((Clob)object, this);
        }
        return object;
    }

    final Object loggedRetrievedObject(Object object) {
        if (object instanceof InputStream) {
            if (this.logIS) {
                object = new SpyInputStream((InputStream)object, this);
            }
        } else if (object instanceof Reader) {
            if (this.logIS) {
                object = new SpyReader((Reader)object, this);
            }
        } else if (object instanceof Blob) {
            if (this.logLobs) {
                object = new SpyBlob((Blob)object, this);
            }
        } else if (object instanceof Clob && this.logLobs) {
            object = new SpyClob((Clob)object, this);
        }
        return object;
    }

    protected abstract void readConfig(SpyConfigInterface var1);

    final String bytesToString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        int n = byArray.length;
        if (this.linelimit != 0) {
            n = Math.min(n / 2, this.linelimit / 2);
        }
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.Digits[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(this.Digits[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    final String intArrayToString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        int n = nArray.length;
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(nArray[i]);
            if (i >= n2) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    final String stringArrayToString(String[] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        int n = stringArray.length;
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= n2) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

