/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.util.UtilDateAndTimeFunctions;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class TDSDateTime {
    private static String footprint = "$Revision:   3.10.2.0  $";
    private static final int NUM_300TH_SECONDS_IN_ONE_MINUTE = 18000;
    private static final int NUM_300TH_SECONDS_IN_ONE_HOUR = 1080000;
    private static final int NUM_300TH_SECONDS_IN_ONE_DAY = 25920000;
    private static int BASEYEAR = 1753;
    private static int MAXYEAR = 9999;
    private static int BASEBIAS = 53690;
    private static Calendar LARGEST_DATETIME_TIMESTAMP = new GregorianCalendar(9999, 11, 31, 23, 59, 59);
    private static long LARGEST_DATETIME_IN_MILLIS = LARGEST_DATETIME_TIMESTAMP.getTime().getTime() + 998L;
    private static Calendar SMALLEST_DATETIME_TIMESTAMP = new GregorianCalendar(1753, 0, 1, 0, 0, 0);
    private static long SMALLEST_DATETIME_IN_MILLIS = SMALLEST_DATETIME_TIMESTAMP.getTime().getTime() - 1L;

    public static void validateTimestamp(BaseExceptions baseExceptions, BaseTimestamp baseTimestamp) throws SQLException {
        if (baseTimestamp == null) {
            return;
        }
        if (baseTimestamp.getMillis() > LARGEST_DATETIME_IN_MILLIS || baseTimestamp.getMillis() < SMALLEST_DATETIME_IN_MILLIS) {
            String[] stringArray = new String[]{baseTimestamp.toString()};
            throw baseExceptions.getException(7012, stringArray);
        }
    }

    public static int[] toDaysFraction(BaseTimestamp baseTimestamp) {
        int n = baseTimestamp.getYear();
        int n2 = baseTimestamp.getMonth() + 1;
        int n3 = (n -= BASEYEAR) * 365 + UtilDateAndTimeFunctions.leapCount(n) + UtilDateAndTimeFunctions.JulianDays[n2] + baseTimestamp.getDate();
        if (n2 > 2 && UtilDateAndTimeFunctions.isLeapYear(n + BASEYEAR)) {
            ++n3;
        }
        int n4 = n3 - BASEBIAS - 1;
        int n5 = baseTimestamp.getHours() * 1080000 + baseTimestamp.getMinutes() * 18000 + baseTimestamp.getSeconds() * 300 + (int)(((long)baseTimestamp.getNanos() * 300L + 500000000L) / 1000000000L);
        if (n5 == 25920000) {
            n5 = 0;
        }
        int[] nArray = new int[]{++n4, n5};
        return nArray;
    }
}

