/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.oracle.spatial;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.oracle.OracleSQLTranslator;
import com.metamatrix.connector.jdbc.oracle.spatial.FilterFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.spatial.Messages;
import com.metamatrix.connector.jdbc.oracle.spatial.NearestNeighborFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.spatial.NnDistanceFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.spatial.OracleSpatialConversionVisitor;
import com.metamatrix.connector.jdbc.oracle.spatial.OracleSpatialFunctions;
import com.metamatrix.connector.jdbc.oracle.spatial.RelateFunctionModifier;
import com.metamatrix.connector.jdbc.oracle.spatial.SpatialSelectProxy;
import com.metamatrix.connector.jdbc.oracle.spatial.WithinDistanceFunctionModifier;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.visitor.util.CollectorVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OracleSpatialSQLTranslator
extends OracleSQLTranslator {
    public Map getFunctionModifiers() {
        Map modifiers = super.getFunctionModifiers();
        Iterator iter = OracleSpatialFunctions.relateFunctions.iterator();
        while (iter.hasNext()) {
            modifiers.put((String)iter.next(), new RelateFunctionModifier());
        }
        iter = OracleSpatialFunctions.nearestNeighborFunctions.iterator();
        while (iter.hasNext()) {
            modifiers.put((String)iter.next(), new NearestNeighborFunctionModifier());
        }
        iter = OracleSpatialFunctions.filterFunctions.iterator();
        while (iter.hasNext()) {
            modifiers.put((String)iter.next(), new FilterFunctionModifier());
        }
        iter = OracleSpatialFunctions.withinDistanceFunctions.iterator();
        while (iter.hasNext()) {
            modifiers.put((String)iter.next(), new WithinDistanceFunctionModifier());
        }
        iter = OracleSpatialFunctions.nnDistanceFunctions.iterator();
        while (iter.hasNext()) {
            modifiers.put((String)iter.next(), new NnDistanceFunctionModifier());
        }
        return modifiers;
    }

    public ICommand modifyCommand(ICommand command, ExecutionContext context) throws ConnectorException {
        if ((command = super.modifyCommand(command, context)) instanceof IQuery) {
            ICriteria criteria;
            IQuery query = (IQuery)command;
            String hint = this.getHint(query);
            ISelect select = ((IQuery)command).getSelect();
            List symbols = select.getSelectSymbols();
            if (symbols.toString().indexOf("SDO_NN_DISTANCE") != -1 && (criteria = query.getWhere()) != null && criteria.toString().indexOf("SDO_NN") == -1) {
                throw new ConnectorException(Messages.getString("OracleSpatialSQLTranslator.SDO_NN_DEPENDENCY_ERROR"));
            }
            if (hint != null) {
                SpatialSelectProxy proxy = new SpatialSelectProxy(select, hint);
                query.setSelect((ISelect)proxy);
            }
        }
        return command;
    }

    public SQLConversionVisitor getTranslationVisitor() {
        OracleSpatialConversionVisitor visitor = new OracleSpatialConversionVisitor();
        visitor.setRuntimeMetadata(this.getRuntimeMetadata());
        visitor.setFunctionModifiers(this.getFunctionModifiers());
        visitor.setProperties(this.getConnectorEnvironment().getProperties());
        visitor.setLanguageFactory(this.getConnectorEnvironment().getLanguageFactory());
        return visitor;
    }

    private String getHint(IQuery query) {
        Class<?> iFunction = null;
        try {
            iFunction = Class.forName("com.metamatrix.data.language.IFunction");
        }
        catch (ClassNotFoundException cex) {
            System.err.println("BML: IFunction Class Missing");
        }
        Collection col = CollectorVisitor.collectObjects(iFunction, (ILanguageObject)query);
        Iterator it = col.iterator();
        while (it.hasNext()) {
            IFunction func = (IFunction)it.next();
            String funcName = func.getName().toUpperCase();
            int indx1 = funcName.indexOf("SDO");
            int indx2 = funcName.indexOf("RELATE");
            if (indx1 < 0 || indx2 <= indx1) continue;
            return "/* + ORDERED */";
        }
        return " ";
    }
}

