/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.base.ExecutionInfo;
import com.metamatrix.connector.xml.base.LargeOrSmallString;
import com.metamatrix.connector.xml.base.LargeTextExtractingXmlFilter;
import com.metamatrix.connector.xml.base.OutputXPathDesc;
import com.metamatrix.connector.xml.base.Response;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.http.Messages;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.internal.core.text.MessageFormat;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jaxen.JaxenException;
import org.jaxen.JaxenHandler;
import org.jaxen.XPath;
import org.jaxen.expr.XPathExpr;
import org.jaxen.jdom.JDOMXPath;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class BaseResultsProducer {
    ExecutionInfo info;
    private IDocumentCache statementCache;
    private ConnectorLogger logger;

    public BaseResultsProducer(IDocumentCache statementCache, ConnectorLogger logger) {
        this.statementCache = statementCache;
        this.logger = logger;
    }

    public List getResult(ExecutionInfo info, Response response) throws ConnectorException {
        this.info = info;
        if (info.getTableXPath() == null || info.getTableXPath().trim().length() == 0) {
            throw new ConnectorException(Messages.getString("Executor.name.in.source.required"));
        }
        XMLDocument[] docs = response.getDocuments();
        if (docs == null || docs.length == 0) {
            throw new ConnectorException(Messages.getString("Executor.xml.docs.not.found"));
        }
        ArrayList resultData = new ArrayList(info.getRequestedColumns().size());
        for (int i = 0; i < info.getRequestedColumns().size(); ++i) {
            ArrayList columnData = new ArrayList();
            resultData.add(columnData);
        }
        XMLDocument xmlDocument = null;
        for (int docCtr = 0; docCtr < docs.length; ++docCtr) {
            xmlDocument = docs[docCtr];
            List groupList = this.generateGroupList(xmlDocument);
            this.processRecords(groupList, resultData, xmlDocument, response);
        }
        return resultData;
    }

    private List generateGroupList(XMLDocument xmlDocument) throws ConnectorException {
        XPath groupExpression = null;
        try {
            String groupString = this.info.getTableXPath();
            groupString = this.relativizeAbsoluteXpath(groupString);
            groupExpression = this.createXPath(groupString);
        }
        catch (SAXPathException sex) {
            throw new ConnectorException((Throwable)sex, Messages.getString("Executor.saxpath.error.on.group"));
        }
        List groupList = null;
        try {
            Object contextRoot = xmlDocument.getContextRoot();
            groupList = groupExpression.selectNodes(contextRoot);
        }
        catch (JaxenException jex) {
            throw new ConnectorException((Throwable)jex, Messages.getString("Executor.jaxen.error.on.selectnodes"));
        }
        return groupList;
    }

    private void processRecords(List groupList, ArrayList resultData, XMLDocument xmlDocument, Response response) throws ConnectorException {
        Iterator groupNodeIterator = groupList.iterator();
        List requestedColumns = this.info.getRequestedColumns();
        ArrayList xpaths = this.generateXPaths(requestedColumns);
        while (groupNodeIterator.hasNext()) {
            Object groupNode = groupNodeIterator.next();
            Iterator requestedXPathIterator = requestedColumns.iterator();
            Iterator actualXpathIterator = xpaths.iterator();
            int colNum = 0;
            while (requestedXPathIterator.hasNext()) {
                LargeOrSmallString data;
                ArrayList columnData = (ArrayList)resultData.get(colNum);
                OutputXPathDesc columnDesc = (OutputXPathDesc)requestedXPathIterator.next();
                XPath xpath = (XPath)actualXpathIterator.next();
                if (columnDesc.isResponseId()) {
                    String r = response.getResponseId();
                    data = LargeOrSmallString.createSmallString(r);
                } else {
                    data = this.getColumnData(xmlDocument, columnDesc, groupNode, xpath);
                }
                columnData.add(data);
                ++colNum;
            }
        }
    }

    private String relativizeAbsoluteXpath(String xpath) throws ConnectorException {
        String retval;
        if (xpath.indexOf(124) != -1 && xpath.indexOf(40) == -1) {
            throw new ConnectorException(Messages.getString("Executor.unsupported.compound.xpath"));
        }
        if (xpath.equals("/")) {
            retval = ".";
        } else if (xpath.startsWith("/") && !xpath.startsWith("//")) {
            retval = xpath.substring(1);
        } else if (xpath.startsWith("(")) {
            xpath = xpath.replaceAll("\\(/", "(");
            retval = xpath = xpath.replaceAll("\\|/", "|");
        } else {
            retval = xpath;
        }
        return retval;
    }

    private ArrayList generateXPaths(List requestedColumns) throws ConnectorException {
        ArrayList<XPath> xpaths = new ArrayList<XPath>();
        OutputXPathDesc xPathDesc = null;
        try {
            Iterator iter = requestedColumns.iterator();
            while (iter.hasNext()) {
                String xpathString;
                xPathDesc = (OutputXPathDesc)iter.next();
                XPath xpath = null;
                if (!xPathDesc.isResponseId() && (xpathString = xPathDesc.getXPath()) != null) {
                    xpathString = this.relativizeAbsoluteXpath(xpathString);
                    xpath = this.createXPath(xpathString);
                }
                xpaths.add(xpath);
            }
        }
        catch (SAXPathException sex) {
            String msgRaw = Messages.getString("Executor.saxpath.error.on.column");
            String msg = MessageFormat.format((String)msgRaw, (Object[])new Object[]{xPathDesc.getColumnName()});
            throw new ConnectorException((Throwable)sex, msg);
        }
        return xpaths;
    }

    private String getNamespaces(Map namespacePairs) throws ConnectorException {
        String namespacePrefixes = this.getNamespacePrefixes();
        return this.getNamespaces(namespacePairs, namespacePrefixes);
    }

    private String getNamespacePrefixes() {
        String namespacePrefixes = this.info.getOtherProperties().getProperty("NamespacePrefixes");
        return namespacePrefixes;
    }

    private String getNamespaces(Map namespacePairs, String namespacePrefixes) throws ConnectorException {
        if (namespacePrefixes == null || namespacePrefixes.trim().length() == 0) {
            return null;
        }
        String prefix = null;
        String uri = null;
        try {
            String xml = "<e " + namespacePrefixes + "/>";
            StringReader reader = new StringReader(xml);
            SAXBuilder builder = new SAXBuilder();
            Document domDoc = builder.build((Reader)reader);
            Element elem = domDoc.getRootElement();
            List namespaces = elem.getAdditionalNamespaces();
            Iterator iter = namespaces.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                Namespace namespace = (Namespace)o;
                prefix = namespace.getPrefix();
                uri = namespace.getURI();
                namespacePairs.put(prefix, uri);
            }
            Namespace defaultNamespace = elem.getNamespace();
            String defaultUri = defaultNamespace.getURI();
            if (defaultUri != null && defaultUri.equals("")) {
                defaultUri = null;
            }
            return defaultUri;
        }
        catch (JDOMException e) {
            String rawMsg = Messages.getString("Executor.jaxen.error.on.namespace.pairs");
            Object[] objs = new Object[]{prefix, uri};
            String msg = MessageFormat.format((String)rawMsg, (Object[])objs);
            throw new ConnectorException((Throwable)e, msg);
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e, e.getMessage());
        }
    }

    private XPath createXPath(String xpathString) throws SAXPathException, ConnectorException {
        XPath expression;
        String namespacePrefixes = this.getNamespacePrefixes();
        String lookup = namespacePrefixes == null ? xpathString : xpathString + namespacePrefixes;
        Object o = this.statementCache.fetchObject(lookup, null);
        if (o instanceof XPath) {
            expression = (XPath)o;
        } else {
            HashMap<String, String> otherNamespaces = new HashMap<String, String>();
            String defaultNamespace = this.getNamespaces(otherNamespaces);
            if (defaultNamespace == null) {
                expression = new JDOMXPath(xpathString);
            } else {
                XPathReader reader = XPathReaderFactory.createReader();
                DefaultNamespaceWorkaroundHander handler = new DefaultNamespaceWorkaroundHander(otherNamespaces);
                reader.setXPathHandler((XPathHandler)handler);
                reader.parse(xpathString);
                XPathExpr xpath = handler.getXPathExpr();
                String xpathWithPrefixes = xpath.getText();
                this.logger.logInfo("Rewriting XPath expression due to use of default namespace.");
                this.logger.logInfo("Was: \"" + xpathString + "\". ");
                this.logger.logInfo("Now: \"" + xpathWithPrefixes + "\". " + "");
                this.logger.logInfo("and adding namespace declaration xmlns:" + handler.getNonceNamespacePrefix() + "=" + defaultNamespace);
                expression = new JDOMXPath(xpathWithPrefixes);
                otherNamespaces.put(handler.getNonceNamespacePrefix(), defaultNamespace);
            }
            this.addNamespacePairs(expression, otherNamespaces);
            this.statementCache.addToCache(lookup, expression, lookup.length(), null);
        }
        return expression;
    }

    private LargeOrSmallString getColumnData(XMLDocument xmlDocument, OutputXPathDesc xPath, Object groupNode, XPath colExpression) throws ConnectorException {
        String data = null;
        if (xPath.getXPath() == null) {
            data = (String)xPath.getCurrentValue();
        } else {
            Object node = null;
            try {
                node = colExpression.selectSingleNode(groupNode);
            }
            catch (JaxenException jex) {
                String msgRaw = Messages.getString("Executor.jaxen.error.on.selectsinglenode");
                String msg = MessageFormat.format((String)msgRaw, (Object[])new Object[]{xPath.getColumnName()});
                throw new ConnectorException((Throwable)jex, msg);
            }
            data = this.getNodeValue(node);
        }
        LargeOrSmallString los = LargeTextExtractingXmlFilter.stringOrValueReference(data, xmlDocument);
        return los;
    }

    private static String getDistinctPrefixes(Map otherNamespaces) {
        String distinctPrefix = null;
        int i = 0;
        while (distinctPrefix == null) {
            int j = i;
            String s = "";
            do {
                char digit = (char)(j % 26);
                char c = (char)(97 + digit);
                s = s + c;
            } while ((j /= 26) > 0);
            Object found = otherNamespaces.get(s);
            if (found == null) {
                distinctPrefix = s;
            }
            ++i;
        }
        return distinctPrefix;
    }

    private String getNodeValue(Object node) {
        String value = null;
        if (node != null) {
            if (node instanceof Attribute) {
                value = ((Attribute)node).getValue();
            } else if (node instanceof Text) {
                value = ((Text)node).getValue();
            } else if (node instanceof CDATA) {
                value = ((CDATA)node).getText();
            } else if (node instanceof Element) {
                Element elem = (Element)node;
                XMLOutputter out = new XMLOutputter();
                value = out.outputString(elem);
            } else {
                value = node.toString();
            }
        }
        return value;
    }

    private void addNamespacePairs(XPath expression, Map namespacePairs) throws ConnectorException {
        try {
            Iterator iter = namespacePairs.keySet().iterator();
            while (iter.hasNext()) {
                String prefix = (String)iter.next();
                String uri = (String)namespacePairs.get(prefix);
                expression.addNamespace(prefix, uri);
            }
        }
        catch (JaxenException e) {
            throw new ConnectorException((Throwable)e, Messages.getString("Executor.jaxen.error.on.namespace.pairs"));
        }
    }

    public static List combineResults(List responseResultList, List allResultsList) {
        if (allResultsList.size() == 0) {
            allResultsList = responseResultList;
        } else {
            for (int x = 0; x < allResultsList.size(); ++x) {
                Object oResultList = allResultsList.get(x);
                List allResultsField = (List)oResultList;
                oResultList = responseResultList.get(x);
                List loopResultsField = (List)oResultList;
                allResultsField.addAll(loopResultsField);
            }
        }
        return allResultsList;
    }

    private static class DefaultNamespaceWorkaroundHander
    extends JaxenHandler {
        private String nonceNamespacePrefix;

        private DefaultNamespaceWorkaroundHander(Map otherNamespaces) {
            this.nonceNamespacePrefix = BaseResultsProducer.getDistinctPrefixes(otherNamespaces);
        }

        public void startNameStep(int axis, String prefix, String localName) throws JaxenException {
            String prefixToUse;
            if (prefix == null || prefix.equals("")) {
                switch (axis) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 13: {
                        prefixToUse = this.nonceNamespacePrefix;
                        break;
                    }
                    default: {
                        prefixToUse = prefix;
                        break;
                    }
                }
            } else {
                prefixToUse = prefix;
            }
            super.startNameStep(axis, prefixToUse, localName);
        }

        public String getNonceNamespacePrefix() {
            return this.nonceNamespacePrefix;
        }
    }
}

