/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.transaction;

import com.metamatrix.common.xa.MMXid;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.data.xa.api.XAConnector;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.transaction.TransactionContextImpl;
import com.metamatrix.dqp.internal.transaction.TransactionProvider;
import com.metamatrix.dqp.internal.transaction.TransactionServerImpl;
import com.metamatrix.dqp.transaction.TransactionServer;
import com.metamatrix.dqp.transaction.XAServer;
import java.util.Iterator;
import java.util.Properties;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TransactionServerImpl
implements TransactionServer,
XAServer {
    private TransactionMapping transactions = new TransactionMapping(null);
    private TransactionProvider provider;

    public void init(Properties props, TransactionProvider theProvider) throws XATransactionException {
        this.provider = theProvider;
        try {
            this.provider.init(props);
        }
        catch (Throwable e) {
            throw new XATransactionException(e);
        }
    }

    public synchronized void shutdown(boolean force) throws XATransactionException {
        this.provider.shutdown();
    }

    public int prepare(String threadId, MMXid xid) throws XATransactionException {
        TransactionContextImpl impl = this.checkXAState(threadId, xid, true, false);
        if (!impl.getSuspendedBy().isEmpty()) {
            throw new XATransactionException(-6, DQPPlugin.Util.getString("TransactionServer.suspended_exist", (Object)xid));
        }
        try {
            this.getTransactionManager().resume(impl.getTransaction());
            this.endAssociations(impl);
            int n = this.provider.getXATerminator().prepare((Xid)xid);
            return n;
        }
        catch (XAException err) {
            throw new XATransactionException(err);
        }
        catch (SystemException err) {
            throw new XATransactionException(err);
        }
        catch (InvalidTransactionException err) {
            throw new XATransactionException(err);
        }
        catch (IllegalStateException err) {
            throw new XATransactionException(err);
        }
        finally {
            try {
                this.getTransactionManager().suspend();
            }
            catch (SystemException err) {
                throw new XATransactionException(err);
            }
        }
    }

    private void endAssociations(TransactionContextImpl impl) throws XATransactionException, SystemException {
        Transaction tx = this.getTransactionManager().getTransaction();
        Assertion.isNotNull((Object)tx);
        Iterator i = impl.getXAResources().iterator();
        while (i.hasNext()) {
            XAResource resource = (XAResource)i.next();
            if (tx.delistResource(resource, 0x4000000)) continue;
            throw new XATransactionException(DQPPlugin.Util.getString("TransactionServer.failed_to_delist"));
        }
        impl.getXAResources().clear();
    }

    public void commit(String threadId, MMXid xid, boolean onePhase) throws XATransactionException {
        TransactionContextImpl tc = this.checkXAState(threadId, xid, true, false);
        try {
            if (onePhase && this.prepare(threadId, xid) == 3) {
                return;
            }
            this.provider.getXATerminator().commit((Xid)xid, false);
        }
        catch (XAException err) {
            throw new XATransactionException(err);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
    }

    public void rollback(String threadId, MMXid xid) throws XATransactionException {
        TransactionContextImpl tc = this.checkXAState(threadId, xid, true, false);
        try {
            this.provider.getXATerminator().rollback((Xid)xid);
        }
        catch (XAException err) {
            throw new XATransactionException(err);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
    }

    public Xid[] recover(int flag) throws XATransactionException {
        try {
            return this.provider.getXATerminator().recover(flag);
        }
        catch (XAException err) {
            throw new XATransactionException(err);
        }
    }

    public void forget(String threadId, MMXid xid) throws XATransactionException {
        try {
            this.provider.getXATerminator().forget((Xid)xid);
        }
        catch (XAException err) {
            throw new XATransactionException(err);
        }
        finally {
            this.transactions.removeTransactionContext(xid);
        }
    }

    public void start(String threadId, MMXid xid, int flags, int timeout) throws XATransactionException {
        TransactionContextImpl tc = null;
        switch (flags) {
            case 0: {
                Transaction tx;
                this.checkXAState(threadId, xid, false, false);
                tc = this.transactions.getOrCreateTransactionContext(threadId);
                if (tc.getTransactionType() != 4) {
                    throw new XATransactionException(-6, DQPPlugin.Util.getString("TransactionServer.existing_transaction"));
                }
                try {
                    tx = this.provider.importTransaction(xid, timeout);
                }
                catch (XAException err) {
                    throw new XATransactionException(err);
                }
                try {
                    tx.registerSynchronization((Synchronization)new /* Unavailable Anonymous Inner Class!! */);
                }
                catch (RollbackException err) {
                    throw new XATransactionException((Throwable)err, 100);
                }
                catch (SystemException err) {
                    throw new XATransactionException((Throwable)err, -3);
                }
                tc.setTransaction(tx, this.provider.getTransactionID(tx));
                tc.setTransactionTimeout(timeout);
                tc.setXid(xid);
                tc.setTransactionType(0);
                break;
            }
            case 0x200000: 
            case 0x8000000: {
                tc = this.checkXAState(threadId, xid, true, false);
                TransactionContextImpl threadContext = this.transactions.getOrCreateTransactionContext(threadId);
                if (threadContext.getTransactionType() != 4) {
                    throw new XATransactionException(-6, DQPPlugin.Util.getString("TransactionServer.existing_transaction"));
                }
                if (flags != 0x8000000 || tc.getSuspendedBy().remove(threadId)) break;
                throw new XATransactionException(-6, DQPPlugin.Util.getString("TransactionServer.resume_failed", new Object[]{xid, threadId}));
            }
            default: {
                throw new XATransactionException(-5, DQPPlugin.Util.getString("TransactionServer.unknown_flags"));
            }
        }
        tc.setThreadId(threadId);
        this.transactions.addTransactionContext(tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void end(String threadId, MMXid xid, int flags) throws XATransactionException {
        TransactionContextImpl tc = this.checkXAState(threadId, xid, true, true);
        try {
            switch (flags) {
                case 0x2000000: {
                    tc.getSuspendedBy().add(threadId);
                    return;
                }
                case 0x4000000: {
                    return;
                }
                case 0x20000000: {
                    try {
                        tc.getTransaction().setRollbackOnly();
                        return;
                    }
                    catch (SystemException err) {
                        throw new XATransactionException((Throwable)err, -3);
                    }
                }
                default: {
                    throw new XATransactionException(-5, DQPPlugin.Util.getString("TransactionServer.unknown_flags"));
                }
            }
        }
        finally {
            tc.setThreadId(null);
            this.transactions.removeTransactionContext(threadId);
        }
    }

    private TransactionContextImpl checkXAState(String threadId, MMXid xid, boolean transactionExpected, boolean threadBound) throws XATransactionException {
        TransactionContextImpl tc = this.transactions.getTransactionContext(xid);
        if (transactionExpected && tc == null) {
            throw new XATransactionException(-4, DQPPlugin.Util.getString("TransactionServer.no_global_transaction", (Object)xid));
        }
        if (!transactionExpected) {
            if (tc != null) {
                throw new XATransactionException(-8, DQPPlugin.Util.getString("TransactionServer.existing_global_transaction", new Object[]{xid}));
            }
            if (!threadBound && (tc = this.transactions.getOrCreateTransactionContext(threadId)).getTransactionType() != 4) {
                throw new XATransactionException(-6, DQPPlugin.Util.getString("TransactionServer.existing_transaction", new Object[]{xid, threadId}));
            }
            return null;
        }
        if (threadBound) {
            if (!threadId.equals(tc.getThreadId())) {
                throw new XATransactionException(-6, DQPPlugin.Util.getString("TransactionServer.wrong_transaction", (Object)xid));
            }
        } else if (tc.getThreadId() != null) {
            throw new XATransactionException(-6, DQPPlugin.Util.getString("TransactionServer.concurrent_transaction", (Object)xid));
        }
        return tc;
    }

    public TransactionContextImpl checkLocalTransactionState(String threadId, boolean transactionExpected) throws NotSupportedException, SystemException, InvalidTransactionException {
        TransactionContextImpl tc = this.transactions.getOrCreateTransactionContext(threadId);
        TransactionManager tm = this.getTransactionManager();
        if (tc.getTransactionType() != 4) {
            if (tc.getTransactionType() != 1) {
                throw new NotSupportedException(DQPPlugin.Util.getString("TransactionServer.existing_transaction"));
            }
            if (!transactionExpected) {
                throw new NotSupportedException(DQPPlugin.Util.getString("TransactionServer.existing_transaction"));
            }
            tm.resume(tc.getTransaction());
        } else if (transactionExpected) {
            throw new InvalidTransactionException(DQPPlugin.Util.getString("TransactionServer.no_transaction", (Object)threadId));
        }
        return tc;
    }

    public TransactionContext begin(String threadId) throws XATransactionException, SystemException {
        try {
            TransactionContextImpl tc = this.checkLocalTransactionState(threadId, false);
            TransactionManager tm = this.getTransactionManager();
            tm.begin();
            Transaction tx = tm.suspend();
            tc.setTransaction(tx, this.provider.getTransactionID(tx));
            tc.setTransactionType(1);
            return tc;
        }
        catch (InvalidTransactionException err) {
            throw new XATransactionException(err);
        }
        catch (NotSupportedException err) {
            throw new XATransactionException(err);
        }
    }

    public void commit(String threadId) throws XATransactionException, SystemException {
        TransactionContextImpl tc;
        try {
            tc = this.checkLocalTransactionState(threadId, true);
        }
        catch (InvalidTransactionException err) {
            throw new XATransactionException(err);
        }
        catch (NotSupportedException err) {
            throw new XATransactionException(err);
        }
        TransactionManager tm = this.getTransactionManager();
        try {
            this.endAssociations(tc);
            tm.commit();
        }
        catch (IllegalStateException err) {
            throw new XATransactionException(err);
        }
        catch (RollbackException err) {
            throw new XATransactionException(err);
        }
        catch (HeuristicMixedException err) {
            throw new XATransactionException(err);
        }
        catch (HeuristicRollbackException err) {
            throw new XATransactionException(err);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
    }

    public void rollback(String threadId) throws XATransactionException, SystemException {
        TransactionContextImpl tc;
        try {
            tc = this.checkLocalTransactionState(threadId, true);
        }
        catch (InvalidTransactionException err) {
            throw new XATransactionException(err);
        }
        catch (NotSupportedException err) {
            throw new XATransactionException(err);
        }
        TransactionManager tm = this.getTransactionManager();
        try {
            tm.rollback();
        }
        catch (IllegalStateException err) {
            throw new XATransactionException(err);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
    }

    private TransactionManager getTransactionManager() {
        return this.provider.getTransactionManager();
    }

    public TransactionContext getOrCreateTransactionContext(String threadId) {
        return this.transactions.getOrCreateTransactionContext(threadId);
    }

    public TransactionContext start(TransactionContext context) throws XATransactionException, SystemException {
        TransactionManager tm = this.getTransactionManager();
        TransactionContextImpl tc = (TransactionContextImpl)context;
        try {
            if (tc.getTransactionType() != 4) {
                throw new XATransactionException(DQPPlugin.Util.getString("TransactionServer.existing_transaction"));
            }
            tm.begin();
            Transaction tx = tm.suspend();
            tc.setTransaction(tx, this.provider.getTransactionID(tx));
            tc.setTransactionType(2);
            return tc;
        }
        catch (NotSupportedException e) {
            throw new XATransactionException(e);
        }
    }

    public TransactionContext commit(TransactionContext context) throws XATransactionException, SystemException {
        Assertion.assertTrue((context.getTransactionType() == 2 ? 1 : 0) != 0);
        TransactionContextImpl tc = (TransactionContextImpl)context;
        TransactionContextImpl currentContext = this.transactions.getTransactionContext(tc.getThreadId());
        if (currentContext == null || currentContext.getTransactionType() == 4) {
            return currentContext;
        }
        TransactionManager tm = this.getTransactionManager();
        try {
            tm.resume(context.getTransaction());
            this.endAssociations(tc);
            tm.commit();
        }
        catch (InvalidTransactionException e) {
            throw new XATransactionException(e);
        }
        catch (RollbackException e) {
            throw new XATransactionException(e);
        }
        catch (HeuristicMixedException e) {
            throw new XATransactionException(e);
        }
        catch (HeuristicRollbackException e) {
            throw new XATransactionException(e);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
        return context;
    }

    public TransactionContext rollback(TransactionContext context) throws XATransactionException, SystemException {
        Assertion.assertTrue((context.getTransactionType() == 2 ? 1 : 0) != 0);
        TransactionManager tm = this.getTransactionManager();
        try {
            tm.resume(context.getTransaction());
            tm.rollback();
        }
        catch (InvalidTransactionException e) {
            throw new XATransactionException(e);
        }
        finally {
            this.transactions.removeTransactionContext((TransactionContextImpl)context);
        }
        return context;
    }

    public TransactionContext delist(TransactionContext context, XAResource resource, int flags) throws XATransactionException {
        TransactionManager tm = this.getTransactionManager();
        TransactionContextImpl tc = (TransactionContextImpl)context;
        try {
            Transaction tx = tm.getTransaction();
            if (!tx.equals(context.getTransaction())) {
                throw new XATransactionException(context.getTransaction() + " != " + tx);
            }
            if (flags == 0x4000000) {
                tc.addXAResource(resource);
            } else if (flags != 0x2000000 && !tx.delistResource(resource, flags)) {
                throw new XATransactionException(DQPPlugin.Util.getString("TransactionServer.failed_to_delist"));
            }
        }
        catch (SystemException err) {
            throw new XATransactionException(err);
        }
        catch (IllegalStateException err) {
            throw new XATransactionException(err);
        }
        finally {
            try {
                tm.suspend();
            }
            catch (SystemException err) {
                throw new XATransactionException(err);
            }
        }
        return tc;
    }

    public TransactionContext enlist(TransactionContext context, XAResource resource) throws XATransactionException {
        TransactionManager tm = this.getTransactionManager();
        TransactionContextImpl tc = (TransactionContextImpl)context;
        try {
            Transaction tx;
            if (tc.getTransactionTimeout() > 0 && tc.getTransactionTimeout() != resource.getTransactionTimeout()) {
                resource.setTransactionTimeout(tc.getTransactionTimeout());
            }
            if ((tx = tm.getTransaction()) == null) {
                tm.resume(context.getTransaction());
            } else if (!tx.equals(context.getTransaction())) {
                throw new XATransactionException(context.getTransaction() + " != " + tx);
            }
            if (!context.getTransaction().enlistResource(resource)) {
                throw new XATransactionException(DQPPlugin.Util.getString("TransactionServer.failed_to_enlist"));
            }
        }
        catch (SystemException err) {
            throw new XATransactionException(err);
        }
        catch (InvalidTransactionException err) {
            throw new XATransactionException(err);
        }
        catch (RollbackException err) {
            throw new XATransactionException(err);
        }
        catch (IllegalStateException err) {
            throw new XATransactionException(err);
        }
        catch (XAException err) {
            throw new XATransactionException(err);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTransactions(String threadId, boolean requestOnly) throws InvalidTransactionException, SystemException {
        TransactionContextImpl tc = this.transactions.getTransactionContext(threadId);
        if (tc == null || tc.getTransactionType() == 4) {
            return;
        }
        if (requestOnly && tc.getTransactionType() != 2) {
            return;
        }
        TransactionManager tm = this.getTransactionManager();
        try {
            tm.resume(tc.getTransaction());
            tm.setRollbackOnly();
        }
        finally {
            tm.suspend();
            this.transactions.removeTransactionContext(tc);
        }
    }

    public synchronized void registerRecoverySource(String name, XAConnector resource) {
        this.provider.registerRecoverySource(name, resource);
    }

    public synchronized void removeRecoverySource(String name) {
        this.provider.removeRecoverySource(name);
    }

    static /* synthetic */ TransactionMapping access$100(TransactionServerImpl x0) {
        return x0.transactions;
    }
}

