/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.testing.tools;

import com.metamatrix.connector.testing.tools.VDBTestImpl;
import java.io.File;
import java.io.FileInputStream;
import java.util.PropertyResourceBundle;

public class VDBTest {
    public static void main(String[] args) {
        try {
            System.out.println("Running VDBTest");
            if (args.length != 1 || null == args[0]) {
                VDBTest.printUsage();
            }
            File propertiesFile = VDBTest.getPropertiesFile(args[0]);
            FileInputStream istream = new FileInputStream(propertiesFile);
            PropertyResourceBundle properties = new PropertyResourceBundle(istream);
            VDBTestImpl impl = new VDBTestImpl(properties);
            impl.execute();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static File getPropertiesFile(String propertiesPath) throws Exception {
        File propertiesFile = new File(propertiesPath);
        if (!propertiesFile.exists()) {
            throw new Exception("The properties file does not exist: " + propertiesPath);
        }
        return propertiesFile;
    }

    private static void printUsage() {
        System.out.println("Call VDBTest with the past to the configuration properties file.");
        System.out.println("e.g. java com.metamatrix.connector.testing.tools.VDBTest c:\\temp\\mytestprop.properties");
    }
}

