/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.function.aggregate;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.FunctionExecutionException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.function.aggregate.Sum;
import java.math.BigDecimal;

public class Avg
extends Sum {
    private static final int AVG_SCALE = 9;
    private int count = 0;

    public void initialize(Class dataType) {
        this.accumulatorType = dataType.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER) || dataType.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL) ? 3 : 1;
    }

    public void reset() {
        super.reset();
        this.count = 0;
    }

    public void addInput(Object input) throws FunctionExecutionException, ExpressionEvaluationException, MetaMatrixComponentException {
        super.addInput(input);
        ++this.count;
    }

    public Object getResult() throws FunctionExecutionException, ExpressionEvaluationException, MetaMatrixComponentException {
        Object sum = super.getResult();
        if (this.count == 0 || sum == null) {
            return null;
        }
        switch (this.getAccumulatorType()) {
            case 1: {
                return new Double((Double)sum / (double)this.count);
            }
            case 3: {
                try {
                    return ((BigDecimal)sum).divide(new BigDecimal((double)this.count), 9, 4);
                }
                catch (ArithmeticException e) {
                    throw new FunctionExecutionException((Throwable)e, "ERR.015.001.0048", QueryPlugin.Util.getString("ERR.015.001.0048", sum, (Object)new Integer(this.count)));
                }
            }
        }
        throw new AssertionError((Object)"unknown accumulator type");
    }
}

