/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl;

import com.metamatrix.core.log.Logger;
import com.metamatrix.modeler.modelgenerator.wsdl.ModelGeneratorWsdlPlugin;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Model;
import com.metamatrix.modeler.modelgenerator.wsdl.model.ModelGenerationException;
import com.metamatrix.modeler.modelgenerator.wsdl.model.internal.ModelBuilder;
import com.metamatrix.modeler.modelgenerator.wsdl.validation.WSDLValidator;
import com.metamatrix.modeler.modelgenerator.wsdl.validation.internal.WSDLValidatorImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;

public class WSDLReader {
    private String m_fileURI;
    private Logger logger;
    private static WSDLValidator VALIDATOR;
    public static final int VALIDATION_SEVERITY_ERROR = 0;
    public static final int VALIDATION_SEVERITY_WARNING = 1;

    public WSDLReader(Logger logger) {
        this(null, logger);
    }

    public WSDLReader(String fileUri, Logger logger) {
        this.m_fileURI = fileUri;
        this.logger = logger;
    }

    public Model getModel() throws ModelGenerationException {
        Model theModel = null;
        try {
            theModel = this.buildWSDLStructures();
        }
        catch (NullPointerException ex) {
            this.logger.log((Throwable)ex);
            Exception e = new Exception(ModelGeneratorWsdlPlugin.Util.getString("WSDLReader.unexpected.parsing.wsdl"));
            throw new ModelGenerationException(e);
        }
        catch (Exception ex) {
            throw new ModelGenerationException(ex);
        }
        return theModel;
    }

    private Model buildWSDLStructures() throws Exception {
        ModelBuilder builder = new ModelBuilder();
        builder.setWSDL(this.m_fileURI);
        if (!builder.isWSDLParsed()) {
            Exception myEx = builder.getWSDLException();
            throw myEx;
        }
        return builder.getModel(this.logger);
    }

    public String getFileUri() {
        return this.m_fileURI;
    }

    public void setFileUri(String fileUri) {
        this.m_fileURI = fileUri;
    }

    public MultiStatus validateWSDL(IProgressMonitor monitor) {
        if (VALIDATOR == null) {
            VALIDATOR = new WSDLValidatorImpl();
        }
        MultiStatus success = VALIDATOR.validateWSDL(this.getFileUri(), monitor);
        return success;
    }
}

