/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer.impl;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BlockedOnMemoryException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.BufferManagerLookup;
import com.metamatrix.common.buffer.IndexedTupleSource;
import com.metamatrix.common.buffer.LobTupleBatch;
import com.metamatrix.common.buffer.MemoryNotAvailableException;
import com.metamatrix.common.buffer.StorageManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.buffer.impl.BufferConfig;
import com.metamatrix.common.buffer.impl.BufferIDCreator;
import com.metamatrix.common.buffer.impl.BufferManagerImpl;
import com.metamatrix.common.buffer.impl.BufferStats;
import com.metamatrix.common.buffer.impl.LongIDCreator;
import com.metamatrix.common.buffer.impl.ManagedBatch;
import com.metamatrix.common.buffer.impl.MemoryState;
import com.metamatrix.common.buffer.impl.SizeUtility;
import com.metamatrix.common.buffer.impl.TupleGroupInfo;
import com.metamatrix.common.buffer.impl.TupleSourceInfo;
import com.metamatrix.common.buffer.storage.file.FileStorageManager;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.types.Streamable;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ReflectionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class BufferManagerImpl
implements BufferManager {
    private BufferManagerLookup lookup;
    private BufferConfig config;
    private Map tupleSourceMap = new HashMap();
    private Map groupInfos = new HashMap();
    private StorageManager memoryMgr;
    private StorageManager diskMgr;
    private BufferIDCreator idCreator;
    private MemoryState memoryState;
    private long freeDiskSpace;
    private Timer timer;
    private int pinRequests = 0;
    private int pinFailures = 0;
    private int pinnedFromDisk = 0;
    private int cleanings = 0;
    private long totalCleaned = 0L;

    public void initialize(BufferManagerLookup lookup, Properties properties) throws MetaMatrixComponentException {
        this.lookup = lookup;
        this.config = new BufferConfig(properties);
        String idCreatorString = properties.getProperty("metamatrix.buffer.idCreator");
        if (idCreatorString != null) {
            try {
                this.idCreator = (BufferIDCreator)ReflectionHelper.create((String)idCreatorString, null, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (MetaMatrixCoreException e) {
                throw new MetaMatrixComponentException((Throwable)e);
            }
        } else {
            this.idCreator = new LongIDCreator();
        }
        this.memoryState = new MemoryState(this.config);
        this.timer = new Timer(true);
        if (this.config.getManagementInterval() > 0) {
            1 mgmtTask = new /* Unavailable Anonymous Inner Class!! */;
            this.timer.schedule((TimerTask)mgmtTask, 0L, (long)this.config.getManagementInterval());
        }
        if (this.config.getLogStatInterval() > 0) {
            2 statTask = new /* Unavailable Anonymous Inner Class!! */;
            this.timer.schedule((TimerTask)statTask, 0L, (long)this.config.getLogStatInterval());
        }
    }

    public BufferConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferStats getStats() {
        BufferStats stats = new BufferStats();
        this.freeDiskSpace = this.diskMgr instanceof FileStorageManager ? ((FileStorageManager)this.diskMgr).getFreeDiskSpace() : -1L;
        stats.freeDiskSpace = this.freeDiskSpace;
        this.memoryState.fillStats(stats);
        Iterator infoIter = null;
        Map map = this.tupleSourceMap;
        synchronized (map) {
            stats.numTupleSources = this.tupleSourceMap.size();
            HashSet copyKeys = new HashSet(this.tupleSourceMap.keySet());
            infoIter = copyKeys.iterator();
        }
        while (infoIter.hasNext()) {
            Map map2;
            Object key = infoIter.next();
            TupleSourceInfo info = null;
            try {
                map2 = this.tupleSourceMap;
                synchronized (map2) {
                    info = (TupleSourceInfo)this.tupleSourceMap.get(key);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (info == null) continue;
            map2 = info;
            synchronized (map2) {
                Iterator batchIter = info.getBatchIterator();
                while (batchIter.hasNext()) {
                    ManagedBatch batch = (ManagedBatch)batchIter.next();
                    switch (batch.getLocation()) {
                        case 0: {
                            ++stats.numPersistentBatches;
                            break;
                        }
                        case 2: {
                            ++stats.numPinnedBatches;
                            if (!LogManager.isMessageToBeRecorded((String)"BUFFER_MGR", (int)6)) break;
                            stats.pinnedManagedBatches.add(batch);
                            break;
                        }
                        case 1: {
                            ++stats.numUnpinnedBatches;
                        }
                    }
                }
            }
        }
        stats.pinRequests = this.pinRequests;
        stats.pinSuccesses = this.pinRequests - this.pinFailures;
        stats.pinnedFromMemory = this.pinRequests - this.pinnedFromDisk;
        stats.numCleanings = this.cleanings;
        stats.totalCleaned = this.totalCleaned;
        this.pinRequests = 0;
        this.pinFailures = 0;
        this.pinnedFromDisk = 0;
        this.cleanings = 0;
        this.totalCleaned = 0L;
        return stats;
    }

    public int getProcessorBatchSize() {
        return this.config.getProcessorBatchSize();
    }

    public int getConnectorBatchSize() {
        return this.config.getConnectorBatchSize();
    }

    public void addStorageManager(StorageManager storageManager) {
        if (storageManager == null) {
            Assertion.isNotNull((Object)storageManager, (String)CommonPlugin.Util.getString("ERR.003.006.0004"));
        }
        if (storageManager.getStorageType() == 0) {
            this.memoryMgr = storageManager;
        } else {
            if (this.diskMgr != null) {
                Assertion.assertTrue((this.diskMgr == null ? 1 : 0) != 0, (String)CommonPlugin.Util.getString("ERR.003.006.0005"));
            }
            this.diskMgr = storageManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleSourceID createTupleSource(List schema, String[] types, String groupName, int tupleSourceType) throws MetaMatrixComponentException {
        TupleSourceID newID = this.idCreator.createTupleSourceID(this.lookup.getCurrentLocation());
        TupleSourceInfo info = new TupleSourceInfo(newID, schema, types, this.getGroupInfo(groupName), tupleSourceType);
        Map map = this.tupleSourceMap;
        synchronized (map) {
            this.tupleSourceMap.put(newID, info);
        }
        if (LogManager.isMessageToBeRecorded((String)"BUFFER_MGR", (int)5)) {
            LogManager.logDetail((String)"BUFFER_MGR", (Object[])new Object[]{"Creating TupleSource: ", newID, "of type " + tupleSourceType});
        }
        return newID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTupleSource(TupleSourceID tupleSourceID) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        if (tupleSourceID == null || tupleSourceID.getLocation() == null) {
            return;
        }
        if (LogManager.isMessageToBeRecorded((String)"BUFFER_MGR", (int)5)) {
            LogManager.logDetail((String)"BUFFER_MGR", (Object[])new Object[]{"Removing TupleSource: ", tupleSourceID});
        }
        TupleSourceInfo info = null;
        Map map = this.tupleSourceMap;
        synchronized (map) {
            info = (TupleSourceInfo)this.tupleSourceMap.get(tupleSourceID);
            if (info == null) {
                throw new TupleSourceNotFoundException("ERR.003.006.0006", CommonPlugin.Util.getString("ERR.003.006.0006", (Object)tupleSourceID));
            }
            this.tupleSourceMap.remove(tupleSourceID);
        }
        map = info;
        synchronized (map) {
            if (!info.isRemoved()) {
                info.setRemoved();
                Iterator iter = info.getBatchIterator();
                while (iter.hasNext()) {
                    ManagedBatch batch = (ManagedBatch)iter.next();
                    switch (batch.getLocation()) {
                        case 1: {
                            this.memoryState.removeUnpinned(batch);
                            this.memoryState.releaseMemory(batch.getSize(), info.getGroupInfo());
                            break;
                        }
                        case 2: {
                            this.memoryState.removePinned(info.getTupleSourceID(), batch.getBeginRow());
                            this.memoryState.releaseMemory(batch.getSize(), info.getGroupInfo());
                        }
                    }
                }
            }
        }
        this.memoryMgr.removeBatches(tupleSourceID);
        if (this.diskMgr != null) {
            this.diskMgr.removeBatches(tupleSourceID);
        }
        this.removeTupleSources(tupleSourceID.getStringID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTupleSources(String groupName) throws MetaMatrixComponentException {
        TupleSourceID tsID;
        if (LogManager.isMessageToBeRecorded((String)"BUFFER_MGR", (int)5)) {
            LogManager.logDetail((String)"BUFFER_MGR", (Object[])new Object[]{"Removing TupleSources for group ", groupName});
        }
        ArrayList<TupleSourceID> removeList = new ArrayList<TupleSourceID>();
        Map map = this.tupleSourceMap;
        synchronized (map) {
            Iterator iter = this.tupleSourceMap.keySet().iterator();
            while (iter.hasNext()) {
                tsID = (TupleSourceID)iter.next();
                TupleSourceInfo info = (TupleSourceInfo)this.tupleSourceMap.get(tsID);
                if (info == null || info.isRemoved()) continue;
                String infoGroup = info.getGroupInfo().getGroupName();
                if (infoGroup == null) {
                    if (groupName != null) continue;
                    removeList.add(tsID);
                    continue;
                }
                if (!infoGroup.equals(groupName)) continue;
                removeList.add(tsID);
            }
        }
        map = this.groupInfos;
        synchronized (map) {
            this.groupInfos.remove(groupName);
        }
        if (removeList.size() > 0) {
            MetaMatrixComponentException ex = null;
            Iterator removeIter = removeList.iterator();
            while (removeIter.hasNext()) {
                tsID = (TupleSourceID)removeIter.next();
                try {
                    this.removeTupleSource(tsID);
                }
                catch (TupleSourceNotFoundException e) {
                }
                catch (MetaMatrixComponentException e) {
                    if (ex != null) continue;
                    ex = e;
                }
            }
            if (ex != null) {
                throw ex;
            }
        }
    }

    public IndexedTupleSource getTupleSource(TupleSourceID tupleSourceID) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        TupleSourceInfo info = this.getTupleSourceInfo(tupleSourceID, true);
        int batchSize = 0;
        switch (info.getType()) {
            case 0: {
                batchSize = this.config.getConnectorBatchSize();
                break;
            }
            case 1: {
                batchSize = this.config.getProcessorBatchSize();
            }
        }
        return new TupleSourceImpl(tupleSourceID, info.getTupleSchema(), this, batchSize);
    }

    public List getTupleSchema(TupleSourceID tupleSourceID) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        TupleSourceInfo info = this.getTupleSourceInfo(tupleSourceID, true);
        return info.getTupleSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(TupleSourceID tupleSourceID, int status) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        TupleSourceInfo info;
        if (LogManager.isMessageToBeRecorded((String)"BUFFER_MGR", (int)5)) {
            LogManager.logDetail((String)"BUFFER_MGR", (Object[])new Object[]{"Setting status for ", tupleSourceID, " to " + status});
        }
        TupleSourceInfo tupleSourceInfo = info = this.getTupleSourceInfo(tupleSourceID, true);
        synchronized (tupleSourceInfo) {
            info.setStatus(status);
        }
    }

    public int getStatus(TupleSourceID tupleSourceID) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        TupleSourceInfo info = this.getTupleSourceInfo(tupleSourceID, true);
        return info.getStatus();
    }

    public int getRowCount(TupleSourceID tupleSourceID) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        TupleSourceInfo info = this.getTupleSourceInfo(tupleSourceID, true);
        return info.getRowCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTupleBatch(TupleSourceID tupleSourceID, TupleBatch tupleBatch) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        TupleSourceInfo info;
        if (LogManager.isMessageToBeRecorded((String)"BUFFER_MGR", (int)6)) {
            LogManager.logTrace((String)"BUFFER_MGR", (Object[])new Object[]{"AddTupleBatch for ", tupleSourceID, " with " + tupleBatch.getRowCount() + " rows"});
        }
        if ((info = this.getTupleSourceInfo(tupleSourceID, true)).lobsInSource()) {
            this.createTupleSourcesForLobs(tupleSourceID, tupleBatch);
        }
        long bytes = SizeUtility.getBatchSize(info.getTypes(), tupleBatch.getAllTuples());
        tupleBatch.setSize(bytes);
        int location = 0;
        if (this.memoryState.reserveMemory(bytes, info.getGroupInfo()) == 1) {
            location = 1;
        }
        TupleSourceInfo tupleSourceInfo = info;
        synchronized (tupleSourceInfo) {
            if (info.isRemoved()) {
                this.memoryState.releaseMemory(bytes, info.getGroupInfo());
                throw new TupleSourceNotFoundException("ERR.003.006.0007", CommonPlugin.Util.getString("ERR.003.006.0007"));
            }
            try {
                if (location == 0) {
                    this.diskMgr.addBatch(tupleSourceID, tupleBatch, info.getTypes());
                } else {
                    this.memoryMgr.addBatch(tupleSourceID, tupleBatch, info.getTypes());
                }
            }
            catch (MetaMatrixComponentException e) {
                if (location != 0) {
                    this.memoryState.releaseMemory(bytes, info.getGroupInfo());
                }
                throw e;
            }
            ManagedBatch managedBatch = new ManagedBatch(tupleSourceID, tupleBatch.getBeginRow(), tupleBatch.getEndRow(), bytes);
            managedBatch.setLocation(location);
            if (location == 1) {
                this.memoryState.addUnpinned(managedBatch);
            }
            info.addBatch(managedBatch);
            info.setRowCount(tupleBatch.getEndRow());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleBatch pinTupleBatch(TupleSourceID tupleSourceID, int beginRow, int maxEndRow) throws TupleSourceNotFoundException, MemoryNotAvailableException, MetaMatrixComponentException {
        if (LogManager.isMessageToBeRecorded((String)"BUFFER_MGR", (int)6)) {
            LogManager.logTrace((String)"BUFFER_MGR", (Object[])new Object[]{"Pinning tupleBatch for ", tupleSourceID, " beginRow: " + beginRow, "  maxEndRow: " + maxEndRow});
        }
        ++this.pinRequests;
        TupleBatch memoryBatch = null;
        int endRow = 0;
        int count = 0;
        TupleSourceInfo info = this.getTupleSourceInfo(tupleSourceID, true);
        long memoryRequiredByBatch = 0L;
        int memoryAvailability = 1;
        for (int pass = 0; pass < 2; ++pass) {
            if (pass == 1) {
                if (memoryAvailability == 2) {
                    this.clean(memoryRequiredByBatch);
                } else {
                    this.clean(memoryRequiredByBatch, info.getGroupInfo(), memoryAvailability);
                }
            }
            TupleSourceInfo tupleSourceInfo = info;
            synchronized (tupleSourceInfo) {
                ManagedBatch mbatch = info.getBatch(beginRow);
                if (mbatch == null) {
                    return new TupleBatch(beginRow, Collections.EMPTY_LIST);
                }
                if (mbatch.getLocation() == 2) {
                    memoryBatch = this.memoryMgr.getBatch(tupleSourceID, beginRow, info.getTypes());
                } else if (mbatch.getLocation() == 1) {
                    mbatch.setLocation(2);
                    this.memoryState.removeUnpinned(mbatch);
                    this.memoryState.addPinned(mbatch);
                    memoryBatch = this.memoryMgr.getBatch(tupleSourceID, beginRow, info.getTypes());
                } else if (mbatch.getLocation() == 0) {
                    memoryRequiredByBatch = mbatch.getSize();
                    memoryAvailability = this.memoryState.reserveMemory(memoryRequiredByBatch, info.getGroupInfo());
                    if (memoryAvailability != 1) {
                        if (pass == 0) {
                            continue;
                        }
                        ++this.pinFailures;
                        throw new MemoryNotAvailableException(CommonPlugin.Util.getString("BufferManagerImpl.No_memory_available._10"));
                    }
                    ++this.pinnedFromDisk;
                    int internalBeginRow = mbatch.getBeginRow();
                    memoryBatch = this.diskMgr.getBatch(tupleSourceID, internalBeginRow, info.getTypes());
                    try {
                        this.memoryMgr.addBatch(tupleSourceID, memoryBatch, info.getTypes());
                    }
                    catch (MetaMatrixComponentException e) {
                        this.memoryState.releaseMemory(mbatch.getSize(), info.getGroupInfo());
                        throw e;
                    }
                    try {
                        this.diskMgr.removeBatch(tupleSourceID, internalBeginRow);
                    }
                    catch (TupleSourceNotFoundException e) {
                    }
                    catch (MetaMatrixComponentException e) {
                        this.memoryState.releaseMemory(memoryRequiredByBatch, info.getGroupInfo());
                        try {
                            this.memoryMgr.removeBatch(tupleSourceID, internalBeginRow);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        throw e;
                    }
                    mbatch.setLocation(2);
                    this.memoryState.addPinned(mbatch);
                }
                if (beginRow > maxEndRow) {
                    endRow = Math.min(beginRow, memoryBatch.getEndRow());
                    beginRow = Math.max(maxEndRow, memoryBatch.getBeginRow());
                } else {
                    endRow = Math.min(maxEndRow, memoryBatch.getEndRow());
                }
                count = endRow - beginRow + 1;
                if (count > 0) {
                    mbatch.setPinnedRows(beginRow, endRow);
                }
                break;
            }
        }
        if (memoryBatch.getRowCount() == 0 || count == 0 || beginRow == memoryBatch.getBeginRow() && count == memoryBatch.getRowCount()) {
            return memoryBatch;
        }
        int firstOffset = beginRow - memoryBatch.getBeginRow();
        List[] memoryRows = memoryBatch.getAllTuples();
        List[] rows = new List[count];
        System.arraycopy(memoryRows, firstOffset, rows, 0, count);
        return new TupleBatch(beginRow, rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpinTupleBatch(TupleSourceID tupleSourceID, int beginRow, int endRow) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        TupleSourceInfo info;
        if (LogManager.isMessageToBeRecorded((String)"BUFFER_MGR", (int)6)) {
            LogManager.logTrace((String)"BUFFER_MGR", (Object[])new Object[]{"Unpinning tupleBatch for ", tupleSourceID, " beginRow: " + beginRow});
        }
        TupleSourceInfo tupleSourceInfo = info = this.getTupleSourceInfo(tupleSourceID, true);
        synchronized (tupleSourceInfo) {
            ManagedBatch mbatch = info.getBatch(beginRow);
            if (mbatch == null) {
                return;
            }
            if (mbatch.getLocation() != 2) {
                return;
            }
            mbatch.removePinnedRows(beginRow, endRow);
            if (!mbatch.hasPinnedRows()) {
                mbatch.setLocation(1);
                this.memoryState.removePinned(tupleSourceID, mbatch.getBeginRow());
                this.memoryState.addUnpinned(mbatch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFinalRowCount(TupleSourceID tupleSourceID) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        TupleSourceInfo info;
        TupleSourceInfo tupleSourceInfo = info = this.getTupleSourceInfo(tupleSourceID, true);
        synchronized (tupleSourceInfo) {
            if (info.getStatus() == 2) {
                return info.getRowCount();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TupleSourceInfo getTupleSourceInfo(TupleSourceID tupleSourceID, boolean throwException) throws TupleSourceNotFoundException {
        TupleSourceInfo info = null;
        Map map = this.tupleSourceMap;
        synchronized (map) {
            info = (TupleSourceInfo)this.tupleSourceMap.get(tupleSourceID);
        }
        if (info == null && throwException) {
            throw new TupleSourceNotFoundException("ERR.003.006.0007", CommonPlugin.Util.getString("ERR.003.006.0007", (Object)tupleSourceID));
        }
        return info;
    }

    protected void clean(long memoryRequired) {
        long targetLevel = this.config.getActiveMemoryLevel();
        long totalMemory = this.config.getTotalAvailableMemory();
        long released = 0L;
        Iterator unpinnedIter = this.memoryState.getAllUnpinned();
        while (unpinnedIter.hasNext() && (memoryRequired > totalMemory - this.memoryState.getMemoryUsed() || this.memoryState.getMemoryUsed() > targetLevel)) {
            ManagedBatch batch = (ManagedBatch)unpinnedIter.next();
            TupleSourceID tsID = batch.getTupleSourceID();
            released += this.releaseMemory(batch, tsID);
        }
        if (released > 0L) {
            ++this.cleanings;
            this.totalCleaned += released;
        }
    }

    protected void clean(long memoryRequired, TupleGroupInfo targetGroupInfo, int reasonForClean) throws TupleSourceNotFoundException {
        boolean cleanForSessionSucceeded = false;
        long released = 0L;
        Iterator unpinnedIter = this.memoryState.getAllUnpinned();
        while (unpinnedIter.hasNext()) {
            ManagedBatch batch = (ManagedBatch)unpinnedIter.next();
            TupleSourceID tsID = batch.getTupleSourceID();
            TupleSourceInfo tsInfo = this.getTupleSourceInfo(tsID, false);
            if (tsInfo == null || !tsInfo.getGroupInfo().equals(targetGroupInfo)) continue;
            long groupMemoryUsed = this.memoryState.getGroupMemoryUsed(targetGroupInfo);
            if (memoryRequired <= this.config.getMaxAvailableSession() - groupMemoryUsed) {
                cleanForSessionSucceeded = true;
                break;
            }
            released += this.releaseMemory(batch, tsID);
        }
        if (released > 0L) {
            ++this.cleanings;
            this.totalCleaned += released;
        }
        if (!cleanForSessionSucceeded) {
            return;
        }
        this.clean(memoryRequired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long releaseMemory(ManagedBatch batch, TupleSourceID tsID) {
        try {
            TupleSourceInfo info = this.getTupleSourceInfo(tsID, false);
            if (info == null) {
                return 0L;
            }
            TupleSourceInfo tupleSourceInfo = info;
            synchronized (tupleSourceInfo) {
                if (info.isRemoved()) {
                    return 0L;
                }
                if ((batch = info.getBatch(batch.getBeginRow())) == null || batch.getLocation() != 1) {
                    return 0L;
                }
                int beginRow = batch.getBeginRow();
                TupleBatch dataBatch = null;
                try {
                    dataBatch = this.memoryMgr.getBatch(tsID, beginRow, info.getTypes());
                }
                catch (TupleSourceNotFoundException e) {
                    return 0L;
                }
                catch (MetaMatrixComponentException e) {
                    return 0L;
                }
                try {
                    this.diskMgr.addBatch(tsID, dataBatch, info.getTypes());
                }
                catch (MetaMatrixComponentException e) {
                    return 0L;
                }
                try {
                    this.memoryMgr.removeBatch(tsID, beginRow);
                }
                catch (TupleSourceNotFoundException e) {
                }
                catch (MetaMatrixComponentException e) {
                    // empty catch block
                }
                batch.setLocation(0);
                this.memoryState.removeUnpinned(batch);
                this.memoryState.releaseMemory(batch.getSize(), info.getGroupInfo());
                return batch.getSize();
            }
        }
        catch (TupleSourceNotFoundException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TupleGroupInfo getGroupInfo(String groupName) {
        TupleGroupInfo info = null;
        Map map = this.groupInfos;
        synchronized (map) {
            info = (TupleGroupInfo)this.groupInfos.get(groupName);
            if (info == null) {
                info = new TupleGroupInfo(groupName);
                this.groupInfos.put(groupName, info);
            }
        }
        return info;
    }

    public void stop() {
        this.timer.cancel();
    }

    private void createTupleSourcesForLobs(TupleSourceID parentId, TupleBatch batch) throws MetaMatrixComponentException, TupleSourceNotFoundException {
        TupleSourceInfo info = this.getTupleSourceInfo(parentId, false);
        List parentSchema = info.getTupleSchema();
        List[] rows = batch.getAllTuples();
        for (int row = 0; row < rows.length; ++row) {
            int col = 0;
            Iterator i = rows[row].iterator();
            while (i.hasNext()) {
                Object anObj = i.next();
                if (anObj instanceof Streamable) {
                    Streamable lob = (Streamable)anObj;
                    if (lob.getReferenceStreamId() == null || this.lobIsNotKnownInTupleSourceMap(lob, parentId)) {
                        ArrayList schema = new ArrayList();
                        schema.add(parentSchema.get(col));
                        TupleSourceID id = this.createTupleSource(schema, new String[]{info.getTypes()[col]}, parentId.getStringID(), 1);
                        lob.setReferenceStreamId(id.getStringID());
                        ArrayList<Streamable> results = new ArrayList<Streamable>();
                        results.add(lob);
                        ArrayList<ArrayList<Streamable>> listOfRows = new ArrayList<ArrayList<Streamable>>();
                        listOfRows.add(results);
                        LobTupleBatch separateBatch = new LobTupleBatch(1, listOfRows);
                        separateBatch.setTerminationFlag(true);
                        this.addTupleBatch(id, (TupleBatch)separateBatch);
                    } else if (!lob.getReferenceStreamId().equals(parentId.getStringID())) {
                        TupleSourceID id = new TupleSourceID(lob.getReferenceStreamId());
                        TupleSourceInfo lobInfo = this.getTupleSourceInfo(id, false);
                        lobInfo.setGroupInfo(this.getGroupInfo(parentId.getStringID()));
                        if (lob.getPersistenceStreamId() != null) {
                            id = new TupleSourceID(lob.getPersistenceStreamId());
                            lobInfo = this.getTupleSourceInfo(id, false);
                            lobInfo.setGroupInfo(this.getGroupInfo(parentId.getStringID()));
                        }
                    }
                }
                ++col;
            }
        }
    }

    private boolean lobIsNotKnownInTupleSourceMap(Streamable lob, TupleSourceID parentId) throws TupleSourceNotFoundException {
        if (!lob.getReferenceStreamId().equals(parentId.getStringID())) {
            TupleSourceID id = new TupleSourceID(lob.getReferenceStreamId());
            TupleSourceInfo lobInfo = this.getTupleSourceInfo(id, false);
            return lobInfo == null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamablePart(TupleSourceID tupleSourceID, LobChunk streamChunk, int beginRow) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        TupleSourceInfo info = this.getTupleSourceInfo(tupleSourceID, true);
        int location = 0;
        TupleSourceInfo tupleSourceInfo = info;
        synchronized (tupleSourceInfo) {
            ArrayList<LobChunk> data = new ArrayList<LobChunk>();
            data.add(streamChunk);
            TupleBatch batch = new TupleBatch(beginRow, new List[]{data});
            this.diskMgr.addBatch(tupleSourceID, batch, info.getTypes());
            ManagedBatch managedBatch = new ManagedBatch(tupleSourceID, beginRow, batch.getEndRow(), 0L);
            managedBatch.setLocation(location);
            info.addBatch(managedBatch);
            info.setRowCount(batch.getEndRow());
        }
    }

    public LobChunk getStreamablePart(TupleSourceID tupleSourceID, int beginRow) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        TupleSourceInfo info = this.getTupleSourceInfo(tupleSourceID, true);
        TupleBatch batch = this.diskMgr.getBatch(tupleSourceID, beginRow, info.getTypes());
        LobChunk chunk = (LobChunk)batch.getAllTuples()[0].get(0);
        return chunk;
    }

    public void releasePinnedBatches() throws MetaMatrixComponentException {
        Map threadPinned = this.memoryState.getPinnedByCurrentThread();
        if (threadPinned == null) {
            return;
        }
        Iterator i = threadPinned.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            i.remove();
            TupleSourceID tsid = (TupleSourceID)entry.getKey();
            Map pinnedBatches = (Map)entry.getValue();
            try {
                Iterator j = pinnedBatches.values().iterator();
                while (j.hasNext()) {
                    ManagedBatch batch = (ManagedBatch)j.next();
                    this.unpinTupleBatch(tsid, batch.getBeginRow(), batch.getEndRow());
                }
            }
            catch (TupleSourceNotFoundException err) {
            }
        }
    }

    public int getPinnedCount() {
        Map pinned = this.memoryState.getAllPinned();
        int count = 0;
        if (pinned == null) {
            return count;
        }
        Iterator i = pinned.values().iterator();
        while (i.hasNext()) {
            count += ((Map)i.next()).size();
        }
        return count;
    }

    private static class TupleSourceImpl
    implements IndexedTupleSource {
        private TupleSourceID tupleSourceID;
        private List schema;
        private BufferManager bufferMgr;
        private int batchSize;
        private TupleBatch currentBatch;
        private int currentRow = 1;

        TupleSourceImpl(TupleSourceID tupleSourceID, List schema, BufferManager bufferMgr, int batchSize) {
            this.tupleSourceID = tupleSourceID;
            this.schema = schema;
            this.bufferMgr = bufferMgr;
            this.batchSize = batchSize;
        }

        public List getSchema() {
            return this.schema;
        }

        public void openSource() throws MetaMatrixComponentException {
        }

        public List nextTuple() throws MetaMatrixComponentException {
            block6: {
                if (this.currentBatch == null || this.currentRow > this.currentBatch.getEndRow()) {
                    this.getBatch();
                    if (this.currentBatch.getRowCount() == 0) {
                        try {
                            int status = this.bufferMgr.getStatus(this.tupleSourceID);
                            if (status == 2) {
                                this.getBatch();
                                if (this.currentBatch.getRowCount() == 0) {
                                    return null;
                                }
                                break block6;
                            }
                            throw BlockedException.INSTANCE;
                        }
                        catch (TupleSourceNotFoundException e) {
                            throw new ComponentNotFoundException((Throwable)e, e.getMessage());
                        }
                    }
                }
            }
            return this.currentBatch.getTuple(this.currentRow++);
        }

        public void closeSource() throws MetaMatrixComponentException {
            this.unpinCurrentBatch();
            this.currentRow = 1;
            this.currentBatch = null;
        }

        public int getCurrentTupleIndex() {
            return this.currentRow;
        }

        public void setCurrentTupleIndex(int index) {
            this.currentRow = index;
            if (this.currentBatch != null && this.currentRow < this.currentBatch.getBeginRow()) {
                this.currentBatch = null;
            }
        }

        private void unpinCurrentBatch() throws MetaMatrixComponentException {
            if (this.currentBatch != null && this.currentBatch.getRowCount() > 0) {
                try {
                    this.bufferMgr.unpinTupleBatch(this.tupleSourceID, this.currentBatch.getBeginRow(), this.currentBatch.getEndRow());
                }
                catch (MetaMatrixComponentException e) {
                    throw e;
                }
                catch (MetaMatrixException e) {
                    throw new MetaMatrixComponentException((Throwable)e, "ERR.003.006.0009", CommonPlugin.Util.getString("ERR.003.006.0009"));
                }
                this.currentBatch = null;
            }
        }

        private void getBatch() throws MetaMatrixComponentException {
            this.unpinCurrentBatch();
            try {
                this.currentBatch = this.bufferMgr.pinTupleBatch(this.tupleSourceID, this.currentRow, this.currentRow + this.batchSize);
            }
            catch (MemoryNotAvailableException e) {
                throw BlockedOnMemoryException.INSTANCE;
            }
            catch (MetaMatrixComponentException e) {
                throw e;
            }
            catch (MetaMatrixException e) {
                throw new MetaMatrixComponentException((Throwable)e, "ERR.003.006.0009", CommonPlugin.Util.getString("ERR.003.006.0009"));
            }
        }
    }
}

