/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerConnection;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSExecuteRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSLoginRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRequest;
import java.net.Socket;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Properties;

public final class SQLServerImplConnection
extends BaseImplConnection {
    private static String footprint = "$Revision:   3.66.1.6  $";
    SQLServerConnection connection;
    TDSConnection conn;
    boolean useServerSideCursor;
    boolean useImplicitTransactions;
    boolean describeParameters;
    int maxRows;
    int maxFieldSize;
    public static int defaultMaxFieldSize = Integer.MAX_VALUE;
    int maxPrecision = -1;
    public SQLServerByteOrderedDataWriter writer;
    public SQLServerByteOrderedDataReader reader;
    public boolean useServerSideUpdatableCursors;
    public boolean useODBCCompatibleComputeColumnNames;
    public int lockingModeConcurrency;
    public static final int PESSIMISTIC_CONCURRENCY = 0;
    public static final int OPTIMISTIC_CONCURRENCY = 1;
    boolean sendStringParametersAsUnicode;
    boolean alwaysReportTriggerResults;
    public int receiveStringParameterType;
    public static final int NVARCHAR = 0;
    public static final int VARCHAR = 1;
    public static final int DESCRIBE = 2;
    private int numOfSetCurrentUser = 0;
    private String currentDatabase;
    private String origDatabase;
    private LinkedList databaseList = null;
    private static int MAX_PACKET_SIZE = Short.MAX_VALUE;
    public boolean xmlDescribeTypeIsChar = true;
    public int protocolVersion;
    public int defaultScale;
    public boolean fullyProcessReply;

    public SQLServerImplConnection(SQLServerConnection sQLServerConnection) {
        this.connection = sQLServerConnection;
        this.quotingChar = (char)39;
        this.intoIsOptional = true;
        this.maxFieldSize = defaultMaxFieldSize;
    }

    public void open() throws SQLException {
        String string;
        String string2;
        String string3;
        int n;
        Object object;
        String string4 = this.connectProps.get("receiveStringParameterType");
        this.receiveStringParameterType = string4 == null ? 0 : (string4.equalsIgnoreCase("nvarchar") ? 0 : (string4.equalsIgnoreCase("varchar") ? 1 : (string4.equalsIgnoreCase("describe") ? 2 : 0)));
        String string5 = this.connectProps.get("alwaysReportTriggerResults");
        this.alwaysReportTriggerResults = string5 != null && string5.equalsIgnoreCase("true");
        String string6 = this.connectProps.get("codePageOverride");
        String string7 = this.connectProps.get("sendStringParametersAsUnicode");
        if (string7 == null) {
            this.sendStringParametersAsUnicode = true;
        } else if (!string7.equalsIgnoreCase("false")) {
            if (string6 == null || string6.length() == 0) {
                this.sendStringParametersAsUnicode = true;
            } else {
                object = new String[]{"sendStringParametersAsUnicode"};
                this.warnings.add(7016, (String[])object);
                this.sendStringParametersAsUnicode = false;
            }
        } else {
            this.sendStringParametersAsUnicode = false;
        }
        object = this.connectProps.get("replyBufferSize");
        int n2 = 0;
        if (object != null) {
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.connectProps.get("packetSize");
        int n3 = MAX_PACKET_SIZE;
        if (object != null) {
            try {
                n = Integer.parseInt((String)object);
                n3 = n == -1 || n > 63 ? MAX_PACKET_SIZE : (n == 0 ? 0 : n * 512);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        n = this.connection.getLongDataCacheSize();
        String string8 = this.connectProps.get("selectMethod");
        this.useServerSideCursor = string8.equalsIgnoreCase("cursor");
        String string9 = this.connectProps.get("transactionMode");
        this.useImplicitTransactions = true;
        if (string9 != null) {
            this.useImplicitTransactions = string9.equalsIgnoreCase("implicit");
        }
        String string10 = this.connectProps.get("describeParameters");
        this.describeParameters = false;
        if (string9 != null) {
            this.describeParameters = string10.equalsIgnoreCase("describeIfString");
        }
        object = this.connectProps.get("computeColumnNames");
        this.useODBCCompatibleComputeColumnNames = true;
        if (object != null && ((String)object).equalsIgnoreCase("false")) {
            this.useODBCCompatibleComputeColumnNames = false;
        }
        if ((string3 = this.connectProps.get("useServerSideUpdatableCursors")) != null) {
            this.useServerSideUpdatableCursors = string3.equalsIgnoreCase("true");
        }
        this.xmlDescribeTypeIsChar = (string2 = this.connectProps.get("XMLDescribeType")).equalsIgnoreCase("LONGVARCHAR");
        String string11 = this.connectProps.get("protocolVersion");
        this.protocolVersion = string11 == null ? 72 : (string11.equals("7.0") || string11.equals("7.1") ? 71 : 72);
        String string12 = this.connectProps.get("defaultScale");
        this.defaultScale = 4;
        if (string12 != null) {
            try {
                this.defaultScale = Integer.parseInt(string12);
                if (this.defaultScale < 0) {
                    this.defaultScale = 4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fullyProcessReply = (string = this.connectProps.get("fullyProcessReply")) != null && string.equalsIgnoreCase("true");
        this.conn = new TDSConnection(this.connectProps.get("serverName"), this.connectProps.get("portNumber"), this.connectProps.get("user"), this.connectProps.get("authenticationMethod"), this.connectProps.get("encryptionMethod"), n2, n3, n, string6, this.connectProps, this.warnings, this.exceptions, this.connection);
        this.writer = this.conn.getWriter();
        this.reader = this.conn.createReader();
        TDSLoginRequest tDSLoginRequest = new TDSLoginRequest(this.conn, this.reader, this.writer, this.warnings, this.conn.getUsername(), this.connectProps.get("password"), this.connectProps.get("databaseName"), this.connectProps.get("programName"), this.connectProps.get("hostProcess"), this.connectProps.get("netAddress"), this.connectProps.get("WSID"));
        tDSLoginRequest.submitRequest(null);
        if (this.conn.getDatabaseMajorVersion() >= 9) {
            this.supportsDMLWithResults = true;
        }
        this.cacheMaxPrecision();
        this.lockingModeConcurrency = 0;
        object = this.connectProps.get("lockingMode");
        if (object != null) {
            try {
                if (((String)object).equalsIgnoreCase("optimistic")) {
                    this.lockingModeConcurrency = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() throws SQLException {
        this.conn.close();
    }

    protected BaseImplStatement createImplStatement(int n, int n2) throws SQLException {
        return new SQLServerImplStatement(this.conn, n, n2, this.exceptions);
    }

    public int getEmptyRowInsertSyntax() {
        return 1;
    }

    protected void startManualTransactionMode() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        if (this.useImplicitTransactions) {
            tDSExecuteRequest.setSQL("SET IMPLICIT_TRANSACTIONS ON");
        } else {
            tDSExecuteRequest.setSQL("BEGIN TRAN");
        }
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
        if (this.useImplicitTransactions) {
            this.conn.isTransactionImplicitOn = true;
        }
    }

    protected void commitTransaction() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        if (this.useImplicitTransactions) {
            tDSExecuteRequest.setSQL("IF @@TRANCOUNT > 0 COMMIT TRAN");
        } else {
            tDSExecuteRequest.setSQL("IF @@TRANCOUNT > 0 COMMIT TRAN BEGIN TRAN");
        }
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    protected void rollbackTransaction() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        tDSExecuteRequest.setSQL("IF @@TRANCOUNT > 0 ROLLBACK TRAN");
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    protected void rollbackTransaction(String string) throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        tDSExecuteRequest.setSQL("IF @@TRANCOUNT > 0 ROLLBACK TRAN " + string);
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    /*
     * Unable to fully structure code
     */
    protected void setSavepoint(String var1_1) throws SQLException {
        var2_2 = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        if (!this.useImplicitTransactions) ** GOTO lbl-1000
        if ((this.connection.workarounds & 2) > 0) {
            var2_2.setSQL("IF @@TRANCOUNT = 0 BEGIN BEGIN TRAN COMMIT END; SAVE TRAN " + var1_1);
        } else lbl-1000:
        // 2 sources

        {
            var2_2.setSQL("IF @@TRANCOUNT = 0 BEGIN TRAN ; SAVE TRAN " + var1_1);
        }
        var2_2.submitRequest(null);
        var2_2.processReply(3, this.warnings);
        var2_2.discardReplyBytes();
    }

    protected void stopManualTransactionMode() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        tDSExecuteRequest.setSQL("IF @@TRANCOUNT > 0 COMMIT TRAN SET IMPLICIT_TRANSACTIONS OFF");
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
        this.conn.isTransactionImplicitOn = false;
    }

    protected int getTransactionIsolation() throws SQLException {
        return 2;
    }

    protected void setTransactionIsolation(int n) throws SQLException {
        Object object;
        String string = new String("SET TRANSACTION ISOLATION LEVEL ");
        switch (n) {
            case 2: {
                string = string + "READ COMMITTED";
                break;
            }
            case 1: {
                string = string + "READ UNCOMMITTED";
                break;
            }
            case 4: {
                string = string + "REPEATABLE READ";
                break;
            }
            case 8: {
                object = this.connectProps.get("snapshotSerializable");
                if (object != null && ((String)object).equalsIgnoreCase("true")) {
                    if (this.conn.getDatabaseMajorVersion() < 9) {
                        throw this.exceptions.getException(7023);
                    }
                    string = string + "SNAPSHOT";
                    break;
                }
                string = string + "SERIALIZABLE";
                break;
            }
            case 16: {
                if (this.conn.getDatabaseMajorVersion() < 9) {
                    throw this.exceptions.getException(7023);
                }
                string = string + "SNAPSHOT";
            }
        }
        object = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        ((TDSExecuteRequest)object).setSQL(string);
        ((TDSExecuteRequest)object).submitRequest(null);
        ((TDSRequest)object).processReply(3, this.warnings);
        ((TDSRequest)object).discardReplyBytes();
    }

    protected String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    protected void setCatalog(String string) throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        tDSExecuteRequest.setSQL("USE " + string);
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(3, this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    private void cacheMaxPrecision() {
        if (this.maxPrecision < 0) {
            try {
                TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
                tDSExecuteRequest.setSQL("select @@MAX_PRECISION");
                tDSExecuteRequest.submitRequest(null);
                tDSExecuteRequest.processReply(1, null);
                tDSExecuteRequest.getRow(null);
                tDSExecuteRequest.getColumnDataForRow(1, 4);
                this.maxPrecision = tDSExecuteRequest.getColumn((int)1).data.getIntegerNoConvert();
                tDSExecuteRequest.discardReplyBytes();
            }
            catch (SQLException sQLException) {
                this.maxPrecision = 28;
            }
        }
    }

    public static String mapNativeErrorToSQLState(int n) {
        switch (n) {
            case 919: 
            case 926: 
            case 3606: 
            case 3607: 
            case 3622: 
            case 5701: 
            case 5703: {
                return "01000";
            }
            case 16934: 
            case 16947: {
                return "01001";
            }
            case 8153: {
                return "01003";
            }
            case 120: 
            case 121: {
                return "07008";
            }
            case 4019: 
            case 17809: 
            case 18450: 
            case 18458: {
                return "08004";
            }
            case 512: {
                return "21000";
            }
            case 109: 
            case 110: 
            case 213: {
                return "21S01";
            }
            case 4409: 
            case 4501: 
            case 4502: {
                return "21S02";
            }
            case 8115: 
            case 8152: {
                return "22001";
            }
            case 168: 
            case 220: 
            case 232: 
            case 236: 
            case 237: 
            case 238: 
            case 240: 
            case 244: 
            case 246: 
            case 248: 
            case 535: 
            case 1007: {
                return "22003";
            }
            case 210: 
            case 211: 
            case 241: 
            case 242: 
            case 295: 
            case 296: 
            case 517: {
                return "22007";
            }
            case 8134: {
                return "22012";
            }
            case 206: 
            case 235: 
            case 245: 
            case 247: 
            case 249: 
            case 256: 
            case 305: 
            case 409: 
            case 518: 
            case 529: {
                return "22018";
            }
            case 1010: {
                return "22019";
            }
            case 310: {
                return "22025";
            }
            case 221: 
            case 233: 
            case 234: 
            case 272: 
            case 273: 
            case 515: 
            case 544: 
            case 547: 
            case 1505: 
            case 1508: 
            case 2601: 
            case 2615: 
            case 2627: 
            case 3604: 
            case 3605: 
            case 8101: {
                return "23000";
            }
            case 16930: 
            case 16931: {
                return "24000";
            }
            case 266: 
            case 628: 
            case 3902: 
            case 3903: 
            case 3906: 
            case 3908: 
            case 6401: {
                return "25000";
            }
            case 4002: 
            case 18456: 
            case 18459: {
                return "28000";
            }
            case 16916: {
                return "34000";
            }
            case 1205: 
            case 1211: 
            case 7112: {
                return "40001";
            }
            case 170: 
            case 229: 
            case 230: {
                return "42000";
            }
            case 2714: {
                return "42S01";
            }
            case 208: 
            case 239: 
            case 267: 
            case 1906: 
            case 2501: 
            case 2706: 
            case 3701: 
            case 4401: 
            case 4701: 
            case 4902: 
            case 4924: {
                return "42S02";
            }
            case 1913: {
                return "42S11";
            }
            case 3718: {
                return "42S12";
            }
            case 2705: 
            case 2727: 
            case 4506: {
                return "42S21";
            }
            case 207: 
            case 1911: {
                return "42S22";
            }
            case 550: {
                return "44000";
            }
            case 16902: {
                return "HY109";
            }
            case 4060: {
                return "08001";
            }
        }
        return "HY000";
    }

    public boolean supportsCancel() {
        return true;
    }

    public boolean supportsQueryTimeout() {
        return false;
    }

    public boolean requiresUserId() {
        return false;
    }

    protected boolean enableXlobOnLongVarX() {
        return true;
    }

    public int getTDSVersion() {
        return this.conn.getTDSVersion();
    }

    public void reset() throws SQLException {
        this.conn.resetTransliteratorPool();
    }

    public Socket getQueryTimeoutSocket() {
        return this.conn.socket;
    }

    protected boolean supportsReauthentication() {
        return this.conn.getDatabaseMajorVersion() >= 9;
    }

    protected String getCurrentUser() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        tDSExecuteRequest.setSQL("select suser_sname()");
        tDSExecuteRequest.submitRequest(null);
        tDSExecuteRequest.processReply(1, null);
        tDSExecuteRequest.getRow(null);
        tDSExecuteRequest.getColumnDataForRow(1, 10);
        String string = tDSExecuteRequest.getColumn((int)1).data.getStringNoConvert();
        tDSExecuteRequest.discardReplyBytes();
        return string;
    }

    protected void setCurrentUser(String string, Properties properties) throws SQLException {
        Object object;
        String string2 = "";
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = true;
        if (this.origDatabase == null) {
            this.origDatabase = this.currentDatabase = this.getCatalog();
        }
        String string5 = this.currentDatabase;
        if (this.databaseList == null) {
            this.databaseList = new LinkedList();
            this.databaseList.add(this.origDatabase);
        }
        if (properties != null) {
            string3 = properties.getProperty("CURRENT_DATABASE");
            string4 = properties.getProperty("REVERT_USER");
        }
        if (string4 != null && string4.equalsIgnoreCase("false")) {
            bl2 = false;
        }
        if (bl2) {
            while (this.numOfSetCurrentUser > 0) {
                this.currentDatabase = (String)this.databaseList.removeLast();
                object = (String)this.databaseList.getLast();
                if (!this.currentDatabase.equalsIgnoreCase((String)object)) {
                    string2 = string2 + "USE " + (String)object + ";";
                    this.currentDatabase = object;
                }
                string2 = string2 + "REVERT;";
                --this.numOfSetCurrentUser;
            }
        }
        string2 = string2 + "Execute AS LOGIN = '" + string + "';";
        if ((string3 == null || string3 != null && string3.length() == 0) && !string5.equalsIgnoreCase(this.currentDatabase)) {
            bl = true;
            string2 = string2 + "USE " + string5 + ";";
            string3 = string5;
        } else if (string3 != null && string3.length() != 0 && !string3.equalsIgnoreCase(this.currentDatabase)) {
            bl = true;
            string2 = string2 + "USE " + string3 + ";";
        }
        object = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        ((TDSExecuteRequest)object).setSQL(string2);
        ((TDSExecuteRequest)object).submitRequest(null);
        ((TDSRequest)object).processReply(3, this.warnings);
        ((TDSRequest)object).discardReplyBytes();
        ++this.numOfSetCurrentUser;
        if (bl) {
            this.currentDatabase = string3;
        }
        this.databaseList.add(this.currentDatabase);
    }

    protected void resetUser() throws SQLException {
        Object object;
        String string = "";
        while (this.numOfSetCurrentUser > 0) {
            this.currentDatabase = (String)this.databaseList.removeLast();
            object = (String)this.databaseList.getLast();
            if (!this.currentDatabase.equalsIgnoreCase((String)object)) {
                string = string + "USE " + (String)object + ";";
                this.currentDatabase = object;
            }
            string = string + "REVERT;";
            --this.numOfSetCurrentUser;
        }
        object = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        ((TDSExecuteRequest)object).setSQL(string);
        ((TDSExecuteRequest)object).submitRequest(null);
        ((TDSRequest)object).processReply(3, this.warnings);
        ((TDSRequest)object).discardReplyBytes();
    }

    public TDSConnection getTDSConnection() {
        return this.conn;
    }
}

