/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.batch;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.BaseProcessorPlan;
import com.metamatrix.query.processor.DescribableUtil;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.util.CommandContext;
import com.metamatrix.query.util.QueryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PreparedBatchUpdatePlan
extends BaseProcessorPlan {
    private ProcessorPlan[] updatePlans;
    private int[] updateCounts;
    private boolean isPlanOpened;
    private int planIndex = 0;
    private List parameterValuesList;
    private List parameterReferences;

    public PreparedBatchUpdatePlan(ProcessorPlan plan, List parameterValuesList, List parameterReferences) {
        this.parameterValuesList = parameterValuesList;
        this.parameterReferences = parameterReferences;
        this.updatePlans = new ProcessorPlan[parameterValuesList.size()];
        this.updatePlans[0] = plan;
        for (int i = 1; i < this.updatePlans.length; ++i) {
            this.updatePlans[i] = (ProcessorPlan)plan.clone();
        }
        this.updateCounts = new int[this.updatePlans.length];
    }

    public Object clone() {
        return new PreparedBatchUpdatePlan((ProcessorPlan)this.updatePlans[0].clone(), this.parameterValuesList, this.parameterReferences);
    }

    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        for (int i = 0; i < this.updatePlans.length; ++i) {
            this.updatePlans[i].initialize(context, dataMgr, bufferMgr);
        }
    }

    public boolean connectTupleSource(TupleSource source, int dataRequestID) {
        if (this.updatePlans[this.planIndex].canHandleData(dataRequestID)) {
            return this.updatePlans[this.planIndex].connectTupleSource(source, dataRequestID);
        }
        throw new MetaMatrixRuntimeException(QueryExecPlugin.Util.getString("BatchedUpdatePlan.cannot_connect_tuplesource", dataRequestID));
    }

    public boolean canHandleData(int dataRequestID) {
        return true;
    }

    public List getOutputElements() {
        return Command.getUpdatesCommandSymbol();
    }

    public void open() throws MetaMatrixComponentException {
        this.updatePlans[0].open();
        this.isPlanOpened = true;
    }

    public TupleBatch nextBatch() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        while (this.planIndex < this.updatePlans.length) {
            if (!this.isPlanOpened) {
                QueryUtil.resolveParameterValues((List)this.parameterReferences, (List)((List)this.parameterValuesList.get(this.planIndex)));
                this.updatePlans[this.planIndex].open();
                this.isPlanOpened = true;
            }
            List[] currentBatch = this.updatePlans[this.planIndex].nextBatch().getAllTuples();
            this.updateCounts[this.planIndex] = (Integer)currentBatch[0].get(0);
            this.updatePlans[this.planIndex].close();
            this.isPlanOpened = false;
            ++this.planIndex;
        }
        ArrayList rows = new ArrayList();
        ArrayList<int[]> row = new ArrayList<int[]>();
        row.add(this.updateCounts);
        rows.add(row);
        TupleBatch batch = new TupleBatch(1, rows);
        batch.setTerminationFlag(true);
        return batch;
    }

    public void close() throws MetaMatrixComponentException {
    }

    public void reset() {
        int i;
        super.reset();
        for (i = 0; i < this.updatePlans.length; ++i) {
            this.updatePlans[i].reset();
        }
        for (i = 0; i < this.updateCounts.length; ++i) {
            this.updateCounts[i] = -1;
        }
        this.planIndex = 0;
    }

    public Map getDescriptionProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("type", "Batched Update Plan");
        ArrayList<Map> children = new ArrayList<Map>();
        for (int i = 0; i < this.updatePlans.length; ++i) {
            children.add(this.updatePlans[i].getDescriptionProperties());
        }
        props.put("children", children);
        props.put("outputCols", DescribableUtil.getOutputColumnProperties((List)this.getOutputElements()));
        return props;
    }

    public String toString() {
        StringBuffer val = new StringBuffer("PreparedBatchUpdatePlan\n");
        val.append(this.updatePlans[0]);
        val.append("\nValues:");
        val.append(this.parameterValuesList);
        val.append("\n");
        return val.toString();
    }

    public Collection getChildPlans() {
        return Arrays.asList(this.updatePlans);
    }
}

