/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink;

import com.metamatrix.jdbc.sequelink.SequeLinkImplConnection;
import com.metamatrix.jdbc.slbase.BaseImplBlob;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspLob;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import java.io.IOException;
import java.sql.SQLException;

public class SequeLinkImplBlob
extends BaseImplBlob
implements SspLob {
    private SequeLinkImplConnection implCon;
    private byte[] locator;
    private long lobLength;
    private boolean moreToCome;
    private int lobOptions;

    public SequeLinkImplBlob(SequeLinkImplConnection sequeLinkImplConnection, byte[] byArray) {
        super(sequeLinkImplConnection.exceptions);
        this.implCon = sequeLinkImplConnection;
        this.locator = byArray;
        this.lobLength = -1L;
        try {
            this.lobOptions = sequeLinkImplConnection.conCtxt.supportsLobs(DiagnosticList.GetADummyList());
        }
        catch (SQLException sQLException) {
            throw new InternalError("SequeLinkImplBlob ctor " + sQLException.toString());
        }
    }

    public long getMaxChunkSize() {
        return 30000L;
    }

    public int readData(byte[] byArray, int n2, long l2, int n3) throws SQLException {
        if ((this.lobOptions & 1) == 0) {
            String[] stringArray = new String[]{"Blob.readData"};
            throw this.exceptions.getException(6003, stringArray);
        }
        return this.implCon.getLobData(this, byArray, n2, l2 - 1L, n3);
    }

    public int writeData(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        if ((this.lobOptions & 4) == 0) {
            String[] stringArray = new String[]{"Blob.writeData"};
            throw this.exceptions.getException(6003, stringArray);
        }
        int n4 = this.implCon.setLobData(this, byArray, n2, l2 - 1L, n3);
        if (this.lobLength != -1L) {
            this.lobLength = Math.max(this.lobLength, l2 - 1L + (long)n4);
        }
        return n4;
    }

    public long getLength() throws SQLException {
        if (this.lobLength != -1L) {
            return this.lobLength;
        }
        this.implCon.getLobLength(this);
        return this.lobLength;
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(byte[] byArray, long l2) throws SQLException {
        return this.implCon.getLobPosition(this, byArray, l2);
    }

    public void truncate(long l2) throws SQLException {
        if ((this.lobOptions & 4) == 0) {
            String[] stringArray = new String[]{"Blob.truncate"};
            throw this.exceptions.getException(6003, stringArray);
        }
        if (this.lobLength != -1L && l2 >= this.lobLength) {
            return;
        }
        this.implCon.lobTruncate(this, l2);
        if (this.lobLength != -1L) {
            this.lobLength = l2;
        }
    }

    public void close() throws SQLException {
        this.implCon = null;
    }

    public void setLocator(byte[] byArray) {
        this.locator = byArray;
    }

    public byte[] getLocator() {
        return this.locator;
    }

    public int getLobType() {
        return 1;
    }

    public void setLobLength(long l2) {
        this.lobLength = l2;
    }

    public void setMoreToCome(boolean bl) {
        this.moreToCome = bl;
    }

    public String getEncoding() {
        return "";
    }

    public int readLobData(SspInputStream sspInputStream, byte[] byArray, int n2, int n3) throws IOException {
        return sspInputStream.readSSPLongVarBinary(byArray, n2, n3);
    }

    public int writeLobData(SspOutputStream sspOutputStream, byte[] byArray, int n2, int n3) throws IOException {
        sspOutputStream.writeSSPLongVarBinary(byArray, n2, n3);
        return n3;
    }
}

