/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.parameters;

import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseParameter;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.Message;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import com.metamatrix.sequelink.util.UnSyncVector;
import com.metamatrix.sequelink.variables.Variable;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilTransliterator;
import java.io.IOException;
import java.sql.SQLException;

public abstract class SequeLinkParameter
implements Variable {
    protected StatementContext stmtCtxt;
    protected int position;
    protected int sqlnkType;
    protected int rsrvcType;
    protected BaseParameter bdIn;
    protected BaseParameter bdOut;
    protected BaseExceptions exceptions;
    protected String encoding;
    protected UtilTransliterator ut;
    private int kind;
    protected int sqlnkSize;
    private int precision;
    protected int scale;
    protected int baseDataType;
    private boolean isBatch;
    private UnSyncVector bdInBatch;

    SequeLinkParameter(StatementContext statementContext, int n, int n2, int n3, int n4, BaseExceptions baseExceptions) throws SQLException {
        this.stmtCtxt = statementContext;
        this.position = n;
        this.rsrvcType = n2;
        this.kind = n4;
        this.exceptions = baseExceptions;
        this.scale = n3;
        this.precision = 0;
        this.encoding = "";
        this.ut = this.getTransliterator();
        this.setBindInfo();
    }

    public void setType(int n) {
        this.rsrvcType = n;
    }

    public void overrideEncoding(String string) throws SQLException {
        this.encoding = string;
        this.ut = this.getTransliterator();
    }

    private UtilTransliterator getTransliterator() throws SQLException {
        return this.stmtCtxt.getSsp().getTransliterator(this.encoding);
    }

    protected abstract void setBindInfo() throws SQLException;

    public boolean isLong() {
        return false;
    }

    public boolean isInput() {
        return this.kind == 2 || this.kind == 6;
    }

    public boolean isOutput() {
        return this.kind == 5 || this.kind == 6;
    }

    public void setBatch() throws SQLException {
        this.isBatch = true;
        this.bdInBatch = new UnSyncVector();
    }

    protected abstract void convertDataIn() throws SQLException;

    public void setDataIn(BaseParameter baseParameter) throws SQLException {
        this.bdIn = baseParameter;
        if (this.bdIn.getType() != this.baseDataType) {
            this.convertDataIn();
        }
        if (this.isBatch) {
            this.bdInBatch.addElement(this.bdIn);
        }
    }

    public void setDataOut(BaseParameter baseParameter) throws SQLException {
        if (this.isBatch) {
            throw Message.Gen.getSqlException(7417);
        }
        this.bdOut = baseParameter;
    }

    public boolean isNull() {
        return this.bdIn.isNull();
    }

    public void writeDefinitionOn(SspOutputStream sspOutputStream) throws IOException, UtilException {
        sspOutputStream.writeSSPInt32(this.position);
        sspOutputStream.writeSSPEnum(this.sqlnkType);
        sspOutputStream.writeSSPEnum(this.rsrvcType);
        sspOutputStream.writeSSPEnum(this.kind);
        sspOutputStream.writeSSPInt32(this.sqlnkSize);
        sspOutputStream.writeSSPString("");
        sspOutputStream.writeSSPInt32(this.precision);
        sspOutputStream.writeSSPInt32(this.scale);
    }

    protected abstract void writeToStream(SspOutputStream var1) throws IOException, UtilException;

    public void writeObjectAndIndicatorOn(SspOutputStream sspOutputStream) throws IOException, UtilException {
        if (this.isBatch) {
            this.bdIn = (BaseParameter)this.bdInBatch.elementAt(0);
            this.bdInBatch.removeElementAt(0);
        }
        int n = this.isNull() ? -1 : 0;
        sspOutputStream.writeSSPIndicator(n);
        if (n != -1) {
            this.writeToStream(sspOutputStream);
        }
    }

    protected abstract void readFromStream(SspInputStream var1) throws IOException, UtilException;

    public void readObjectAndIndicatorFrom(SspInputStream sspInputStream) throws IOException, UtilException {
        int n = sspInputStream.readSSPIndicator();
        if (n > -1 || n == -2) {
            this.readFromStream(sspInputStream);
        } else {
            this.bdOut.setNull(this.baseDataType);
        }
    }
}

