/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.xsd;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.relational.AccessPattern;
import com.metamatrix.metamodels.relational.BaseTable;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.DirectionKind;
import com.metamatrix.metamodels.relational.ForeignKey;
import com.metamatrix.metamodels.relational.NullableType;
import com.metamatrix.metamodels.relational.PrimaryKey;
import com.metamatrix.metamodels.relational.Procedure;
import com.metamatrix.metamodels.relational.ProcedureParameter;
import com.metamatrix.metamodels.relational.ProcedureResult;
import com.metamatrix.metamodels.relational.RelationalEntity;
import com.metamatrix.metamodels.relational.UniqueKey;
import com.metamatrix.metamodels.relational.View;
import com.metamatrix.metamodels.xsd.XsdBuilderOptions;
import com.metamatrix.metamodels.xsd.XsdPlugin;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.core.workspace.ModelResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;

public class XsdSchemaBuilderImpl {
    private static final String TYPE_SUFFIX = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.type");
    private static final String ROOT_SUFFIX = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.rootSuffix");
    private static final String INPUT_SUFFIX = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.inputSuffix");
    private static final String OUTPUT_SUFFIX = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.outputSuffix");
    private static final String MM_URI = "http://www.metamatrix.com/";
    public static boolean HEADLESS = false;
    private final XSDFactory factory = XSDFactory.eINSTANCE;
    private final XsdBuilderOptions ops;
    private final StringNameValidator nameValidator = new StringNameValidator();
    private final Collection addedNamespaces = new HashSet();
    private final Collection includedSchemas = new HashSet();
    private final Collection completedRoots = new HashSet();
    private final HashMap scoreMap = new HashMap();
    private final Collection outputRoots = new HashSet();
    private final boolean doFlat;
    private MultiStatus result;
    private XSDSchema reusableSchema;
    private XSDResourceImpl currentResource;
    private ModelResource modelResource;
    private Collection rootElements;
    private Collection rootElementNames;
    private Collection inputRootElements;
    private Collection inputRootElementNames;
    private HashMap outputToInputMap;
    private HashMap tableToOutputMap;
    private HashMap refMap;
    private boolean trackMappings = false;
    private int currentScore;

    public XsdSchemaBuilderImpl(XsdBuilderOptions ops) {
        ArgCheck.isNotNull((Object)ops);
        ArgCheck.isNotNull((Object)ops.getRoots());
        this.ops = ops;
        this.doFlat = ops.isFlat();
    }

    public static MultiStatus buildSchemas(XsdBuilderOptions ops, IProgressMonitor monitor) {
        XsdSchemaBuilderImpl builder = new XsdSchemaBuilderImpl(ops);
        return builder.buildSchemas(monitor, null);
    }

    public Collection getRootElements() {
        if (this.rootElements == null) {
            this.rootElements = new ArrayList();
        }
        return this.rootElements;
    }

    public Collection getInputRootElements() {
        if (this.inputRootElements == null) {
            this.inputRootElements = new ArrayList();
        }
        return this.inputRootElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiStatus buildSchemas(IProgressMonitor monitor, MultiStatus result) {
        this.result = result == null ? new MultiStatus("com.metamatrix.metamodels.xsd", 0, XsdPlugin.Util.getString("XsdSchemaBuilderImpl.result"), null) : result;
        this.rootElements = new ArrayList();
        this.rootElementNames = new ArrayList();
        this.inputRootElements = new ArrayList();
        this.inputRootElementNames = new ArrayList();
        this.outputToInputMap = new HashMap();
        this.tableToOutputMap = new HashMap();
        this.refMap = new HashMap();
        this.trackMappings = this.ops.genInput() && this.ops.genOutput();
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        String txnDescr = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.genxsd");
        boolean startedTxn = ModelerCore.startTxn((boolean)true, (boolean)true, (String)txnDescr, (Object)this);
        ArrayList<Object> inputRoots = new ArrayList<Object>();
        try {
            Collection roots = null;
            if (this.doFlat) {
                roots = this.ops.getRoots();
            } else {
                this.buildScoreMap(this.ops.getRoots());
                roots = this.buildScoredRootsCollection();
            }
            monitor.beginTask(XsdPlugin.Util.getString("XsdSchemaBuilderImpl.creating", roots.size()), roots.size());
            if (roots == null || roots.isEmpty()) {
                String noRoots = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.noRoots");
                this.addStatus(4, noRoots, null);
            }
            this.validateRoots(roots);
            if (this.ops.genOutput()) {
                this.currentResource = this.createModel(false);
            }
            Iterator rootIt = roots.iterator();
            while (rootIt.hasNext()) {
                RelationalEntity root = (RelationalEntity)rootIt.next();
                if (root instanceof ProcedureResult) {
                    Procedure proc = ((ProcedureResult)root).getProcedure();
                    if (this.hasInputParameter(proc)) {
                        inputRoots.add(proc);
                    }
                } else if (root instanceof BaseTable) {
                    BaseTable table = (BaseTable)root;
                    if (table.getPrimaryKey() != null) {
                        inputRoots.add(root);
                    } else if (!table.getAccessPatterns().isEmpty()) {
                        inputRoots.add(root);
                    }
                } else if (root instanceof Procedure && this.hasInputParameter((Procedure)root)) {
                    inputRoots.add(root);
                }
                if (this.ops.genOutput()) {
                    this.doBuild(this.currentResource, root, false);
                }
                boolean doSave = this.ops.genOutput() && !rootIt.hasNext();
                try {
                    if (doSave && this.modelResource != null) {
                        this.modelResource.save((IProgressMonitor)new NullProgressMonitor(), true);
                        this.modelResource.getEmfResource().setModified(false);
                    }
                }
                catch (Exception e) {
                    String saveError = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.errSave", (Object)this.modelResource.getItemName());
                    this.addStatus(4, saveError, e);
                }
                monitor.worked(1);
            }
            this.completedRoots.clear();
            if (this.ops.genInput()) {
                this.createInputXsd(inputRoots);
            }
            this.cleanup();
            MultiStatus multiStatus = this.result;
            return multiStatus;
        }
        catch (Exception e) {
            String err = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.err1");
            this.addStatus(4, err, e);
            MultiStatus multiStatus = this.result;
            return multiStatus;
        }
        finally {
            if (startedTxn) {
                ModelerCore.commitTxn();
            }
        }
    }

    private void cleanup() {
        this.completedRoots.clear();
        this.currentResource = null;
        this.addedNamespaces.clear();
        this.includedSchemas.clear();
        this.outputRoots.clear();
        this.inputRootElementNames = null;
        this.inputRootElements = null;
        this.modelResource = null;
        this.reusableSchema = null;
        this.tableToOutputMap = null;
        this.refMap = null;
    }

    private XSDResourceImpl createModel(boolean isInput) throws CoreException {
        String fileName;
        String rootName;
        String parentLocation = this.ops.getParentPath();
        if (isInput) {
            rootName = this.ops.getInputModelName();
            fileName = parentLocation + File.separator + rootName;
        } else {
            rootName = this.ops.getOutputModelName();
            fileName = parentLocation + File.separator + rootName;
        }
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        File check = new File(fileName);
        if (this.reusableSchema == null && check.exists()) {
            String fileExists = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.nameExists", (Object)rootName, (Object)fileName);
            this.addStatus(4, fileExists, null);
            return null;
        }
        IFile resource = wsroot.getFileForLocation((IPath)new Path(fileName));
        XSDResourceImpl rsrc = null;
        if (HEADLESS) {
            Container cntr = ModelerCore.getModelContainer();
            rsrc = (XSDResourceImpl)cntr.getOrCreateResource(URI.createFileURI((String)fileName));
        } else if (this.reusableSchema != null) {
            this.modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)resource);
            if (this.modelResource != null) {
                rsrc = (XSDResourceImpl)this.modelResource.getEmfResource();
            }
        } else {
            this.modelResource = ModelerCore.create((IFile)resource);
            if (this.modelResource != null) {
                this.addStatus(1, XsdPlugin.Util.getString("XsdSchemaBuilderImpl.newModel", (Object)resource.getName()), null);
                rsrc = (XSDResourceImpl)this.modelResource.getEmfResource();
            }
        }
        return rsrc;
    }

    private boolean hasInputParameter(Procedure proc) {
        Iterator params = proc.getParameters().iterator();
        while (params.hasNext()) {
            ProcedureParameter param = (ProcedureParameter)params.next();
            DirectionKind dir = param.getDirection();
            if (!dir.equals(DirectionKind.IN_LITERAL) && !dir.equals(DirectionKind.INOUT_LITERAL)) continue;
            return true;
        }
        return false;
    }

    private void addStatus(int severity, String msg, Throwable ex) {
        this.result.add((IStatus)new Status(severity, this.result.getPlugin(), 0, msg, ex));
    }

    private void createInputXsd(Collection inputRoots) throws CoreException {
        if (inputRoots.isEmpty()) {
            return;
        }
        this.refMap.clear();
        this.reusableSchema = null;
        this.currentResource = this.createModel(true);
        Iterator rootIt = inputRoots.iterator();
        while (rootIt.hasNext()) {
            RelationalEntity root = (RelationalEntity)rootIt.next();
            if (!this.doFlat && !this.outputRoots.contains(root)) continue;
            this.doBuild(this.currentResource, root, true);
        }
        try {
            if (this.modelResource != null) {
                this.modelResource.save((IProgressMonitor)new NullProgressMonitor(), true);
                this.modelResource.getEmfResource().setModified(false);
            }
        }
        catch (Exception e) {
            String saveError = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.errSave", (Object)this.modelResource.getItemName());
            this.addStatus(4, saveError, e);
        }
    }

    private void buildScoreMap(Collection roots) {
        Iterator rootIt = roots.iterator();
        while (rootIt.hasNext()) {
            Object next = rootIt.next();
            this.currentScore = 0;
            this.scoreEntity(next);
            Integer score = new Integer(this.currentScore);
            HashSet entities = (HashSet)this.scoreMap.get(score);
            if (entities == null) {
                entities = new HashSet();
                this.scoreMap.put(score, entities);
            }
            entities.add(next);
        }
    }

    private Collection buildScoredRootsCollection() {
        ArrayList scoredRoots = new ArrayList();
        int count = 0;
        int score = 0;
        while (count < this.scoreMap.size()) {
            Integer nextScore;
            Collection nextRoots;
            if ((nextRoots = (Collection)this.scoreMap.get(nextScore = new Integer(score++))) == null || nextRoots.isEmpty()) continue;
            scoredRoots.addAll(0, nextRoots);
            ++count;
        }
        return scoredRoots;
    }

    private void scoreEntity(Object entity) {
        if (entity instanceof BaseTable) {
            HashSet processed = new HashSet();
            this.scoreTable((BaseTable)entity, processed);
        }
    }

    private void scoreTable(BaseTable table, HashSet processed) {
        processed.add(table);
        Iterator fks = table.getForeignKeys().iterator();
        while (fks.hasNext()) {
            ForeignKey fk = (ForeignKey)fks.next();
            UniqueKey pk = fk.getUniqueKey();
            BaseTable bt = pk == null ? null : pk.getTable();
            if (processed.contains(bt) || pk.getTable() == null) continue;
            ++this.currentScore;
            this.scoreTable(pk.getTable(), processed);
        }
    }

    private void doBuild(XSDResourceImpl rsrc, RelationalEntity root, boolean isInput) throws CoreException {
        if (rsrc == null) {
            return;
        }
        if (isInput || !this.completedRoots.contains(root)) {
            this.buildEntities(root, new Stack(), isInput, null);
        }
    }

    private void addStructure(XSDComplexTypeDefinition type, RelationalEntity entity, boolean isInput) {
        ArrayList<ProcedureParameter> inParams = new ArrayList<ProcedureParameter>();
        ArrayList atts = new ArrayList();
        if (entity instanceof BaseTable) {
            BaseTable table = (BaseTable)entity;
            if (isInput) {
                PrimaryKey pk = table.getPrimaryKey();
                if (pk != null) {
                    Iterator pkCols = pk.getColumns().iterator();
                    while (pkCols.hasNext()) {
                        Object nextCol = pkCols.next();
                        if (atts.contains(nextCol)) continue;
                        atts.add(nextCol);
                    }
                }
                Iterator accessPatterns = table.getAccessPatterns().iterator();
                while (accessPatterns.hasNext()) {
                    AccessPattern ap = (AccessPattern)accessPatterns.next();
                    Iterator apCols = ap.getColumns().iterator();
                    while (apCols.hasNext()) {
                        Object nextCol = apCols.next();
                        if (atts.contains(nextCol)) continue;
                        atts.add(nextCol);
                    }
                }
            } else {
                atts = new ArrayList(table.getColumns());
            }
        } else if (entity instanceof View) {
            View view = (View)entity;
            if (isInput) {
                Iterator accessPatterns = view.getAccessPatterns().iterator();
                while (accessPatterns.hasNext()) {
                    AccessPattern ap = (AccessPattern)accessPatterns.next();
                    Iterator apCols = ap.getColumns().iterator();
                    while (apCols.hasNext()) {
                        Object nextCol = apCols.next();
                        if (atts.contains(nextCol)) continue;
                        atts.add(nextCol);
                    }
                }
            } else {
                atts = new ArrayList(view.getColumns());
            }
        } else if (entity instanceof ProcedureResult) {
            ProcedureResult procResult = (ProcedureResult)entity;
            if (this.result != null) {
                atts = new ArrayList(procResult.getColumns());
            }
            Procedure p = procResult.getProcedure();
            Iterator params = p.getParameters().iterator();
            while (params.hasNext()) {
                ProcedureParameter param = (ProcedureParameter)params.next();
                DirectionKind dir = param.getDirection();
                if (!dir.equals(DirectionKind.IN_LITERAL) && !dir.equals(DirectionKind.INOUT_LITERAL)) continue;
                atts.add(param);
            }
        } else if (entity instanceof Procedure) {
            Iterator params = ((Procedure)entity).getParameters().iterator();
            while (params.hasNext()) {
                ProcedureParameter param = (ProcedureParameter)params.next();
                DirectionKind dir = param.getDirection();
                if (isInput && dir.equals(DirectionKind.IN_LITERAL) || dir.equals(DirectionKind.INOUT_LITERAL)) {
                    atts.add(param);
                    continue;
                }
                if (isInput) continue;
                if (dir.equals(DirectionKind.OUT_LITERAL) || dir.equals(DirectionKind.INOUT_LITERAL)) {
                    atts.add(param);
                    continue;
                }
                inParams.add(param);
            }
        } else {
            String msg = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.invalidRoot", (Object)entity.getClass().getName());
            this.addStatus(4, msg, null);
        }
        atts.addAll(inParams);
        Iterator attsIterator = atts.iterator();
        while (attsIterator.hasNext()) {
            NullableType nullable;
            RelationalEntity att = (RelationalEntity)attsIterator.next();
            XSDElementDeclaration next = this.factory.createXSDElementDeclaration();
            next.setName(att.getName());
            XSDTypeDefinition attType = null;
            if (att instanceof Column) {
                Column col = (Column)att;
                attType = (XSDTypeDefinition)col.getType();
                nullable = col.getNullable();
                next.setNillable(NullableType.NULLABLE_LITERAL == nullable);
            } else {
                ProcedureParameter param = (ProcedureParameter)att;
                attType = (XSDTypeDefinition)param.getType();
                nullable = param.getNullable();
                next.setNillable(NullableType.NULLABLE_LITERAL == nullable);
                String defaultVal = param.getDefaultValue();
                if (defaultVal != null) {
                    next.setLexicalValue(defaultVal);
                    next.setConstraint(XSDConstraint.DEFAULT_LITERAL);
                }
            }
            this.addImportForType(this.reusableSchema, attType);
            next.setTypeDefinition(attType);
            this.addChild(type, next, false);
        }
    }

    private boolean buildEntities(RelationalEntity entity, Stack recursionStack, boolean isInput, XSDComplexTypeDefinition parent) {
        BaseTable bt;
        if (recursionStack.contains(entity)) {
            return false;
        }
        recursionStack.push(entity);
        this.completedRoots.add(entity);
        String rootName = entity.getName();
        String uniqueName = null;
        uniqueName = isInput ? this.nameValidator.createValidUniqueName(rootName + INPUT_SUFFIX, this.inputRootElementNames) : this.nameValidator.createValidUniqueName(rootName + OUTPUT_SUFFIX, this.rootElementNames);
        if (uniqueName == null) {
            uniqueName = isInput ? rootName + INPUT_SUFFIX : rootName + OUTPUT_SUFFIX;
        }
        boolean doRef = false;
        if (!isInput && !this.doFlat && entity instanceof BaseTable && (bt = (BaseTable)entity).getPrimaryKey() != null && bt.getPrimaryKey().getForeignKeys().size() > 1) {
            doRef = true;
        }
        XSDElementDeclaration element = this.createElement(isInput, parent, entity, uniqueName);
        XSDElementDeclaration refd = null;
        if (doRef) {
            refd = (XSDElementDeclaration)this.refMap.get(entity);
            if (refd != null) {
                element.setResolvedElementDeclaration(refd);
                return true;
            }
            refd = this.createElement(isInput, null, entity, uniqueName);
            this.refMap.put(entity, refd);
        }
        XSDComplexTypeDefinition type = this.factory.createXSDComplexTypeDefinition();
        if (parent == null || doRef) {
            this.reusableSchema.getContents().add((Object)type);
            if (refd != null) {
                refd.setTypeDefinition((XSDTypeDefinition)type);
            } else {
                element.setTypeDefinition((XSDTypeDefinition)type);
            }
            type.setName(uniqueName + TYPE_SUFFIX);
        } else {
            element.setAnonymousTypeDefinition((XSDTypeDefinition)type);
        }
        this.addStructure(type, entity, isInput);
        if (!isInput && !this.doFlat && entity instanceof BaseTable) {
            BaseTable bt2 = (BaseTable)entity;
            Iterator fks = bt2.getForeignKeys().iterator();
            while (fks.hasNext()) {
                BaseTable child;
                boolean added;
                ForeignKey fk = (ForeignKey)fks.next();
                if (fk.getUniqueKey() == null || fk.getUniqueKey().getTable() == null || !(added = this.buildEntities((RelationalEntity)(child = fk.getUniqueKey().getTable()), recursionStack, isInput, type)) || recursionStack.isEmpty()) continue;
                recursionStack.pop();
            }
        }
        if (doRef && refd != null) {
            element.setResolvedElementDeclaration(refd);
        }
        return true;
    }

    private XSDElementDeclaration createElement(boolean isInput, XSDComplexTypeDefinition parent, RelationalEntity entity, String uniqueName) {
        if (this.reusableSchema == null) {
            this.initReusableSchema(uniqueName);
        }
        XSDElementDeclaration element = this.factory.createXSDElementDeclaration();
        XSDElementDeclaration wrapper = null;
        if (isInput) {
            element.setName(uniqueName);
            if (parent == null) {
                this.reusableSchema.getContents().add((Object)element);
                this.inputRootElements.add(element);
                this.inputRootElementNames.add(uniqueName);
                XSDElementDeclaration outGlobal = (XSDElementDeclaration)this.tableToOutputMap.get(entity);
                if (this.trackMappings && outGlobal != null) {
                    this.outputToInputMap.put(outGlobal, element);
                }
            } else {
                this.addChild(parent, element, false);
            }
        } else {
            element.setName(uniqueName);
            if (parent == null) {
                if (entity instanceof ProcedureResult) {
                    this.outputRoots.add(((ProcedureResult)entity).getProcedure());
                } else {
                    this.outputRoots.add(entity);
                }
                wrapper = this.factory.createXSDElementDeclaration();
                wrapper.setName(uniqueName + ROOT_SUFFIX);
                XSDComplexTypeDefinition elementType = this.factory.createXSDComplexTypeDefinition();
                element.setAnonymousTypeDefinition((XSDTypeDefinition)elementType);
                this.addChild(elementType, wrapper, true);
                this.reusableSchema.getContents().add((Object)element);
                this.rootElements.add(element);
                if (this.trackMappings) {
                    if (entity instanceof ProcedureResult) {
                        Procedure tmp = ((ProcedureResult)entity).getProcedure();
                        this.tableToOutputMap.put(tmp, element);
                    } else {
                        this.tableToOutputMap.put(entity, element);
                    }
                }
            } else {
                this.addChild(parent, element, false);
            }
        }
        if (wrapper != null) {
            return wrapper;
        }
        return element;
    }

    private void addChild(XSDComplexTypeDefinition parent, XSDElementDeclaration element, boolean isRoot) {
        XSDParticle particle = null;
        XSDModelGroup sequence = null;
        if (parent.getContent() != null && parent.getContent() instanceof XSDParticle) {
            particle = (XSDParticle)parent.getContent();
            if (particle.getContent() instanceof XSDModelGroup) {
                sequence = (XSDModelGroup)particle.getContent();
            } else {
                sequence = this.factory.createXSDModelGroup();
                sequence.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
                particle.setContent((XSDParticleContent)sequence);
            }
        } else {
            particle = this.factory.createXSDParticle();
            sequence = this.factory.createXSDModelGroup();
            sequence.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
            particle.setContent((XSDParticleContent)sequence);
            parent.setContent((XSDComplexTypeContent)particle);
        }
        XSDParticle holder = this.factory.createXSDParticle();
        holder.setContent((XSDParticleContent)element);
        if (isRoot) {
            holder.setMaxOccurs(-1);
        } else {
            holder.setMaxOccurs(1);
        }
        holder.setMinOccurs(0);
        sequence.getContents().add((Object)holder);
    }

    private XSDSchema initReusableSchema(String rootName) {
        if (this.reusableSchema != null) {
            return this.reusableSchema;
        }
        this.reusableSchema = XSDFactory.eINSTANCE.createXSDSchema();
        this.currentResource.getContents().add((Object)this.reusableSchema);
        Map map = this.reusableSchema.getQNamePrefixToNamespaceMap();
        String schemaForSchemaPrefixText = "xs";
        map.put(schemaForSchemaPrefixText, "http://www.w3.org/2001/XMLSchema");
        this.reusableSchema.setSchemaForSchemaQNamePrefix(schemaForSchemaPrefixText);
        this.includedSchemas.clear();
        this.addedNamespaces.clear();
        this.addedNamespaces.add("http://www.w3.org/2001/XMLSchema");
        String ns = MM_URI + rootName;
        this.reusableSchema.setTargetNamespace(ns);
        map.put(null, ns);
        return this.reusableSchema;
    }

    private void addImportForType(XSDSchema target, XSDTypeDefinition type) {
        if (target == null || type == null || type.getSchema() == null) {
            return;
        }
        String ns = type.getTargetNamespace();
        try {
            if (this.addedNamespaces.contains(ns) || this.includedSchemas.contains(type.getSchema())) {
                return;
            }
            if (ns == null) {
                XSDInclude xsdInclude = XSDFactory.eINSTANCE.createXSDInclude();
                xsdInclude.setSchemaLocation(type.eResource().getURI().toFileString());
                target.getContents().add(0, (Object)xsdInclude);
                this.includedSchemas.add(type.getSchema());
            } else {
                XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
                xsdImport.setNamespace(ns);
                xsdImport.setSchemaLocation(ns);
                target.getContents().add(0, (Object)xsdImport);
                this.addedNamespaces.add(ns);
            }
        }
        catch (Exception err) {
            String msg = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.importErr", (Object)ns);
            this.addStatus(4, msg, err);
        }
    }

    private void validateRoots(Collection roots) {
        if (roots == null || roots.isEmpty()) {
            return;
        }
        Iterator rootIT = roots.iterator();
        while (rootIT.hasNext()) {
            Object next = rootIT.next();
            if (next instanceof BaseTable || next instanceof View || next instanceof ProcedureResult || next instanceof Procedure) continue;
            String invalidRoot = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.invalidRoot", (Object)next.getClass().getName());
            throw new MetaMatrixRuntimeException(invalidRoot);
        }
    }

    public HashMap getOutputToInputMappings() {
        if (this.outputToInputMap == null) {
            this.outputToInputMap = new HashMap();
        }
        return this.outputToInputMap;
    }
}

