/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.sequelink;

import com.metamatrix.jdbc.sequelink.SequeLinkConnection;
import com.metamatrix.jdbc.sequelink.SequeLinkImplConnection;
import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbcx.slbase.BaseImplXAResource;
import com.metamatrix.sequelink.ssp.SlXid;
import com.metamatrix.sequelink.util.SlXaException;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class SequeLinkImplXAResource
extends BaseImplXAResource {
    private SlXid _slXid;

    public SequeLinkImplXAResource(BaseConnection baseConnection) {
        this.connection = baseConnection;
    }

    protected void open() throws SQLException {
        this.getImplConnection().xa_open();
    }

    protected void close() throws SQLException {
        this.getImplConnection().xa_close();
    }

    protected void start(Xid xid, int n2) throws XAException {
        SlXid slXid = new SlXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        try {
            this.getImplConnection().xa_start(slXid, n2);
        }
        catch (SlXaException slXaException) {
            throw new XAException(slXaException.getXaRetCode());
        }
    }

    protected void end(Xid xid, int n2) throws XAException {
        SlXid slXid = new SlXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        try {
            this.getImplConnection().xa_end(slXid, n2);
        }
        catch (SlXaException slXaException) {
            throw new XAException(slXaException.getXaRetCode());
        }
    }

    protected int prepare(Xid xid) throws XAException {
        SlXid slXid = new SlXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        try {
            return this.getImplConnection().xa_prepare(slXid);
        }
        catch (SlXaException slXaException) {
            throw new XAException(slXaException.getXaRetCode());
        }
    }

    protected void commit(Xid xid, boolean bl) throws XAException {
        SlXid slXid = new SlXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        try {
            this.getImplConnection().xa_commit(slXid, bl);
        }
        catch (SlXaException slXaException) {
            throw new XAException(slXaException.getXaRetCode());
        }
    }

    protected void rollback(Xid xid) throws XAException {
        SlXid slXid = new SlXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        try {
            this.getImplConnection().xa_rollback(slXid);
        }
        catch (SlXaException slXaException) {
            throw new XAException(slXaException.getXaRetCode());
        }
    }

    protected synchronized Xid[] recover(int n2) throws XAException {
        try {
            SlXid[] slXidArray = this.getImplConnection().xa_recover(n2);
            Xid[] xidArray = new Xid[slXidArray.length];
            for (int i2 = 0; i2 < slXidArray.length; ++i2) {
                this._slXid = slXidArray[i2];
                xidArray[i2] = new Xid(){
                    int formatId;
                    byte[] globalTransactionId;
                    byte[] branchQualifier;
                    {
                        this.formatId = SequeLinkImplXAResource.this._slXid.getFormatId();
                        this.globalTransactionId = SequeLinkImplXAResource.this._slXid.getGlobalTransactionId();
                        this.branchQualifier = SequeLinkImplXAResource.this._slXid.getBranchQualifier();
                    }

                    public int getFormatId() {
                        return this.formatId;
                    }

                    public byte[] getGlobalTransactionId() {
                        return this.globalTransactionId;
                    }

                    public byte[] getBranchQualifier() {
                        return this.branchQualifier;
                    }
                };
            }
            return xidArray;
        }
        catch (SlXaException slXaException) {
            throw new XAException(slXaException.getXaRetCode());
        }
    }

    protected void forget(Xid xid) throws XAException {
        SlXid slXid = new SlXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        try {
            this.getImplConnection().xa_forget(slXid);
        }
        catch (SlXaException slXaException) {
            throw new XAException(slXaException.getXaRetCode());
        }
    }

    protected int getTransactionTimeout() throws XAException {
        try {
            return this.getImplConnection().getXaTransactionTimeout();
        }
        catch (SlXaException slXaException) {
            throw new XAException(slXaException.getXaRetCode());
        }
    }

    protected boolean setTransactionTimeout(int n2) throws XAException {
        try {
            return this.getImplConnection().setXATransactionTimeout(n2);
        }
        catch (SlXaException slXaException) {
            throw new XAException(slXaException.getXaRetCode());
        }
    }

    protected String getRmIdentification() throws XAException {
        try {
            return this.getImplConnection().getRmIdentification();
        }
        catch (SlXaException slXaException) {
            throw new XAException(slXaException.getXaRetCode());
        }
    }

    private SequeLinkImplConnection getImplConnection() {
        return ((SequeLinkConnection)this.connection).getImplConnection();
    }
}

