/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.utils;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.RevokedCertificate;
import iaik.x509.V3Extension;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.extensions.CertificateIssuer;
import iaik.x509.extensions.ExtendedKeyUsage;
import iaik.x509.extensions.IssuingDistributionPoint;
import iaik.x509.extensions.ReasonCode;
import iaik.x509.ocsp.BasicOCSPResponse;
import iaik.x509.ocsp.CertID;
import iaik.x509.ocsp.CertStatus;
import iaik.x509.ocsp.OCSPException;
import iaik.x509.ocsp.OCSPRequest;
import iaik.x509.ocsp.OCSPResponse;
import iaik.x509.ocsp.ReqCert;
import iaik.x509.ocsp.Request;
import iaik.x509.ocsp.ResponderID;
import iaik.x509.ocsp.RevokedInfo;
import iaik.x509.ocsp.SingleResponse;
import iaik.x509.ocsp.UnknownInfo;
import iaik.x509.ocsp.extensions.CrlID;
import iaik.x509.ocsp.extensions.Nonce;
import iaik.x509.ocsp.extensions.ServiceLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;

public class ResponseGenerator {
    private boolean d = false;
    private Vector e;
    private Vector a = new Vector();
    private X509Certificate[] c;
    private PrivateKey b;
    private int f = 0;
    private PrintWriter g = null;

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            Object object;
            Object object2;
            SEQUENCE sEQUENCE = new SEQUENCE();
            ResponderID responderID = new ResponderID((Name)this.c[0].getSubjectDN());
            sEQUENCE.addComponent(responderID.toASN1Object());
            if (this.e.size() > 0) {
                object2 = this.e.elements();
                object = new SEQUENCE();
                while (object2.hasMoreElements()) {
                    ((ConstructedType)object).addComponent(((Name)object2.nextElement()).toASN1Object());
                }
                sEQUENCE.addComponent((ASN1Object)object);
            }
            if (this.a.size() > 0) {
                object2 = this.a.elements();
                object = new SEQUENCE();
                while (object2.hasMoreElements()) {
                    ((ConstructedType)object).addComponent(((SingleResponse)object2.nextElement()).toASN1Object());
                }
                sEQUENCE.addComponent(new CON_SPEC(0, (ASN1Object)object));
            }
            object2 = new ASN1(sEQUENCE);
            object = AlgorithmID.sha1WithRSAEncryption;
            if (!(this.b instanceof RSAPrivateKey)) {
                if (this.b instanceof DSAPrivateKey) {
                    object = AlgorithmID.dsa;
                } else {
                    throw new IOException("Cannot sign basic response. Unknown key algorithm: " + this.b.getAlgorithm());
                }
            }
            Signature signature = ((AlgorithmID)object).getSignatureInstance();
            signature.initSign(this.b);
            signature.update(((ASN1)object2).toByteArray());
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(((ASN1)object2).toASN1Object());
            sEQUENCE2.addComponent(new BIT_STRING(signature.sign()));
            DerCoder.encodeTo(sEQUENCE2, outputStream);
            return;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Responder: " + this.c[0].getSubjectDN() + "\n");
        stringBuffer.append("Cert Issuers: " + this.e.size() + "\n");
        stringBuffer.append("Cached responses: " + this.a.size());
        return stringBuffer.toString();
    }

    public void setDebugStream(OutputStream outputStream) {
        if (outputStream == null) {
            this.g = null;
            return;
        }
        this.g = new PrintWriter(outputStream, true);
    }

    public SingleResponse removeSingleResponse(ReqCert reqCert) {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            SingleResponse singleResponse = (SingleResponse)enumeration.nextElement();
            if (!singleResponse.isResponseFor(reqCert) || !this.a.removeElement(singleResponse)) continue;
            return singleResponse;
        }
        return null;
    }

    public boolean removeCertificateIssuer(Name name) {
        return this.e.removeElement(name);
    }

    public void removeAllSingleResponses() {
        this.a.removeAllElements();
    }

    public void removeAllCertIssuers() {
        this.e.removeAllElements();
    }

    public void printDebug(boolean bl) {
        if (bl) {
            this.setDebugStream(System.out);
            return;
        }
        this.setDebugStream(null);
    }

    public void init(InputStream inputStream) throws IOException {
        try {
            Object object;
            this.a.removeAllElements();
            this.e.removeAllElements();
            ASN1 aSN1 = new ASN1(inputStream);
            byte[] byArray = aSN1.getFirstObject();
            ASN1Object aSN1Object = aSN1.getComponentAt(0);
            ResponderID responderID = new ResponderID(aSN1Object.getComponentAt(0));
            if (!responderID.isResponderIdFor(this.c[0])) {
                throw new IOException("Initialization failed. Response not created by this generator!");
            }
            int n2 = 1;
            while (n2 < aSN1Object.countComponents()) {
                object = aSN1Object.getComponentAt(n2);
                if (!((ASN1Object)object).isA(ASN.CON_SPEC)) {
                    int n3 = 0;
                    while (n3 < ((ASN1Object)object).countComponents()) {
                        this.e.addElement(new Name(((ASN1Object)object).getComponentAt(n3)));
                        ++n3;
                    }
                } else {
                    SEQUENCE sEQUENCE = (SEQUENCE)((ASN1Object)object).getValue();
                    int n4 = 0;
                    while (n4 < sEQUENCE.countComponents()) {
                        this.a.addElement(new SingleResponse(sEQUENCE.getComponentAt(n4)));
                        ++n4;
                    }
                }
                ++n2;
            }
            object = (byte[])aSN1.getComponentAt(1).getValue();
            AlgorithmID algorithmID = AlgorithmID.sha1WithRSAEncryption;
            if (!(this.b instanceof RSAPrivateKey)) {
                if (this.b instanceof DSAPrivateKey) {
                    algorithmID = AlgorithmID.dsa;
                } else {
                    throw new IOException("Cannot verify basic response. Unknown key algorithm: " + this.b.getAlgorithm());
                }
            }
            Signature signature = algorithmID.getSignatureInstance();
            signature.initVerify(this.c[0].getPublicKey());
            signature.update(byArray);
            if (!signature.verify((byte[])object)) {
                throw new IOException("Cannot init generator. Signture verification error!");
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean a(ReqCert reqCert) {
        Name name;
        block14: {
            int n2 = reqCert.getType();
            name = null;
            Enumeration enumeration = null;
            try {
                switch (n2) {
                    case 0: {
                        CertID certID = (CertID)reqCert.getReqCert();
                        byte[] byArray = certID.getIssuerNameHash();
                        Name name2 = (Name)this.c[0].getSubjectDN();
                        byte[] byArray2 = CertID.calculateIssuerNameHash(name2, certID.getHashAlgorithm());
                        if (CryptoUtils.equalsBlock(byArray, byArray2)) {
                            return true;
                        }
                        name2 = (Name)this.c[0].getIssuerDN();
                        byArray2 = CertID.calculateIssuerNameHash(name2, certID.getHashAlgorithm());
                        if (CryptoUtils.equalsBlock(byArray, byArray2) && this.d) {
                            return true;
                        }
                        enumeration = this.e.elements();
                        while (enumeration.hasMoreElements()) {
                            Name name3 = (Name)enumeration.nextElement();
                            byArray2 = CertID.calculateIssuerNameHash(name3, certID.getHashAlgorithm());
                            if (!CryptoUtils.equalsBlock(byArray, byArray2)) continue;
                            name = name3;
                            break block14;
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        Name name4 = ResponseGenerator.a(reqCert.getReqCert());
                        if (name4.equals(this.c[0].getSubjectDN())) {
                            return true;
                        }
                        if (name4.equals(this.c[0].getIssuerDN()) && this.d) {
                            return true;
                        }
                        enumeration = this.e.elements();
                        while (enumeration.hasMoreElements()) {
                            Name name5 = (Name)enumeration.nextElement();
                            if (!name4.equals(name5)) continue;
                            name = name5;
                            break block14;
                        }
                        break;
                    }
                    default: {
                        if (name == null) return false;
                    }
                }
            }
            catch (Exception exception) {}
        }
        if (name == null) return false;
        if (name.equals((Name)this.c[0].getSubjectDN())) {
            return true;
        }
        if (!name.equals((Name)this.c[0].getIssuerDN())) {
            return false;
        }
        if (!this.d) return false;
        return true;
    }

    public Enumeration getSingleResponses() {
        return this.a.elements();
    }

    private SingleResponse a(Request request, int n2, int n3) {
        Object object;
        Object object2;
        try {
            object2 = request.getServiceLocator();
            if (object2 != null) {
                this.a("Request contains the ServiceLocator extension.", n2, n3);
                object = ((ServiceLocator)object2).getIssuer();
                if (!((Name)object).equals(this.c[0].getSubjectDN())) {
                    this.a("Service Locator does not reference this reponder: sending unknown response.", n2, n3);
                    return new SingleResponse(request.getReqCert(), new CertStatus(new UnknownInfo()), new Date());
                }
            }
        }
        catch (X509ExtensionException x509ExtensionException) {}
        object2 = this.a.elements();
        while (object2.hasMoreElements()) {
            object = (SingleResponse)object2.nextElement();
            if (!((SingleResponse)object).isResponseFor(request.getReqCert())) continue;
            this.a("Cached request detected.", n2, n3);
            return object;
        }
        this.a("No single response cached. Creating new...", n2, n3);
        this.a("Searching for authorized issuer...", n2, n3);
        object = request.getReqCert();
        CertStatus certStatus = new CertStatus(new UnknownInfo());
        if (this.a((ReqCert)object)) {
            certStatus = new CertStatus();
            this.a("Authorized issuer found. CertStatus good.", n2, n3);
        } else {
            this.a("No authorized issuer found. CertStatus unknown.", n2, n3);
        }
        return new SingleResponse((ReqCert)object, certStatus, new Date());
    }

    public SingleResponse getSingleResponse(Request request) {
        return this.a(request, -1, -1);
    }

    public SingleResponse getSingleResponse(ReqCert reqCert) {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            SingleResponse singleResponse = (SingleResponse)enumeration.nextElement();
            if (!singleResponse.isResponseFor(reqCert)) continue;
            return singleResponse;
        }
        return null;
    }

    public PrivateKey getResponderKey() {
        return this.b;
    }

    public X509Certificate[] getResponderCertificates() {
        return this.c;
    }

    private static Name a(Object object) {
        if (object instanceof IssuerAndSerialNumber) {
            return ((IssuerAndSerialNumber)object).getIssuer();
        }
        if (object instanceof X509Certificate) {
            return (Name)((X509Certificate)object).getIssuerDN();
        }
        return null;
    }

    private void a(String string, int n2, int n3) {
        if (this.g != null) {
            this.g.println("(rg_debug" + (n2 > 0 ? " " + n2 + "_" + n3 + ") " : ") ") + string);
        }
    }

    private void a(String string, int n2) {
        if (this.g != null) {
            this.g.println("(rg_debug" + (n2 > 0 ? " " + n2 + ") " : ") ") + string);
        }
    }

    private void a(String string) {
        this.a(string, -1, -1);
    }

    private static SingleResponse a(RevokedCertificate revokedCertificate, PublicKey publicKey, Name name, Date date, Date date2, int n2) throws Exception {
        Object object;
        Object object2;
        RevokedInfo revokedInfo = new RevokedInfo(revokedCertificate.getRevocationDate());
        try {
            object2 = (ReasonCode)revokedCertificate.getExtension(ReasonCode.oid);
            if (object2 != null) {
                revokedInfo.setRevocationReason((ReasonCode)object2);
            }
        }
        catch (X509ExtensionException x509ExtensionException) {}
        object2 = new CertStatus(revokedInfo);
        ReqCert reqCert = null;
        if (n2 == 0) {
            object = new CertID(AlgorithmID.sha1, name, publicKey, revokedCertificate.getSerialNumber());
            reqCert = new ReqCert(0, object);
        } else {
            reqCert = new ReqCert(1, new IssuerAndSerialNumber(name, revokedCertificate.getSerialNumber()));
        }
        object = new SingleResponse(reqCert, (CertStatus)object2, date);
        if (date2 != null) {
            ((SingleResponse)object).setNextUpdate(date2);
        }
        return object;
    }

    public OCSPResponse createOCSPResponse(InputStream inputStream, PublicKey publicKey, AlgorithmID algorithmID, V3Extension[] v3ExtensionArray) {
        Object object;
        int n2;
        OCSPRequest oCSPRequest;
        OCSPResponse oCSPResponse;
        int n3;
        block35: {
            n3 = -1;
            if (this.g != null) {
                n3 = ++this.f;
            }
            oCSPResponse = null;
            oCSPRequest = null;
            n2 = 0;
            this.a("Parsing request...", n3);
            try {
                oCSPRequest = new OCSPRequest(inputStream);
                if (oCSPRequest.containsSignature()) {
                    this.a("Request is signed.", n3);
                    boolean bl = false;
                    if (publicKey != null) {
                        this.a("Verifying signature with using supplied requestor key.", n3);
                        try {
                            oCSPRequest.verify(publicKey);
                            bl = true;
                            this.a("Signature ok", n3);
                        }
                        catch (Exception exception) {}
                    }
                    if (!bl && oCSPRequest.containsCertificates()) {
                        this.a("Verifying signature with included signer cert...", n3);
                        X509Certificate x509Certificate = oCSPRequest.verify();
                        this.a("Signature ok from request signer " + x509Certificate.getSubjectDN(), n3);
                        bl = true;
                    }
                    if (!bl) {
                        this.a("Request signed but cannot verify signature since missing signer key. Sending malformed request!", n3);
                        n2 = 1;
                    }
                    break block35;
                }
                this.a("Unsigned request!", n3);
            }
            catch (IOException iOException) {
                this.a("Encoding error; sending malformedRequest " + iOException.getMessage(), n3);
                n2 = 1;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.a("Cannot verify; sending internalError: " + noSuchAlgorithmException.getMessage(), n3);
                n2 = 2;
            }
            catch (OCSPException oCSPException) {
                this.a("Included certs do not belong to signer; sending malformedRequest : " + oCSPException.getMessage(), n3);
                n2 = 1;
            }
            catch (InvalidKeyException invalidKeyException) {
                this.a("Signer key invalid; sending malformedRequest : " + invalidKeyException.getMessage(), n3);
                n2 = 1;
            }
            catch (SignatureException signatureException) {
                this.a("Signature verification error; sending malformedRequest : " + signatureException.getMessage(), n3);
                n2 = 1;
            }
            catch (Exception exception) {
                if (this.g != null) {
                    exception.printStackTrace();
                }
                this.a("Some error occured during request parsing/verification; sending tryLater " + exception.getMessage(), n3);
                n2 = 3;
            }
        }
        if (n2 != 0) {
            oCSPResponse = new OCSPResponse(n2);
            return oCSPResponse;
        }
        try {
            ObjectID[] objectIDArray = oCSPRequest.getAccepatableResponseTypes();
            if (objectIDArray != null && objectIDArray.length > 0) {
                boolean bl = false;
                int n4 = 0;
                while (n4 < objectIDArray.length) {
                    if (objectIDArray[n4].equals(BasicOCSPResponse.responseType)) {
                        bl = true;
                        break;
                    }
                    ++n4;
                }
                if (!bl) {
                    this.a("Warning! Client does not support basic response type. Using it anyway...", n3);
                }
            }
        }
        catch (Exception exception) {}
        this.a("Create successful response.", n3);
        oCSPResponse = new OCSPResponse(0);
        BasicOCSPResponse basicOCSPResponse = new BasicOCSPResponse();
        try {
            object = new ResponderID((Name)this.c[0].getSubjectDN());
            basicOCSPResponse.setResponderID((ResponderID)object);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            Date date = gregorianCalendar.getTime();
            basicOCSPResponse.setProducedAt(date);
            this.a("Processing requests...", n3);
            Request[] requestArray = oCSPRequest.getRequestList();
            SingleResponse[] singleResponseArray = new SingleResponse[requestArray.length];
            int n5 = 0;
            while (n5 < requestArray.length) {
                this.a("Processing Request No. " + (n5 + 1), n3);
                singleResponseArray[n5] = this.a(requestArray[n5], n3, n5 + 1);
                ++n5;
            }
            basicOCSPResponse.setSingleResponses(singleResponseArray);
        }
        catch (Exception exception) {
            if (this.g != null) {
                exception.printStackTrace();
            }
            this.a("Some error occured; sending tryLater " + exception.getMessage(), n3);
            return new OCSPResponse(3);
        }
        try {
            object = (Nonce)oCSPRequest.getExtension(Nonce.oid);
            if (object != null) {
                this.a("Nonce included in request. Copy into response.", n3);
                basicOCSPResponse.addExtension((V3Extension)object);
            }
        }
        catch (Exception exception) {
            this.a("Error in setting Nonce for response (ignore this): " + exception.getMessage(), n3);
        }
        if (v3ExtensionArray != null) {
            int n6 = 0;
            while (n6 < v3ExtensionArray.length) {
                this.a("Adding extension " + v3ExtensionArray[n6].getName(), n3);
                try {
                    basicOCSPResponse.addExtension(v3ExtensionArray[n6]);
                }
                catch (Exception exception) {
                    this.a("Cannot add extension " + v3ExtensionArray[n6].getName() + ", ignore this", n3);
                }
                ++n6;
            }
        }
        this.a("Sign response.", n3);
        basicOCSPResponse.setCertificates(this.c);
        try {
            basicOCSPResponse.sign(algorithmID, this.b);
        }
        catch (Exception exception) {
            this.a("Error signing response: " + exception.getMessage(), n3);
            this.a("Send tryLater response", n3);
            return new OCSPResponse(3);
        }
        oCSPResponse.setResponse(basicOCSPResponse);
        return oCSPResponse;
    }

    private boolean a(X509Certificate x509Certificate) {
        ExtendedKeyUsage extendedKeyUsage = null;
        try {
            extendedKeyUsage = (ExtendedKeyUsage)x509Certificate.getExtension(ExtendedKeyUsage.oid);
            if (extendedKeyUsage != null) {
                ObjectID[] objectIDArray = extendedKeyUsage.getKeyPurposeIDs();
                int n2 = 0;
                while (n2 < objectIDArray.length) {
                    if (objectIDArray[n2].equals(ExtendedKeyUsage.ocspSigning)) {
                        this.a("Responder cert is allowed to sign OCSP responses (ExtendenKeyUsage purpose ocspSigning is set).");
                        return true;
                    }
                    ++n2;
                }
            }
        }
        catch (X509ExtensionException x509ExtensionException) {}
        return false;
    }

    public void addResponseEntry(SingleResponse singleResponse) {
        int n2 = this.a.size();
        int n3 = 0;
        while (n3 < n2) {
            SingleResponse singleResponse2 = (SingleResponse)this.a.elementAt(n3);
            if (singleResponse2.isResponseFor(singleResponse.getReqCert())) {
                this.a.setElementAt(singleResponse, n3);
                return;
            }
            ++n3;
        }
        this.a.addElement(singleResponse);
    }

    public void addResponseEntry(ReqCert reqCert, CertStatus certStatus, Date date, Date date2) {
        SingleResponse singleResponse = new SingleResponse(reqCert, certStatus, date);
        if (date2 != null) {
            singleResponse.setNextUpdate(date2);
        }
        this.addResponseEntry(singleResponse);
    }

    public void addResponseEntries(X509CRL x509CRL, X509Certificate x509Certificate, int n2, CrlID crlID) throws SignatureException, OCSPException {
        Object[] objectArray;
        if (n2 < 0 || n2 > 2) {
            throw new OCSPException("Invalid reqCertType (" + n2 + ")! Only can create " + "responses for ReqCert types certID or issuerSerial from crl!");
        }
        if (x509CRL == null) {
            throw new IllegalArgumentException("Cannot create entries from a null CRL!");
        }
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Cannot create entries from CRL; missing crl issuer cert!");
        }
        this.a("Verifying crl with issuer key!");
        try {
            x509CRL.verify(x509Certificate.getPublicKey());
        }
        catch (Exception exception) {
            throw new SignatureException("Error verifying crl: " + exception.getMessage());
        }
        this.addCertificateIssuer((Name)x509Certificate.getSubjectDN());
        boolean bl = false;
        try {
            objectArray = (Object[])x509CRL.getExtension(IssuingDistributionPoint.oid);
            if (objectArray != null && objectArray.getIndirectCRL()) {
                bl = true;
                this.a("Indirect CRL!");
            }
        }
        catch (X509ExtensionException x509ExtensionException) {}
        if (!bl && !this.c[0].getSubjectDN().equals(x509CRL.getIssuerDN())) {
            this.a("No indirect crl but crl issuer different from ocsp response signer.");
            if (!this.d) {
                throw new OCSPException("Cannot create response entries for this crl. CRL issuer is different from response signer which is not allowed for OCSP signing!");
            }
            this.a("Responder is allowed to sign OCSP responses.");
            if (!this.c[0].getIssuerDN().equals(x509CRL.getIssuerDN())) {
                throw new OCSPException("Cannot create response entries for this crl. Responder is allowed to sign OCSP responses, but not by the authorized by the CRL issuer!");
            }
            this.a("Responder is authorized from crl issuer.");
        }
        if (!bl) {
            this.a("Create response entries for non indirect crl...");
            objectArray = x509CRL.getRevokedCertificates().toArray();
            RevokedCertificate revokedCertificate = null;
            int n3 = 0;
            while (n3 < objectArray.length) {
                try {
                    revokedCertificate = (RevokedCertificate)objectArray[n3];
                    SingleResponse singleResponse = ResponseGenerator.a(revokedCertificate, x509Certificate.getPublicKey(), (Name)x509Certificate.getSubjectDN(), x509CRL.getThisUpdate(), x509CRL.getNextUpdate(), n2);
                    if (crlID != null) {
                        singleResponse.setCrlID(crlID);
                    }
                    this.addResponseEntry(singleResponse);
                }
                catch (Exception exception) {
                    throw new OCSPException("Error processing revocation entry " + revokedCertificate.getSerialNumber() + ": " + exception.getMessage());
                }
                ++n3;
            }
            return;
        }
        this.a("Create response entries for indirect crl...");
        objectArray = x509CRL.getRevokedCertificates().toArray();
        RevokedCertificate revokedCertificate = null;
        Name name = (Name)x509Certificate.getSubjectDN();
        boolean bl2 = true;
        int n4 = 0;
        while (n4 < objectArray.length) {
            Object object;
            revokedCertificate = (RevokedCertificate)objectArray[n4];
            try {
                object = (CertificateIssuer)revokedCertificate.getExtension(CertificateIssuer.oid);
                if (object != null) {
                    this.a("Entry number " + n4 + " contains certificate issuer extension.");
                    GeneralNames generalNames = ((CertificateIssuer)object).getIssuer();
                    Enumeration enumeration = generalNames.getNames();
                    GeneralName generalName = (GeneralName)enumeration.nextElement();
                    if (generalName.getType() != 4) {
                        throw new OCSPException("Error processing revocation entry " + revokedCertificate.getSerialNumber() + ": " + "CertificateIssuer is not a directoryName!");
                    }
                    name = (Name)generalName.getName();
                    bl2 = true;
                }
            }
            catch (X509ExtensionException x509ExtensionException) {}
            if (bl2) {
                if (!(name.equals(this.c[0].getSubjectDN()) || name.equals(this.c[0].getIssuerDN()) && this.d)) {
                    throw new OCSPException("Error processing revocation entry " + revokedCertificate.getSerialNumber() + ": " + "responder not authorized for signing this entry!");
                }
                this.addCertificateIssuer(name);
                bl2 = false;
            }
            try {
                object = ResponseGenerator.a(revokedCertificate, null, name, x509CRL.getThisUpdate(), x509CRL.getNextUpdate(), 1);
                if (crlID != null) {
                    ((SingleResponse)object).setCrlID(crlID);
                }
                this.addResponseEntry((SingleResponse)object);
            }
            catch (Exception exception) {
                throw new OCSPException("Error processing revocation entry " + revokedCertificate.getSerialNumber());
            }
            ++n4;
        }
    }

    public void addResponseEntries(X509CRL x509CRL, X509Certificate x509Certificate, int n2) throws SignatureException, OCSPException {
        this.addResponseEntries(x509CRL, x509Certificate, n2, null);
    }

    public void addCertificateIssuer(Name name) {
        int n2 = this.e.size();
        int n3 = 0;
        while (n3 < n2) {
            if (name.equals((Name)this.e.elementAt(n3))) {
                return;
            }
            ++n3;
        }
        this.e.addElement(name);
    }

    public ResponseGenerator(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        this();
        if (privateKey == null) {
            throw new IllegalArgumentException("Cannot create ResponseGenerator. Missing responder key!");
        }
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            throw new IllegalArgumentException("Cannot create ResponseGenerator. Missing responder certs!");
        }
        this.b = privateKey;
        this.c = x509CertificateArray;
        this.d = this.a(x509CertificateArray[0]);
    }

    public ResponseGenerator(PKCS12 pKCS12, char[] cArray) throws PKCSException {
        this();
        if (!pKCS12.verify(cArray)) {
            throw new PKCSException("Verification error!");
        }
        pKCS12.decrypt(cArray);
        KeyBag keyBag = pKCS12.getKeyBag();
        this.b = keyBag.getPrivateKey();
        CertificateBag[] certificateBagArray = pKCS12.getCertificateBags();
        Certificate[] certificateArray = CertificateBag.getCertificates(certificateBagArray);
        try {
            this.c = Util.convertCertificateChain(certificateArray);
        }
        catch (Exception exception) {
            throw new PKCSException("Error reading certificates: " + exception.getMessage());
        }
        this.c = Util.arrangeCertificateChain(this.c, false);
        if (this.c == null) {
            throw new PKCSException("Cannot sort certificates included in PKCS#12 object!");
        }
        if (this.b == null) {
            throw new IllegalArgumentException("Cannot create ResponseGenerator. Missing responder key!");
        }
        if (this.c == null || this.c.length < 1) {
            throw new IllegalArgumentException("Cannot create ResponseGenerator. Missing responder certs!");
        }
        this.d = this.a(this.c[0]);
    }

    ResponseGenerator() {
        this.e = new Vector();
    }
}

