/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.columns;

import com.metamatrix.jdbc.slbase.BaseColumn;
import com.metamatrix.sequelink.describe.VariableDescriptor;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import java.io.IOException;

public class SequeLinkColumnDescribe {
    static final PseudoVariableDescriptor PVD_1 = new PseudoVariableDescriptor(1);
    static final PseudoVariableDescriptor PVD_2 = new PseudoVariableDescriptor(2);
    static final PseudoVariableDescriptor PVD_127 = new PseudoVariableDescriptor(127);
    static final PseudoVariableDescriptor PVD_Minus127 = new PseudoVariableDescriptor(-127);
    private VariableDescriptor[] describe;
    private int type;
    private int length;
    private String catalogName;
    private int displaySize;
    private String encoding;
    private String label;
    private String name;
    private int position;
    private int precision;
    private int scale;
    private String schemaName;
    private String tableName;
    private String typeName;
    private boolean autoIncrement;
    private boolean caseSensitive;
    private boolean currency;
    private boolean definitelyWritable;
    private int nullable;
    private boolean readOnly;
    private int searchable;
    private boolean signed;
    private boolean writable;

    public SequeLinkColumnDescribe(VariableDescriptor[] variableDescriptorArray, int n, boolean bl) {
        this.position = n;
        this.describe = variableDescriptorArray;
        this.type = this._getType();
        if (bl && (this.type == 6 || this.type == 8)) {
            this.mapORANumber0ToNumeric();
            this.type = this._getType();
        }
        this.length = this._getLength();
        this.catalogName = this._getCatalogName();
        this.displaySize = this._getDisplaySize();
        this.encoding = this._getEncoding();
        this.label = this._getLabel();
        this.name = this._getName();
        this.precision = this._getPrecision();
        this.scale = this._getScale();
        this.schemaName = this._getSchemaName();
        this.tableName = this._getTableName();
        this.typeName = this._getTypeName();
        this.autoIncrement = this._isAutoIncrement();
        this.caseSensitive = this._isCaseSensitive();
        this.currency = this._isCurrency();
        this.definitelyWritable = this._isDefinitelyWritable();
        this.nullable = this._isNullable();
        this.readOnly = this._isReadOnly();
        this.searchable = this._isSearchable();
        this.signed = this._isSigned();
        this.writable = this._isWritable();
        this.describe = null;
    }

    public SequeLinkColumnDescribe(BaseColumn baseColumn, int n) {
        this.position = n;
        this.type = baseColumn.type;
        this.catalogName = baseColumn.catalogName;
        this.displaySize = baseColumn.displaySize;
        this.encoding = "";
        this.label = baseColumn.label;
        this.name = baseColumn.name;
        this.precision = baseColumn.precision;
        this.scale = baseColumn.scale;
        this.schemaName = baseColumn.schemaName;
        this.tableName = baseColumn.tableName;
        this.typeName = baseColumn.typeName;
        this.autoIncrement = baseColumn.isAutoIncrement;
        this.caseSensitive = baseColumn.isCaseSensitive;
        this.currency = baseColumn.isCurrency;
        this.definitelyWritable = baseColumn.isDefinitelyWritable;
        this.nullable = baseColumn.isNullable;
        this.readOnly = baseColumn.isReadOnly;
        this.searchable = baseColumn.isSearchable;
        this.signed = baseColumn.isSigned;
        this.writable = baseColumn.isWritable;
        if (this.type == 12 || this.type == 1 || this.type == -1) {
            this.precision = this.displaySize;
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public boolean isDefinitelyWritable() {
        return this.definitelyWritable;
    }

    public int isNullable() {
        return this.nullable;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int isSearchable() {
        return this.searchable;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isWritable() {
        return this.writable;
    }

    private int _getLength() {
        VariableDescriptor variableDescriptor = this.describe[5];
        int n = (Integer)variableDescriptor.getInfo();
        return n;
    }

    private int _getType() {
        VariableDescriptor variableDescriptor = this.describe[12];
        int n = (Integer)variableDescriptor.getInfo();
        if (n == -8) {
            n = 1;
        } else if (n == -9) {
            n = 12;
        } else if (n == -10) {
            n = -1;
        }
        return n;
    }

    private String _getCatalogName() {
        VariableDescriptor variableDescriptor = this.describe[2];
        String string = (String)variableDescriptor.getInfo();
        return string;
    }

    private int _getDisplaySize() {
        int n;
        int n2 = this._getType();
        switch (n2) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                n = this._getLength();
                break;
            }
            case 2: 
            case 3: {
                int n3 = this._getPrecision();
                int n4 = this._getScale();
                n = n4 > 0 ? (n4 < n3 ? n3 + 1 : n4 + 2) : n3 - n4;
                if (!this._isSigned()) break;
                ++n;
                break;
            }
            case 4: {
                n = this._isSigned() ? 11 : 10;
                break;
            }
            case 6: 
            case 8: {
                n = 22;
                break;
            }
            case 5: {
                n = this._isSigned() ? 6 : 5;
                break;
            }
            case 7: {
                n = 13;
                break;
            }
            case 93: {
                n = this._getLength();
                if (n >= 19) break;
                n = 19;
                break;
            }
            case 91: {
                n = 10;
                break;
            }
            case 92: {
                n = 8;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                n = this._getLength() * 2;
                if (n >= 0) break;
                n = Integer.MAX_VALUE;
                break;
            }
            case -6: {
                n = this._isSigned() ? 4 : 3;
                break;
            }
            case -7: {
                n = 1;
                break;
            }
            case -5: {
                n = 20;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private String _getLabel() {
        VariableDescriptor variableDescriptor = this.describe[4];
        String string = (String)variableDescriptor.getInfo();
        if (string.length() == 0) {
            return this._getName();
        }
        return string;
    }

    private String _getName() {
        VariableDescriptor variableDescriptor = this.describe[6];
        String string = (String)variableDescriptor.getInfo();
        return string;
    }

    private String _getTypeName() {
        VariableDescriptor variableDescriptor = this.describe[13];
        String string = (String)variableDescriptor.getInfo();
        return string;
    }

    private int _getPrecision() {
        int n;
        int n2 = this._getType();
        switch (n2) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                n = this._getLength();
                break;
            }
            case 2: 
            case 3: {
                n = this._getLength();
                int n3 = this._getScale();
                if (n3 > 0) {
                    if (this._isSigned()) {
                        n -= 2;
                        break;
                    }
                    --n;
                    break;
                }
                if (n3 == 0) {
                    if (!this._isSigned()) break;
                    --n;
                    break;
                }
                --n;
                break;
            }
            case 4: {
                n = 10;
                break;
            }
            case 6: 
            case 8: {
                n = 15;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 7: {
                n = 7;
                break;
            }
            case 91: {
                n = 10;
                break;
            }
            case 92: {
                n = 8;
                break;
            }
            case 93: {
                n = this._getLength();
                break;
            }
            case -6: {
                n = 3;
                break;
            }
            case -7: {
                n = 1;
                break;
            }
            case -5: {
                n = this._isSigned() ? 19 : 20;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private int _getScale() {
        VariableDescriptor variableDescriptor = this.describe[8];
        int n = (Integer)variableDescriptor.getInfo();
        return n;
    }

    private String _getSchemaName() {
        VariableDescriptor variableDescriptor = this.describe[9];
        String string = (String)variableDescriptor.getInfo();
        return string;
    }

    private String _getTableName() {
        VariableDescriptor variableDescriptor = this.describe[11];
        String string = (String)variableDescriptor.getInfo();
        return string;
    }

    private boolean _isAutoIncrement() {
        VariableDescriptor variableDescriptor = this.describe[0];
        int n = (Integer)variableDescriptor.getInfo();
        return n == 1;
    }

    private boolean _isCaseSensitive() {
        VariableDescriptor variableDescriptor = this.describe[1];
        int n = (Integer)variableDescriptor.getInfo();
        return n == 1;
    }

    private boolean _isCurrency() {
        VariableDescriptor variableDescriptor = this.describe[3];
        int n = (Integer)variableDescriptor.getInfo();
        return n == 1;
    }

    private boolean _isDefinitelyWritable() {
        VariableDescriptor variableDescriptor = this.describe[15];
        int n = (Integer)variableDescriptor.getInfo();
        return n == 1;
    }

    private int _isNullable() {
        VariableDescriptor variableDescriptor = this.describe[7];
        int n = (Integer)variableDescriptor.getInfo();
        return n;
    }

    private boolean _isReadOnly() {
        VariableDescriptor variableDescriptor = this.describe[15];
        int n = (Integer)variableDescriptor.getInfo();
        return n == 0;
    }

    private boolean _isWritable() {
        VariableDescriptor variableDescriptor = this.describe[15];
        int n = (Integer)variableDescriptor.getInfo();
        return n != 0;
    }

    private int _isSearchable() {
        VariableDescriptor variableDescriptor = this.describe[10];
        int n = (Integer)variableDescriptor.getInfo();
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    private boolean _isSigned() {
        VariableDescriptor variableDescriptor = this.describe[14];
        int n = (Integer)variableDescriptor.getInfo();
        return n == 0;
    }

    private String _getEncoding() {
        if (this.describe.length < 17) {
            return "";
        }
        VariableDescriptor variableDescriptor = this.describe[16];
        String string = (String)variableDescriptor.getInfo();
        return string;
    }

    private void mapORANumber0ToNumeric() {
        this.describe[3] = PVD_1;
        this.describe[5] = PVD_127;
        this.describe[8] = PVD_Minus127;
        this.describe[12] = PVD_2;
    }

    static class PseudoVariableDescriptor
    extends VariableDescriptor {
        PseudoVariableDescriptor(String string) {
            this.object = string;
        }

        PseudoVariableDescriptor(int n) {
            this.object = new Integer(n);
        }

        public void writeObjectOn(SspOutputStream sspOutputStream) throws IOException {
            throw new IOException();
        }
    }
}

