/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.dh.DHParameterGenerator;
import iaik.security.dh.ESDHParameterGenerator;
import iaik.security.dh.ESDHParameterSpec;
import iaik.security.dh.ESDHPrivateKey;
import iaik.security.dh.ESDHPublicKey;
import iaik.security.random.SecRandom;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;

public class ESDHKeyPairGenerator
extends KeyPairGenerator {
    private int u;
    private byte[] e;
    private BigInteger ab;
    private BigInteger k;
    private BigInteger fb;
    private BigInteger v;
    private int gb = -1;
    private int l = -1;
    private SecureRandom f;
    private static final int kb = 300;
    private static final int jb = 1024;
    private static final BigInteger hb;
    private static final BigInteger ib;
    private static int s;
    private static final byte[] c;
    private static final byte[] y;
    private static final byte[] i;
    private static final byte[] o;
    private static final byte[] db;
    private static int t;
    private static final byte[] d;
    private static final byte[] z;
    private static final byte[] j;
    private static final byte[] p;
    private static final byte[] eb;
    private static int q;
    private static final byte[] a;
    private static final byte[] w;
    private static final byte[] g;
    private static final byte[] m;
    private static final byte[] bb;
    private static int r;
    private static final byte[] b;
    private static final byte[] x;
    private static final byte[] h;
    private static final byte[] n;
    private static final byte[] cb;

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.f = secureRandom;
        if (algorithmParameterSpec instanceof ESDHParameterSpec) {
            this.v = ((ESDHParameterSpec)algorithmParameterSpec).getP();
            this.fb = ((ESDHParameterSpec)algorithmParameterSpec).getG();
            this.k = ((ESDHParameterSpec)algorithmParameterSpec).getQ();
            this.ab = ((ESDHParameterSpec)algorithmParameterSpec).getJ();
            this.e = ((ESDHParameterSpec)algorithmParameterSpec).getSeed();
            this.u = ((ESDHParameterSpec)algorithmParameterSpec).getPGenCounter();
            this.l = this.v.bitLength();
            this.gb = this.k.bitLength();
            if (this.gb > this.l) {
                throw new InvalidAlgorithmParameterException("The size of the exponent must be less than the size of the modulus");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameter must be a ESDHParameterSpec.");
        }
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.f = secureRandom;
        this.l = n2;
        switch (this.l) {
            case 512: {
                this.v = new BigInteger(1, n);
                this.fb = new BigInteger(1, cb);
                this.k = new BigInteger(1, h);
                this.ab = new BigInteger(1, x);
                this.e = b;
                this.u = r;
                break;
            }
            case 768: {
                this.v = new BigInteger(1, m);
                this.fb = new BigInteger(1, bb);
                this.k = new BigInteger(1, g);
                this.ab = new BigInteger(1, w);
                this.e = a;
                this.u = q;
                break;
            }
            case 1024: {
                this.v = new BigInteger(1, p);
                this.fb = new BigInteger(1, eb);
                this.k = new BigInteger(1, j);
                this.ab = new BigInteger(1, z);
                this.e = d;
                this.u = t;
                break;
            }
            case 2048: {
                this.v = new BigInteger(1, o);
                this.fb = new BigInteger(1, db);
                this.k = new BigInteger(1, i);
                this.ab = new BigInteger(1, y);
                this.e = c;
                this.u = s;
                break;
            }
            default: {
                this.v = null;
                this.fb = null;
            }
        }
        this.gb = -1;
    }

    public void initialize(int n2) {
        this.initialize(n2, null);
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        Object object;
        Object object2;
        if (this.f == null) {
            this.f = SecRandom.getDefault();
        }
        if (this.l < 0) {
            this.l = 1024;
        }
        if (this.gb <= 0) {
            this.gb = 300;
        }
        ESDHParameterSpec eSDHParameterSpec = new ESDHParameterSpec(this.v, this.fb, this.k, this.ab, this.e, this.u);
        if (this.v == null || this.fb == null || this.k == null) {
            try {
                object2 = new DHGenParameterSpec(this.l, this.gb);
                object = new ESDHParameterGenerator();
                ((DHParameterGenerator)object).engineInit((AlgorithmParameterSpec)object2, this.f);
                AlgorithmParameters algorithmParameters = ((DHParameterGenerator)object).engineGenerateParameters();
                eSDHParameterSpec = (ESDHParameterSpec)algorithmParameters.getParameterSpec(eSDHParameterSpec.getClass());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException(invalidAlgorithmParameterException.toString());
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new RuntimeException(invalidParameterSpecException.toString());
            }
        }
        while ((bigInteger = new BigInteger(this.gb, this.f)).bitLength() != this.gb) {
        }
        object2 = new ESDHPrivateKey(bigInteger, eSDHParameterSpec);
        BigInteger bigInteger2 = eSDHParameterSpec.getG().modPow(bigInteger, eSDHParameterSpec.getP());
        object = new ESDHPublicKey(bigInteger2, eSDHParameterSpec);
        return new KeyPair((PublicKey)object, (PrivateKey)object2);
    }

    public ESDHKeyPairGenerator() {
        super("ESDH");
    }

    static {
        cb = new byte[]{126, 19, 102, -15, -94, -46, 109, -107, -39, -27, -116, 104, -127, 117, -11, -86, 102, -38, -9, 42, 61, -40, 20, 89, 99, -16, 46, -39, -69, -110, 87, -122, -113, -73, -39, -124, -63, 86, 122, 72, 43, -119, 84, 87, -88, 38, -111, 19, 36, 78, -56, -101, 9, -126, 71, -61, 38, 118, 109, -3, 8, -126, -50, 65};
        n = new byte[]{-67, 46, 57, -115, 64, -123, -71, -120, 116, 123, -101, -7, 22, 89, -121, 106, 42, -72, -19, -48, -114, 97, 29, 112, -88, -19, -46, 72, -115, 7, -35, 7, 63, 105, 10, 9, -31, -13, -61, -95, -5, -33, -83, -49, -97, 67, -118, 103, -6, 78, 4, -112, 13, -4, 75, 1, -50, -66, 115, 66, -24, 4, 61, -21};
        byte[] byArray = new byte[38];
        byArray[0] = 13;
        byArray[1] = -114;
        byArray[2] = -61;
        byArray[3] = 92;
        byArray[4] = -65;
        byArray[5] = -63;
        byArray[6] = 114;
        byArray[7] = -32;
        byArray[8] = -128;
        byArray[9] = 39;
        byArray[10] = -76;
        byArray[11] = 45;
        byArray[12] = -110;
        byArray[13] = 32;
        byArray[14] = -1;
        byArray[15] = 78;
        byArray[16] = -107;
        byArray[17] = -54;
        byArray[18] = 47;
        byArray[19] = 75;
        byArray[20] = -19;
        byArray[21] = -22;
        byArray[22] = -28;
        byArray[23] = 31;
        byArray[24] = 85;
        byArray[25] = 18;
        byArray[26] = 62;
        byArray[27] = 41;
        byArray[28] = 99;
        byArray[30] = 79;
        byArray[31] = 83;
        byArray[32] = -19;
        byArray[33] = -27;
        byArray[34] = -88;
        byArray[35] = 24;
        byArray[36] = -41;
        byArray[37] = -17;
        h = byArray;
        x = new byte[]{13, -12, 42, 41, -45, 108, -69, -48, -119, 35, 53, -79, 8, 27, -93, 88, 111, 81, -104, -76, 50, 99, -125, -121, 70, -26, -74};
        b = new byte[]{-21, 116, -32, -62, 69, -107, 100, -67, 17, 59, -38, -81, -92, -89, 54, -16, -110, 62, 23, 78, -116, -99, -26, 118, -71, 109, -114, -127, 12, 25, 68, -60, 17, -126, 20, -111, -24, 31};
        r = 348;
        bb = new byte[]{-119, -61, -126, -41, 13, 34, 26, 27, 42, 102, 81, 41, -74, 53, 11, -23, 99, 91, -10, -65, 22, 106, -26, -35, -102, 46, -37, -7, 9, 6, -6, 68, -19, -60, 120, -106, 85, -41, 98, -34, -38, 94, -61, 101, -128, -3, -59, -36, -74, 6, -21, -86, -124, 22, 20, -111, -87, -59, 82, 45, 46, 95, -7, -72, -48, 110, -71, 93, 114, 32, 2, -9, -86, 22, 12, 98, -87, -102, -18, 3, 107, -34, 103, -46, 69, -119, -35, 110, -115, 17, -29, -88, 90, 83, 107, 83};
        m = new byte[]{-24, -70, 122, -95, -76, 114, 87, 26, -66, -77, -63, 104, 110, -70, 84, 75, -43, 70, -118, -40, 41, 96, 107, 13, -117, -86, 24, 1, 113, 25, 46, -8, 111, 18, 68, -12, -5, 83, -2, -23, 19, -90, -39, -81, -125, 94, -119, -91, 28, -116, 39, 59, 55, 50, -124, 110, -112, 10, -89, -69, -116, 71, 47, -76, -111, -80, 101, -58, -25, 54, 46, 36, -71, 8, 20, -41, 22, 9, -18, -84, 102, -11, 20, -82, 73, 63, 5, -71, 102, -114, -51, -44, 15, 123, 79, -69};
        g = new byte[]{14, -102, -25, 93, -42, 68, 39, -17, -27, 34, -88, 46, 115, -62, -28, 62, 3, 60, 83, -32, -69, -50, -98, -54, -115, -8, 88, 55, -58, -117, 17, 49, -42, 76, -97, -25, -93, 49};
        w = new byte[]{15, -17, 75, 118, 76, 110, 71, -50, -55, 104, 3, 12, -104, 56, 71, 23, -40, 29, -55, 91, -46, 126, 61, 29, 93, 53, -39, 81, 89, 72, -36, -75, 30, 24, -47, -61, -110, -57, 14, 112, 72, -94, -20, -52, -53, 46, 2, -55, -127, 59, -7, -112, 82, 90, -115, 126, -39, -40, -38};
        a = new byte[]{105, -87, 107, -56, 85, 40, -53, 100, 5, -105, -125, 78, 57, -87, 55, 72, 71, -80, -43, 98, 95, 50, 73, 29, 24, 121, 107, -69, -23, -120, 94, 108, -106, -110, -92, 11, 32, 2};
        q = 409;
        eb = new byte[]{124, -108, 123, 56, -47, 64, 17, -18, -58, -106, -40, 14, -115, 114, 44, -76, 58, 108, -82, 53, 109, 32, 106, 58, -29, 67, 45, 98, 55, -28, -125, -43, -93, 127, -108, -125, 103, 86, 108, 28, -38, -82, -80, -9, -100, -120, 111, 38, -59, 10, 116, 69, 107, 64, -52, 59, 97, 90, 90, -120, 59, 44, -124, 31, 71, 27, 5, -25, 115, 66, 49, -108, -2, 77, 59, 118, -76, 58, 5, 88, -97, -117, 60, -15, 77, -33, -110, -114, 17, 34, -107, 28, -32, 121, 109, 37, -81, -67, 94, -106, 75, -86, -43, -45, -64, -85, 33, -45, 97, -90, -39, 33, 62, 115, -120, 9, 8, -11, 82, -68, -88, -115, 29, -36, -9, 35, -72, 90};
        p = new byte[]{-27, -21, -122, 101, 122, -77, 95, 11, -58, 29, -16, -114, -2, -5, -12, -15, -126, 77, 94, -21, -74, 72, 59, 78, -96, 67, -48, 31, -34, -53, -114, -4, -121, -83, 82, 16, -126, 79, 84, 30, -107, -51, 33, 54, -65, -51, 84, 105, -3, -126, -9, 116, 117, -124, -96, 20, 113, 100, -105, -102, 4, 103, -53, 48, 10, -73, -51, 6, 127, 121, 9, -117, -111, -36, -111, -42, -104, 29, -41, 23, -13, -58, -45, 7, 73, -70, 82, 60, 116, -127, -125, 29, -116, -26, 51, -29, 8, 59, -92, 39, -102, -30, -27, 17, 46, 66, 38, -49, -97, 19, -19, -100, -17, -78, -79, 3, 38, -100, 32, -40, -79, 77, 108, 28, -40, -46, -51, -13};
        j = new byte[]{10, 70, -69, -105, -95, 52, 74, 90, -86, -41, 34, 86, 86, 10, -100, 121, -95, -73, 30, -77, -61, 60, 102, 102, -100, -17, 27, -125, 11, -69, -85, 100, -41, 36, 63, -90, 119, -105};
        z = new byte[]{22, 95, -78, 64, 5, -15, 8, 55, -114, -118, 30, 113, 57, 36, 104, 14, 1, 31, 114, -125, -21, 4, -11, -7, -109, 104, 100, 71, 77, 76, -87, -75, 17, 58, 102, 98, -32, 85, 123, 75, -67, -68, -87, 124, -8, -65, -111, -15, -45, -31, 127, 109, 30, -82, -3, 113, -61, 74, -6, -29, -85, 49, 123, -125, 58, -77, 43, -79, -115, -85, -84, 79, 69, 58, -92, 101, -18, 103, -41, -72, 88, 49, -87, -13, -102, 72, -53, -86, -36, -49, -34};
        d = new byte[]{-7, -127, -28, -33, 83, -55, -24, -45, -54, -49, -123, 125, -30, -83, 97, 82, 119, 25, -17, -89, -79, 119, 112, 90, 19, -126, -107, -33, -84, -108, 106, 46, 28, 83, 61, 8, -16, 15};
        t = 42;
        db = new byte[]{-123, -75, 87, 86, -77, 98, 126, -69, 26, -9, 74, 98, -13, -54, 85, -36, -49, 108, -95, 41, 113, 8, 113, 65, 111, -4, 34, 113, -15, -27, 38, -1, 78, 26, 122, 56, 96, -123, -91, 103, 43, 104, -63, 81, -82, 92, 80, -87, -16, 60, -37, -38, 88, -117, 37, -94, -86, 99, 115, 57, -44, -38, -121, 64, -102, -84, -8, -59, 51, -56, -68, 89, 35, -52, -91, 100, 71, -18, 122, -89, 17, 108, -26, 117, -3, 76, 10, 67, -29, -44, 120, -59, -74, -85, -8, 17, -7, 9, 16, 88, 117, 96, -76, 40, 35, 34, 73, -86, 35, -122, -47, 83, 72, -81, 5, -77, -66, 32, -36, -12, 39, -90, 69, 32, -52, -104, -105, 17, 76, 24, -37, -99, -77, 11, 100, 90, -77, -123, -94, 100, -120, 4, -26, 126, 122, -70, -32, 122, -98, -91, -99, -123, 126, 14, -126, -47, 4, -86, -64, -82, -57, -40, 112, 87, 100, 50, 96, -110, 87, -106, 54, -94, 39, 120, 31, -109, -19, 126, 48, 71, 96, -65, -66, -94, 101, 35, -124, -113, -106, -78, -101, -86, 7, 109, -3, 73, -103, -13, -85, -112, 75, -17, -33, 99, -75, -71, 51, -34, -96, -2, 114, -95, -46, -67, -120, 51, 22, -112, 32, -105, -88, -108, -54, 10, -69, -4, 82, 25, 6, 65, -35, -70, -80, 78, -123, 122, -26, -5, -86, 69, -13, -24, -45, -101, 77, 84, 64, 108, -121, -101, -38, 104, 54, -69, -115, -19};
        o = new byte[]{-74, 94, 41, -30, -68, 12, 71, -86, -72, 84, -79, -117, 18, 49, 66, -86, 10, -54, -50, -116, 53, 95, -121, 56, 97, 1, -95, -24, 66, -91, 90, 23, 5, -82, -40, -117, -127, 34, -90, -24, 44, 25, -44, -113, 49, -65, 111, 36, -9, 100, -12, -97, -98, -97, -3, -36, 45, 24, -75, -95, -27, 102, 115, -53, -79, 112, 78, 121, -19, -27, 91, -100, -18, 18, 32, 122, -42, 66, 24, -38, 42, 114, 39, 94, -86, -121, 23, 102, 107, -41, 52, -74, -16, 89, 66, -63, 27, -66, -87, 108, -51, 97, -114, 21, -96, -92, -7, 93, 125, 42, 126, 10, 59, 9, 21, 99, 78, -114, 61, 86, 68, 66, 69, -18, -33, 78, 58, 27, -116, 93, -82, 122, 104, 60, -57, -1, 50, 125, 109, 106, -68, 47, 42, 60, -29, 98, 118, -68, 8, 47, -46, 100, -79, -70, 80, -61, -23, -12, 59, 120, -94, 55, -40, -55, -10, 22, 73, -39, -28, 88, -52, -95, 37, -70, 24, 63, -39, 21, -3, 35, 74, 22, 99, -21, -117, -34, 100, 44, 107, -62, 87, -126, 83, -2, 21, 32, 28, 87, 19, 86, 27, 49, -77, 42, -35, 9, 118, 29, -77, -67, 78, -33, -118, -45, -48, -101, -64, -114, -122, 85, 125, 49, 73, -112, -119, -47, 83, 83, -11, -39, 56, -37, -84, -78, 59, 42, -17, 124, -71, -55, -51, 63, 48, 41, 17, -55, -69, 68, 78, 87, -97, -128, 74, -25, -93, -39};
        i = new byte[]{13, -15, -3, -92, -83, 42, -36, -79, 37, 116, 36, 59, -29, -2, -78, -95, 32, -66, -78, -123, 72, -39, 87, 98, 19, 35, 118, -35, 62, 124, -14, -97, 49, -19, 100, 17, 99, -85};
        byte[] byArray2 = new byte[219];
        byArray2[0] = 13;
        byArray2[1] = 19;
        byArray2[2] = -49;
        byArray2[3] = -36;
        byArray2[4] = -61;
        byArray2[5] = -63;
        byArray2[6] = -42;
        byArray2[7] = -20;
        byArray2[8] = 59;
        byArray2[9] = 5;
        byArray2[10] = 120;
        byArray2[11] = 29;
        byArray2[12] = 44;
        byArray2[13] = -114;
        byArray2[14] = 97;
        byArray2[15] = -13;
        byArray2[16] = 103;
        byArray2[18] = -76;
        byArray2[19] = 103;
        byArray2[20] = 29;
        byArray2[21] = 114;
        byArray2[22] = -41;
        byArray2[23] = -55;
        byArray2[24] = -99;
        byArray2[25] = 79;
        byArray2[26] = -126;
        byArray2[27] = 73;
        byArray2[28] = -89;
        byArray2[29] = -105;
        byArray2[30] = -6;
        byArray2[31] = -85;
        byArray2[32] = -1;
        byArray2[33] = 85;
        byArray2[34] = -108;
        byArray2[35] = -43;
        byArray2[36] = 120;
        byArray2[37] = 65;
        byArray2[38] = -2;
        byArray2[39] = 12;
        byArray2[40] = 122;
        byArray2[41] = 33;
        byArray2[42] = 101;
        byArray2[43] = 91;
        byArray2[44] = 62;
        byArray2[45] = -52;
        byArray2[46] = -119;
        byArray2[47] = 120;
        byArray2[48] = 37;
        byArray2[49] = 46;
        byArray2[50] = -109;
        byArray2[51] = -82;
        byArray2[52] = -59;
        byArray2[53] = 56;
        byArray2[54] = -109;
        byArray2[55] = -34;
        byArray2[56] = 77;
        byArray2[57] = 115;
        byArray2[58] = 53;
        byArray2[59] = 91;
        byArray2[60] = -16;
        byArray2[61] = -15;
        byArray2[62] = 87;
        byArray2[63] = 92;
        byArray2[64] = 100;
        byArray2[65] = 40;
        byArray2[66] = 55;
        byArray2[67] = 104;
        byArray2[68] = 99;
        byArray2[69] = -92;
        byArray2[70] = -76;
        byArray2[71] = -118;
        byArray2[72] = -123;
        byArray2[73] = -116;
        byArray2[74] = -71;
        byArray2[75] = -29;
        byArray2[76] = 40;
        byArray2[77] = 56;
        byArray2[78] = 27;
        byArray2[79] = -94;
        byArray2[80] = -6;
        byArray2[81] = 75;
        byArray2[82] = -6;
        byArray2[83] = -55;
        byArray2[84] = -9;
        byArray2[85] = 34;
        byArray2[86] = -55;
        byArray2[87] = -26;
        byArray2[88] = -15;
        byArray2[89] = -19;
        byArray2[90] = -29;
        byArray2[91] = -107;
        byArray2[92] = 78;
        byArray2[93] = -28;
        byArray2[94] = 1;
        byArray2[95] = -43;
        byArray2[96] = -57;
        byArray2[97] = 84;
        byArray2[98] = -10;
        byArray2[99] = 102;
        byArray2[100] = 89;
        byArray2[101] = -120;
        byArray2[102] = -104;
        byArray2[103] = -97;
        byArray2[104] = 88;
        byArray2[105] = 37;
        byArray2[106] = -114;
        byArray2[107] = -33;
        byArray2[108] = -2;
        byArray2[109] = 74;
        byArray2[110] = -55;
        byArray2[111] = 75;
        byArray2[112] = -88;
        byArray2[113] = -1;
        byArray2[114] = -35;
        byArray2[115] = -89;
        byArray2[116] = -49;
        byArray2[117] = -73;
        byArray2[118] = -79;
        byArray2[119] = -123;
        byArray2[120] = -67;
        byArray2[121] = -17;
        byArray2[122] = -90;
        byArray2[123] = -40;
        byArray2[124] = -79;
        byArray2[125] = 8;
        byArray2[126] = -31;
        byArray2[127] = -52;
        byArray2[128] = -33;
        byArray2[129] = -98;
        byArray2[130] = 37;
        byArray2[131] = -48;
        byArray2[132] = -34;
        byArray2[133] = 7;
        byArray2[134] = 2;
        byArray2[135] = -11;
        byArray2[136] = -96;
        byArray2[137] = 95;
        byArray2[138] = 5;
        byArray2[139] = -33;
        byArray2[140] = -93;
        byArray2[141] = -125;
        byArray2[142] = 2;
        byArray2[143] = -86;
        byArray2[144] = 67;
        byArray2[145] = 51;
        byArray2[146] = -71;
        byArray2[147] = -73;
        byArray2[148] = -54;
        byArray2[149] = -97;
        byArray2[150] = -24;
        byArray2[151] = 74;
        byArray2[152] = 47;
        byArray2[153] = -106;
        byArray2[154] = 62;
        byArray2[155] = 46;
        byArray2[156] = -28;
        byArray2[157] = 27;
        byArray2[158] = -77;
        byArray2[159] = -9;
        byArray2[160] = -78;
        byArray2[161] = -41;
        byArray2[162] = 12;
        byArray2[163] = -67;
        byArray2[164] = 91;
        byArray2[165] = -69;
        byArray2[166] = -40;
        byArray2[167] = 97;
        byArray2[168] = 35;
        byArray2[169] = 91;
        byArray2[170] = 3;
        byArray2[171] = -91;
        byArray2[172] = -113;
        byArray2[173] = 94;
        byArray2[174] = -36;
        byArray2[175] = 114;
        byArray2[176] = 127;
        byArray2[177] = 9;
        byArray2[178] = 41;
        byArray2[179] = -45;
        byArray2[180] = -93;
        byArray2[181] = -90;
        byArray2[182] = 24;
        byArray2[183] = -103;
        byArray2[184] = 38;
        byArray2[185] = 11;
        byArray2[186] = -104;
        byArray2[187] = 110;
        byArray2[188] = -96;
        byArray2[189] = -26;
        byArray2[190] = -56;
        byArray2[191] = 75;
        byArray2[192] = -23;
        byArray2[193] = -104;
        byArray2[194] = 77;
        byArray2[195] = 65;
        byArray2[196] = 14;
        byArray2[197] = 36;
        byArray2[198] = -91;
        byArray2[199] = -30;
        byArray2[200] = -24;
        byArray2[201] = -53;
        byArray2[202] = 46;
        byArray2[203] = 24;
        byArray2[204] = 46;
        byArray2[205] = 85;
        byArray2[206] = 88;
        byArray2[207] = 46;
        byArray2[208] = -77;
        byArray2[209] = -124;
        byArray2[210] = 120;
        byArray2[211] = 22;
        byArray2[212] = -49;
        byArray2[213] = 108;
        byArray2[214] = 114;
        byArray2[215] = -64;
        byArray2[216] = -49;
        byArray2[217] = 19;
        byArray2[218] = -120;
        y = byArray2;
        c = new byte[]{21, 20, 38, 54, -21, -117, -40, -46, 23, 122, 20, -60, -58, 125, -1, 33, -44, -83, 82, 111, -104, 97, -12, -91, -58, 114, -19, -67, 77, -127, -78, -50, -51, 38, -51, -11, -43, -74};
        s = 227;
        ib = BigInteger.valueOf(1L);
        hb = BigInteger.valueOf(2L);
    }
}

