/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.auth;

import com.metamatrix.sequelink.auth.MGSSToken;
import com.metamatrix.sequelink.ssp.AttribList;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;
import java.util.Properties;

public class AttribListToken
extends MGSSToken {
    private static final int ATTRIB_VERSION = 1;
    private static final int ATTRIB_MINVERSION = 2;
    private static final int ATTRIB_MAXVERSION = 3;
    private static final int ATTRIB_UID = 4;
    private static final int ATTRIB_PWD = 5;
    private static final int ATTRIB_HUID = 6;
    private static final int ATTRIB_HPWD = 7;
    private static final int ATTRIB_AUTHMECH = 8;
    private static final int ATTRIB_ACCEPTORSTATE = 9;
    private static final int ATTRIB_NEWPWD = 10;
    private static final int ATTRIB_PROMPTENABLED = 11;
    private Properties properties;
    private Integer version;
    private Integer minVersion;
    private Integer maxVersion;
    private Integer acceptorState;
    private Boolean promptEnabled = new Boolean(false);

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setVersion(int n2) {
        this.version = new Integer(n2);
    }

    public void setMinVersion(int n2) {
        this.minVersion = new Integer(n2);
    }

    public void setMaxVersion(int n2) {
        this.maxVersion = new Integer(n2);
    }

    public void setAcceptorState(int n2) {
        this.acceptorState = new Integer(n2);
    }

    public void setPromptEnable(boolean bl) {
        this.promptEnabled = new Boolean(bl);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer gsetMinVersion() {
        return this.minVersion;
    }

    public Integer getMaxVersion() {
        return this.maxVersion;
    }

    public Integer getAcceptorState() {
        return this.acceptorState;
    }

    public Boolean getPromptEnable() {
        return this.promptEnabled;
    }

    public void streamToken(SspOutputStream sspOutputStream) throws IOException, UtilException {
        String string;
        AttribList attribList = new AttribList();
        AttribList attribList2 = new AttribList();
        if (this.version != null) {
            attribList.addInteger(1, this.version);
        }
        if (this.minVersion != null) {
            attribList.addInteger(2, this.minVersion);
        }
        if (this.maxVersion != null) {
            attribList.addInteger(3, this.maxVersion);
        }
        if ((string = this.properties.getProperty("UID")) != null) {
            attribList.addStringEncrypted(4, string);
        }
        if ((string = this.properties.getProperty("PWD")) != null) {
            attribList.addStringEncrypted(5, string);
        }
        if ((string = this.properties.getProperty("HUID")) != null) {
            attribList.addStringEncrypted(6, string);
        }
        if ((string = this.properties.getProperty("HPWD")) != null) {
            attribList.addStringEncrypted(7, string);
        }
        if (this.acceptorState != null) {
            attribList.addInteger(9, this.acceptorState);
        }
        if ((string = this.properties.getProperty("NEWPWD")) != null) {
            attribList.addStringEncrypted(10, string);
        }
        if (this.promptEnabled != null) {
            attribList.addBoolean(11, this.promptEnabled);
        }
        attribList.encode(sspOutputStream);
        attribList2.encode(sspOutputStream);
    }

    public void unstreamToken(SspInputStream sspInputStream) throws IOException, UtilException {
        this.properties = new Properties();
        AttribList attribList = new AttribList();
        AttribList attribList2 = new AttribList();
        attribList.decode(sspInputStream);
        attribList2.decode(sspInputStream);
        this.version = attribList.getIntegerValue(1);
        this.minVersion = attribList.getIntegerValue(2);
        this.maxVersion = attribList.getIntegerValue(3);
        String string = attribList.getStringValue(4);
        if (string != null) {
            this.properties.put("UID", string);
        }
        if ((string = attribList.getStringValue(5)) != null) {
            this.properties.put("PWD", string);
        }
        if ((string = attribList.getStringValue(6)) != null) {
            this.properties.put("HUID", string);
        }
        if ((string = attribList.getStringValue(7)) != null) {
            this.properties.put("HPWD", string);
        }
        this.acceptorState = attribList.getIntegerValue(9);
        string = attribList.getStringValue(10);
        if (string != null) {
            this.properties.put("NEWPWD", string);
        }
        this.promptEnabled = attribList.getBooleanValue(11);
    }
}

