/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseClob;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.util.UtilDataConversions;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class BaseClobOutputStream
extends OutputStream {
    private static String footprint = "$Revision:   3.2.1.0  $";
    private BaseClob clob;
    private BaseImplClob implClob;
    private Object synchronizer;
    private BaseExceptions exceptions;
    private long curPosition;
    private boolean asciiStream;

    public BaseClobOutputStream(BaseClob baseClob, BaseImplClob baseImplClob, long l, Object object, BaseExceptions baseExceptions) {
        this.clob = baseClob;
        this.implClob = baseImplClob;
        this.synchronizer = object;
        this.exceptions = baseExceptions;
        this.curPosition = l >= 1L ? l : 1L;
        this.asciiStream = false;
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosed();
            if (n2 == 0) {
                return;
            }
            if (n < 0 || n + n2 > byArray.length) {
                String[] stringArray = new String[]{new String("write")};
                SQLException sQLException = this.exceptions.getException(6069, stringArray);
                throw new IOException(sQLException.getMessage());
            }
            try {
                int n3 = 0;
                char[] cArray = UtilDataConversions.AsciiByteArrayToUCS2CharArray((byte[])byArray, (int)n, (int)n2);
                n3 = this.implClob.writeData(this.curPosition, cArray, n, n2);
                this.curPosition += (long)n2;
                if (n3 != n2) {
                    throw this.exceptions.getException(6079);
                }
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
    }

    public void close() throws IOException {
        this.implClob = null;
    }

    void validateClosed() throws IOException {
        if (this.implClob == null) {
            SQLException sQLException = this.exceptions.getException(6009);
            throw new IOException(sQLException.getMessage());
        }
    }
}

