/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.ctxt.stmt;

import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.CodecPartialFetch;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.Message;
import com.metamatrix.sequelink.util.BufferManager;
import com.metamatrix.sequelink.variables.StreamVariable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class SequeLinkInputStream
extends InputStream {
    private byte[] data;
    private int dataLen;
    private int dataRead;
    private boolean closed;
    private DiagnosticList diagnosticList;
    private StatementContext stmtCtxt;
    private int indicator;
    private int offsetAtServer;
    private CodecPartialFetch codec;

    public SequeLinkInputStream(StreamVariable streamVariable, DiagnosticList diagnosticList) throws SQLException {
        this.diagnosticList = diagnosticList;
        this.stmtCtxt = streamVariable.getContext();
        this.data = BufferManager.GetBuffer();
        this.codec = this.stmtCtxt.getSsp().getCodecPartialFetch(streamVariable, this.stmtCtxt);
        this.receive();
        if (this.isNull()) {
            this.closed = true;
        }
    }

    public boolean isNull() {
        return this.indicator == -1;
    }

    public int read() throws IOException {
        this.ensureOpen();
        if (this.dataRead == this.dataLen) {
            if (this.indicator == 0) {
                return -1;
            }
            try {
                this.receive();
            }
            catch (SQLException sQLException) {
                throw new IOException();
            }
        }
        return this.data[this.dataRead++] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (this.dataRead == this.dataLen) {
            if (this.indicator == 0) {
                return -1;
            }
            try {
                this.receive();
            }
            catch (SQLException sQLException) {
                throw new IOException();
            }
        }
        int n4 = this.dataLen - this.dataRead;
        int n5 = Math.min(n4, n3);
        System.arraycopy(this.data, this.dataRead, byArray, n2, n5);
        this.dataRead += n5;
        return n5;
    }

    public void close() throws IOException {
        if (this.data != null) {
            BufferManager.ReturnBuffer(this.data);
            this.data = null;
        }
        this.closed = true;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException(Message.Gen.getPrefixedMessage("msg.is.closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receive() throws SQLException {
        Object object = this.stmtCtxt.getNetMutex();
        synchronized (object) {
            block5: {
                try {
                    this.stmtCtxt.preCancel();
                    this.codec.setData(this.data, 0, this.data.length);
                    this.codec.setOffsetAtServer(this.offsetAtServer);
                    this.stmtCtxt.add(this.codec);
                    this.stmtCtxt.send(this.diagnosticList);
                    this.indicator = this.codec.getIndicator();
                    this.dataLen = this.codec.getLengthReturned();
                    this.offsetAtServer += this.dataLen;
                    this.dataRead = 0;
                    Object var3_2 = null;
                    if (this.indicator != -1 && this.dataLen != 0) break block5;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.indicator == -1 || this.dataLen == 0) {
                        BufferManager.ReturnBuffer(this.data);
                        this.data = null;
                    }
                    this.stmtCtxt.postCancel();
                    throw throwable;
                }
                BufferManager.ReturnBuffer(this.data);
                this.data = null;
            }
            this.stmtCtxt.postCancel();
            return;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }
}

