/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseCallEscape;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseFunctionEscape;
import com.metamatrix.jdbc.base.BaseSQLScanner;
import com.metamatrix.jdbc.base.BaseSQLToken;
import com.metamatrix.jdbc.base.BaseTimestampEscape;
import com.metamatrix.jdbc.oracle.OracleImplConnection;

public class OracleEscapeTranslator
extends BaseEscapeTranslator {
    private static String footprint = "$Revision:   3.7.1.0  $";
    private OracleImplConnection oic = null;

    public OracleEscapeTranslator(OracleImplConnection oracleImplConnection) {
        this.oic = oracleImplConnection;
    }

    public int getTranslationNeeded(int n) {
        int n2;
        switch (n) {
            case 8212: {
                n2 = 1;
                break;
            }
            case 8193: 
            case 8194: 
            case 8196: {
                n2 = 2;
                break;
            }
            case 8200: {
                n2 = 2;
                break;
            }
            case 8208: {
                if (this.oic.oracleServerVersion >= 800000000L && this.oic.oracleServerVersion < 900000000L) {
                    n2 = 2;
                    break;
                }
                n2 = 1;
                break;
            }
            case 8209: {
                n2 = 2;
                break;
            }
            case 8210: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        return n2;
    }

    public void insertOuterJoinOperator(StringBuffer stringBuffer, int n) {
        if (n == 1037) {
            return;
        }
        BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
        int n2 = 0;
        baseSQLScanner.setup(stringBuffer.toString(), '\'', '\"');
        while (true) {
            BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
            if (baseSQLToken.type == 6 || baseSQLToken.value.charAt(0) == ')') break;
            n2 += baseSQLToken.value.length();
            if (baseSQLToken.value.charAt(0) != '=' || n != 1036) continue;
            stringBuffer.insert(n2 - 1, " (+) ");
            n2 += 5;
        }
        if (n == 1035) {
            stringBuffer.insert(n2, " (+)");
        }
    }

    public String translateCallEscape(BaseCallEscape baseCallEscape) {
        String string = new String("BEGIN ");
        if (baseCallEscape.getEscapeType() == 8210) {
            string = string + " ? := ";
        }
        string = string + baseCallEscape.getProcedureName() + " (" + baseCallEscape.getAllParameters() + ") ; END;";
        return string;
    }

    public String translateTimestampEscape(BaseTimestampEscape baseTimestampEscape) {
        String string = null;
        switch (baseTimestampEscape.getEscapeType()) {
            case 8194: {
                string = "to_date('" + baseTimestampEscape.getDate() + "','YYYY-MM-DD')";
                break;
            }
            case 8193: {
                switch (this.oic.connection.getDateTimeBehavior()) {
                    case 0: 
                    case 2: {
                        string = "to_date(to_char(sysdate,'YYYY-MM-DD') || ' ' || '" + baseTimestampEscape.getTime() + "','YYYY-MM-DD HH24:MI:SS')";
                        break;
                    }
                    case 1: {
                        string = "to_date('1970-01-01 ' || '" + baseTimestampEscape.getTime() + "','YYYY-MM-DD HH24:MI:SS')";
                    }
                }
                break;
            }
            default: {
                String string2 = baseTimestampEscape.getSecondsFraction();
                if (string2 != null && string2.length() > 0) {
                    if (this.oic.oracleServerVersion >= 900000000L) {
                        string = "to_timestamp('" + baseTimestampEscape.getTimestamp() + "','YYYY-MM-DD HH24:MI:SS.FF')";
                        break;
                    }
                    this.warnings.add(7005);
                    String string3 = baseTimestampEscape.getTimestamp();
                    string = "to_date('" + string3.substring(0, string3.lastIndexOf(".")) + "','YYYY-MM-DD HH24:MI:SS')";
                    break;
                }
                string = "to_date('" + baseTimestampEscape.getTimestamp() + "','YYYY-MM-DD HH24:MI:SS')";
            }
        }
        return string;
    }

    public String translateFunctionEscape(BaseFunctionEscape baseFunctionEscape) {
        String string;
        switch (baseFunctionEscape.getFunctionType()) {
            case 8: {
                string = "chr(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 7: {
                string = "ceil(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 11: {
                string = baseFunctionEscape.getParameter(1) + " || " + baseFunctionEscape.getParameter(2);
                break;
            }
            case 14: {
                string = "(1/tan(" + baseFunctionEscape.getAllParameters() + "))";
                break;
            }
            case 32: {
                string = "substr(" + baseFunctionEscape.getParameter(1) + ",1,(" + baseFunctionEscape.getParameter(2) + ")-1) || " + baseFunctionEscape.getParameter(4) + " || substr(" + baseFunctionEscape.getParameter(1) + ", (" + baseFunctionEscape.getParameter(2) + ")+(" + baseFunctionEscape.getParameter(3) + "))";
                break;
            }
            case 33: {
                string = "lower(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 34: {
                string = "substr(" + baseFunctionEscape.getParameter(1) + ",1," + baseFunctionEscape.getParameter(2) + ")";
                break;
            }
            case 35: {
                string = "length(rtrim(" + baseFunctionEscape.getAllParameters() + "))";
                break;
            }
            case 36: {
                String string2 = baseFunctionEscape.getParameterCount() < 3 ? "1" : baseFunctionEscape.getParameter(3).toString();
                string = "instr(" + baseFunctionEscape.getParameter(2) + "," + baseFunctionEscape.getParameter(1) + "," + string2 + ")";
                break;
            }
            case 37: {
                string = "ln(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 38: {
                string = "log(10," + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 46: {
                string = "3.14159265358979";
                break;
            }
            case 52: {
                string = "rpad(" + baseFunctionEscape.getParameter(1) + ",(" + baseFunctionEscape.getParameter(2) + "*length(rtrim(" + baseFunctionEscape.getParameter(1) + ")))," + baseFunctionEscape.getParameter(1) + ")";
                break;
            }
            case 53: {
                string = "replace(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 54: {
                string = "substr(" + baseFunctionEscape.getParameter(1) + ", -(" + baseFunctionEscape.getParameter(2) + "))";
                break;
            }
            case 61: {
                string = "rpad(' '," + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 63: {
                string = "substr(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 67: {
                string = "trunc(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 68: {
                string = "upper(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 0: 
            case 2: 
            case 13: 
            case 27: 
            case 29: 
            case 39: 
            case 41: 
            case 48: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: {
                string = baseFunctionEscape.getFunctionTypeText().toLowerCase() + "(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 22: {
                string = "to_number(to_char(" + baseFunctionEscape.getAllParameters() + ",'DD'))";
                break;
            }
            case 21: {
                string = "to_char(" + baseFunctionEscape.getAllParameters() + ",'fmDay')";
                break;
            }
            case 23: {
                string = "to_number(to_char(" + baseFunctionEscape.getAllParameters() + ",'D'))";
                break;
            }
            case 24: {
                string = "to_number(to_char(" + baseFunctionEscape.getAllParameters() + ",'DDD'))";
                break;
            }
            case 43: {
                string = "to_char(" + baseFunctionEscape.getAllParameters() + ",'fmMonth')";
                break;
            }
            case 30: {
                string = "to_number(to_char(" + baseFunctionEscape.getAllParameters() + ",'HH24'))";
                break;
            }
            case 40: {
                string = "to_number(to_char(" + baseFunctionEscape.getAllParameters() + ",'MI'))";
                break;
            }
            case 42: {
                string = "to_number(to_char(" + baseFunctionEscape.getAllParameters() + ",'MM'))";
                break;
            }
            case 49: {
                string = "to_number(to_char(" + baseFunctionEscape.getAllParameters() + ",'Q'))";
                break;
            }
            case 57: {
                string = "to_number(to_char(" + baseFunctionEscape.getAllParameters() + ",'SS'))";
                break;
            }
            case 70: {
                string = "to_number(to_char(" + baseFunctionEscape.getAllParameters() + ",'WW'))";
                break;
            }
            case 71: {
                string = "to_number(to_char(" + baseFunctionEscape.getAllParameters() + ",'SYYYY'))";
                break;
            }
            case 18: 
            case 44: {
                string = "sysdate";
                break;
            }
            case 15: 
            case 16: {
                string = "trunc(sysdate,'J')";
                break;
            }
            case 31: {
                string = "nvl(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 69: {
                string = "user";
                break;
            }
            case 12: {
                String string3 = baseFunctionEscape.getParameter(2).toString();
                if (string3.equals("DECIMAL")) {
                    string3 = "decimal(8,4)";
                } else if (string3.equals("DOUBLE")) {
                    string3 = "float";
                } else if (string3.equals("LONGVARCHAR")) {
                    string3 = "text";
                } else if (string3.equals("LONGVARBINARY")) {
                    string3 = "image";
                }
                string = "convert(" + string3.toLowerCase() + "," + baseFunctionEscape.getParameter(1) + ")";
                break;
            }
            default: {
                string = baseFunctionEscape.getFunctionText();
            }
        }
        return string;
    }
}

