/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.ssp;

import com.metamatrix.sequelink.auth.MGSSHandle;
import com.metamatrix.sequelink.auth.MGSSToken;
import com.metamatrix.sequelink.describe.VariableDescriptor;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.net.Session;
import com.metamatrix.sequelink.ssp.AttribList;
import com.metamatrix.sequelink.ssp.Chain;
import com.metamatrix.sequelink.ssp.CodecAdmin;
import com.metamatrix.sequelink.ssp.CodecAssociate;
import com.metamatrix.sequelink.ssp.CodecAuthenticate;
import com.metamatrix.sequelink.ssp.CodecChainedPacket;
import com.metamatrix.sequelink.ssp.CodecDefineDescribe;
import com.metamatrix.sequelink.ssp.CodecExec;
import com.metamatrix.sequelink.ssp.CodecExecDirect;
import com.metamatrix.sequelink.ssp.CodecExecRsn;
import com.metamatrix.sequelink.ssp.CodecExtendedDefine;
import com.metamatrix.sequelink.ssp.CodecFetch;
import com.metamatrix.sequelink.ssp.CodecFreeVariables;
import com.metamatrix.sequelink.ssp.CodecGetDescribe;
import com.metamatrix.sequelink.ssp.CodecGetSettings;
import com.metamatrix.sequelink.ssp.CodecLogon;
import com.metamatrix.sequelink.ssp.CodecNImmediate;
import com.metamatrix.sequelink.ssp.CodecNextResult;
import com.metamatrix.sequelink.ssp.CodecOpen;
import com.metamatrix.sequelink.ssp.CodecPartialBind;
import com.metamatrix.sequelink.ssp.CodecPartialFetch;
import com.metamatrix.sequelink.ssp.CodecSetGetSettings;
import com.metamatrix.sequelink.ssp.CodecSetSettings;
import com.metamatrix.sequelink.ssp.CodecXaRecover;
import com.metamatrix.sequelink.ssp.CodecXaXainfo;
import com.metamatrix.sequelink.ssp.CodecXaXid;
import com.metamatrix.sequelink.ssp.GetSetting;
import com.metamatrix.sequelink.ssp.Message;
import com.metamatrix.sequelink.ssp.SetGetSetting;
import com.metamatrix.sequelink.ssp.SetSetting;
import com.metamatrix.sequelink.ssp.SlXid;
import com.metamatrix.sequelink.ssp.Ssp;
import com.metamatrix.sequelink.ssp.SspContext;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import com.metamatrix.sequelink.ssp.SspStreamFactory;
import com.metamatrix.sequelink.util.UnSyncVector;
import com.metamatrix.sequelink.variables.CursorVariables;
import com.metamatrix.sequelink.variables.StreamVariable;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilTransliterator;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Ssp7
extends Ssp {
    private Session netSession;
    private int serverVersion;
    private SspInputStream sis;
    private SspOutputStream sos;
    private UtilTransliterator transliterator;
    private UtilTransliterator asciiTransliterator;
    private HashMap transliteratorCache;
    private int transliterationWorkaroundClient;
    private int transliterationWorkaroundServer;
    private static Vector preventGarbageCollection = new Vector();

    Ssp7(Session session, String string, int n2, UtilTransliterator utilTransliterator) throws SQLException {
        UtilTransliterator utilTransliterator2;
        this.netSession = session;
        this.serverVersion = n2;
        this.transliteratorCache = new HashMap();
        this.asciiTransliterator = utilTransliterator;
        this.transliteratorCache.put("ASCII", utilTransliterator);
        if (!"ASCII".equals(string)) {
            try {
                utilTransliterator2 = UtilTransliterator.GetNewTransliterator(string);
            }
            catch (UtilException utilException) {
                SQLException sQLException = Message.Gen.getSqlException(7452);
                Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
                throw sQLException;
            }
            this.transliteratorCache.put(string, utilTransliterator2);
        } else {
            utilTransliterator2 = utilTransliterator;
        }
        this.sis = SspStreamFactory.GetInputStream();
        this.sos = SspStreamFactory.GetOutputStream();
        this.setDefaultTransliterator(utilTransliterator2);
        preventGarbageCollection.addElement(this);
    }

    public int getSspVersion() {
        return 7;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public void close() throws SQLException {
        try {
            preventGarbageCollection.removeElement(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.netSession.detach();
        }
        catch (NetworkException networkException) {
            throw networkException.toSqlException();
        }
    }

    public Session getNetworkSession() {
        return this.netSession;
    }

    public SspInputStream getSspInputStream() {
        return this.sis;
    }

    public SspOutputStream getSspOutputStream() {
        return this.sos;
    }

    public boolean supportsCancel() {
        return this.netSession.getCancelOption();
    }

    public void cancel() throws SQLException {
        try {
            this.netSession.cancel();
        }
        catch (NetworkException networkException) {
            // empty catch block
        }
    }

    public Chain getChain() {
        return new Chain(this, this.getSspVersion());
    }

    public CodecAdmin getCodecAdmin(SspContext sspContext, UnSyncVector unSyncVector) {
        return new CodecAdmin(sspContext, unSyncVector);
    }

    public CodecAssociate getCodecAssociate(String string, SspContext sspContext) {
        return new CodecAssociate(string, sspContext);
    }

    public CodecChainedPacket getCodecClose(SspContext sspContext) {
        return this.getCodec(3, sspContext);
    }

    public CodecChainedPacket getCodecCloseCursor(SspContext sspContext) {
        return this.getCodec(4, sspContext);
    }

    public CodecChainedPacket getCodecCommit(SspContext sspContext) {
        return this.getCodec(5, sspContext);
    }

    public CodecDefineDescribe getCodecDefineDescribeCursor(VariableDescriptor[] variableDescriptorArray, SspContext sspContext) {
        return new CodecDefineDescribe(6, variableDescriptorArray, sspContext);
    }

    public CodecDefineDescribe getCodecDefineDescribeParam(VariableDescriptor[] variableDescriptorArray, SspContext sspContext) {
        throw new InternalError(this.getClass().getName() + " getCodecDefineDescribeParam");
    }

    public CodecExec getCodecExec(SspContext sspContext, UnSyncVector unSyncVector, UnSyncVector unSyncVector2) {
        return new CodecExec(sspContext, unSyncVector, unSyncVector2);
    }

    public CodecExecDirect getCodecExecDirect(String string, SspContext sspContext, UnSyncVector unSyncVector, UnSyncVector unSyncVector2) {
        return new CodecExecDirect(string, sspContext, unSyncVector, unSyncVector2);
    }

    public CodecExecRsn getCodecExecRsn(SspContext sspContext, int n2, UnSyncVector unSyncVector, UnSyncVector unSyncVector2) {
        return new CodecExecRsn(sspContext, n2, unSyncVector, unSyncVector2);
    }

    public CodecExtendedDefine getCodecExtendedDefine(UnSyncVector unSyncVector, SspContext sspContext) {
        return new CodecExtendedDefine(unSyncVector, sspContext);
    }

    public CodecFetch getCodecFetch(int n2, CursorVariables cursorVariables, UnSyncVector unSyncVector, SspContext sspContext) {
        return new CodecFetch(n2, cursorVariables, unSyncVector, sspContext);
    }

    public CodecFreeVariables getCodecFreeVariables(int n2, SspContext sspContext) {
        return new CodecFreeVariables(n2, sspContext);
    }

    public CodecGetDescribe getCodecGetDescribeCursor(VariableDescriptor[] variableDescriptorArray, SspContext sspContext) {
        return new CodecGetDescribe(10, variableDescriptorArray, sspContext);
    }

    public CodecGetDescribe getCodecGetDescribeParam(VariableDescriptor[] variableDescriptorArray, SspContext sspContext) {
        throw new InternalError(this.getClass().getName() + " getCodecGetDescribeParam");
    }

    public CodecGetSettings getCodecGetSettings(GetSetting[] getSettingArray, SspContext sspContext) {
        return new CodecGetSettings(getSettingArray, sspContext);
    }

    public CodecChainedPacket getCodecLogoff(SspContext sspContext) {
        return this.getCodec(13, sspContext);
    }

    public CodecLogon getCodecLogon(AttribList attribList, SspContext sspContext) {
        return new CodecLogon(attribList, sspContext);
    }

    public CodecNextResult getCodecNextResult(SspContext sspContext, UnSyncVector unSyncVector) {
        return new CodecNextResult(sspContext, unSyncVector);
    }

    public CodecNImmediate getCodecNImmediate(UnSyncVector unSyncVector, SspContext sspContext) {
        return new CodecNImmediate(unSyncVector, sspContext);
    }

    public CodecOpen getCodecOpen(int n2, SspContext sspContext) {
        return new CodecOpen(n2, sspContext);
    }

    public CodecPartialBind getCodecPartialBind(StreamVariable streamVariable, SspContext sspContext) {
        return new CodecPartialBind(streamVariable, sspContext);
    }

    public CodecPartialFetch getCodecPartialFetch(StreamVariable streamVariable, SspContext sspContext) {
        return new CodecPartialFetch(streamVariable, sspContext);
    }

    public CodecChainedPacket getCodecRollback(SspContext sspContext) {
        return this.getCodec(20, sspContext);
    }

    public CodecChainedPacket getCodecSetGetSettings(SetGetSetting[] setGetSettingArray, SspContext sspContext) {
        return new CodecSetGetSettings(setGetSettingArray, sspContext);
    }

    public CodecChainedPacket getCodecSetSettings(SetSetting[] setSettingArray, SspContext sspContext) {
        return new CodecSetSettings(setSettingArray, sspContext);
    }

    public CodecXaXainfo getCodecXaOpen(SspContext sspContext) {
        return new CodecXaXainfo(21, sspContext);
    }

    public CodecXaXainfo getCodecXaClose(SspContext sspContext) {
        return new CodecXaXainfo(22, sspContext);
    }

    public CodecXaXid getCodecXaStart(SspContext sspContext, SlXid slXid, int n2) {
        return new CodecXaXid(23, sspContext, slXid, n2);
    }

    public CodecXaXid getCodecXaEnd(SspContext sspContext, SlXid slXid, int n2) {
        return new CodecXaXid(27, sspContext, slXid, n2);
    }

    public CodecXaXid getCodecXaPrepare(SspContext sspContext, SlXid slXid) {
        return new CodecXaXid(24, sspContext, slXid, 0);
    }

    public CodecXaXid getCodecXaCommit(SspContext sspContext, SlXid slXid, int n2) {
        return new CodecXaXid(25, sspContext, slXid, n2);
    }

    public CodecXaXid getCodecXaRollback(SspContext sspContext, SlXid slXid) {
        return new CodecXaXid(26, sspContext, slXid, 0);
    }

    public CodecXaXid getCodecXaForget(SspContext sspContext, SlXid slXid) {
        return new CodecXaXid(29, sspContext, slXid, 0);
    }

    public CodecXaRecover getCodecXaRecover(SspContext sspContext, int n2) {
        return new CodecXaRecover(28, sspContext, n2);
    }

    public CodecAuthenticate getCodecAuthenticate(SspContext sspContext, MGSSHandle mGSSHandle, MGSSToken mGSSToken, int n2) {
        return new CodecAuthenticate(sspContext, mGSSHandle, mGSSToken, n2);
    }

    public UtilTransliterator getDefaultTransliterator() {
        return this.transliterator;
    }

    public UtilTransliterator getAsciiTransliterator() {
        return this.asciiTransliterator;
    }

    public UtilTransliterator getTransliterator(String string) throws SQLException {
        UtilTransliterator utilTransliterator = (UtilTransliterator)this.transliteratorCache.get(string);
        if (utilTransliterator == null) {
            try {
                utilTransliterator = UtilTransliterator.GetNewTransliterator(string, this.transliterationWorkaroundClient, this.transliterationWorkaroundServer);
                this.transliteratorCache.put(string, utilTransliterator);
            }
            catch (UtilException utilException) {
                SQLException sQLException = Message.Gen.getSqlException(7452);
                Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
                throw sQLException;
            }
        }
        return utilTransliterator;
    }

    public void applyTransliterationWorkarounds() throws SQLException {
        if (this.transliterationWorkaroundClient == 0) {
            this.transliterationWorkaroundServer = 0;
            return;
        }
        if (this.transliterationWorkaroundServer == 0) {
            this.transliterationWorkaroundClient = 0;
            return;
        }
        if (this.transliterationWorkaroundClient == this.transliterationWorkaroundServer) {
            this.transliterationWorkaroundClient = 0;
            this.transliterationWorkaroundServer = 0;
            return;
        }
        HashMap hashMap = this.transliteratorCache;
        this.transliteratorCache = new HashMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            UtilTransliterator utilTransliterator;
            String string = (String)iterator.next();
            UtilTransliterator utilTransliterator2 = (UtilTransliterator)hashMap.get(string);
            if (string.equals("ASCII")) {
                utilTransliterator = utilTransliterator2;
            } else {
                if (string.equals("")) continue;
                try {
                    utilTransliterator = UtilTransliterator.GetNewTransliterator(string, this.transliterationWorkaroundClient, this.transliterationWorkaroundServer);
                }
                catch (UtilException utilException) {
                    SQLException sQLException = Message.Gen.getSqlException(7452);
                    Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
                    throw sQLException;
                }
            }
            this.transliteratorCache.put(string, utilTransliterator);
            if (utilTransliterator2 != this.transliterator) continue;
            this.transliterator = utilTransliterator;
            this.transliteratorCache.put("", utilTransliterator);
        }
    }

    public byte[] transliterate(String string) throws SQLException {
        try {
            return this.transliterator.encode(string);
        }
        catch (UtilException utilException) {
            SQLException sQLException = Message.Gen.getSqlException(7452);
            Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
            throw sQLException;
        }
        catch (NullPointerException nullPointerException) {
            throw Message.Gen.getSqlException(7398);
        }
    }

    public void setTransliterationWorkaroundServer(int n2) {
        this.transliterationWorkaroundServer = n2;
    }

    public void setTransliterationWorkaroundClient(int n2) {
        this.transliterationWorkaroundClient = n2;
    }

    protected CodecChainedPacket getCodec(int n2, SspContext sspContext) {
        return new CodecChainedPacket(n2, sspContext);
    }

    void setDefaultTransliterator(UtilTransliterator utilTransliterator) {
        this.transliteratorCache.remove("");
        this.transliterator = utilTransliterator;
        this.transliteratorCache.put("", utilTransliterator);
        this.sis.setTransliterator(utilTransliterator);
        this.sos.setTransliterator(utilTransliterator);
    }
}

