/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.NetCrypto;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.util.BufferManager;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class NetInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public NetInputStream(byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public NetInputStream(byte[] byArray, int n2, int n3) {
        this.buf = byArray;
        this.pos = n2;
        this.count = Math.min(n2 + n3, byArray.length);
    }

    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n3 > this.count) {
            n3 = this.count - this.pos;
        }
        if (n3 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n2, n3);
        this.pos += n3;
        return n3;
    }

    public long skip(long l2) {
        if ((long)this.pos + l2 > (long)this.count) {
            l2 = this.count - this.pos;
        }
        if (l2 < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l2);
        return l2;
    }

    public int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n2) {
        this.mark = this.pos;
    }

    public void reset() {
        this.pos = this.mark;
    }

    public void replaceBuffer(byte[] byArray, int n2, int n3) {
        BufferManager.ReturnBuffer(this.buf);
        this.buf = byArray;
        this.pos = n2;
        this.count = Math.min(n2 + n3, this.buf.length);
    }

    public void close() {
        if (this.buf != null) {
            BufferManager.ReturnBuffer(this.buf);
            this.buf = null;
        }
    }

    public void decrypt(NetCrypto netCrypto) throws NetworkException {
        int n2 = this.count - this.pos;
        int n3 = netCrypto.getDecryptionOutputSize(n2);
        if (this.buf.length < n3 + this.pos) {
            this.buf = BufferManager.GetBiggerBuffer(this.buf, n3 + this.pos);
        }
        int n4 = netCrypto.decrypt(this.buf, this.pos, n2, this.buf, this.pos);
        this.count = n4 + this.pos;
    }

    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.buf, this.pos, this.count);
    }
}

