/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.ui.internal.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.ui.UiConstants;
import com.metamatrix.ui.internal.InternalUiConstants;
import com.metamatrix.ui.internal.widget.ITreeViewerController;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class WidgetUtil
implements InternalUiConstants.Widgets,
StringUtil.Constants,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$ui$internal$util$WidgetUtil == null ? (class$com$metamatrix$ui$internal$util$WidgetUtil = WidgetUtil.class$("com.metamatrix.ui.internal.util.WidgetUtil")) : class$com$metamatrix$ui$internal$util$WidgetUtil));
    private static final String FOLDER_SELECTION_DIALOG_TITLE = WidgetUtil.getString("folderSelectionDialogTitle");
    private static final String CONFIRM_OVERWRITE_MESSAGE_ID = "confirmOverwriteMessage";
    private static final String ERROR_CAUSE_MESSAGE_ID = "errorCauseMessage";
    private static final String FILE_EXISTS_MESSAGE_ID = "fileExistsMessage";
    private static final String INVALID_SEVERITY_MESSAGE = WidgetUtil.getString("invalidSeverityMessage");
    private static final String NOT_RADIO_BUTTON_MESSAGE = WidgetUtil.getString("notRadioButtonMessage");
    private static final String FOLDER_SELECTION_DIALOG_MESSAGE = WidgetUtil.getString("folderSelectionDialogMessage");
    private static final int COMBO_ITEM_LIMIT = 15;
    public static final String A_END_TAG = "</a>";
    public static final String A_START_TAG = "<a>";
    public static final String FORM_TEXT_END_TAG = "</p></html>";
    public static final String FORM_TEXT_START_TAG = "<html><p>";
    static /* synthetic */ Class class$com$metamatrix$ui$internal$util$WidgetUtil;

    public static boolean confirmOverwrite(File file) {
        return WidgetUtil.showConfirmation(WidgetUtil.getString(CONFIRM_OVERWRITE_MESSAGE_ID, WidgetUtil.getFileExistsMessage(file)));
    }

    public static boolean confirmOverwrite(IFile file) {
        return WidgetUtil.showConfirmation(WidgetUtil.getString(CONFIRM_OVERWRITE_MESSAGE_ID, WidgetUtil.getFileExistsMessage(file)));
    }

    public static Map disable(Control[] controls) {
        ArgCheck.isNotNull((Object)controls);
        HashMap map = new HashMap(0);
        int ndx = controls.length;
        while (--ndx >= 0) {
            Control ctrl = controls[ndx];
            ArgCheck.isNotNull((Object)ctrl);
            WidgetUtil.disable(ctrl, map);
        }
        return map;
    }

    private static void disable(Control control, Map map) {
        if (!map.containsKey(control)) {
            map.put(control, new Boolean(control.getEnabled()));
        }
        control.setEnabled(false);
        if (control instanceof Composite) {
            Control[] ctrls = ((Composite)control).getChildren();
            int ndx = ctrls.length;
            while (--ndx >= 0) {
                WidgetUtil.disable(ctrls[ndx], map);
            }
        }
    }

    public static void disableFormText(FormText formText) {
        HyperlinkSettings settings = formText.getHyperlinkSettings();
        settings.setHyperlinkUnderlineMode(1);
        settings.setForeground(formText.getForeground());
        settings.setActiveForeground(formText.getForeground());
        formText.redraw();
    }

    public static Map disable(Composite container) {
        ArgCheck.isNotNull((Object)container);
        return WidgetUtil.disable(new Control[]{container});
    }

    public static void enable(Control[] controls) {
        ArgCheck.isNotNull((Object)controls);
        int ndx = controls.length;
        while (--ndx >= 0) {
            Control ctrl = controls[ndx];
            ArgCheck.isNotNull((Object)ctrl);
            if (ctrl instanceof Composite) {
                WidgetUtil.enable(((Composite)ctrl).getChildren());
            }
            ctrl.setEnabled(true);
        }
    }

    public static void enable(Composite container) {
        WidgetUtil.enable(new Control[]{container});
    }

    public static void enableFormText(FormText formText) {
        HyperlinkSettings settings = formText.getHyperlinkSettings();
        settings.setHyperlinkUnderlineMode(3);
        settings.setForeground(JFaceColors.getHyperlinkText((Display)formText.getDisplay()));
        settings.setActiveForeground(JFaceColors.getActiveHyperlinkText((Display)formText.getDisplay()));
        formText.redraw();
    }

    public static TreeItem findTreeItem(Object node, Tree tree) {
        ArgCheck.isNotNull((Object)node);
        ArgCheck.isNotNull((Object)tree);
        return WidgetUtil.findTreeItem(node, tree.getItems());
    }

    public static TreeItem findTreeItem(Object node, TreeViewer viewer) {
        ArgCheck.isNotNull((Object)viewer);
        return WidgetUtil.findTreeItem(node, viewer.getTree());
    }

    private static TreeItem findTreeItem(Object node, TreeItem[] items) {
        int ndx = items.length;
        while (--ndx >= 0) {
            TreeItem item = items[ndx];
            if (node == item.getData()) {
                return item;
            }
            if (item.getItemCount() <= 0 || (item = WidgetUtil.findTreeItem(node, item.getItems())) == null) continue;
            return item;
        }
        return null;
    }

    public static String getCauseMessage(String prefix, IStatus status) {
        return WidgetUtil.getString(ERROR_CAUSE_MESSAGE_ID, prefix, status.getMessage());
    }

    public static String getCauseMessage(String prefix, Throwable throwable) {
        return WidgetUtil.getString(ERROR_CAUSE_MESSAGE_ID, prefix, throwable.getLocalizedMessage());
    }

    public static int getCheckedState(TreeItem item) {
        ArgCheck.isNotNull((Object)item);
        Object obj = item.getData("checkedState");
        if (obj == null || !(obj instanceof Integer)) {
            return 1;
        }
        return (Integer)obj;
    }

    public static Map getCheckedStates(TableTreeViewer ttvViewer) {
        HashMap hmItemCheckedStates = new HashMap();
        TableTreeItem[] ttiItems = ttvViewer.getTableTree().getItems();
        for (int i = 0; i < ttiItems.length; ++i) {
            TableTreeItem ttiTemp = ttiItems[i];
            WidgetUtil.getCheckedStates(hmItemCheckedStates, ttiTemp);
        }
        return hmItemCheckedStates;
    }

    private static void getCheckedStates(Map mapItemCheckedStates, TableTreeItem ttiItem) {
        mapItemCheckedStates.put(ttiItem.getData(), new Boolean(ttiItem.getChecked()));
        TableTreeItem[] ttiChildren = ttiItem.getItems();
        for (int i = 0; i < ttiChildren.length; ++i) {
            WidgetUtil.getCheckedStates(mapItemCheckedStates, ttiChildren[i]);
        }
    }

    public static int getChildIndex(TreeItem theChild) {
        ArgCheck.isNotNull((Object)theChild);
        int result = -1;
        TreeItem parent = theChild.getParentItem();
        if (parent != null) {
            TreeItem[] kids = parent.getItems();
            for (int i = 0; i < kids.length; ++i) {
                if (kids[i] != theChild) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public static String getFileExistsMessage(File file) {
        return WidgetUtil.getString(FILE_EXISTS_MESSAGE_ID, file.getAbsolutePath());
    }

    public static String getFileExistsMessage(IFile file) {
        return WidgetUtil.getString(FILE_EXISTS_MESSAGE_ID, file.getFullPath().makeRelative());
    }

    public static String getMessage(Throwable error) {
        Throwable err;
        ArgCheck.isNotNull((Object)error);
        if (error instanceof WrappedException) {
            err = ((WrappedException)error).exception();
            if (err != null) {
                error = err;
            }
        } else if (error instanceof InvocationTargetException && (err = ((InvocationTargetException)error).getTargetException()) != null) {
            error = err;
        }
        String msg = error.getLocalizedMessage();
        return msg == null ? error.toString() : msg;
    }

    public static boolean hasState(int state, int queriedState) {
        return (state & queriedState) == queriedState;
    }

    public static boolean hasStyle(Widget widget, int style) {
        ArgCheck.isNotNull((Object)widget);
        return WidgetUtil.hasState(widget.getStyle(), style);
    }

    public static void initializePanel(Composite panel) {
        WidgetUtil.initializePanel(panel, 0, 1, 1);
    }

    public static void initializePanel(Composite panel, int gridStyle, int span, int columns) {
        GridData gridData = new GridData(gridStyle);
        gridData.horizontalSpan = span;
        panel.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(columns, false);
        if (WidgetUtil.hasStyle((Widget)panel, 8)) {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        panel.setLayout((Layout)layout);
    }

    public static IDialogSettings initializeSettings(Object object, AbstractUIPlugin plugin) {
        String name;
        IDialogSettings settings = plugin.getDialogSettings();
        IDialogSettings section = settings.getSection(name = object.getClass().getName());
        if (section == null) {
            section = settings.addNewSection(name);
        }
        return section;
    }

    public static boolean isChecked(TreeItem item) {
        return WidgetUtil.hasState(WidgetUtil.getCheckedState(item), 2);
    }

    public static boolean isPartiallyChecked(TreeItem item) {
        return WidgetUtil.hasState(WidgetUtil.getCheckedState(item), 4);
    }

    public static boolean isUnchecked(TreeItem item) {
        return WidgetUtil.hasState(WidgetUtil.getCheckedState(item), 1);
    }

    public static void pack(TableViewer viewer) {
        WidgetUtil.pack(viewer.getTable());
    }

    public static void pack(Table table) {
        TableColumn[] cols = table.getColumns();
        for (int ndx = 0; ndx < cols.length; ++ndx) {
            cols[ndx].pack();
        }
    }

    public static void removeMissingResources(IDialogSettings settings, String id) {
        ArgCheck.isNotNull((Object)settings);
        ArgCheck.isNotNull((Object)id);
        String[] resourceItems = settings.getArray(id);
        if (resourceItems != null && resourceItems.length > 0) {
            ArrayList<String> newItems = new ArrayList<String>(Arrays.asList(resourceItems));
            File tmp = null;
            Iterator itr = newItems.iterator();
            while (itr.hasNext()) {
                String sItem = (String)itr.next();
                if (sItem == null) {
                    itr.remove();
                    continue;
                }
                tmp = new File(sItem);
                if (tmp.exists()) continue;
                itr.remove();
            }
            if (resourceItems.length != newItems.size()) {
                String[] resourceNames = new String[newItems.size()];
                int ndx = resourceNames.length;
                while (--ndx >= 0) {
                    resourceNames[ndx] = (String)newItems.get(ndx);
                }
                settings.put(id, resourceNames);
            }
        }
    }

    public static void removeMissingProjectResources(IDialogSettings settings, String id) {
        ArgCheck.isNotNull((Object)settings);
        ArgCheck.isNotNull((Object)id);
        String[] resourceItems = settings.getArray(id);
        if (resourceItems != null && resourceItems.length > 0) {
            int RESOURCE_TYPES = 7;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ArrayList<String> newItems = new ArrayList<String>(Arrays.asList(resourceItems));
            Iterator itr = newItems.iterator();
            while (itr.hasNext()) {
                if (workspace.validatePath((String)itr.next(), 7).isOK()) continue;
                itr.remove();
            }
            if (resourceItems.length != newItems.size()) {
                String[] resourceNames = new String[newItems.size()];
                int ndx = resourceNames.length;
                while (--ndx >= 0) {
                    resourceNames[ndx] = (String)newItems.get(ndx);
                }
                settings.put(id, resourceNames);
            }
        }
    }

    public static void restore(Map map) {
        ArgCheck.isNotNull((Object)map);
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ((Control)entry.getKey()).setEnabled(((Boolean)entry.getValue()).booleanValue());
        }
    }

    public static void saveSettings(IDialogSettings settings, String id, Combo combo) {
        WidgetUtil.saveSettings(settings, id, combo, 15);
    }

    public static void saveSettings(IDialogSettings theSettings, String theId, Combo theCombo, int theLimit) {
        ArgCheck.isNotNull((Object)theSettings);
        ArgCheck.isNotNull((Object)theId);
        ArgCheck.isNotNull((Object)theCombo);
        ArgCheck.isPositive((int)theLimit);
        String currentValue = theCombo.getText();
        if (currentValue.length() > 0 && theCombo.indexOf(currentValue) == -1) {
            theCombo.add(currentValue);
        }
        if (theCombo.getItemCount() > theLimit) {
            theCombo.remove(0, theCombo.getItemCount() - theLimit - 1);
        }
        theSettings.put(theId, theCombo.getItems());
    }

    public static void select(Object object, Viewer viewer) {
        IStructuredSelection selection;
        if (object != null && ((selection = (IStructuredSelection)viewer.getSelection()).size() != 1 || selection.getFirstElement() != object)) {
            viewer.setSelection((ISelection)new StructuredSelection(object), true);
        }
    }

    public static void selectRadioButton(Button button) {
        ArgCheck.isNotNull((Object)button);
        ArgCheck.isTrue((boolean)WidgetUtil.hasStyle((Widget)button, 16), (String)NOT_RADIO_BUTTON_MESSAGE);
        Composite parent = button.getParent();
        Control[] kids = parent.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            if (kids[i] == button || !(kids[i] instanceof Button) || !WidgetUtil.hasStyle((Widget)kids[i], 16) || !((Button)kids[i]).getSelection()) continue;
            Button oldButton = (Button)kids[i];
            oldButton.setSelection(false);
            oldButton.notifyListeners(13, new Event());
            break;
        }
        if (!button.getSelection()) {
            button.setSelection(true);
            button.notifyListeners(13, new Event());
        }
    }

    public static void setChecked(TreeItem item, boolean checked, boolean selected, ITreeViewerController controller) {
        WidgetUtil.setCheckedState(item, checked ? 2 : 1, selected, controller);
    }

    public static void setCheckedState(TreeItem item, int state, boolean selected, ITreeViewerController controller) {
        ArgCheck.isNotNull((Object)item);
        ArgCheck.isNotNull((Object)controller);
        item.setData("checkedState", (Object)new Integer(state));
        controller.update(item, selected);
    }

    public static void setCheckedStates(TableTreeViewer ttvViewer, Map mapItemCheckedStates) {
        TableTreeItem[] ttiItems = ttvViewer.getTableTree().getItems();
        for (int i = 0; i < ttiItems.length; ++i) {
            TableTreeItem ttiTemp = ttiItems[i];
            WidgetUtil.setCheckedStates(mapItemCheckedStates, ttiTemp);
        }
    }

    private static void setCheckedStates(Map mapItemCheckedStates, TableTreeItem ttiItem) {
        Boolean BChecked = (Boolean)mapItemCheckedStates.get(ttiItem.getData());
        ttiItem.setChecked(BChecked.booleanValue());
        TableTreeItem[] ttiChildren = ttiItem.getItems();
        for (int i = 0; i < ttiChildren.length; ++i) {
            WidgetUtil.setCheckedStates(mapItemCheckedStates, ttiChildren[i]);
        }
    }

    public static void setComboItems(Combo combo, List items) {
        WidgetUtil.setComboItems(combo, items, null);
    }

    public static void setComboItems(Combo combo, Object[] items) {
        WidgetUtil.setComboItems(combo, Arrays.asList(items), null);
    }

    public static void setComboItems(Combo combo, List items, ILabelProvider provider) {
        WidgetUtil.setComboItems(combo, items, provider, false);
    }

    public static void setComboItems(Combo combo, List items, ILabelProvider provider, boolean sort) {
        ArgCheck.isNotNull((Object)combo);
        WidgetUtil.setComboItems(combo, items, provider, sort, combo.getText());
    }

    public static void setComboItems(Combo combo, List items, ILabelProvider provider, boolean sort, String selection) {
        ArgCheck.isNotNull((Object)combo);
        ArgCheck.isNotNull((Object)items);
        combo.removeAll();
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            String text;
            String string = text = provider == null ? iter.next().toString() : provider.getText(iter.next());
            if (sort) {
                int index = Collections.binarySearch(Arrays.asList(combo.getItems()), text);
                if (index < 0) {
                    combo.add(text, -(index + 1));
                    continue;
                }
                combo.add(text, index);
                continue;
            }
            combo.add(text);
        }
        if (selection != null && selection.length() > 0) {
            combo.setText(selection);
        }
    }

    public static void setComboText(Combo combo, Object selection) {
        WidgetUtil.setComboText(combo, selection, null);
    }

    public static void setComboText(Combo combo, Object selection, ILabelProvider provider) {
        WidgetUtil.setComboText(combo, selection, provider, false);
    }

    public static void setComboText(Combo combo, Object selection, boolean add) {
        WidgetUtil.setComboText(combo, selection, null, add);
    }

    public static void setComboText(Combo combo, Object selection, ILabelProvider provider, boolean add) {
        ArrayList<String> items;
        String text;
        ArgCheck.isNotNull((Object)combo);
        String string = selection == null ? "" : (text = provider == null ? selection.toString() : provider.getText(selection));
        if (add && !(items = new ArrayList<String>(Arrays.asList(combo.getItems()))).contains(text)) {
            items.add(text);
            WidgetUtil.setComboItems(combo, items, provider);
        }
        combo.setText(text);
    }

    public static void setSashFormWeights(SashForm theSash) {
        int[] weights = WidgetUtil.getSashFormWeights(theSash);
        if (weights != null) {
            theSash.setWeights(weights);
        }
    }

    public static int[] getSashFormWeights(SashForm theSash) {
        ArgCheck.isNotNull((Object)theSash);
        Control[] kids = theSash.getChildren();
        boolean vertical = WidgetUtil.hasStyle((Widget)theSash, 512);
        int[] weights = null;
        double total = 0.0;
        if (kids.length > 0) {
            int i;
            ArrayList<Integer> temp = new ArrayList<Integer>();
            for (i = 0; i < kids.length; ++i) {
                if (kids[i] instanceof Sash) continue;
                Point point = kids[i].computeSize(-1, -1);
                int size = vertical ? point.y : point.x;
                temp.add(new Integer(size));
                total += (double)size;
            }
            weights = new int[temp.size()];
            for (i = 0; i < weights.length; ++i) {
                int size = (Integer)temp.get(i);
                weights[i] = (int)Math.round((double)size / total * 100.0);
            }
        }
        return weights;
    }

    public static void show(IStatus status) {
        ArgCheck.isNotNull((Object)status);
        switch (status.getSeverity()) {
            case 4: {
                WidgetUtil.showError(status.getMessage());
                break;
            }
            case 2: {
                WidgetUtil.showWarning(status.getMessage());
                break;
            }
            default: {
                WidgetUtil.showNotification(status.getMessage());
            }
        }
    }

    public static void showCause(String prefix, IStatus status) {
        ArgCheck.isNotNull((Object)prefix);
        ArgCheck.isNotNull((Object)status);
        String msg = WidgetUtil.getCauseMessage(prefix, status);
        Object newStatus = status.isMultiStatus() ? new MultiStatus(status.getPlugin(), status.getCode(), status.getChildren(), msg, status.getException()) : new Status(status.getSeverity(), status.getPlugin(), status.getCode(), msg, status.getException());
        WidgetUtil.show((IStatus)newStatus);
    }

    public static void showCause(String prefix, Throwable throwable) {
        WidgetUtil.showCause(prefix, throwable, 4);
    }

    public static void showCause(String prefix, Throwable throwable, int severity) {
        ArgCheck.isNotNull((Object)prefix);
        ArgCheck.isNotNull((Object)throwable);
        ArgCheck.isTrue((severity == 4 || severity == 2 ? 1 : 0) != 0, (String)INVALID_SEVERITY_MESSAGE);
        WidgetUtil.show((IStatus)new Status(severity, "com.metamatrix.ui", 0, WidgetUtil.getCauseMessage(prefix, throwable), throwable));
    }

    public static boolean showConfirmation(String message) {
        ArgCheck.isNotNull((Object)message);
        Shell shell = Display.getCurrent().getActiveShell();
        return MessageDialog.openConfirm((Shell)shell, (String)InternalUiConstants.Widgets.CONFIRM_MESSAGE_TITLE, (String)message);
    }

    public static void showError(String message) {
        ArgCheck.isNotNull((Object)message);
        Shell shell = Display.getCurrent().getActiveShell();
        MessageDialog.openError((Shell)shell, (String)InternalUiConstants.Widgets.ERROR_MESSAGE_TITLE, (String)message);
    }

    public static void showError(Throwable error) {
        WidgetUtil.showError(WidgetUtil.getMessage(error));
    }

    public static IContainer showFolderSelectionDialog(IContainer selection) {
        return WidgetUtil.showFolderSelectionDialog(selection, null);
    }

    public static IContainer showFolderSelectionDialog(IContainer selection, ISelectionStatusValidator validator) {
        return WidgetUtil.showFolderSelectionDialog(selection, null, validator);
    }

    public static IContainer showFolderSelectionDialog(IContainer selection, final ViewerFilter filter, ISelectionStatusValidator validator) {
        ViewerFilter baseFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return element instanceof IContainer && ((IContainer)element).isAccessible() && (filter == null || filter.select(viewer, parent, element));
            }
        };
        Object[] objs = WidgetUtil.showWorkspaceObjectSelectionDialog(FOLDER_SELECTION_DIALOG_TITLE, FOLDER_SELECTION_DIALOG_MESSAGE, false, selection, baseFilter, validator);
        return objs.length == 0 ? null : (IContainer)objs[0];
    }

    public static void showNotification(String message) {
        ArgCheck.isNotNull((Object)message);
        Shell shell = Display.getCurrent().getActiveShell();
        MessageDialog.openInformation((Shell)shell, (String)InternalUiConstants.Widgets.NOTIFICATION_MESSAGE_TITLE, (String)message);
    }

    public static void showWarning(String message) {
        ArgCheck.isNotNull((Object)message);
        Shell shell = Display.getCurrent().getActiveShell();
        MessageDialog.openWarning((Shell)shell, (String)InternalUiConstants.Widgets.WARNING_MESSAGE_TITLE, (String)message);
    }

    public static Object[] showWorkspaceObjectSelectionDialog(String title, String message, boolean allowMultiple, Object selection, ViewerFilter filter, ISelectionStatusValidator validator) {
        return WidgetUtil.showWorkspaceObjectSelectionDialog(title, message, allowMultiple, selection, filter, validator, (ILabelProvider)new WorkbenchLabelProvider());
    }

    public static Object[] showWorkspaceObjectSelectionDialog(String title, String message, boolean allowMultiple, Object selection, ViewerFilter filter, ISelectionStatusValidator validator, ILabelProvider labelProvider) {
        Shell shell = Display.getCurrent().getActiveShell();
        ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(shell, labelProvider, (ITreeContentProvider)new WorkbenchContentProvider()){};
        dlg.setAllowMultiple(allowMultiple);
        dlg.setTitle(title);
        dlg.setMessage(message);
        if (filter != null) {
            dlg.addFilter(filter);
        }
        if (validator != null) {
            dlg.setValidator(validator);
        }
        dlg.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (selection != null) {
            dlg.setInitialSelection(selection);
        }
        if (dlg.open() == 0) {
            return dlg.getResult();
        }
        return StringUtil.Constants.EMPTY_STRING_ARRAY;
    }

    public static Object[] showWorkspaceObjectSelectionDialog(String title, String message, boolean allowMultiple, Object selection, ViewerFilter filter, ISelectionStatusValidator validator, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        Shell shell = Display.getCurrent().getActiveShell();
        ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(shell, labelProvider, contentProvider){};
        dlg.setAllowMultiple(allowMultiple);
        dlg.setTitle(title);
        dlg.setMessage(message);
        if (filter != null) {
            dlg.addFilter(filter);
        }
        if (validator != null) {
            dlg.setValidator(validator);
        }
        dlg.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (selection != null) {
            dlg.setInitialSelection(selection);
        }
        if (dlg.open() == 0) {
            return dlg.getResult();
        }
        return StringUtil.Constants.EMPTY_STRING_ARRAY;
    }

    public static void toggleCheckedState(TreeItem item, ITreeViewerController controller) {
        WidgetUtil.setChecked(item, !WidgetUtil.isChecked(item), true, controller);
    }

    private static String getString(String id) {
        return UiConstants.Util.getString(I18N_PREFIX + id);
    }

    private static String getString(String id, Object parameter) {
        return UiConstants.Util.getString(I18N_PREFIX + id, parameter);
    }

    private static String getString(String id, Object parameter1, Object parameter2) {
        return UiConstants.Util.getString(I18N_PREFIX + id, parameter1, parameter2);
    }

    private WidgetUtil() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

