/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.IIOP;
import com.metamatrix.sequelink.net.NetByteOrder;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.util.OutputStreamOnByteArray;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class IIOPOctetSequence {
    private static final byte[] ALIGNMENT = new byte[]{0};
    private byte[] octetSequence;
    private byte[] iiopOctetSequence;

    IIOPOctetSequence(byte[] byArray, boolean bl) throws NetworkException {
        this.octetSequence = byArray;
        this.encodeOctetSequence(bl);
    }

    IIOPOctetSequence(DataInputStream dataInputStream, boolean bl) throws NetworkException {
        this.decodeOctetSequence(dataInputStream, bl);
    }

    public byte[] getIIOPOctetSequence() {
        return this.iiopOctetSequence;
    }

    public byte[] getOctetSequence() {
        return this.octetSequence;
    }

    public static int getLengthIIOPOctetSequence(byte[] byArray) {
        return IIOPOctetSequence.lengthOctetSequence(byArray.length);
    }

    private static int alignmentLengthOctetSequence(int n2) {
        return (n2 / 4 + 1) * 4 - n2;
    }

    private static int lengthOctetSequence(int n2) {
        int n3 = 4;
        int n4 = n2;
        int n5 = IIOPOctetSequence.alignmentLengthOctetSequence(n2);
        return n3 + n4 + n5;
    }

    private void encodeOctetSequence(boolean bl) throws NetworkException {
        int n2 = this.octetSequence.length;
        int n3 = NetByteOrder.htonl(n2, bl);
        int n4 = IIOPOctetSequence.lengthOctetSequence(n2);
        int n5 = IIOPOctetSequence.alignmentLengthOctetSequence(n2);
        this.iiopOctetSequence = new byte[n4];
        OutputStreamOnByteArray outputStreamOnByteArray = new OutputStreamOnByteArray(this.iiopOctetSequence);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStreamOnByteArray);
        try {
            dataOutputStream.writeInt(n3);
            outputStreamOnByteArray.write(this.octetSequence, 0, n2);
            for (int i2 = 0; i2 < n5; ++i2) {
                outputStreamOnByteArray.write(ALIGNMENT, 0, 1);
            }
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }

    private void decodeOctetSequence(DataInputStream dataInputStream, boolean bl) throws NetworkException {
        try {
            int n2 = dataInputStream.readInt();
            int n3 = NetByteOrder.htonl(n2, bl);
            int n4 = IIOPOctetSequence.alignmentLengthOctetSequence(n3);
            this.octetSequence = new byte[n3];
            dataInputStream.readFully(this.octetSequence, 0, n3);
            dataInputStream.skipBytes(n4);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }
}

