/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket;

import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.comm.ServerListenerRegistry;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.server.MessageFilterServiceAgent;
import com.metamatrix.common.comm.platform.socket.NullSocketLog;
import com.metamatrix.common.comm.platform.socket.server.SocketListener;
import com.metamatrix.common.comm.platform.socket.server.SocketServerWorkerFactory;
import com.metamatrix.common.comm.service.SocketService;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.ServiceInterfaceInterceptorStruct;
import com.metamatrix.core.proxy.TerminalServiceInterceptor;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.HashMap;

public class SocketServiceListener
implements ServerListenerRegistry,
SocketService {
    private HostInfo hostInfo = null;
    private ServerListener serverlistener;
    private MessageFilterServiceAgent messageRouter;
    private static final String SOCKET_WORKER_POOL_NAME = "SocketWorkerQueue";
    private static HashMap socketListenThreads = new HashMap();

    public SocketServiceListener(String socketHost, int socketPort, ServerListener serverlistener) {
        this.hostInfo = new HostInfo(socketHost, socketPort);
    }

    public ServerListener getServerListener() {
        return this.serverlistener;
    }

    public SocketListener startSocketTransport(int port, String host, int maxThreads, long timeToLive, int inputBufferSize, int outputBufferSize) {
        this.hostInfo.setPortNumber(port);
        SocketListener listener = new SocketListener(port, host, this.getServerListener(), this.getSocketServerWorkerPool(maxThreads, timeToLive), NullSocketLog.create(), inputBufferSize, outputBufferSize);
        SocketListenerRunner runner = new SocketListenerRunner(listener);
        runner.start();
        socketListenThreads.put(listener, runner);
        return listener;
    }

    public void stopSocketTransport(SocketListener listener) {
        if (listener != null) {
            listener.stop();
            Thread thread = (Thread)socketListenThreads.remove(listener);
            if (thread != null) {
                while (thread.isAlive()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private WorkerPool getSocketServerWorkerPool(int maxThreads, long timeToLive) {
        WorkerPool result = new WorkerPool(SOCKET_WORKER_POOL_NAME, (QueueWorkerFactory)new SocketServerWorkerFactory(), maxThreads, timeToLive);
        return result;
    }

    public String getHost() throws RemoteException {
        return this.hostInfo.getHostName();
    }

    public int getPort() throws RemoteException {
        return this.hostInfo.getPortNumber();
    }

    public InetAddress getInetAddress() throws RemoteException {
        return this.hostInfo.getInetAddress();
    }

    public void registerServiceInterceptor(String name, Class serviceName, ServiceInterceptor[] interceptor, TerminalServiceInterceptor terminal) {
        if (this.messageRouter == null) {
            this.messageRouter = new MessageFilterServiceAgent(this.serverlistener);
        }
        this.messageRouter.addServiceInterface(name, new ServiceInterfaceInterceptorStruct(name, serviceName, interceptor, terminal));
    }

    public void setServerListener(ServerListener serverLitener) {
        this.serverlistener = serverLitener;
    }

    public void registerMBean(Object mBean, String mBeanName) {
    }

    static class SocketListenerRunner
    extends Thread {
        SocketListener listener = null;

        public SocketListenerRunner(SocketListener listener) {
            super("SocketListenerRunner");
            this.listener = listener;
        }

        public void run() {
            try {
                this.listener.run();
            }
            catch (CommunicationException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
        }
    }
}

