/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.jdbc;

import com.metamatrix.sequelink.ctxt.CtxtAttributes;
import com.metamatrix.sequelink.net.EndPointGenerator;
import com.metamatrix.sequelink.ssp.AttribList;
import com.metamatrix.sequelink.ssp.Message;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public final class ConnectAttributes
implements CtxtAttributes {
    public static final String CIPHERSUITES = "CIPHERSUITES";
    public static final String CERTIFICATECHECKER = "CERTIFICATECHECKER";
    public static final String SEQUELINKLOGFILE = "SEQUELINKLOGFILE";
    public static final String IIOPOBJECTKEY = "IIOPOBJECTKEY";
    public static final String IIOPOPERATIONTARGET = "IIOPOPERATIONTARGET";
    public static final String JBM_MINBUFFERSIZE = "JBM_MINBUFFERSIZE";
    public static final String JBM_SIZEINCREMENT = "JBM_SIZEINCREMENT";
    public static final String JBM_INITIALPOOLSIZE = "JBM_INITIALPOOLSIZE";
    public static final String JBM_MAXPOOLSIZE = "JBM_MAXPOOLSIZE";
    private Properties attributes = new Properties();
    private String url;
    private Properties info;

    public ConnectAttributes() {
    }

    public ConnectAttributes(String string, Properties properties) throws SQLException {
        this.url = string;
        this.info = properties;
        this.decodeURL();
        this.overrideWithParamProperties();
    }

    public String getUrl() {
        return this.url;
    }

    public DriverPropertyInfo[] getPropertyInfo() throws SQLException {
        if (this.getServerName() != null && this.getPortNumber() != null) {
            return new DriverPropertyInfo[0];
        }
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[23];
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("DATABASENAME", this.getDatabaseName());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.databaseName");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[0] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("PASSWORD", this.getPassword());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.password");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[1] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("PORTNUMBER", this.getPortNumber());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.portNumber");
        driverPropertyInfo.required = true;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[2] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("SERVERNAME", this.getServerName());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.serverName");
        driverPropertyInfo.required = true;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[3] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("USER", this.getUser());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.user");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[4] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("DBUSER", this.getDBUser());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.DBUser");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[5] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("DBPASSWORD", this.getDBPassword());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.DBPassword");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[6] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("SERVERDATASOURCE", this.getServerDataSource());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.serverDataSource");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[7] = driverPropertyInfo;
        Integer n = this.getBlockFetchForUpdate();
        driverPropertyInfo = n == null ? new DriverPropertyInfo("BLOCKFETCHFORUPDATE", null) : new DriverPropertyInfo("BLOCKFETCHFORUPDATE", n.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.blockFetchForUpdate");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[8] = driverPropertyInfo;
        n = this.getAllowPrefetch();
        driverPropertyInfo = n == null ? new DriverPropertyInfo("ALLOWPREFETCH", null) : new DriverPropertyInfo("ALLOWPREFETCH", n.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.allowPrefetch");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[9] = driverPropertyInfo;
        n = this.getSLKStaticCursorLongColBuffLen();
        driverPropertyInfo = n == null ? new DriverPropertyInfo("SLKSTATICCURSORLONGCOLBUFFLEN", null) : new DriverPropertyInfo("SLKSTATICCURSORLONGCOLBUFFLEN", n.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.SLKStaticCursorLongColBuffLen");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[10] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("HUSER", this.getHUser());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.HUser");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[11] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("HPASSWORD", this.getHPassword());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.HPassword");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[12] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("NEWPASSWORD", this.getNewPassword());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.newPassword");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[13] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("NETWORKPROTOCOL", this.getNetworkProtocol());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.networkProtocol");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[14] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo(CIPHERSUITES, this.getCipherSuites());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.cipherSuites");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[15] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo(CERTIFICATECHECKER, this.getCertificateCheck());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.certificateChecker");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[16] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo(IIOPOBJECTKEY, this.getIIOPObjectKey());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.IIOPObjectKey");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[17] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo(IIOPOPERATIONTARGET, this.getIIOPOperationTarget());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.IIOPOperationTarget");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[18] = driverPropertyInfo;
        n = this.getORANumber0IsNumeric();
        driverPropertyInfo = n == null ? new DriverPropertyInfo("ORANUMBER0ISNUMERIC", null) : new DriverPropertyInfo("ORANUMBER0ISNUMERIC", n.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.ORANumber0IsNumeric");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[19] = driverPropertyInfo;
        n = this.getMSSMapLongToDecimal();
        driverPropertyInfo = n == null ? new DriverPropertyInfo("MSSMAPLONGTODECIMAL", null) : new DriverPropertyInfo("MSSMAPLONGTODECIMAL", n.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.MSSMapLongToDecimal");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[20] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("APPLICATIONNAME", this.getApplicationName());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.applicationName");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[21] = driverPropertyInfo;
        n = this.getTransliterationWorkaroundServer();
        driverPropertyInfo = n == null ? new DriverPropertyInfo("TRANSLITERATIONWASERVER", null) : new DriverPropertyInfo("TRANSLITERATIONWASERVER", n.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.transliterationWorkaroundServer");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[22] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    public AttribList getSDSAttributes() {
        AttribList attribList = new AttribList();
        if (this.getDatabaseName() == null) {
            attribList.addInteger(1, 36);
        }
        if (this.getBlockFetchForUpdate() == null) {
            attribList.addInteger(1, 72);
        }
        if (this.getSLKStaticCursorLongColBuffLen() == null) {
            attribList.addInteger(1, 70);
        }
        if (this.getORANumber0IsNumeric() == null) {
            attribList.addInteger(1, 173);
        }
        if (this.getMSSMapLongToDecimal() == null) {
            attribList.addInteger(1, 174);
        }
        return attribList;
    }

    public AttribList getSDSAttributes54(AttribList attribList) {
        if (this.getAllowPrefetch() == null) {
            attribList.addInteger(1, 245);
        }
        attribList.addInteger(1, 237);
        return attribList;
    }

    public AttribList getSDSAttributes54Only(AttribList attribList) {
        attribList.addInteger(1, 239);
        return attribList;
    }

    public void setSDSAttributes(AttribList attribList) {
        String string = attribList.getStringValue(36);
        if (this.getDatabaseName() == null && string != null && string.length() != 0) {
            this.setDatabaseName(string);
        }
        Integer n = attribList.getIntegerValue(72);
        if (this.getBlockFetchForUpdate() == null && n != null) {
            this.setBlockFetchForUpdate(n);
        }
        n = attribList.getIntegerValue(70);
        if (this.getSLKStaticCursorLongColBuffLen() == null && n != null) {
            this.setSLKStaticCursorLongColBuffLen(n);
        }
        n = attribList.getIntegerValue(173);
        if (this.getORANumber0IsNumeric() == null && n != null) {
            this.setORANumber0IsNumeric(n);
        }
        n = attribList.getIntegerValue(174);
        if (this.getMSSMapLongToDecimal() == null && n != null) {
            this.setMSSMapLongToDecimal(n);
        }
    }

    public void setSDSAttributes54(AttribList attribList) {
        Integer n;
        Boolean bl = attribList.getBooleanValue(245);
        if (this.getAllowPrefetch() == null && bl != null) {
            n = new Integer(bl != false ? 1 : 0);
            this.setAllowPrefetch(n);
        }
        if ((n = attribList.getIntegerValue(237)) != null) {
            this.setTransliterationWorkaroundServer(n);
        }
    }

    public void setSDSAttributes54Only(AttribList attribList) {
        Integer n = attribList.getIntegerValue(239);
        if (n != null) {
            this.setWABadDescribeParam54(n);
        }
    }

    public String getDatabaseName() {
        return this.getAttribute("DATABASENAME");
    }

    public void setDatabaseName(String string) {
        this.setAttribute("DATABASENAME", string);
    }

    public String getNetworkProtocol() {
        String string = this.getAttribute("NETWORKPROTOCOL");
        if (string == null) {
            string = "socket";
        }
        return string;
    }

    public void setNetworkProtocol(String string) {
        this.setAttribute("NETWORKPROTOCOL", string);
    }

    public String getPassword() {
        return this.getAttribute("PASSWORD");
    }

    public void setPassword(String string) {
        this.setAttribute("PASSWORD", string);
    }

    public String getPortNumber() {
        return this.getAttribute("PORTNUMBER");
    }

    public int getPortNumberAsInt() {
        String string = this.getAttribute("PORTNUMBER");
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public void setPortNumber(String string) {
        this.setAttribute("PORTNUMBER", string);
    }

    public String getServerName() {
        return this.getAttribute("SERVERNAME");
    }

    public void setServerName(String string) {
        this.setAttribute("SERVERNAME", string);
    }

    public String getUser() {
        return this.getAttribute("USER");
    }

    public void setUser(String string) {
        this.setAttribute("USER", string);
    }

    public String getServerDataSource() {
        return this.getAttribute("SERVERDATASOURCE");
    }

    public void setServerDataSource(String string) {
        this.setAttribute("SERVERDATASOURCE", string);
    }

    public Integer getBlockFetchForUpdate() {
        return this.getIntegerAttribute("BLOCKFETCHFORUPDATE");
    }

    public void setBlockFetchForUpdate(Integer n) {
        this.setIntegerAttribute("BLOCKFETCHFORUPDATE", n);
    }

    public Integer getAllowPreFetch() {
        return this.getIntegerAttribute("ALLOWPREFETCH");
    }

    public void setAllowPreFetch(Integer n) {
        this.setIntegerAttribute("ALLOWPREFETCH", n);
    }

    public Integer getSLKStaticCursorLongColBuffLen() {
        return this.getIntegerAttribute("SLKSTATICCURSORLONGCOLBUFFLEN");
    }

    public void setSLKStaticCursorLongColBuffLen(Integer n) {
        this.setIntegerAttribute("SLKSTATICCURSORLONGCOLBUFFLEN", n);
    }

    public Integer getORANumber0IsNumeric() {
        return this.getIntegerAttribute("ORANUMBER0ISNUMERIC");
    }

    public void setORANumber0IsNumeric(Integer n) {
        this.setIntegerAttribute("ORANUMBER0ISNUMERIC", n);
    }

    public Integer getMSSMapLongToDecimal() {
        return this.getIntegerAttribute("MSSMAPLONGTODECIMAL");
    }

    public void setMSSMapLongToDecimal(Integer n) {
        this.setIntegerAttribute("MSSMAPLONGTODECIMAL", n);
    }

    public String getApplicationName() {
        return this.getAttribute("APPLICATIONNAME");
    }

    public Integer getAllowPrefetch() {
        return this.getIntegerAttribute("ALLOWPREFETCH");
    }

    public void setAllowPrefetch(Integer n) {
        this.setIntegerAttribute("ALLOWPREFETCH", n);
    }

    public Integer getTransliterationWorkaroundServer() {
        return this.getIntegerAttribute("TRANSLITERATIONWASERVER");
    }

    public void setTransliterationWorkaroundServer(Integer n) {
        this.setIntegerAttribute("TRANSLITERATIONWASERVER", n);
    }

    public Integer getWABadDescribeParam54() {
        return this.getIntegerAttribute("WABADDESCRIBEPARAM54");
    }

    public void setWABadDescribeParam54(Integer n) {
        this.setIntegerAttribute("WABADDESCRIBEPARAM54", n);
    }

    public String getDBUser() {
        return this.getAttribute("DBUSER");
    }

    public void setDBUser(String string) {
        this.setAttribute("DBUSER", string);
    }

    public String getDBPassword() {
        return this.getAttribute("DBPASSWORD");
    }

    public void setDBPassword(String string) {
        this.setAttribute("DBPASSWORD", string);
    }

    public String getHUser() {
        return this.getAttribute("HUSER");
    }

    public void setHUser(String string) {
        this.setAttribute("HUSER", string);
    }

    public String getHPassword() {
        return this.getAttribute("HPASSWORD");
    }

    public void setHPassword(String string) {
        this.setAttribute("HPASSWORD", string);
    }

    public String getNewPassword() {
        return this.getAttribute("NEWPASSWORD");
    }

    public void setNewPassword(String string) {
        this.setAttribute("NEWPASSWORD", string);
    }

    public String getCipherSuites() {
        return this.attributes.getProperty(CIPHERSUITES);
    }

    public void setCipherSuites(String string) {
        this.setAttribute(CIPHERSUITES, string);
    }

    public String getCertificateCheck() {
        return this.attributes.getProperty(CERTIFICATECHECKER);
    }

    public void setCertificateCheck(String string) {
        this.setAttribute(CERTIFICATECHECKER, string);
    }

    public String getSequeLinkLogFile() {
        return this.attributes.getProperty(SEQUELINKLOGFILE);
    }

    public void setSequeLinkLogFile(String string) {
        this.setAttribute(SEQUELINKLOGFILE, string);
    }

    public String getIIOPObjectKey() {
        return this.attributes.getProperty(IIOPOBJECTKEY);
    }

    public void setIIOPObjectKey(String string) {
        this.setAttribute(IIOPOBJECTKEY, string);
    }

    public String getIIOPOperationTarget() {
        return this.attributes.getProperty(IIOPOPERATIONTARGET);
    }

    public void setIIOPOperationTarget(String string) {
        this.setAttribute(IIOPOPERATIONTARGET, string);
    }

    public String getSSLDebug() {
        return null;
    }

    public String getSSLVersions() {
        return null;
    }

    public int getJBM_MinBufferSize() {
        return this.getIntAttribute(JBM_MINBUFFERSIZE);
    }

    public void setJBM_MinBufferSize(int n) {
        this.setIntegerAttribute(JBM_MINBUFFERSIZE, n);
    }

    public int getJBM_SizeIncrement() {
        return this.getIntAttribute(JBM_SIZEINCREMENT);
    }

    public void setJBM_SizeIncrement(int n) {
        this.setIntegerAttribute(JBM_SIZEINCREMENT, n);
    }

    public int getInitialPoolSize() {
        return this.getIntAttribute(JBM_INITIALPOOLSIZE);
    }

    public void setInitialPoolSize(int n) {
        this.setIntegerAttribute(JBM_INITIALPOOLSIZE, n);
    }

    public int getJBM_MaxPoolSize() {
        return this.getIntAttribute(JBM_MAXPOOLSIZE);
    }

    public void setJBM_MaxPoolSize(int n) {
        this.setIntegerAttribute(JBM_MAXPOOLSIZE, n);
    }

    public String getAttribute(String string) {
        return this.attributes.getProperty(string);
    }

    public void setAttribute(String string, String string2) {
        if (string2 != null) {
            this.attributes.put(string.toUpperCase(), string2);
        }
    }

    public int getIntAttribute(String string) {
        String string2 = this.getAttribute(string);
        if (string2 == null) {
            return 0;
        }
        return Integer.parseInt(this.getAttribute(string));
    }

    public Integer getIntegerAttribute(String string) {
        String string2 = this.getAttribute(string);
        if (string2 == null) {
            return null;
        }
        return new Integer(string2);
    }

    private void setIntegerAttribute(String string, int n) {
        this.setAttribute(string, new Integer(n).toString());
    }

    private void setIntegerAttribute(String string, Integer n) {
        this.setAttribute(string, n.toString());
    }

    private void setBooleanAttribute(String string, Boolean bl) {
        this.setAttribute(string, bl.toString());
    }

    public Boolean getBooleanAttribute(String string) {
        String string2 = this.getAttribute(string);
        if (string2 == null) {
            return null;
        }
        return "true".equalsIgnoreCase(string2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public void checkComplete() throws SQLException {
        if (this.getServerName() == null || this.getPortNumber() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getServerName() == null) {
                stringBuffer.append("SERVERNAME");
                stringBuffer.append(" ");
            }
            if (this.getPortNumber() == null) {
                stringBuffer.append("PORTNUMBER");
            }
            throw Message.Gen.getSqlException(7397, stringBuffer.toString());
        }
    }

    private void decodeURL() throws SQLException {
        String string;
        int n;
        if (!"jdbc:sequelink:".regionMatches(0, this.url, 0, 15)) {
            throw this.urlNotAccepted();
        }
        String string2 = this.url.substring(15);
        if ("".equals(string2)) {
            return;
        }
        if (!string2.startsWith("//")) {
            n = string2.indexOf(58);
            if (n == -1) {
                throw this.urlNotAccepted();
            }
            string = string2.substring(0, n);
            if (!EndPointGenerator.IsNetworkName(string)) {
                throw this.urlNotAccepted();
            }
            this.attributes.put("NETWORKPROTOCOL", string);
            string2 = string2.substring(n + 1);
        }
        if (!string2.startsWith("//")) {
            throw this.urlNotAccepted();
        }
        n = string2.indexOf(58);
        if (n == -1) {
            throw this.urlNotAccepted();
        }
        this.setServerName(string2.substring(2, n));
        string2 = string2.substring(n + 1);
        if ("".equals(string2)) {
            return;
        }
        n = string2.indexOf(";");
        if (n == -1) {
            this.setPortNumber(string2);
            return;
        }
        this.setPortNumber(string2.substring(0, n));
        string2 = string2.substring(n + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            n = string.indexOf(61);
            if (n == -1) continue;
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1, string.length());
            this.setAttribute(string3.toUpperCase(), string4);
        }
    }

    private void overrideWithParamProperties() {
        if (this.info != null) {
            Enumeration<?> enumeration = this.info.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.info.getProperty(string);
                this.setAttribute(string.toUpperCase(), string2);
            }
        }
    }

    private SQLException urlNotAccepted() {
        return Message.Gen.getSqlException(7396, this.url);
    }
}

