/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.oracle.OracleColumn;
import com.metamatrix.jdbc.oracle.OracleConnection;
import com.metamatrix.jdbc.oracle.OracleImplStatement;
import com.metamatrix.jdbc.oracle.net8.OracleNet8Communication;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTACPacket;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTCNPacket;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTDAPacket;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTRDPacket;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTRFPacket;
import com.metamatrix.jdbc.oracle.net8.TTIANODataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDCBDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDTYDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUNDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OALL8;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OAUTHENTICATE;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OCLOSE;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OCOMMIT;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OLOGOFF;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OOPEN;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OROLLBACK;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OSES;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OVERSION;
import com.metamatrix.jdbc.oracle.net8.TTIIOVDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIOERDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIPRODataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIRXDDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIRXHDataPacket;
import com.metamatrix.jdbc.oracle.sec.C1;
import com.metamatrix.jdbc.oracle.tns.TnsAddress;
import com.metamatrix.jdbc.oracle.tns.TnsCID;
import com.metamatrix.jdbc.oracle.tns.TnsConnectDescriptor;
import com.metamatrix.jdbc.oracle.tns.TnsDescriptionList;
import com.metamatrix.jdbc.oracle.tns.TnsFile;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSecurityContext;
import com.metamatrix.util.UtilSecurityContextCreator;
import com.metamatrix.util.UtilSocketCreator;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilTransliteratorForUTF8;
import java.net.Socket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;

public class OracleImplConnection
extends BaseImplConnection {
    private static String footprint = "$Revision:   3.128.1.6  $";
    public OracleConnection connection;
    UtilSecurityContext securityContext;
    public String authenticationMethodArg = null;
    private static final int NTLM_AUTHENTICATION = 0;
    private static final int CLIENT_AUTHENTICATION = 1;
    private static final int USERIDPASSWORD_AUTHENTICATION = 2;
    private static final int KERBEROS_AUTHENTICATION = 3;
    private static final int KERBEROS_USERIDPWD_AUTHENTICATION = 4;
    private int authenticationMethod;
    short[] m_oracleCursorCache = null;
    int m_cachedCursorLimit = 32;
    public String oracleServerVersionString = null;
    public long oracleServerVersion = 0L;
    public String m_orgUser;
    public String m_user;
    public String m_orgOracleSessionId;
    public String m_currOracleSessionId;
    public String m_orgOracleSerialNum;
    public String m_currOracleSerialNum;
    private int m_offsethours;
    private int m_offsetminutes;
    public String database;
    protected int byteOrder;
    private boolean allowMaxFloat = false;
    private int numberPrecisionScaleOption = 0;
    private boolean sendFloatParametersAsString = false;
    private boolean supportLinks = false;
    public boolean useOAll7;
    public boolean describeAtPrepare = false;
    public boolean refCursorSupport = true;
    public boolean returnSynonyms;
    public boolean FetchTSWTZasTimestamp = false;
    private short m_cursorID;
    public OracleNet8Communication comm;
    public short currentOraCharset;
    public short originalReportedOraCharset;
    public short originalReportedOraNCharset = 0;
    UtilTransliterator transliterator = null;
    public boolean wireCSmatchesOracleCS = true;
    public TTIOERDataPacket gTTIoer;
    public OracleNet8NSPTDAPacket NSPTDAPacket;
    SQLException myException;
    public Hashtable procParamInfoHashtable = null;
    public boolean stringParamsMustMatchCharColumns = true;
    public int initialColumnBufferSize = -1;
    public int thresholdForTreatingCharParamsAsLong;
    public int thresholdForTreatingCharParamsAsLongForNationalCharset;
    public int thresholdForTreatingBinaryParamsAsLong = 4000;
    public int writeCharParamAtEndOfRXDThreshold;
    public int largestAllowableMaxLengthValueForVARCHARandRAWParams;
    public int maxBytesPerCharForOriginalReportedOraCharset;
    public int maxBytesPerCharForOriginalReportedOraNationalCharset;
    TnsCID cid = new TnsCID();
    public boolean japaneseAsUTF8;
    boolean alterStatementHasBeenIssued = false;
    String databaseTimeZone = null;
    String sessionTimeZone = null;
    int tzHours = 0;
    int tzMinutes = 0;
    static final int maxIntsRequiredForVNUConversion = 18;
    public int[] intBufferForVNUConversion = new int[18];
    public byte[][] byteBufferForVNUConversion = new byte[18][];
    public char[] charBufferForVNUConversion;
    public StringBuffer stringBufferForVNUConversion;
    boolean codepageOverrideNoConvert;
    static final String OVERRIDE_NOCONVERT = "NOCONVERT";
    public int maxLocatorLength;

    public OracleImplConnection(OracleConnection oracleConnection) {
        for (int i = 0; i < 18; ++i) {
            this.byteBufferForVNUConversion[i] = new byte[(18 - i) * 3];
        }
        this.charBufferForVNUConversion = new char[150];
        this.stringBufferForVNUConversion = new StringBuffer(50);
        this.codepageOverrideNoConvert = false;
        this.connection = oracleConnection;
        this.supportsDMLWithResults = true;
    }

    public boolean supportsQueryTimeout() {
        return false;
    }

    public Socket getQueryTimeoutSocket() {
        return this.comm.socket;
    }

    public boolean supportsCancel() {
        return true;
    }

    public boolean supportsSelectStarCommaColumn() {
        return false;
    }

    public short allocateCursor() throws SQLException {
        TTIFUN_OOPEN tTIFUN_OOPEN = new TTIFUN_OOPEN();
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OOPEN);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.gTTIoer.retCode = 0;
        this.processReply(tTIFUN_OOPEN);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw this.myException;
        }
        return tTIFUN_OOPEN.cid;
    }

    public short getOpenCursor() throws SQLException {
        for (int i = 0; i < this.m_cachedCursorLimit; ++i) {
            if (this.m_oracleCursorCache[i] == 0) continue;
            short s = this.m_oracleCursorCache[i];
            this.m_oracleCursorCache[i] = 0;
            return s;
        }
        return 0;
    }

    public void freeCursor(short s) throws SQLException {
        if (s != 0) {
            TTIFUN_OCLOSE tTIFUN_OCLOSE = new TTIFUN_OCLOSE(s);
            this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OCLOSE);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            this.gTTIoer.retCode = 0;
            this.processReply(tTIFUN_OCLOSE);
            if (this.gTTIoer.retCode != 0) {
                String[] stringArray = new String[]{this.gTTIoer.errMsg};
                this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
                throw this.myException;
            }
            return;
        }
    }

    public void closeCursor(short s) throws SQLException {
        for (int i = 0; i < this.m_cachedCursorLimit; ++i) {
            if (this.m_oracleCursorCache[i] != 0) continue;
            this.m_oracleCursorCache[i] = s;
            return;
        }
        this.freeCursor(s);
    }

    public String getUser() {
        return this.m_user;
    }

    public boolean getAllowMaxFloat() {
        return this.allowMaxFloat;
    }

    public int getNumberPrecisionScaleOption() {
        return this.numberPrecisionScaleOption;
    }

    public boolean getSendFloatParametersAsString() {
        return this.sendFloatParametersAsString;
    }

    public int getEmptyRowInsertSyntax() {
        return 3;
    }

    protected void startManualTransactionMode() throws SQLException {
    }

    protected int getTransactionIsolation() throws SQLException {
        return 2;
    }

    protected void setTransactionIsolation(int n) throws SQLException {
        String string;
        switch (n) {
            case 2: {
                string = "alter session set isolation_level = read committed";
                break;
            }
            case 8: {
                string = "alter session set isolation_level = serializable";
                break;
            }
            default: {
                throw this.exceptions.getException(7009, "HY024");
            }
        }
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this);
        tTIFUN_OALL8.setOptions(32801);
        tTIFUN_OALL8.setCommandText(string);
        tTIFUN_OALL8.setCursorID(this.m_cursorID);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OALL8);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            SQLException sQLException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw sQLException;
        }
    }

    protected String getCatalog() throws SQLException {
        return "";
    }

    public void mergeAlternateConnectProps(BaseConnectionProperties baseConnectionProperties, BaseConnectionProperties baseConnectionProperties2) throws SQLException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8 = baseConnectionProperties.get("serverName");
        if (string8 != null && string8.length() == 0) {
            string8 = null;
        }
        if ((string7 = baseConnectionProperties2.get("serverName")) != null && string7.length() == 0) {
            string7 = null;
        }
        if ((string6 = baseConnectionProperties.get("SID")) != null && string6.length() == 0) {
            string6 = null;
        }
        if ((string5 = baseConnectionProperties.get("serviceName")) != null && string5.length() == 0) {
            string5 = null;
        }
        if ((string4 = baseConnectionProperties.get("serverType")) != null && string4.length() == 0) {
            string4 = null;
        }
        if ((string3 = baseConnectionProperties.get("TNSNamesFile")) != null && string3.length() == 0) {
            string3 = null;
        }
        if ((string2 = baseConnectionProperties2.get("TNSNamesFile")) != null && string2.length() == 0) {
            string2 = null;
        }
        if ((string = baseConnectionProperties.get("TNSServerName")) != null && string.length() == 0) {
            string = null;
        }
        if (string6 != null) {
            if (string5 != null) {
                String[] stringArray = new String[]{"SID", "serviceName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("serviceName", null);
            if (string != null) {
                String[] stringArray = new String[]{"SID", "TNSServerName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("TNSServerName", null);
            if (string3 != null) {
                String[] stringArray = new String[]{"SID", "TNSNamesFile"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("TNSNamesFile", null);
            if (string8 == null && string7 == null) {
                String[] stringArray = new String[]{"SID", "serverName"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        if (string5 != null) {
            if (string != null) {
                String[] stringArray = new String[]{"serviceName", "TNSServerName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("TNSServerName", null);
            if (string3 != null) {
                String[] stringArray = new String[]{"serviceName", "TNSNamesFile"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("TNSNamesFile", null);
            if (string8 == null && string7 == null) {
                String[] stringArray = new String[]{"serviceName", "serverName"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        if (string != null) {
            if (string8 != null) {
                String[] stringArray = new String[]{"TNSServerName", "serverName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("serverName", null);
            if (string4 != null) {
                String[] stringArray = new String[]{"TNSServerName", "serverType"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("serverType", null);
            if (string3 == null && string2 == null) {
                String[] stringArray = new String[]{"TNSServerName", "TNSNamesFile"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        if (string3 != null) {
            if (string8 != null) {
                String[] stringArray = new String[]{"TNSNamesFile", "serverName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("serverName", null);
            if (string4 != null) {
                String[] stringArray = new String[]{"tnsNamesFile", "serverType"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("serverType", null);
            if (string8 == null && string7 == null) {
                String[] stringArray = new String[]{"TNSNamesFile", "TNSServerName"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        super.mergeAlternateConnectProps(baseConnectionProperties, baseConnectionProperties2);
    }

    public void open() throws SQLException {
        block43: {
            this.m_user = this.connectProps.get("user");
            String string = this.connectProps.get("password");
            this.authenticationMethodArg = this.connectProps.get("authenticationMethod");
            String string2 = null;
            try {
                string2 = this.connectProps.get("allowMaxFloat");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = null;
            try {
                string3 = this.connectProps.get("NumberPrecisionScale");
                if (Integer.parseInt(string3) == 1) {
                    this.numberPrecisionScaleOption = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string4 = null;
            try {
                string4 = this.connectProps.get("oracleCursorCacheSize");
                this.m_cachedCursorLimit = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_oracleCursorCache = new short[this.m_cachedCursorLimit];
            String string5 = null;
            try {
                string5 = this.connectProps.get("describeAtPrepare");
                if (Integer.parseInt(string5) == 1) {
                    this.describeAtPrepare = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string6 = null;
            try {
                string6 = this.connectProps.get("stringParamsMustMatchCharColumns");
                if (string6.equalsIgnoreCase("false")) {
                    this.stringParamsMustMatchCharColumns = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string7 = null;
            try {
                string7 = this.connectProps.get("initialColumnBufferSize");
                this.initialColumnBufferSize = Integer.parseInt(string7);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string8 = null;
            try {
                string8 = this.connectProps.get("supportLinks");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string8 != null && string8.equalsIgnoreCase("true")) {
                this.supportLinks = true;
            }
            String string9 = null;
            try {
                string9 = this.connectProps.get("WireProtocolMode");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string9 != null) {
                try {
                    this.useOAll7 = Integer.parseInt(string9) == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string10 = null;
            try {
                string10 = this.connectProps.get("sendFloatParametersAsString");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string10 != null && string10.equalsIgnoreCase("true")) {
                this.sendFloatParametersAsString = true;
            }
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                this.allowMaxFloat = true;
            }
            this.refCursorSupport = !this.connectProps.get("refCursorSupport").equalsIgnoreCase("false");
            this.FetchTSWTZasTimestamp = this.connectProps.get("FetchTSWTZasTimestamp").equalsIgnoreCase("true");
            try {
                this.connectAndAuthenticate(string, 1);
            }
            catch (Exception exception) {
                if (this.authenticationMethod == 0) {
                    try {
                        this.setConnectionStatus(2);
                        this.connectAndAuthenticate(string, 2);
                    }
                    catch (Exception exception2) {
                        try {
                            this.setConnectionStatus(2);
                            this.connectAndAuthenticate(string, 3);
                            break block43;
                        }
                        catch (Exception exception3) {
                            try {
                                this.setConnectionStatus(2);
                                this.connectAndAuthenticate(string, 4);
                                break block43;
                            }
                            catch (UtilException utilException) {
                                throw this.exceptions.getException((Exception)((Object)utilException));
                            }
                        }
                    }
                }
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                throw this.exceptions.getException(exception);
            }
        }
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        if (timeZone.inDaylightTime(new Date())) {
            n += 3600000;
        }
        timeZone = null;
        this.m_offsethours = n / 3600000;
        this.m_offsetminutes = (n - this.m_offsethours * 3600000) / 60000;
        if (this.m_offsetminutes < 0) {
            this.m_offsetminutes = -this.m_offsetminutes;
        }
        this.alterSessionParams();
        try {
            String[] stringArray;
            String string = this.mapOraCharsetToName(this.originalReportedOraNCharset);
            if (string == null) {
                stringArray = new String[]{"character set " + this.originalReportedOraNCharset};
                this.warnings.add(7033, stringArray);
                string = "UTF8";
            }
            stringArray = UtilTransliterator.GetNewTransliterator((String)string);
            this.comm.transliteratorForNationalCharset = stringArray;
            this.comm.getReader().setTransliteratorForNationalCharacterSet((UtilTransliterator)stringArray);
            this.comm.getWriter().setTransliteratorForNationalCharacterSet((UtilTransliterator)stringArray);
        }
        catch (UtilException utilException) {
            // empty catch block
        }
        this.m_orgUser = this.m_user = this.getUsernameFromServer();
        if (this.oracleServerVersion >= 900000000L) {
            this.databaseTimeZone = this.getDatabaseTimeZone();
            this.computeTimeZoneHoursAndMinutes();
        }
    }

    private void alterSessionParams() throws SQLException {
        String[] stringArray;
        Object object;
        Object object2;
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this);
        tTIFUN_OALL8.setCursorID(this.m_cursorID);
        tTIFUN_OALL8.setOptions(32801);
        tTIFUN_OALL8.setCommandText("ALTER SESSION SET TIME_ZONE = '" + this.m_offsethours + ":" + this.m_offsetminutes + "'");
        tTIFUN_OALL8.setParameters(null);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        int n = this.processReply(tTIFUN_OALL8);
        if (this.gTTIoer.retCode == 0) {
            this.sessionTimeZone = this.m_offsethours + ":" + this.m_offsetminutes;
            this.m_cursorID = tTIFUN_OALL8.getCursorID();
            object2 = " ALTER SESSION SET NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM' ";
            object = System.getProperty("user.language");
            stringArray = System.getProperty("user.country");
            if (((String)object).equalsIgnoreCase("ja") && (stringArray == null || stringArray.equalsIgnoreCase("JP"))) {
                object2 = (String)object2 + " NLS_LANGUAGE = 'JAPANESE' ";
                object2 = (String)object2 + " NLS_TERRITORY = 'JAPAN' ";
            }
            tTIFUN_OALL8.setCommandText((String)object2);
            tTIFUN_OALL8.setParameters(null);
            this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            n = this.processReply(tTIFUN_OALL8);
        }
        if (this.gTTIoer.retCode != 0) {
            object2 = new String[]{this.gTTIoer.errMsg};
            object = this.comm.exceptions.getException(6001, (String[])object2, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            this.comm.close();
            throw object;
        }
        if (this.oracleServerVersion >= 1002000000L) {
            object2 = null;
            try {
                object2 = this.connectProps.get("commitBehavior");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object2 != null) {
                object = null;
                if (((String)object2).equalsIgnoreCase("waitImmediate")) {
                    object = "IMMEDIATE,WAIT";
                } else if (((String)object2).equalsIgnoreCase("waitBatch")) {
                    object = "BATCH,WAIT";
                } else if (((String)object2).equalsIgnoreCase("noWaitImmediate")) {
                    object = "IMMEDIATE,NOWAIT";
                } else if (((String)object2).equalsIgnoreCase("noWaitBatch")) {
                    object = "BATCH,NOWAIT";
                }
                if (object != null) {
                    tTIFUN_OALL8.setCommandText("ALTER SESSION SET COMMIT_WRITE='" + (String)object + "'");
                    tTIFUN_OALL8.setParameters(null);
                    this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    this.processReply(tTIFUN_OALL8);
                    if (this.gTTIoer.retCode != 0) {
                        stringArray = new String[]{this.gTTIoer.errMsg};
                        this.warnings.add(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
                    }
                }
            }
        }
    }

    private void setCurrentSession(String string, String string2) throws SQLException {
        TTIFUN_OSES tTIFUN_OSES = new TTIFUN_OSES(string, string2);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OSES);
        this.m_currOracleSessionId = string;
        this.m_currOracleSerialNum = string2;
    }

    protected boolean supportsReauthentication() {
        return true;
    }

    protected String getCurrentUser() throws SQLException {
        return this.getUser();
    }

    protected void setCurrentUser(String string, Properties properties) throws SQLException {
        if ((string = string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' ? string.substring(1, string.length() - 1) : string.toUpperCase()).compareTo(this.m_user) == 0) {
            return;
        }
        this.freeAllCursors();
        this.freeCursor(this.m_cursorID);
        this.m_cursorID = 0;
        if (!this.m_user.equalsIgnoreCase(this.m_orgUser)) {
            this.sendLogoff();
            this.m_user = this.m_orgUser;
            this.m_currOracleSessionId = this.m_orgOracleSessionId;
            this.m_currOracleSerialNum = this.m_orgOracleSerialNum;
        }
        TTIFUN_OAUTHENTICATE tTIFUN_OAUTHENTICATE = new TTIFUN_OAUTHENTICATE(string, this.wireCSmatchesOracleCS, this.supportLinks, TTIFUN_OAUTHENTICATE.LOGINMODE_REAUTHENTICATE);
        tTIFUN_OAUTHENTICATE.setSessionId(this.m_orgOracleSessionId);
        tTIFUN_OAUTHENTICATE.setSerialNum(this.m_orgOracleSerialNum);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OAUTHENTICATE);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.gTTIoer.retCode = 0;
        this.processReply(tTIFUN_OAUTHENTICATE);
        if (this.gTTIoer.retCode != 0) {
            this.setCurrentSession(this.m_orgOracleSessionId, this.m_orgOracleSerialNum);
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw this.myException;
        }
        this.m_currOracleSessionId = tTIFUN_OAUTHENTICATE.getSessionId();
        this.m_currOracleSerialNum = tTIFUN_OAUTHENTICATE.getSerialNum();
        this.m_user = this.getUsernameFromServer();
        this.alterSessionParams();
        this.setTransactionIsolation(this.connection.getTransactionIsolation());
    }

    protected void resetUser() throws SQLException {
        if (this.m_currOracleSessionId != this.m_orgOracleSessionId || this.m_currOracleSerialNum != this.m_orgOracleSerialNum) {
            this.freeAllCursors();
            this.freeCursor(this.m_cursorID);
            this.m_cursorID = 0;
            this.sendLogoff();
            this.setCurrentSession(this.m_orgOracleSessionId, this.m_orgOracleSerialNum);
            this.m_user = this.m_orgUser;
            this.m_currOracleSessionId = this.m_orgOracleSessionId;
            this.m_currOracleSerialNum = this.m_orgOracleSerialNum;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectAndAuthenticate(String string, int n) throws UtilException, SQLException {
        Object object;
        Object object2;
        block70: {
            this.gTTIoer = new TTIOERDataPacket(this);
            this.m_cursorID = 0;
            boolean bl = this.m_user != null && this.m_user.length() > 0;
            boolean bl2 = string != null && string.length() > 0;
            if (this.authenticationMethodArg.equalsIgnoreCase("ntlm")) {
                this.authenticationMethod = 0;
                this.m_user = "";
            } else if (this.authenticationMethodArg.equalsIgnoreCase("type2")) {
                this.authenticationMethod = bl ? 2 : 0;
            } else if (this.authenticationMethodArg.equalsIgnoreCase("client")) {
                this.authenticationMethod = 1;
                this.m_user = "";
            } else if (this.authenticationMethodArg.equalsIgnoreCase("kerberos")) {
                this.authenticationMethod = 3;
                this.m_user = "";
            } else {
                if (this.authenticationMethodArg.equalsIgnoreCase("KerberosUIDPassword")) {
                    if (bl && bl2) {
                        this.authenticationMethod = 4;
                        break block70;
                    } else {
                        String[] stringArray = new String[]{"'" + this.authenticationMethodArg + "'"};
                        throw this.exceptions.getException(7035, stringArray);
                    }
                }
                if (this.authenticationMethodArg.equalsIgnoreCase("UserIdPassword") || this.authenticationMethodArg.equalsIgnoreCase("none")) {
                    if (bl && bl2) {
                        this.authenticationMethod = 2;
                        break block70;
                    } else {
                        String[] stringArray = new String[]{"'" + this.authenticationMethodArg + "'"};
                        throw this.exceptions.getException(7035, stringArray);
                    }
                }
                if (this.authenticationMethodArg.equalsIgnoreCase("auto")) {
                    if (bl && bl2) {
                        this.authenticationMethod = 2;
                    } else {
                        object2 = System.getProperty("os.name");
                        if (object2 != null && ((String)object2).indexOf("Windows") != -1) {
                            try {
                                this.securityContext = UtilSecurityContextCreator.createType2SecurityContext((String)this.m_user, (int)2, (String)this.connection.getLoadLibraryPath());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.authenticationMethod = this.securityContext != null ? 0 : 3;
                        } else {
                            this.authenticationMethod = 3;
                        }
                    }
                }
            }
        }
        this.makeConnection();
        this.NSPTDAPacket = new OracleNet8NSPTDAPacket(this.comm);
        object2 = new TTIANODataPacket(this.exceptions);
        if (this.authenticationMethod == 3 || this.authenticationMethod == 4) {
            ((TTIANODataPacket)object2).useKerberosAuthentication();
            ((TTIANODataPacket)object2).kerberosStep = 1;
            this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object2);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            if (this.NSPTDAPacket.connectionWasAbortedByServer) {
                throw this.exceptions.getException(7050);
            }
            if (this.NSPTDAPacket.getNextTTCCode() != -34) {
                this.comm.close();
                throw this.exceptions.getException(7002, "08001");
            }
            this.NSPTDAPacket.getNextNextTTISubpacket((TTIDataPacket)object2);
            ((TTIANODataPacket)object2).kerberosStep = 2;
            this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object2);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            if (this.NSPTDAPacket.getNextTTCCode() != -34) {
                this.comm.close();
                throw this.exceptions.getException(7002, "08001");
            }
            this.NSPTDAPacket.getNextNextTTISubpacket((TTIDataPacket)object2);
            ((TTIANODataPacket)object2).kerberosStep = 3;
            this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object2);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            if (this.NSPTDAPacket.getNextTTCCode() != -34) {
                this.comm.close();
                throw this.exceptions.getException(7002, "08001");
            }
            this.NSPTDAPacket.getNextNextTTISubpacket((TTIDataPacket)object2);
            ((TTIANODataPacket)object2).kerberosStep = 4;
            this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object2);
            this.NSPTDAPacket.getNextNextTTISubpacket((TTIDataPacket)object2);
            this.NSPTDAPacket.sendRequestNoReply();
        } else if (this.authenticationMethod == 0) {
            try {
                switch (n) {
                    case 2: {
                        ((TTIANODataPacket)object2).ANO3Triplet = ((TTIANODataPacket)object2).ANO3Triplet2;
                        ((TTIANODataPacket)object2).ANO4Triplet = ((TTIANODataPacket)object2).ANO4Triplet2;
                        break;
                    }
                    case 3: {
                        ((TTIANODataPacket)object2).ANO3Triplet = ((TTIANODataPacket)object2).ANO3Triplet2;
                        ((TTIANODataPacket)object2).ANO4Triplet = ((TTIANODataPacket)object2).ANO4Triplet3;
                        break;
                    }
                    case 4: {
                        ((TTIANODataPacket)object2).ANO3Triplet = ((TTIANODataPacket)object2).ANO3Triplet3;
                        ((TTIANODataPacket)object2).ANO4Triplet = ((TTIANODataPacket)object2).ANO4Triplet4;
                        break;
                    }
                }
                this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object2);
                this.NSPTDAPacket.sendRequest();
                this.NSPTDAPacket.receiveReply();
                if (this.NSPTDAPacket.getNextTTCCode() != -34) {
                    this.comm.close();
                    throw this.exceptions.getException(7002, "08001");
                }
                this.NSPTDAPacket.getNextNextTTISubpacket((TTIDataPacket)object2);
                if (((TTIANODataPacket)object2).packetType == 1) {
                    this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object2);
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    if (this.NSPTDAPacket.getNextTTCCode() != -34) {
                        this.comm.close();
                        throw this.exceptions.getException(7002, "08001");
                    }
                    this.NSPTDAPacket.getNextNextTTISubpacket((TTIDataPacket)object2);
                }
                if (this.securityContext == null) {
                    this.securityContext = UtilSecurityContextCreator.createType2SecurityContext((String)this.m_user, (int)2, (String)this.connection.getLoadLibraryPath());
                }
                int n2 = 2049;
                ((TTIANODataPacket)object2).clientSecurityToken = this.securityContext.getSecurityToken2(null, n2);
                this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object2);
                this.NSPTDAPacket.sendRequest();
                this.NSPTDAPacket.receiveReply();
                if (this.NSPTDAPacket.getNextTTCCode() != -34) {
                    this.comm.close();
                    throw this.exceptions.getException(7002, "08001");
                }
                this.NSPTDAPacket.getNextNextTTISubpacket((TTIDataPacket)object2);
                ((TTIANODataPacket)object2).clientSecurityToken = this.securityContext.getSecurityToken2(((TTIANODataPacket)object2).serverSecurityToken, n2);
                this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object2);
                this.NSPTDAPacket.sendRequestNoReply();
            }
            catch (UtilException utilException) {
                throw this.exceptions.getException((Exception)((Object)utilException));
            }
        }
        TTIPRODataPacket tTIPRODataPacket = new TTIPRODataPacket(8);
        this.NSPTDAPacket.appendTTISubPacket(tTIPRODataPacket);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        if (this.NSPTDAPacket.getNextTTCCode() != 1) {
            this.comm.close();
            throw this.exceptions.getException(7002, "08001");
        }
        this.NSPTDAPacket.getNextNextTTISubpacket(tTIPRODataPacket);
        this.originalReportedOraCharset = this.currentOraCharset = (short)tTIPRODataPacket.srvCharSet;
        this.originalReportedOraNCharset = tTIPRODataPacket.originalReportedOraNCharset;
        String string2 = null;
        String string3 = this.connectProps.get("codePageOverride");
        if (string3 != null && !string3.equals("")) {
            this.currentOraCharset = this.mapCodePageOverrideToOraCharset(string3);
            string2 = this.mapCodePageOverrideToName(string3);
        } else {
            string2 = this.mapOraCharsetToName(this.currentOraCharset);
            if (string2 == null) {
                string2 = "UTF8";
            }
        }
        if (string2.equalsIgnoreCase("UTF8")) {
            int n3 = string3.toUpperCase().indexOf(OVERRIDE_NOCONVERT);
            if (!this.isUTF8CharacterSet(this.originalReportedOraCharset) && n3 == -1) {
                this.currentOraCharset = (short)871;
            }
            this.transliterator = new UtilTransliteratorForUTF8();
        } else {
            try {
                this.transliterator = UtilTransliterator.GetNewTransliterator((String)string2);
            }
            catch (UtilException utilException) {
                String[] stringArray = new String[]{string2};
                this.warnings.add(7033, stringArray);
                String[] stringArray2 = new String[]{utilException.getMessage()};
                this.warnings.add(6001, stringArray2);
                this.currentOraCharset = (short)871;
                this.transliterator = new UtilTransliteratorForUTF8();
            }
        }
        if (this.currentOraCharset == 871 && this.useOAll7) {
            this.warnings.add(7041);
            this.useOAll7 = false;
        }
        if (this.currentOraCharset == this.originalReportedOraCharset) {
            this.wireCSmatchesOracleCS = true;
        } else {
            tTIPRODataPacket.srvFlags = 2;
            this.wireCSmatchesOracleCS = false;
        }
        this.japaneseAsUTF8 = (this.originalReportedOraCharset == 830 || this.originalReportedOraCharset == 832 || this.originalReportedOraCharset == 834 || this.originalReportedOraCharset == 838) && !this.wireCSmatchesOracleCS;
        this.comm.transliterator = this.transliterator;
        this.comm.getReader().setTransliterator(this.transliterator);
        this.comm.getWriter().setTransliterator(this.transliterator);
        TTIDTYDataPacket tTIDTYDataPacket = new TTIDTYDataPacket();
        tTIDTYDataPacket.cliRIn = this.currentOraCharset;
        tTIDTYDataPacket.cliRout = this.currentOraCharset;
        tTIDTYDataPacket.flags = (byte)tTIPRODataPacket.srvFlags;
        this.NSPTDAPacket.appendTTISubPacket(tTIDTYDataPacket);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        if (this.NSPTDAPacket.getNextTTCCode() != 2) {
            this.comm.close();
            throw this.exceptions.getException(7002, "08001");
        }
        this.NSPTDAPacket.getNextNextTTISubpacket(tTIDTYDataPacket);
        TTIFUN_OVERSION tTIFUN_OVERSION = new TTIFUN_OVERSION(this.wireCSmatchesOracleCS);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OVERSION);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.gTTIoer.retCode = 0;
        this.processReply(tTIFUN_OVERSION);
        if (this.gTTIoer.retCode == 0) {
            this.oracleServerVersionString = tTIFUN_OVERSION.RdbmsVersion;
            int n4 = this.oracleServerVersionString.indexOf("Release ") + 8;
            int n5 = this.oracleServerVersionString.indexOf(" -", n4);
            if (n4 > 0 && n5 > 0 && n5 > n4) {
                this.oracleServerVersionString = this.oracleServerVersionString.substring(n4, n5);
            } else {
                UtilDebug.assert((String)"cannot extract version number from Version Info", (boolean)false);
                this.oracleServerVersionString = "8.0.0.0.0";
            }
            try {
                object = new String[5];
                int n6 = 0;
                int n7 = this.oracleServerVersionString.indexOf(46);
                object[0] = this.oracleServerVersionString.substring(n6, n7);
                for (int i = 1; i <= 3; ++i) {
                    n6 = n7 + 1;
                    n7 = this.oracleServerVersionString.indexOf(46, n6 + 1);
                    object[i] = this.oracleServerVersionString.substring(n6, n7);
                }
                n6 = n7 + 1;
                n7 = this.oracleServerVersionString.indexOf(46, n6 + 1);
                object[4] = this.oracleServerVersionString.substring(n6, this.oracleServerVersionString.length());
                this.oracleServerVersion = Integer.parseInt(object[0]) * 100000000 + Integer.parseInt(object[1]) * 1000000 + Integer.parseInt(object[2]) * 10000 + Integer.parseInt(object[3]) * 100 + Integer.parseInt((String)object[4]);
            }
            catch (Exception exception) {
                UtilDebug.assert((String)"expecting 5 parts in version number string", (boolean)false);
                this.oracleServerVersion = 800000000L;
            }
        }
        this.maxLocatorLength = this.oracleServerVersion < 1000000000L ? 86 : 4000;
        this.maxBytesPerCharForOriginalReportedOraCharset = this.maxBytesPerChar(this.originalReportedOraCharset);
        this.maxBytesPerCharForOriginalReportedOraNationalCharset = this.maxBytesPerChar(this.originalReportedOraNCharset);
        this.largestAllowableMaxLengthValueForVARCHARandRAWParams = this.useOAll7 || this.oracleServerVersion < 801070000L ? 4000 : Integer.MAX_VALUE;
        if (this.oracleServerVersion < 902000400L) {
            this.thresholdForTreatingCharParamsAsLong = 4000 / this.maxBytesPerCharForOriginalReportedOraCharset;
            this.thresholdForTreatingCharParamsAsLongForNationalCharset = 4000 / this.maxBytesPerCharForOriginalReportedOraNationalCharset;
        } else {
            this.thresholdForTreatingCharParamsAsLong = 4000;
            this.thresholdForTreatingCharParamsAsLongForNationalCharset = 4000;
        }
        this.writeCharParamAtEndOfRXDThreshold = this.wireCSmatchesOracleCS ? 4000 : 4000 / this.maxBytesPerCharForOriginalReportedOraCharset;
        int n8 = 0;
        String string4 = null;
        try {
            string4 = this.connectProps.get("sysLoginRole");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string4 != null) {
            if (string4.equalsIgnoreCase("SYSDBA")) {
                n8 = TTIFUN_OAUTHENTICATE.LOGINMODE_SYSDBA;
            } else if (string4.equalsIgnoreCase("SYSOPER")) {
                n8 = TTIFUN_OAUTHENTICATE.LOGINMODE_SYSOPER;
            }
        }
        object = new TTIFUN_OAUTHENTICATE(this.m_user, this.wireCSmatchesOracleCS, this.supportLinks, n8);
        this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.gTTIoer.retCode = 0;
        this.processReply((TTIFUNDataPacket)object);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            this.comm.close();
            throw this.myException;
        }
        if (this.authenticationMethod != 2 && this.authenticationMethod != 4) {
            this.m_orgOracleSessionId = this.m_currOracleSessionId = ((TTIFUN_OAUTHENTICATE)object).getSessionId();
            this.m_orgOracleSerialNum = this.m_currOracleSerialNum = ((TTIFUN_OAUTHENTICATE)object).getSerialNum();
            return;
        }
        byte[] byArray = this.encryptPassword(this.m_user, string, ((TTIFUN_OAUTHENTICATE)object).getEncryptionKey());
        ((TTIFUN_OAUTHENTICATE)object).setEncryptedPassword(byArray);
        this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.gTTIoer.retCode = 0;
        this.processReply((TTIFUNDataPacket)object);
        if (this.gTTIoer.retCode == 0) {
            this.m_orgOracleSessionId = this.m_currOracleSessionId = ((TTIFUN_OAUTHENTICATE)object).getSessionId();
            this.m_orgOracleSerialNum = this.m_currOracleSerialNum = ((TTIFUN_OAUTHENTICATE)object).getSerialNum();
            return;
        }
        String[] stringArray = new String[]{this.gTTIoer.errMsg};
        this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
        this.comm.close();
        throw this.myException;
    }

    private String getColumnValueFromDatabase(String string) {
        try {
            TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this);
            tTIFUN_OALL8.setOptions(32865);
            tTIFUN_OALL8.setCommandText(string);
            tTIFUN_OALL8.setParameters(null);
            tTIFUN_OALL8.setIsSelect(true);
            tTIFUN_OALL8.setCursorID(this.m_cursorID);
            this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            int n = this.processReply(tTIFUN_OALL8);
            if (n == 16) {
                TTIDCBDataPacket tTIDCBDataPacket = new TTIDCBDataPacket(this);
                this.NSPTDAPacket.getNextNextTTISubpacket(tTIDCBDataPacket);
                BaseColumn[] baseColumnArray = tTIDCBDataPacket.getColumns();
                n = this.processReply(tTIFUN_OALL8);
                if (n == 6) {
                    this.NSPTDAPacket.getNextNextTTISubpacket(new TTIRXHDataPacket());
                    n = this.processReply(tTIFUN_OALL8);
                    if (n == 7) {
                        TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(this, false, baseColumnArray);
                        this.NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
                        OracleColumn oracleColumn = (OracleColumn)baseColumnArray[0];
                        return this.comm.transliterator.decode(oracleColumn.data, 0, oracleColumn.data.length);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public BaseColumn[] getColumnDescriptionsFromDatabase(String string) {
        try {
            TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this);
            tTIFUN_OALL8.setOptions(32801);
            tTIFUN_OALL8.setCommandText(string);
            tTIFUN_OALL8.setParameters(null);
            tTIFUN_OALL8.setIsSelect(true);
            tTIFUN_OALL8.setArraySize(0);
            tTIFUN_OALL8.setCursorID(this.m_cursorID);
            this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            int n = this.processReply(tTIFUN_OALL8);
            if (n == 16) {
                TTIDCBDataPacket tTIDCBDataPacket = new TTIDCBDataPacket(this);
                this.NSPTDAPacket.getNextNextTTISubpacket(tTIDCBDataPacket);
                return tTIDCBDataPacket.getColumns();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getUsernameFromServer() {
        return this.getColumnValueFromDatabase("select USER from DUAL");
    }

    private String getDatabaseTimeZone() {
        return this.getColumnValueFromDatabase("select TZ_OFFSET(DBTIMEZONE) from dual");
    }

    private void getSessionTimeZone() {
        this.sessionTimeZone = this.getColumnValueFromDatabase("select TZ_OFFSET(sessiontimezone) from dual");
    }

    private void computeTimeZoneHoursAndMinutes() {
        try {
            int n = this.databaseTimeZone.indexOf(58);
            String string = this.databaseTimeZone.substring(0, n);
            boolean bl = false;
            if (string.charAt(0) == '-') {
                bl = true;
                string = string.substring(1);
            } else if (string.charAt(0) == '+') {
                string = string.substring(1);
            }
            int n2 = Integer.parseInt(string);
            String string2 = this.databaseTimeZone.substring(n + 1);
            char c = string2.charAt(string2.length() - 1);
            if (c < '0' || c > '9') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            int n3 = Integer.parseInt(string2);
            int n4 = this.sessionTimeZone.indexOf(58);
            String string3 = this.sessionTimeZone.substring(0, n4);
            boolean bl2 = false;
            if (string3.charAt(0) == '-') {
                bl2 = true;
                string3 = string3.substring(1);
            } else if (string3.charAt(0) == '+') {
                string3 = string3.substring(1);
            }
            int n5 = Integer.parseInt(string3);
            String string4 = this.sessionTimeZone.substring(n4 + 1);
            c = string4.charAt(string4.length() - 1);
            if (c < '0' || c > '9') {
                string4 = string4.substring(0, string4.length() - 1);
            }
            int n6 = Integer.parseInt(string4);
            int n7 = 0;
            n7 = bl ? -n2 * 60 - n3 : n2 * 60 + n3;
            int n8 = 0;
            n8 = bl2 ? -n5 * 60 - n6 : n5 * 60 + n6;
            int n9 = n8 - n7;
            this.tzHours = n9 / 60;
            this.tzMinutes = n9 % 60;
        }
        catch (Exception exception) {
            this.warnings.add(7043);
        }
    }

    public int getTimeZoneHours() {
        if (this.alterStatementHasBeenIssued) {
            this.getSessionTimeZone();
            this.computeTimeZoneHoursAndMinutes();
            this.alterStatementHasBeenIssued = false;
        }
        return this.tzHours;
    }

    public int getTimeZoneMinutes() {
        if (this.alterStatementHasBeenIssued) {
            this.getSessionTimeZone();
            this.computeTimeZoneHoursAndMinutes();
            this.alterStatementHasBeenIssued = false;
        }
        return this.tzMinutes;
    }

    private short mapCodePageOverrideToOraCharset(String string) throws SQLException {
        int n = string.toUpperCase().indexOf(OVERRIDE_NOCONVERT);
        if (n >= 0) {
            this.codepageOverrideNoConvert = true;
            return this.currentOraCharset;
        }
        if (string.equalsIgnoreCase("SJIS") || string.equalsIgnoreCase("MS932") || string.equalsIgnoreCase("ENHANCED_SJIS") || string.equalsIgnoreCase("ENHANCED_SJIS_ORACLE")) {
            switch (this.currentOraCharset) {
                case 838: {
                    return 838;
                }
                case 834: {
                    return 834;
                }
            }
            return 832;
        }
        if (string.equalsIgnoreCase("UTF8")) {
            if (this.isUTF8CharacterSet(this.originalReportedOraCharset)) {
                return this.originalReportedOraCharset;
            }
            return 871;
        }
        String[] stringArray = new String[]{string};
        throw this.exceptions.getException(7032, stringArray);
    }

    private String mapCodePageOverrideToName(String string) throws SQLException {
        String string2 = string;
        int n = string.toUpperCase().indexOf(OVERRIDE_NOCONVERT);
        if (n >= 0) {
            string = string.substring(0, n).trim();
        }
        if (string.equalsIgnoreCase("SJIS")) {
            return "ORACLE_SJIS";
        }
        if (string.equalsIgnoreCase("ENHANCED_SJIS")) {
            return "CUSTOM_ICU_SJIS";
        }
        if (string.equalsIgnoreCase("ENHANCED_SJIS_ORACLE")) {
            return "CUSTOM_ICU_SJIS_MS932_BIAS";
        }
        if (string.equalsIgnoreCase("MS932")) {
            return string;
        }
        if (string.equalsIgnoreCase("UTF8")) {
            return string;
        }
        if (n >= 0) {
            return string;
        }
        String[] stringArray = new String[]{string2};
        throw this.exceptions.getException(7032, stringArray);
    }

    private String mapOraCharsetToName(short s) {
        String string = null;
        switch (s) {
            case 1: 
            case 31: {
                string = "ISO8859-1";
                break;
            }
            case 32: {
                string = "ISO8859-2";
                break;
            }
            case 33: {
                string = "ISO8859-3";
                break;
            }
            case 34: {
                string = "ISO8859-4";
                break;
            }
            case 35: {
                string = "ISO8859-5";
                break;
            }
            case 36: {
                string = "ISO8859-6";
                break;
            }
            case 37: {
                string = "ISO8859-7";
                break;
            }
            case 38: {
                string = "ISO8859-8";
                break;
            }
            case 39: {
                string = "ISO8859-9";
                break;
            }
            case 46: {
                string = "ISO8859-15";
                break;
            }
            case 167: {
                string = "ORA167";
                break;
            }
            case 178: {
                string = "1252";
                break;
            }
            case 180: {
                string = "273";
                break;
            }
            case 183: {
                string = "278";
                break;
            }
            case 181: {
                string = "280";
                break;
            }
            case 8: {
                string = "285";
                break;
            }
            case 186: {
                string = "297";
                break;
            }
            case 6: {
                string = "500";
                break;
            }
            case 10: {
                string = "850";
                break;
            }
            case 5: {
                string = "37";
                break;
            }
            case 261: 
            case 351: 
            case 352: {
                string = "ROMAN8";
                break;
            }
            case 832: {
                string = "CUSTOM_ICU_SJIS_MS932_BIAS";
                break;
            }
            case 834: {
                string = "CUSTOM_ICU_SJISYEN_MS932_BIAS";
                break;
            }
            case 838: {
                string = "CUSTOM_ICU_SJISTILDE_MS932_BIAS";
                break;
            }
            case 830: {
                string = "EUCJP";
                break;
            }
            case 840: {
                string = "EUC_KR";
                break;
            }
            case 846: {
                string = "MS949";
                break;
            }
            case 852: {
                string = "GBK";
                break;
            }
            case 865: {
                string = "BIG5";
                break;
            }
            case 174: {
                string = "1253";
                break;
            }
            case 2000: {
                string = "UCS2";
                break;
            }
            case 870: 
            case 871: 
            case 872: 
            case 873: {
                string = "UTF8";
            }
        }
        return string;
    }

    boolean isUTF8CharacterSet(int n) {
        switch (n) {
            case 870: 
            case 871: 
            case 872: 
            case 873: {
                return true;
            }
        }
        return false;
    }

    protected byte[] encryptPassword(String string, String string2, byte[] byArray) throws SQLException {
        int n;
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        if (string2 != null && string2.length() > 2 && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        int n2 = (n = string2.length()) % 8 > 0 ? 8 - n % 8 : 0;
        boolean bl = this.originalReportedOraCharset >= 800;
        C1 c1 = new C1();
        byte[] byArray2 = c1.m(string, string2, bl);
        byte[] byArray3 = c1.j(byArray2, byArray);
        byte[] byArray4 = new byte[n + n2];
        byte[] byArray5 = null;
        try {
            byArray5 = this.comm.transliterator.encode(string2);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(7003, "08001");
        }
        System.arraycopy(byArray5, 0, byArray4, 0, n);
        byte[] byArray6 = c1.c(byArray3, byArray4);
        byte[] byArray7 = new byte[2 * byArray4.length + 1];
        if (byArray7.length < 2 * byArray6.length) {
            throw this.exceptions.getException(7003, "08001");
        }
        for (int i = 0; i < byArray6.length; ++i) {
            byArray7[i * 2] = this.nibbleToHex((byte)((byArray6[i] & 0xF0) >> 4));
            byArray7[i * 2 + 1] = this.nibbleToHex((byte)(byArray6[i] & 0xF));
        }
        byArray7[byArray7.length - 1] = this.nibbleToHex((byte)n2);
        return byArray7;
    }

    private byte nibbleToHex(byte by) {
        return (byte)((by = (byte)(by & 0xF)) >= 10 ? by - 10 + 65 : by + 48);
    }

    protected void makeConnection() throws SQLException {
        String string = this.connectProps.get("serverName");
        String string2 = this.connectProps.get("portNumber");
        String string3 = this.connectProps.get("SID");
        String string4 = this.connectProps.get("serviceName");
        String string5 = this.connectProps.get("serverType");
        String string6 = this.connectProps.get("TNSNamesFile");
        String string7 = this.connectProps.get("TNSServerName");
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        if (string6 != null && string6.length() == 0) {
            string6 = null;
        }
        if (string7 != null && string7.length() == 0) {
            string7 = null;
        }
        if (string3 != null) {
            if (string4 != null) {
                String[] stringArray = new String[]{"SID", "serviceName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string7 != null) {
                String[] stringArray = new String[]{"SID", "TNSServerName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string6 != null) {
                String[] stringArray = new String[]{"SID", "TNSNamesFile"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string == null) {
                String[] stringArray = new String[]{"SID", "serverName"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        if (string4 != null) {
            if (string7 != null) {
                String[] stringArray = new String[]{"serviceName", "TNSServerName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string6 != null) {
                String[] stringArray = new String[]{"serviceName", "TNSNamesFile"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string == null) {
                String[] stringArray = new String[]{"serviceName", "serverName"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        if (string7 != null) {
            if (string != null) {
                String[] stringArray = new String[]{"TNSServerName", "serverName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string5 != null) {
                String[] stringArray = new String[]{"TNSServerName", "serverType"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string6 == null) {
                String[] stringArray = new String[]{"TNSServerName", "TNSNamesFile"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        if (string6 != null) {
            if (string != null) {
                String[] stringArray = new String[]{"TNSNamesFile", "serverName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string5 != null) {
                String[] stringArray = new String[]{"tnsNamesFile", "serverType"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string7 == null) {
                String[] stringArray = new String[]{"TNSNamesFile", "TNSServerName"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        TnsConnectDescriptor tnsConnectDescriptor = null;
        if (string7 != null) {
            TnsDescriptionList tnsDescriptionList = TnsFile.CreateDescriptorList(string7, string6, this.exceptions);
            ArrayList arrayList = new ArrayList();
            tnsDescriptionList.CollectConnectDescriptors((int)(Math.random() * 100.0), arrayList, string7, this.exceptions);
            SQLException sQLException = null;
            SQLException sQLException2 = null;
            boolean bl = false;
            int n = 0;
            while (!bl && n < arrayList.size()) {
                tnsConnectDescriptor = (TnsConnectDescriptor)arrayList.get(n);
                try {
                    this.setConnectionStatus(2);
                    this.makeConnectionHelper(tnsConnectDescriptor, true);
                    bl = true;
                }
                catch (SQLException sQLException3) {
                    if (sQLException == null) {
                        sQLException = sQLException3;
                        sQLException2 = sQLException3;
                    } else {
                        sQLException2.setNextException(sQLException3);
                        sQLException2 = sQLException3;
                    }
                    ++n;
                }
            }
            if (!bl) {
                throw sQLException;
            }
        } else {
            if (string == null) {
                throw this.exceptions.getException(7012, "08001");
            }
            tnsConnectDescriptor = new TnsConnectDescriptor(string, string2, string4, string3, string5, this.exceptions);
            this.makeConnectionHelper(tnsConnectDescriptor, false);
        }
    }

    void makeConnectionHelper(TnsConnectDescriptor tnsConnectDescriptor, boolean bl) throws SQLException {
        Object object;
        Properties properties;
        Object object2;
        boolean bl2 = false;
        String string = tnsConnectDescriptor.getConnectString(this.cid);
        String string2 = tnsConnectDescriptor.getAddress().getHost();
        int n = tnsConnectDescriptor.getAddress().getPort();
        boolean bl3 = false;
        if (bl) {
            bl3 = tnsConnectDescriptor.getAddress().getProtocol() == TnsAddress.TNSPROTOCOL_TCPS;
        } else {
            object2 = this.connectProps.get("encryptionMethod");
            if (object2 != null && !((String)object2).equalsIgnoreCase("noEncryption") && ((String)object2).equalsIgnoreCase("SSL")) {
                bl3 = true;
            }
        }
        object2 = null;
        Properties properties2 = properties = this.connectProps.getProperties();
        try {
            if (bl3) {
                object = properties.getProperty("HOSTNAMEINCERTIFICATE");
                if (object != null && ((String)object).equalsIgnoreCase("#SERVERNAME#")) {
                    properties2 = new Properties(properties);
                    properties2.put("HOSTNAMEINCERTIFICATE", string2);
                }
                object2 = UtilSocketCreator.getSSLSocket((String)string2, (int)n, (Properties)properties2);
            } else {
                object2 = UtilSocketCreator.getSocket((String)string2, (int)n, (Properties)properties);
            }
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException), "08001");
        }
        this.comm = new OracleNet8Communication((Socket)object2, this, this.exceptions, this.warnings);
        block11: while (!bl2) {
            object = new OracleNet8NSPTCNPacket(this.comm, string.toString());
            if (this.authenticationMethod == 3 || this.authenticationMethod == 4) {
                ((OracleNet8NSPTCNPacket)object).useKerberosAuthentication = true;
            }
            if (this.authenticationMethod == 0) {
                ((OracleNet8NSPTCNPacket)object).setANOFlag(1);
            }
            ((OracleNet8NSPTCNPacket)object).submitRequest();
            int n2 = ((OracleNet8NSPTCNPacket)object).getReplyNSPTPacketType();
            switch (n2) {
                case 4: {
                    String[] stringArray;
                    OracleNet8NSPTRFPacket oracleNet8NSPTRFPacket = new OracleNet8NSPTRFPacket(this.comm);
                    oracleNet8NSPTRFPacket.receiveReply();
                    int n3 = oracleNet8NSPTRFPacket.userReason;
                    int n4 = oracleNet8NSPTRFPacket.errorString.indexOf("ERR=") + 4;
                    int n5 = oracleNet8NSPTRFPacket.errorString.indexOf(41, n4);
                    this.comm.close();
                    if (n4 > 0 && n5 > n4) {
                        stringArray = oracleNet8NSPTRFPacket.errorString.substring(n4, n5);
                        n3 = Integer.parseInt((String)stringArray);
                    }
                    stringArray = new String[1];
                    if (n3 == 12505) {
                        stringArray[0] = tnsConnectDescriptor.getConnectData().getSID();
                        throw this.comm.exceptions.getException(7028, stringArray, "08001", n3);
                    }
                    if (n3 == 12514) {
                        stringArray[0] = tnsConnectDescriptor.getConnectData().getServiceName();
                        throw this.comm.exceptions.getException(7034, stringArray, "08001", n3);
                    }
                    if (n3 == 12519 || n3 == 12515) {
                        stringArray[0] = String.valueOf(n3);
                        throw this.comm.exceptions.getException(7029, stringArray, "08001", n3);
                    }
                    stringArray[0] = oracleNet8NSPTRFPacket.errorString;
                    throw this.comm.exceptions.getException(7027, stringArray, "08001", n3);
                }
                case 5: {
                    OracleNet8NSPTRDPacket oracleNet8NSPTRDPacket = new OracleNet8NSPTRDPacket(this.comm);
                    oracleNet8NSPTRDPacket.receiveReply();
                    tnsConnectDescriptor = new TnsConnectDescriptor(tnsConnectDescriptor, oracleNet8NSPTRDPacket.conString);
                    string = tnsConnectDescriptor.getConnectString(this.cid);
                    string2 = tnsConnectDescriptor.getAddress().getHost();
                    n = tnsConnectDescriptor.getAddress().getPort();
                    this.comm.close();
                    try {
                        object2 = bl3 ? UtilSocketCreator.getSSLSocket((String)string2, (int)n, (Properties)properties2) : UtilSocketCreator.getSocket((String)string2, (int)n, (Properties)properties);
                    }
                    catch (Exception exception) {
                        String[] stringArray = new String[]{string2, String.valueOf(n)};
                        SQLException sQLException = this.exceptions.getException(7040, stringArray, "08001");
                        sQLException.setNextException(this.exceptions.getException(exception));
                        throw sQLException;
                    }
                    this.comm = new OracleNet8Communication((Socket)object2, this, this.exceptions, this.warnings);
                    continue block11;
                }
                case 2: {
                    OracleNet8NSPTACPacket oracleNet8NSPTACPacket = new OracleNet8NSPTACPacket(this.comm);
                    oracleNet8NSPTACPacket.receiveReply();
                    this.byteOrder = oracleNet8NSPTACPacket.byteOrder;
                    this.comm.setMaxPacketSize(oracleNet8NSPTACPacket.maxPacketSize);
                    bl2 = true;
                    continue block11;
                }
                case 3: {
                    bl2 = true;
                    continue block11;
                }
                case 11: {
                    continue block11;
                }
            }
            throw this.exceptions.getException(7002, "08001");
        }
    }

    protected BaseImplStatement createImplStatement(int n, int n2) throws SQLException {
        return new OracleImplStatement(n, n2, this.comm, this);
    }

    public short getCursorID() throws SQLException {
        return this.m_cursorID;
    }

    protected void setSavepoint(String string) throws SQLException {
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this);
        tTIFUN_OALL8.setOptions(32801);
        tTIFUN_OALL8.setCommandText("SAVEPOINT " + string);
        tTIFUN_OALL8.setCursorID(this.m_cursorID);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OALL8);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            SQLException sQLException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw sQLException;
        }
    }

    protected void releaseSavepoint(String string) throws SQLException {
    }

    protected void rollbackTransaction(String string) throws SQLException {
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this);
        tTIFUN_OALL8.setOptions(32801);
        tTIFUN_OALL8.setCommandText("ROLLBACK TO SAVEPOINT " + string);
        tTIFUN_OALL8.setCursorID(this.m_cursorID);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OALL8);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            SQLException sQLException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw sQLException;
        }
    }

    protected void commitTransaction() throws SQLException {
        TTIFUN_OCOMMIT tTIFUN_OCOMMIT = new TTIFUN_OCOMMIT();
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OCOMMIT);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OCOMMIT);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw this.myException;
        }
    }

    protected void rollbackTransaction() throws SQLException {
        TTIFUN_OROLLBACK tTIFUN_OROLLBACK = new TTIFUN_OROLLBACK();
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OROLLBACK);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OROLLBACK);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw this.myException;
        }
    }

    public boolean requiresColDescriptionsForGeneratedKeys() {
        return true;
    }

    public boolean requiresUserId() {
        return false;
    }

    private void freeAllCursors() throws SQLException {
        for (int i = 0; i < this.m_cachedCursorLimit; ++i) {
            if (this.m_oracleCursorCache[i] == 0) continue;
            this.freeCursor(this.m_oracleCursorCache[i]);
            this.m_oracleCursorCache[i] = 0;
        }
    }

    private void sendLogoff() throws SQLException {
        TTIFUN_OLOGOFF tTIFUN_OLOGOFF = new TTIFUN_OLOGOFF();
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOGOFF);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OLOGOFF);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw this.myException;
        }
    }

    public void close() throws SQLException {
        try {
            this.freeAllCursors();
            this.sendLogoff();
            if (this.securityContext != null) {
                try {
                    this.securityContext.cleanup();
                }
                catch (UtilException utilException) {
                    throw this.exceptions.getException((Exception)((Object)utilException));
                }
            }
            this.comm.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() throws SQLException {
        this.transliterator.setDefaultCacheSize();
    }

    protected void stopManualTransactionMode() throws SQLException {
        this.commitTransaction();
    }

    public int processReply(TTIFUNDataPacket tTIFUNDataPacket) throws SQLException {
        return this.processReply(tTIFUNDataPacket, this.gTTIoer);
    }

    public int processReply(TTIFUNDataPacket tTIFUNDataPacket, TTIOERDataPacket tTIOERDataPacket) throws SQLException {
        boolean bl = false;
        tTIOERDataPacket.retCode = 0;
        block13: while (!bl) {
            int n = this.NSPTDAPacket.getNextTTCCode();
            switch (n) {
                case 9: {
                    if (this.oracleServerVersion >= 1000000000L) {
                        try {
                            int n2 = this.NSPTDAPacket.reader.readB4();
                        }
                        catch (UtilException utilException) {
                            throw this.exceptions.getException(7002, "08001");
                        }
                    }
                }
                case -1: {
                    bl = true;
                    break;
                }
                case 4: {
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIOERDataPacket);
                    bl = true;
                    break;
                }
                case 8: {
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIFUNDataPacket);
                    break;
                }
                case 11: {
                    TTIIOVDataPacket tTIIOVDataPacket = new TTIIOVDataPacket(null);
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIIOVDataPacket);
                    break;
                }
                case 6: 
                case 7: 
                case 14: 
                case 16: 
                case 21: {
                    return n;
                }
                case 15: {
                    try {
                        short s = this.NSPTDAPacket.reader.readB2();
                        short s2 = this.NSPTDAPacket.reader.readB2();
                        this.NSPTDAPacket.reader.readB2();
                        if (s2 <= 0) continue block13;
                        byte[] byArray = new byte[s2];
                        this.NSPTDAPacket.reader.readBytes(byArray, 0, s2);
                        String[] stringArray = new String[]{this.comm.transliterator.decode(byArray, 0, (int)s2)};
                        this.warnings.add(6001, stringArray, "01000", (int)s);
                        break;
                    }
                    catch (Exception exception) {
                        throw this.exceptions.getException(exception, "08001");
                    }
                }
                default: {
                    throw this.exceptions.getException(7002, "08001");
                }
            }
        }
        return 0;
    }

    protected boolean supportsRowId() {
        return true;
    }

    protected String[] getAggregateFunctions() {
        String[] stringArray = new String[]{"AVG", "COUNT", "FIRST", "LAST", "MAX", "MIN", "SUM"};
        return stringArray;
    }

    public int maxBytesPerChar(int n) {
        if (n < 800) {
            return 1;
        }
        switch (n) {
            case 830: 
            case 835: 
            case 837: 
            case 842: 
            case 853: 
            case 864: 
            case 870: 
            case 871: 
            case 996: 
            case 998: 
            case 9996: 
            case 9997: 
            case 9998: 
            case 9999: {
                return 3;
            }
            case 854: 
            case 860: 
            case 861: 
            case 863: 
            case 872: 
            case 873: 
            case 1863: {
                return 4;
            }
        }
        return 2;
    }

    protected String setClientApplicationName(String string) throws SQLException {
        if (string.length() > 64) {
            string = string.substring(0, 64);
        }
        if (this.oracleServerVersion >= 900000000L) {
            String string2 = "begin dbms_session.set_identifier('" + string + "'); end;";
            OracleImplStatement oracleImplStatement = (OracleImplStatement)this.createImplStatement(1003, 1007);
            BaseSQL baseSQL = new BaseSQL(string2, 0, '\'', this.intoIsOptional, null, this.exceptions);
            oracleImplStatement.setup(this, this.warnings);
            oracleImplStatement.setSQL(baseSQL);
            oracleImplStatement.execute();
            oracleImplStatement.close();
        }
        return string;
    }
}

