/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.slbase;

import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbcx.slbase.BaseConnectionWrapper;
import com.metamatrix.jdbcx.slbase.BaseDependent;
import com.metamatrix.jdbcx.slbase.BaseStatementWrapper;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class BaseResultSetWrapper
implements ResultSet,
BaseDependent {
    ResultSet realResultSet;
    private BaseConnectionWrapper connectionWrapper;
    private BaseStatementWrapper statementWrapper;
    private boolean isClosed;
    private BaseExceptions exceptions;

    protected void finalize() throws Throwable {
        if (this.statementWrapper == null && !this.isClosed) {
            this.connectionWrapper.notifyResultSetGarbage();
        }
        super.finalize();
    }

    public void doClose() {
    }

    public Object realObject() {
        return this.realResultSet;
    }

    BaseResultSetWrapper(ResultSet resultSet, BaseConnectionWrapper baseConnectionWrapper) throws SQLException {
        this.realResultSet = resultSet;
        this.connectionWrapper = baseConnectionWrapper;
        baseConnectionWrapper.addDependent(this);
    }

    BaseResultSetWrapper(BaseStatementWrapper baseStatementWrapper, ResultSet resultSet, BaseConnectionWrapper baseConnectionWrapper) throws SQLException {
        this.realResultSet = resultSet;
        this.connectionWrapper = baseConnectionWrapper;
        this.statementWrapper = baseStatementWrapper;
    }

    public boolean next() throws SQLException {
        try {
            return this.realResultSet.next();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        try {
            this.realResultSet.close();
            if (this.statementWrapper == null) {
                this.connectionWrapper.removeFromDependents(this);
            }
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
        finally {
            this.isClosed = true;
        }
    }

    public boolean wasNull() throws SQLException {
        try {
            return this.realResultSet.wasNull();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String getString(int n) throws SQLException {
        try {
            return this.realResultSet.getString(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getInt(int n) throws SQLException {
        try {
            return this.realResultSet.getInt(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            return this.realResultSet.getDouble(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            return this.realResultSet.getBytes(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            return this.realResultSet.getBoolean(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public byte getByte(int n) throws SQLException {
        try {
            return this.realResultSet.getByte(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public short getShort(int n) throws SQLException {
        try {
            return this.realResultSet.getShort(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public long getLong(int n) throws SQLException {
        try {
            return this.realResultSet.getLong(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            return this.realResultSet.getFloat(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            return this.realResultSet.getBigDecimal(n, n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            return this.realResultSet.getDate(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            return this.realResultSet.getTime(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            return this.realResultSet.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        try {
            return this.realResultSet.getAsciiStream(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        try {
            return this.realResultSet.getUnicodeStream(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        try {
            return this.realResultSet.getBinaryStream(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Object getObject(int n) throws SQLException {
        try {
            return this.realResultSet.getObject(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String getString(String string) throws SQLException {
        try {
            return this.realResultSet.getString(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        try {
            return this.realResultSet.getBoolean(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public byte getByte(String string) throws SQLException {
        try {
            return this.realResultSet.getByte(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public short getShort(String string) throws SQLException {
        try {
            return this.realResultSet.getShort(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getInt(String string) throws SQLException {
        try {
            return this.realResultSet.getInt(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public long getLong(String string) throws SQLException {
        try {
            return this.realResultSet.getLong(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public float getFloat(String string) throws SQLException {
        try {
            return this.realResultSet.getFloat(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public double getDouble(String string) throws SQLException {
        try {
            return this.realResultSet.getDouble(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        try {
            return this.realResultSet.getBigDecimal(string, n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        try {
            return this.realResultSet.getBytes(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Date getDate(String string) throws SQLException {
        try {
            return this.realResultSet.getDate(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Time getTime(String string) throws SQLException {
        try {
            return this.realResultSet.getTime(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            return this.realResultSet.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        try {
            return this.realResultSet.getAsciiStream(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        try {
            return this.realResultSet.getUnicodeStream(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        try {
            return this.realResultSet.getBinaryStream(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.realResultSet.getWarnings();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.realResultSet.clearWarnings();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String getCursorName() throws SQLException {
        try {
            return this.realResultSet.getCursorName();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.realResultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Object getObject(String string) throws SQLException {
        try {
            return this.realResultSet.getObject(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int findColumn(String string) throws SQLException {
        try {
            return this.realResultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Reader getCharacterStream(int n) throws SQLException {
        try {
            return this.realResultSet.getCharacterStream(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        try {
            return this.realResultSet.getCharacterStream(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            return this.realResultSet.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            return this.realResultSet.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        try {
            return this.realResultSet.isBeforeFirst();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isAfterLast() throws SQLException {
        try {
            return this.realResultSet.isAfterLast();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isFirst() throws SQLException {
        try {
            return this.realResultSet.isFirst();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isLast() throws SQLException {
        try {
            return this.realResultSet.isLast();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void beforeFirst() throws SQLException {
        try {
            this.realResultSet.beforeFirst();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void afterLast() throws SQLException {
        try {
            this.realResultSet.afterLast();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean first() throws SQLException {
        try {
            return this.realResultSet.first();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean last() throws SQLException {
        try {
            return this.realResultSet.last();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getRow() throws SQLException {
        try {
            return this.realResultSet.getRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean absolute(int n) throws SQLException {
        try {
            return this.realResultSet.absolute(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean relative(int n) throws SQLException {
        try {
            return this.realResultSet.relative(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean previous() throws SQLException {
        try {
            return this.realResultSet.previous();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            this.realResultSet.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.realResultSet.getFetchDirection();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            this.realResultSet.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.realResultSet.getFetchSize();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getType() throws SQLException {
        try {
            return this.realResultSet.getType();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getConcurrency() throws SQLException {
        try {
            return this.realResultSet.getConcurrency();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean rowUpdated() throws SQLException {
        try {
            return this.realResultSet.rowUpdated();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean rowInserted() throws SQLException {
        try {
            return this.realResultSet.rowInserted();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean rowDeleted() throws SQLException {
        try {
            return this.realResultSet.rowDeleted();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateNull(int n) throws SQLException {
        try {
            this.realResultSet.updateNull(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        try {
            this.realResultSet.updateBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateByte(int n, byte by) throws SQLException {
        try {
            this.realResultSet.updateByte(n, by);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        try {
            this.realResultSet.updateShort(n, s);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateInt(int n, int n2) throws SQLException {
        try {
            this.realResultSet.updateInt(n, n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateLong(int n, long l) throws SQLException {
        try {
            this.realResultSet.updateLong(n, l);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateFloat(int n, float f) throws SQLException {
        try {
            this.realResultSet.updateFloat(n, f);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateDouble(int n, double d) throws SQLException {
        try {
            this.realResultSet.updateDouble(n, d);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            this.realResultSet.updateBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateString(int n, String string) throws SQLException {
        try {
            this.realResultSet.updateString(n, string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        try {
            this.realResultSet.updateBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateDate(int n, Date date) throws SQLException {
        try {
            this.realResultSet.updateDate(n, date);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateTime(int n, Time time) throws SQLException {
        try {
            this.realResultSet.updateTime(n, time);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            this.realResultSet.updateTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.realResultSet.updateAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.realResultSet.updateBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            this.realResultSet.updateCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        try {
            this.realResultSet.updateObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        try {
            this.realResultSet.updateObject(n, object);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateNull(String string) throws SQLException {
        try {
            this.realResultSet.updateNull(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        try {
            this.realResultSet.updateBoolean(string, bl);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateByte(String string, byte by) throws SQLException {
        try {
            this.realResultSet.updateByte(string, by);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateShort(String string, short s) throws SQLException {
        try {
            this.realResultSet.updateShort(string, s);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateInt(String string, int n) throws SQLException {
        try {
            this.realResultSet.updateInt(string, n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateLong(String string, long l) throws SQLException {
        try {
            this.realResultSet.updateLong(string, l);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateFloat(String string, float f) throws SQLException {
        try {
            this.realResultSet.updateFloat(string, f);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateDouble(String string, double d) throws SQLException {
        try {
            this.realResultSet.updateDouble(string, d);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            this.realResultSet.updateBigDecimal(string, bigDecimal);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        try {
            this.realResultSet.updateString(string, string2);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            this.realResultSet.updateBytes(string, byArray);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateDate(String string, Date date) throws SQLException {
        try {
            this.realResultSet.updateDate(string, date);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateTime(String string, Time time) throws SQLException {
        try {
            this.realResultSet.updateTime(string, time);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            this.realResultSet.updateTimestamp(string, timestamp);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            this.realResultSet.updateAsciiStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        try {
            this.realResultSet.updateBinaryStream(string, inputStream, n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        try {
            this.realResultSet.updateCharacterStream(string, reader, n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        try {
            this.realResultSet.updateObject(string, object, n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateObject(String string, Object object) throws SQLException {
        try {
            this.realResultSet.updateObject(string, object);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void insertRow() throws SQLException {
        try {
            this.realResultSet.insertRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateRow() throws SQLException {
        try {
            this.realResultSet.updateRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void deleteRow() throws SQLException {
        try {
            this.realResultSet.deleteRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void refreshRow() throws SQLException {
        try {
            this.realResultSet.refreshRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void cancelRowUpdates() throws SQLException {
        try {
            this.realResultSet.cancelRowUpdates();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void moveToInsertRow() throws SQLException {
        try {
            this.realResultSet.moveToInsertRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void moveToCurrentRow() throws SQLException {
        try {
            this.realResultSet.moveToCurrentRow();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Statement getStatement() throws SQLException {
        try {
            this.realResultSet.getStatement();
            return this.statementWrapper;
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        try {
            return this.realResultSet.getObject(n, map);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Ref getRef(int n) throws SQLException {
        try {
            return this.realResultSet.getRef(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Blob getBlob(int n) throws SQLException {
        try {
            return this.realResultSet.getBlob(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Clob getClob(int n) throws SQLException {
        try {
            return this.realResultSet.getClob(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Array getArray(int n) throws SQLException {
        try {
            return this.realResultSet.getArray(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        try {
            return this.realResultSet.getObject(string, map);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Ref getRef(String string) throws SQLException {
        try {
            return this.realResultSet.getRef(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Blob getBlob(String string) throws SQLException {
        try {
            return this.realResultSet.getBlob(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Clob getClob(String string) throws SQLException {
        try {
            return this.realResultSet.getClob(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Array getArray(String string) throws SQLException {
        try {
            return this.realResultSet.getArray(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            return this.realResultSet.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            return this.realResultSet.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            return this.realResultSet.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            return this.realResultSet.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            return this.realResultSet.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            return this.realResultSet.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public URL getURL(int n) throws SQLException {
        try {
            return this.realResultSet.getURL(n);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public URL getURL(String string) throws SQLException {
        try {
            return this.realResultSet.getURL(string);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        try {
            this.realResultSet.updateRef(n, ref);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        try {
            this.realResultSet.updateRef(string, ref);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        try {
            this.realResultSet.updateBlob(n, blob);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            this.realResultSet.updateBlob(string, blob);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        try {
            this.realResultSet.updateClob(n, clob);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            this.realResultSet.updateClob(string, clob);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateArray(int n, Array array) throws SQLException {
        try {
            this.realResultSet.updateArray(n, array);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void updateArray(String string, Array array) throws SQLException {
        try {
            this.realResultSet.updateArray(string, array);
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }
}

