/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.data.pool;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.data.DataPlugin;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.monitor.AliveStatus;
import com.metamatrix.data.monitor.ConnectionStatus;
import com.metamatrix.data.pool.ConnectionPool;
import com.metamatrix.data.pool.ConnectionPoolException;
import com.metamatrix.data.pool.ConnectorIdentity;
import com.metamatrix.data.pool.SourceConnection;
import com.metamatrix.data.pool.SourceConnectionFactory;
import java.util.Properties;

public class DisabledConnectionPool
extends ConnectionPool {
    public static final String WAIT_FOR_SOURCE_TIME = "com.metamatrix.data.pool.wait_for_source_time";
    private static final String CTX_CONNECTOR = "CONNECTOR";

    public DisabledConnectionPool(SourceConnectionFactory connectionFactory) {
        super(connectionFactory);
    }

    public void initialize(Properties poolProperties) throws ConnectionPoolException {
        ArgCheck.isNotNull((Object)poolProperties);
        LogManager.logInfo((String)CTX_CONNECTOR, (String)DataPlugin.Util.getString("ConnectionPool.Connection_pool_created_1"));
    }

    public SourceConnection obtain(SecurityContext securityContext) throws ConnectionPoolException {
        ConnectorIdentity id = null;
        try {
            id = this.getConnectionFactory().createIdentity(securityContext);
            SourceConnection connection = this.getConnectionFactory().createConnection(id);
            if (LogManager.isMessageToBeRecorded((String)CTX_CONNECTOR, (int)6)) {
                LogManager.logTrace((String)CTX_CONNECTOR, (String)DataPlugin.Util.getString("ConnectionPool.New_conn", (Object)id));
            }
            return connection;
        }
        catch (ConnectorException e) {
            throw new ConnectionPoolException((Throwable)e);
        }
    }

    public void release(SourceConnection connection) {
        this.closeSourceConnection(connection);
    }

    public void error(SourceConnection connection) {
        this.closeSourceConnection(connection);
    }

    public ConnectionStatus getStatus() {
        return new ConnectionStatus(this.testConnectionStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AliveStatus testConnectionStatus() {
        SourceConnection connection = null;
        try {
            connection = this.obtain(null);
            boolean alive = connection.isAlive();
            AliveStatus aliveStatus = alive ? AliveStatus.ALIVE : AliveStatus.DEAD;
            return aliveStatus;
        }
        catch (ConnectionPoolException e) {
            AliveStatus aliveStatus = AliveStatus.DEAD;
            return aliveStatus;
        }
        finally {
            this.release(connection);
        }
    }

    public void shutDown() {
    }

    private boolean closeSourceConnection(SourceConnection connection) {
        try {
            connection.closeSource();
            if (LogManager.isMessageToBeRecorded((String)CTX_CONNECTOR, (int)6)) {
                LogManager.logTrace((String)CTX_CONNECTOR, (String)DataPlugin.Util.getString("ConnectionPool.Closed_conn"));
            }
            return true;
        }
        catch (Exception e) {
            LogManager.logError((String)CTX_CONNECTOR, (String)DataPlugin.Util.getString("ConnectionPool.Failed_close_conn"));
            return false;
        }
    }
}

