/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BIT_STRING
extends ASN1Object {
    protected byte[] value;
    protected int bits_not_valid;

    public String toString() {
        return String.valueOf(super.toString()) + this.value.length + " byte(s); " + this.bits_not_valid + " bit(s) not valid";
    }

    public void setValue(Object object) {
        this.value = (byte[])object;
        this.bits_not_valid = 0;
    }

    public Object getValue() {
        return this.value;
    }

    public String getBinaryString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < this.value.length - 1) {
            n2 = 7;
            while (n2 >= 0) {
                if ((this.value[n3] & 1 << n2) != 0) {
                    stringBuffer.append('1');
                } else {
                    stringBuffer.append('0');
                }
                --n2;
            }
            ++n3;
        }
        n2 = 7;
        while (n2 >= this.bits_not_valid) {
            if ((this.value[n3] & 1 << n2) != 0) {
                stringBuffer.append('1');
            } else {
                stringBuffer.append('0');
            }
            --n2;
        }
        return stringBuffer.toString();
    }

    protected void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.value);
        outputStream.write(this.bits_not_valid);
    }

    protected void decode(int n2, InputStream inputStream) throws IOException {
        this.bits_not_valid = inputStream.read();
        this.value = new byte[n2 - 1];
        Util.fillArray(this.value, inputStream);
    }

    public int bitsNotValid() {
        return this.bits_not_valid;
    }

    public BIT_STRING(boolean[] blArray) {
        this();
        int n2 = blArray.length;
        this.bits_not_valid = 8 - n2 % 8;
        this.value = new byte[(n2 + 7) / 8];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 / 8;
            this.value[n4] = (byte)(this.value[n4] << 1);
            if (blArray[n3]) {
                int n5 = n3 / 8;
                this.value[n5] = (byte)(this.value[n5] + 1);
            }
            ++n3;
        }
        if (this.bits_not_valid > 0) {
            int n6 = n3 / 8;
            this.value[n6] = (byte)(this.value[n6] << this.bits_not_valid);
        }
    }

    public BIT_STRING(byte[] byArray, int n2) {
        this();
        this.value = byArray;
        this.bits_not_valid = n2;
    }

    public BIT_STRING(byte[] byArray) {
        this();
        this.value = byArray;
        this.bits_not_valid = 0;
    }

    public BIT_STRING(String string) {
        this();
        int n2 = string.length();
        this.bits_not_valid = (8 - n2 % 8) % 8;
        int n3 = (n2 + 7) / 8;
        this.value = new byte[n3];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4 / 8;
            this.value[n5] = (byte)(this.value[n5] << 1);
            if (string.charAt(n4) == '1') {
                int n6 = n4 / 8;
                this.value[n6] = (byte)(this.value[n6] + 1);
            }
            ++n4;
        }
        if (this.bits_not_valid > 0) {
            int n7 = n4 / 8;
            this.value[n7] = (byte)(this.value[n7] << this.bits_not_valid);
        }
    }

    protected BIT_STRING() {
        this.asnType = ASN.BIT_STRING;
    }
}

